/*
 * Decompiled with CFR 0.152.
 */
package perffmwk;

import hydra.FileUtil;
import hydra.TestFileUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import perffmwk.Expr;
import perffmwk.StatConfigException;
import perffmwk.StatSpec;
import perffmwk.StatSpecId;
import perffmwk.TrimSpec;

public class StatConfig {
    private String testDir;
    private Properties latest = null;
    private Properties testprops = null;
    private SortedMap trimspecs = new TreeMap();
    private SortedMap statspecs = new TreeMap();
    private Map sysprops = new HashMap();
    boolean isNativeClient = false;
    protected Map matchingArchiveCache = new HashMap();

    protected StatConfig(String testDir) {
        this.testDir = testDir;
        this.isNativeClient = FileUtil.exists(this.testDir + "/Driver.log");
    }

    protected String getTestName() {
        return this.latest == null ? null : this.latest.getProperty("TestName");
    }

    protected boolean isNativeClient() {
        return this.isNativeClient;
    }

    protected String getTestDescription() {
        return this.latest == null ? null : this.latest.getProperty("hydra.Prms-testDescription");
    }

    protected String getSourceRepository() {
        return this.latest == null ? null : this.latest.getProperty("source.repository");
    }

    protected String getSourceRevision() {
        return this.latest == null ? null : this.latest.getProperty("source.revision");
    }

    protected String getSourceDate() {
        return this.latest == null ? null : this.latest.getProperty("source.date");
    }

    protected String getBuildVersion() {
        return this.latest == null ? null : this.latest.getProperty("build.version");
    }

    protected String getBuildDate() {
        return this.latest == null ? null : this.latest.getProperty("build.date");
    }

    protected String getBuildJDK() {
        return this.latest == null ? null : this.latest.getProperty("build.jdk");
    }

    protected String getNativeClientSourceRepository() {
        return this.latest == null ? null : this.latest.getProperty("nativeClient.repository");
    }

    protected String getNativeClientSourceRevision() {
        return this.latest == null ? null : this.latest.getProperty("nativeClient.revision");
    }

    protected String getNativeClientBuildVersion() {
        return this.latest == null ? null : this.latest.getProperty("nativeClient.version");
    }

    protected String getRuntimeJDK() {
        return this.latest == null ? null : this.latest.getProperty("runtime.jdk");
    }

    protected String getJavaVMName() {
        return this.latest == null ? null : this.latest.getProperty("java.vm.name");
    }

    protected String getTestDir() {
        return this.testDir;
    }

    protected void setLatestProperties(Properties p) {
        this.latest = p;
    }

    protected Properties getLatestProperties() {
        return this.latest;
    }

    protected void setTestProperties(Properties p) {
        this.testprops = p;
    }

    protected Properties getTestProperties() {
        return this.testprops;
    }

    protected Map getSystemProperties() {
        return this.sysprops;
    }

    protected void addSystemProperty(String key, String val) {
        this.sysprops.put(key, val);
    }

    protected SortedMap getTrimSpecs() {
        return this.trimspecs;
    }

    protected synchronized TrimSpec getTrimSpec(String name) {
        TrimSpec trimspec = (TrimSpec)this.trimspecs.get(name);
        if (trimspec == null && (trimspec = (TrimSpec)this.trimspecs.get(name)) == null) {
            trimspec = new TrimSpec(name);
            this.addTrimSpec(trimspec);
        }
        return trimspec;
    }

    protected void addTrimSpec(TrimSpec trimspec) {
        String name = trimspec.getName();
        if (this.trimspecs.get(name) != null) {
            String s = "Duplicate trim specification with name: " + name;
            throw new StatConfigException(s);
        }
        this.trimspecs.put(name, trimspec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector getStatSpecsWithId(StatSpecId id) {
        Vector<StatSpec> matches = null;
        String idstr = id.toString();
        SortedMap sortedMap = this.statspecs;
        synchronized (sortedMap) {
            for (StatSpec statspec : this.statspecs.values()) {
                if (!statspec.getId().toString().startsWith(idstr)) continue;
                if (matches == null) {
                    matches = new Vector<StatSpec>();
                }
                matches.add(statspec);
            }
        }
        return matches;
    }

    protected StatSpec getStatSpecByKey(String key) {
        return (StatSpec)this.statspecs.get(key);
    }

    protected StatSpec getStatSpec(String name) {
        for (StatSpec statspec : this.statspecs.values()) {
            if (!statspec.getName().equals(name)) continue;
            return statspec;
        }
        return null;
    }

    protected SortedMap getStatSpecs() {
        return this.statspecs;
    }

    protected Map getStatSpecInstances() {
        TreeMap map = new TreeMap();
        for (String key : this.statspecs.keySet()) {
            Object obj = this.statspecs.get(key);
            if (obj instanceof Expr) continue;
            map.put(key, obj);
        }
        return map;
    }

    protected Map getExprInstances() {
        TreeMap map = new TreeMap();
        for (String key : this.statspecs.keySet()) {
            Object obj = this.statspecs.get(key);
            if (!(obj instanceof Expr)) continue;
            map.put(key, obj);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void addStatSpec(StatSpec statspec) {
        String name = statspec.getName();
        SortedMap sortedMap = this.statspecs;
        synchronized (sortedMap) {
            if (this.getStatSpec(name) != null) {
                throw new StatConfigException("Logical statspec name " + name + " occurs more than once in statspec file");
            }
            this.putStatSpec(statspec);
        }
    }

    private void putStatSpec(StatSpec statspec) {
        if (statspec instanceof Expr) {
            this.statspecs.put(statspec.getName(), statspec);
        } else {
            String key = statspec.getName() + " " + statspec.getId().toString();
            this.statspecs.put(key, statspec);
        }
    }

    protected void setStatSpecs(SortedMap statspecs) {
        this.statspecs = statspecs;
        for (StatSpec statspec : this.statspecs.values()) {
            statspec.setStatConfig(this);
        }
    }

    protected void resetStatSpecs() {
        this.statspecs = new TreeMap();
        this.matchingArchiveCache = new HashMap();
    }

    protected List getMatchingArchiveCache(String specname) {
        return (List)this.matchingArchiveCache.get(specname);
    }

    protected void setMatchingArchiveCache(String specname, List archives) {
        this.matchingArchiveCache.put(specname, archives);
    }

    protected SortedMap distillStatSpecsForComparison() {
        if (this.statspecs != null) {
            StatSpec statspec;
            TreeMap<String, StatSpec> distilledstatspecs = new TreeMap<String, StatSpec>();
            for (String key : this.statspecs.keySet()) {
                statspec = (StatSpec)this.statspecs.get(key);
                StatSpec distilledstatspec = statspec.distill();
                if (distilledstatspec == null) continue;
                distilledstatspecs.put(key, distilledstatspec);
            }
            this.statspecs = distilledstatspecs;
            for (String key : this.statspecs.keySet()) {
                statspec = this.statspecs.get(key);
                if (!(statspec instanceof Expr)) continue;
                Expr expr = (Expr)statspec;
                this.putStatSpec(expr.getNumerator());
                this.putStatSpec(expr.getDenominator());
            }
        }
        return this.statspecs;
    }

    protected List getStatisticArchivesAsList() {
        List<String> archives = null;
        if (this.isNativeClient) {
            return TestFileUtil.getNativeClientStatisticArchivesAsList(this.testDir);
        }
        archives = TestFileUtil.getStatisticArchivesAsList(this.testDir);
        if (archives == null || archives.size() == 0) {
            return null;
        }
        return archives;
    }

    protected SortedMap getStatisticArchives() {
        SortedMap<String, List<String>> archives = TestFileUtil.getStatisticArchives(this.testDir);
        if (archives == null || archives.size() == 0) {
            return null;
        }
        return archives;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.trimspecs.size() > 0) {
            buf.append("\nTrim Specifications\n\n");
            for (TrimSpec trimspec : this.trimspecs.values()) {
                buf.append(trimspec.toSpecString() + "\n");
            }
        }
        if (this.statspecs.size() > 0) {
            buf.append("\nStatistic Specifications\n\n");
            for (StatSpec statspec : this.statspecs.values()) {
                buf.append(statspec.toSpecString() + "\n");
            }
        }
        return buf.toString();
    }
}

