/*
 * Decompiled with CFR 0.152.
 */
package perffmwk;

import hydra.FileUtil;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import perffmwk.ComparisonConstants;
import perffmwk.PerfComparisonException;
import perffmwk.PerfReporter;
import perffmwk.StatConfig;

public class Test
implements ComparisonConstants,
Comparable<Test> {
    private String testDir;
    private SortedMap testProps;
    private String testId;
    private String testDescription;
    private String testResult;
    private String statSpecFile;
    private StatConfig statConfig;
    private String sourceVersion;
    private String buildVersion;
    private String nativeClientSourceVersion;
    private String nativeClientBuildVersion;
    private String buildJDK;
    private String runtimeJDK;
    private String javaVMName;

    public Test(String testDir, boolean compareByKey) {
        this.testDir = testDir;
        this.statSpecFile = testDir + "/statistics.spec";
        this.statConfig = PerfReporter.getStatConfig(this.testDir, this.statSpecFile);
        this.testResult = this.computeTestResult(this.testDir);
        if (this.statConfig != null) {
            SortedMap distilled = this.statConfig.distillStatSpecsForComparison();
            this.statConfig.setStatSpecs(distilled);
            this.testProps = this.computeTestProperties(this.statConfig);
            this.testId = this.computeTestId(this.testProps, compareByKey);
            this.testDescription = this.statConfig.getTestDescription();
            String svn = this.statConfig.getSourceRepository();
            this.sourceVersion = svn == null ? "not available" : this.statConfig.getSourceRepository() + ":" + this.statConfig.getSourceRevision() + " (" + this.statConfig.getSourceDate() + ")";
            this.buildVersion = this.statConfig.getBuildVersion();
            this.buildJDK = this.statConfig.getBuildJDK();
            this.runtimeJDK = this.statConfig.getRuntimeJDK();
            this.javaVMName = this.statConfig.getJavaVMName();
            if (this.statConfig.isNativeClient()) {
                svn = this.statConfig.getNativeClientSourceRepository();
                this.nativeClientSourceVersion = svn == null ? "not available" : this.statConfig.getNativeClientSourceRepository() + ":" + this.statConfig.getNativeClientSourceRevision();
                this.nativeClientBuildVersion = this.statConfig.getNativeClientBuildVersion();
            }
        }
    }

    public String getTestDir() {
        return this.testDir;
    }

    public SortedMap getTestProperties() {
        return this.testProps;
    }

    public String getTestId() {
        return this.testId;
    }

    public String getTestDescription() {
        return this.testDescription;
    }

    public String getTestResult() {
        return this.testResult;
    }

    public String getStatSpecFile() {
        return this.statSpecFile;
    }

    public StatConfig getStatConfig() {
        return this.statConfig;
    }

    public void resetStatSpecs(String statSpecFile) {
        this.statSpecFile = statSpecFile;
        this.statConfig = PerfReporter.getStatConfig(this.testDir, this.statSpecFile);
        SortedMap distilled = this.statConfig.distillStatSpecsForComparison();
        this.statConfig.setStatSpecs(distilled);
    }

    public SortedMap getStatSpecs() {
        return this.statConfig.getStatSpecs();
    }

    public String getSourceVersion() {
        return this.sourceVersion;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public String getNativeClientSourceVersion() {
        return this.nativeClientSourceVersion;
    }

    public String getNativeClientBuildVersion() {
        return this.nativeClientBuildVersion;
    }

    public String getBuildJDK() {
        return this.buildJDK;
    }

    public String getRuntimeJDK() {
        return this.runtimeJDK;
    }

    public String getJavaVMName() {
        return this.javaVMName;
    }

    public String toString() {
        String s = "\ntestDir: " + this.testDir + "\ntestId: " + this.testId + "\ntestDescription: " + this.testDescription + "\ntestResult: " + this.testResult + "\nstatSpecFile: " + this.statSpecFile + "\nsourceVersion: " + this.sourceVersion + "\nbuildVersion: " + this.buildVersion + "\nbuildJDK: " + this.buildJDK + "\nruntimeJDK: " + this.runtimeJDK + "\njavaVMName: " + this.javaVMName;
        if (this.statConfig.isNativeClient()) {
            s = s + "\nnativeClientSourceVersion: " + this.nativeClientSourceVersion + "\nnativeClientBuildVersion: " + this.nativeClientBuildVersion;
        }
        return s;
    }

    private SortedMap computeTestProperties(StatConfig statConfig) {
        TreeMap sortedProps = new TreeMap();
        Properties testProps = statConfig.getTestProperties();
        if (testProps != null) {
            return new TreeMap<Object, Object>(testProps);
        }
        return new TreeMap();
    }

    private String computeTestId(SortedMap testProps, boolean compareByKey) {
        String testId = this.statConfig.getTestName();
        if (testProps != null) {
            if (compareByKey) {
                String key = (String)testProps.get("perffmwk.comparisonKey");
                if (key == null) {
                    String s = "perffmwk.comparisonKey not found";
                    throw new PerfComparisonException(s);
                }
                testId = key;
            } else {
                for (String key : testProps.keySet()) {
                    if (key.equals("testName") || key.equals("perffmwk.comparisonKey")) continue;
                    testId = testId + " " + key + "=" + testProps.get(key);
                }
            }
        }
        return testId;
    }

    private String computeTestResult(String testDir) {
        if (!FileUtil.exists(testDir + "/latest.prop")) {
            return "bogus";
        }
        if (FileUtil.exists(testDir + "/hang.txt")) {
            return "H";
        }
        if (FileUtil.exists(testDir + "/errors.txt")) {
            return "F";
        }
        if (this.statConfig.isNativeClient() && FileUtil.exists(testDir + "/failure.txt")) {
            return "F";
        }
        return "P";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Test)) {
            return false;
        }
        Test other = (Test)obj;
        return this.testDir.equals(other.testDir);
    }

    public int hashCode() {
        return this.testDir.hashCode();
    }

    @Override
    public int compareTo(Test o) {
        return this.testDir.compareTo(o.testDir);
    }
}

