/*
 * Decompiled with CFR 0.152.
 */
package perffmwk;

import hydra.FileUtil;
import hydra.Log;
import hydra.TestFileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import perffmwk.ComparisonConstants;
import perffmwk.PerfComparisonException;
import perffmwk.Test;

public class TestContainer
implements ComparisonConstants {
    private String testContainerDir;
    private List tests;

    public TestContainer(String testContainerDir, boolean omitFailedTests, boolean compareByKey, boolean enforceConsistency) {
        if (!FileUtil.exists(testContainerDir)) {
            String s = "Directory not found: " + testContainerDir;
            throw new PerfComparisonException(s);
        }
        this.testContainerDir = testContainerDir;
        this.tests = new ArrayList();
        List testDirs = TestFileUtil.getTestDirectories(testContainerDir, false);
        if (testDirs.size() == 0) {
            String s = "Directory contains no test results: " + testContainerDir;
            throw new PerfComparisonException(s);
        }
        Iterator i = testDirs.iterator();
        while (i.hasNext()) {
            String s;
            String testDir = ((File)i.next()).toString();
            Test test = new Test(testDir, compareByKey);
            String testResult = test.getTestResult();
            if (testResult.equals("bogus")) {
                s = "Omitting " + testResult + " test: " + testDir;
                Log.getLogWriter().warning(s);
                continue;
            }
            if (test.getTestResult().equals("P") || !omitFailedTests) {
                this.tests.add(test);
                continue;
            }
            s = "Omitting " + testResult + " test: " + testDir;
            Log.getLogWriter().warning(s);
        }
        Collections.sort(this.tests);
        if (this.tests.size() == 0) {
            String s = "Directory contains no passing tests: " + testContainerDir;
            throw new PerfComparisonException(s);
        }
        if (enforceConsistency) {
            this.enforceBuildVersion();
            this.enforceNativeClientBuildVersion();
            this.enforceNativeClientSourceVersion();
            this.enforceBuildJDK();
            this.enforceRuntimeJDK();
        }
    }

    public String getTestContainerDir() {
        return this.testContainerDir;
    }

    public List getTests() {
        return this.tests;
    }

    public SortedSet getTestPropertyKeys() {
        TreeSet keys = new TreeSet();
        for (Test test : this.tests) {
            keys.addAll(test.getTestProperties().keySet());
        }
        return keys;
    }

    public List getTestIds() {
        ArrayList<String> testIds = new ArrayList<String>();
        for (Test test : this.tests) {
            String testId = test.getTestId();
            if (testId == null) continue;
            testIds.add(testId);
        }
        return testIds;
    }

    public List getTestDirsWithId(String testId) {
        ArrayList<String> testDirs = new ArrayList<String>();
        for (Test test : this.tests) {
            if (!test.getTestId().equals(testId)) continue;
            testDirs.add(test.getTestDir());
        }
        return testDirs;
    }

    public List getTestsWithId(String testId) {
        ArrayList<Test> testsWithId = new ArrayList<Test>();
        for (Test test : this.tests) {
            if (!test.getTestId().equals(testId)) continue;
            testsWithId.add(test);
        }
        return testsWithId;
    }

    public boolean isNativeClient() {
        Test test = (Test)this.tests.iterator().next();
        return test.getStatConfig().isNativeClient();
    }

    private void enforceBuildVersion() {
        String lastBuildVersion = null;
        for (Test test : this.tests) {
            String currentBuildVersion = test.getBuildVersion();
            if (currentBuildVersion == null) continue;
            if (lastBuildVersion == null) {
                lastBuildVersion = currentBuildVersion;
                continue;
            }
            if (this.same(currentBuildVersion, lastBuildVersion)) continue;
            String s = "Directory " + this.testContainerDir + " contains tests that use different build versions: " + lastBuildVersion + " and " + currentBuildVersion;
            throw new PerfComparisonException(s);
        }
    }

    private void enforceNativeClientBuildVersion() {
        String lastNativeClientBuildVersion = null;
        for (Test test : this.tests) {
            String currentNativeClientBuildVersion = test.getNativeClientBuildVersion();
            if (currentNativeClientBuildVersion == null) continue;
            if (lastNativeClientBuildVersion == null) {
                lastNativeClientBuildVersion = currentNativeClientBuildVersion;
                continue;
            }
            if (this.same(currentNativeClientBuildVersion, lastNativeClientBuildVersion)) continue;
            String s = "Directory " + this.testContainerDir + " contains tests that use different build versions: " + lastNativeClientBuildVersion + " and " + currentNativeClientBuildVersion;
            throw new PerfComparisonException(s);
        }
    }

    private void enforceNativeClientSourceVersion() {
        String lastNativeClientSourceVersion = null;
        for (Test test : this.tests) {
            String currentNativeClientSourceVersion = test.getNativeClientSourceVersion();
            if (currentNativeClientSourceVersion == null) continue;
            if (lastNativeClientSourceVersion == null) {
                lastNativeClientSourceVersion = currentNativeClientSourceVersion;
                continue;
            }
            if (this.same(currentNativeClientSourceVersion, lastNativeClientSourceVersion)) continue;
            String s = "Directory " + this.testContainerDir + " contains tests that use different source versions: " + lastNativeClientSourceVersion + " and " + currentNativeClientSourceVersion;
            throw new PerfComparisonException(s);
        }
    }

    public String getSourceVersion() {
        Test test = (Test)this.tests.iterator().next();
        return test.getSourceVersion();
    }

    public String getNativeClientSourceVersion() {
        Test test = (Test)this.tests.iterator().next();
        return test.getNativeClientSourceVersion();
    }

    public String getBuildVersion() {
        for (Test test : this.tests) {
            String firstBuildVersion = test.getBuildVersion();
            if (firstBuildVersion == null) continue;
            return firstBuildVersion;
        }
        String s = "No build version available in " + this.testContainerDir;
        throw new PerfComparisonException(s);
    }

    public String getNativeClientBuildVersion() {
        for (Test test : this.tests) {
            String firstNativeClientBuildVersion = test.getNativeClientBuildVersion();
            if (firstNativeClientBuildVersion == null) continue;
            return firstNativeClientBuildVersion;
        }
        String s = "No build version available in " + this.testContainerDir;
        throw new PerfComparisonException(s);
    }

    private void enforceBuildJDK() {
        String lastBuildJDK = null;
        for (Test test : this.tests) {
            String currentBuildJDK = test.getBuildJDK();
            if (currentBuildJDK == null) continue;
            if (lastBuildJDK == null) {
                lastBuildJDK = currentBuildJDK;
                continue;
            }
            if (this.same(currentBuildJDK, lastBuildJDK)) continue;
            String s = "Directory " + this.testContainerDir + " contains tests that use different build JDKs: " + lastBuildJDK + " and " + currentBuildJDK;
            throw new PerfComparisonException(s);
        }
    }

    public String getBuildJDK() {
        for (Test test : this.tests) {
            String buildJDK = test.getBuildJDK();
            if (buildJDK == null) continue;
            return buildJDK;
        }
        String s = "No build JDK available in " + this.testContainerDir;
        throw new PerfComparisonException(s);
    }

    private void enforceRuntimeJDK() {
        String lastRuntimeJDK = null;
        String lastJavaVMName = null;
        for (Test test : this.tests) {
            String currentRuntimeJDK = test.getRuntimeJDK();
            String currentJavaVMName = test.getJavaVMName();
            if (currentRuntimeJDK == null) continue;
            if (lastRuntimeJDK == null) {
                lastRuntimeJDK = currentRuntimeJDK;
                lastJavaVMName = currentJavaVMName;
                continue;
            }
            if (!this.same(currentRuntimeJDK, lastRuntimeJDK)) {
                String s = "Directory " + this.testContainerDir + " contains tests that use different runtime JDKs: " + lastRuntimeJDK + " and " + currentRuntimeJDK;
                throw new PerfComparisonException(s);
            }
            if (this.same(currentJavaVMName, lastJavaVMName)) continue;
            String s = "Directory " + this.testContainerDir + " contains tests that use different Java VM names: " + lastJavaVMName + " and " + currentJavaVMName;
            throw new PerfComparisonException(s);
        }
    }

    public String getRuntimeJDK() {
        for (Test test : this.tests) {
            String runtimeJDK = test.getRuntimeJDK();
            if (runtimeJDK == null) continue;
            return runtimeJDK;
        }
        String s = "No runtime JDK available in " + this.testContainerDir;
        throw new PerfComparisonException(s);
    }

    public String getJavaVMName() {
        for (Test test : this.tests) {
            String javaVMName = test.getJavaVMName();
            if (javaVMName == null) continue;
            return javaVMName;
        }
        return null;
    }

    private boolean same(String s, String t) {
        if (s == null && t == null) {
            return true;
        }
        if (s == null && t != null) {
            return false;
        }
        if (s != null && t == null) {
            return false;
        }
        return s.equals(t);
    }

    public String toString() {
        return "\n" + this.testContainerDir + "\nTests: " + this.tests;
    }
}

