/*
 * Decompiled with CFR 0.152.
 */
package perffmwk;

import hydra.Log;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import perffmwk.PerfStatException;
import perffmwk.StatConfigException;

public class TrimSpec
implements Serializable {
    public static String DEFAULT_TRIM_SPEC_NAME = "default";
    protected static final DateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS z");
    private String name;
    private long start = -1L;
    private String startStr = null;
    private long end = -1L;
    private String endStr = null;
    private long minSamples = Long.MAX_VALUE;
    private long maxSamples = Long.MIN_VALUE;

    public TrimSpec(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public long getStart() {
        return this.start;
    }

    public String getStartStr() {
        return this.startStr;
    }

    protected void setStart(String dateStr, Long timestamp) {
        this.start = timestamp == null ? this.getTimestamp(dateStr) : timestamp.longValue();
        this.startStr = dateStr;
    }

    public long getEnd() {
        return this.end;
    }

    public String getEndStr() {
        return this.endStr;
    }

    protected void setEnd(String dateStr, Long timestamp) {
        this.end = timestamp == null ? this.getTimestamp(dateStr) : timestamp.longValue();
        this.endStr = dateStr;
    }

    private long getTimestamp(String dateStr) {
        Date d;
        try {
            d = formatter.parse(dateStr);
        }
        catch (ParseException e) {
            throw new StatConfigException("Invalid date format: " + dateStr);
        }
        long t = d.getTime();
        String s = "Converted " + dateStr + " to " + t + " using inaccurate and deprecated method DateFormat.parse.";
        Log.getLogWriter().warning(s);
        return t;
    }

    public synchronized void start() {
        this.start(System.currentTimeMillis());
    }

    public synchronized void start(long startTime) {
        if (this.start == -1L || this.start < startTime) {
            this.start = startTime;
            this.startStr = formatter.format(new Date(this.start));
        }
        if (this.end != -1L && this.start > this.end) {
            throw new PerfStatException("Trim intervals do not overlap for " + this.name + ", start (" + this.startStr + ") was called after end (" + this.endStr + ")");
        }
    }

    public synchronized void startExtended(long startTime) {
        if (this.start == -1L || this.start > startTime) {
            this.start = startTime;
            this.startStr = formatter.format(new Date(this.start));
        }
    }

    public synchronized void end() {
        this.end(System.currentTimeMillis());
    }

    public synchronized void end(long endTime) {
        if (this.end == -1L || this.end > endTime) {
            this.end = endTime;
            this.endStr = formatter.format(new Date(this.end));
        }
    }

    public synchronized void endExtended(long endTime) {
        if (this.end == -1L || this.end < endTime) {
            this.end = endTime;
            this.endStr = formatter.format(new Date(this.end));
        }
        if (this.end != -1L && this.start > this.end) {
            throw new PerfStatException("Trim intervals do not overlap for " + this.name + ", start (" + this.startStr + ") was called after end (" + this.endStr + ")");
        }
    }

    public void setSamples(int count) {
        this.minSamples = Math.min(this.minSamples, (long)count);
        this.maxSamples = Math.max(this.maxSamples, (long)count);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.name);
        if (this.startStr != null) {
            buf.append(" start=").append(this.startStr);
        }
        if (this.endStr != null) {
            buf.append(" end=").append(this.endStr);
        }
        return buf.toString();
    }

    public String toSpecString() {
        StringBuffer buf = new StringBuffer();
        buf.append("trimspec " + this.name);
        String indent = this.getIndent(buf.length() + "start".length() - "end".length());
        if (this.startStr != null) {
            buf.append(" ").append("start").append("=").append(this.startStr).append(" (").append(this.start).append(")");
        }
        if (this.startStr != null && this.endStr != null) {
            buf.append("\n").append(indent);
        }
        if (this.endStr != null) {
            buf.append(" ").append("end").append("=").append(this.endStr).append(" (").append(this.end).append(")");
        }
        return buf.append("\n;").toString();
    }

    private String getIndent(int indent) {
        char[] fill = new char[indent];
        Arrays.fill(fill, ' ');
        return String.valueOf(fill);
    }

    public String toReportString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.name);
        buf.append(" ==> ");
        buf.append("start=" + this.startStr + " ");
        buf.append("end=" + this.endStr + " ");
        if (this.minSamples == Long.MAX_VALUE) {
            buf.append("samples=unused");
        } else if (this.minSamples == this.maxSamples) {
            buf.append("samples=" + this.minSamples);
        } else {
            buf.append("samples=" + this.minSamples + "-" + this.maxSamples);
        }
        return buf.toString();
    }
}

