/*
 * Decompiled with CFR 0.152.
 */
package perffmwk.samples;

import com.gemstone.gemfire.internal.NanoTimer;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import java.util.Random;
import perffmwk.HistogramStats;

public class HistogramClient {
    private static HydraThreadLocal localhistogram = new HydraThreadLocal();
    private static Random rng = new Random();

    public static void openHistogramTask() {
        HistogramClient c = new HistogramClient();
        c.openHistogram();
    }

    private void openHistogram() {
        HistogramStats histogram = HistogramStats.getInstance("sleeps");
        localhistogram.set(histogram);
        Log.getLogWriter().info("Opened sleep histogram");
    }

    public static void sleepHistogramTask() {
        HistogramClient c = new HistogramClient();
        c.sleepHistogram();
    }

    private void sleepHistogram() {
        HistogramStats histogram = (HistogramStats)localhistogram.get();
        long start = NanoTimer.getTime();
        MasterController.sleepForMs(rng.nextInt(4000));
        long elapsed = NanoTimer.getTime() - start;
        histogram.incBin(elapsed);
    }

    public static void closeHistogramTask() {
        HistogramClient c = new HistogramClient();
        c.closeHistogram();
    }

    private void closeHistogram() {
        HistogramStats histogram = (HistogramStats)localhistogram.get();
        histogram.close();
        Log.getLogWriter().info("Closed sleep histogram");
    }
}

