/*
 * Decompiled with CFR 0.152.
 */
package perffmwk.samples;

import hydra.MasterController;
import hydra.TestConfig;
import perffmwk.PerfStatMgr;
import perffmwk.samples.SamplePrms;
import perffmwk.samples.SampleThreadStatistics;
import perffmwk.samples.SampleVMStatistics;

public class NamedStatClient {
    public static void openStatisticsTask() {
        SampleVMStatistics.getInstance("vm-warmup", "warmup");
        SampleVMStatistics.getInstance("vm-work", "work");
        SampleThreadStatistics.getInstance("thread-warmup", "warmup");
        SampleThreadStatistics.getInstance("thread-work", "work");
    }

    public static void workWithStatisticsTask() {
        NamedStatClient c = new NamedStatClient();
        c.workWithStatistics();
    }

    public static void closeStatisticsTask() {
        SampleThreadStatistics.getInstance("vm-warmup").close();
        SampleThreadStatistics.getInstance("vm-work").close();
        SampleVMStatistics.getInstance("thread-warmup").close();
        SampleVMStatistics.getInstance("thread-work").close();
    }

    protected void workWithStatistics() {
        SampleVMStatistics vmStats = SampleVMStatistics.getInstance("vm-warmup");
        SampleThreadStatistics threadStats = SampleThreadStatistics.getInstance("thread-warmup");
        PerfStatMgr.getInstance().startTrim("warmup");
        this.doSomething(TestConfig.tab().intAt(SamplePrms.warmupIterations), vmStats, threadStats);
        PerfStatMgr.getInstance().endTrim("warmup");
        vmStats = SampleVMStatistics.getInstance("vm-work");
        threadStats = SampleThreadStatistics.getInstance("thread-work");
        PerfStatMgr.getInstance().startTrim("work");
        this.doSomething(TestConfig.tab().intAt(SamplePrms.workIterations), vmStats, threadStats);
        PerfStatMgr.getInstance().endTrim("work");
    }

    protected void doSomething(int iterations, SampleVMStatistics vmStats, SampleThreadStatistics threadStats) {
        for (int i = 0; i < iterations; ++i) {
            threadStats.startOperation();
            this.doSomethingHere();
            threadStats.endOperation();
        }
        vmStats.incLoops();
    }

    protected void doSomethingHere() {
        MasterController.sleepForMs(10);
    }
}

