/*
 * Decompiled with CFR 0.152.
 */
package perffmwk.samples;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.internal.NanoTimer;
import perffmwk.PerformanceStatistics;

public class SampleThreadStatistics
extends PerformanceStatistics {
    private static final int SCOPE = 0;
    protected static final String OPS = "operations";
    protected static final String OP_TIME = "operationTime";
    private NanoTimer t = new NanoTimer();

    public static StatisticDescriptor[] getStatisticDescriptors() {
        boolean largerIsBetter = true;
        return new StatisticDescriptor[]{SampleThreadStatistics.factory().createLongCounter(OPS, "Number of get operations per thread", OPS, largerIsBetter), SampleThreadStatistics.factory().createLongCounter(OP_TIME, "Time per get operation per thread", "nanoseconds", !largerIsBetter)};
    }

    public static SampleThreadStatistics getInstance() {
        return (SampleThreadStatistics)SampleThreadStatistics.getInstance(SampleThreadStatistics.class, 0);
    }

    public static SampleThreadStatistics getInstance(String name) {
        return (SampleThreadStatistics)SampleThreadStatistics.getInstance(SampleThreadStatistics.class, 0, name);
    }

    public static SampleThreadStatistics getInstance(String name, String trimspecName) {
        return (SampleThreadStatistics)SampleThreadStatistics.getInstance(SampleThreadStatistics.class, 0, name, trimspecName);
    }

    public SampleThreadStatistics(Class cls, StatisticsType type, int scope, String instanceName, String trimspecName) {
        super(cls, type, scope, instanceName, trimspecName);
    }

    public long readOps() {
        return this.statistics().getLong(OPS);
    }

    public void incOps(long amount) {
        this.statistics().incLong(OPS, amount);
    }

    public void incOpTime(long amount) {
        this.statistics().incLong(OP_TIME, amount);
    }

    public void startOperation() {
        this.t.reset();
    }

    public void endOperation() {
        this.statistics().incLong(OPS, 1L);
        this.statistics().incLong(OP_TIME, this.t.reset());
    }
}

