/*
 * Decompiled with CFR 0.152.
 */
package perffmwk.samples;

import hydra.MasterController;
import hydra.TestConfig;
import perffmwk.PerfStatMgr;
import perffmwk.samples.SamplePrms;
import perffmwk.samples.SampleThreadStatistics;
import perffmwk.samples.SampleVMStatistics;

public class StatClient {
    public static void openStatisticsTask() {
        long start = System.currentTimeMillis();
        SampleVMStatistics.getInstance();
        long t = System.currentTimeMillis() - start;
        System.out.println("HEY: time to get vm stats, in ms: " + t);
        start = System.currentTimeMillis();
        SampleThreadStatistics.getInstance();
        t = System.currentTimeMillis() - start;
        System.out.println("HEY: time to get thread stats, in ms: " + t);
    }

    public static void workWithStatisticsTask() {
        StatClient c = new StatClient();
        c.workWithStatistics();
    }

    public static void closeStatisticsTask() {
        SampleThreadStatistics.getInstance().close();
        SampleVMStatistics.getInstance().close();
    }

    protected void workWithStatistics() {
        this.doSomething(TestConfig.tab().intAt(SamplePrms.warmupIterations));
        PerfStatMgr.getInstance().startTrim();
        this.doSomething(TestConfig.tab().intAt(SamplePrms.workIterations));
        PerfStatMgr.getInstance().endTrim();
    }

    protected void doSomething(int iterations) {
        SampleThreadStatistics threadStats = SampleThreadStatistics.getInstance();
        for (int i = 0; i < iterations; ++i) {
            threadStats.startOperation();
            this.doSomethingHere();
            threadStats.endOperation();
        }
        SampleVMStatistics.getInstance().incLoops();
    }

    protected void doSomethingHere() {
        MasterController.sleepForMs(10);
    }
}

