/*
 * Decompiled with CFR 0.152.
 */
package query.common;

import cacheperf.gemfire.query.QueryPerfPrms;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryExecutionTimeoutException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.internal.QueryObserverAdapter;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import event.ETListener;
import event.EventBB;
import event.EventPrms;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.CachePrms;
import hydra.ClientPrms;
import hydra.DiskStoreHelper;
import hydra.DistributedSystemHelper;
import hydra.FileUtil;
import hydra.GemFireDescription;
import hydra.GemFirePrms;
import hydra.HydraThreadLocal;
import hydra.HydraVector;
import hydra.Log;
import hydra.PoolDescription;
import hydra.PoolHelper;
import hydra.PoolPrms;
import hydra.ProcessMgr;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import objects.ObjectHelper;
import parReg.ParRegUtil;
import pdx.PdxETListener;
import pdx.PdxTest;
import query.common.QueryBB;
import query.common.QueryPrms;
import query.common.QueryValidator;
import util.CacheUtil;
import util.EventCountersBB;
import util.NameFactory;
import util.RandomValues;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;

public class QueryTest {
    protected static QueryTest queryTest;
    protected static final int ADD_OPERATION = 1;
    protected static final int UPDATE_OPERATION = 2;
    protected static final int INVALIDATE_OPERATION = 3;
    protected static final int DESTROY_OPERATION = 4;
    protected static final int READ_OPERATION = 5;
    protected static final int LOCAL_INVALIDATE_OPERATION = 6;
    protected static final int LOCAL_DESTROY_OPERATION = 7;
    protected static final int QUERY_OPERATION = 8;
    protected static final int CREATE_INDEX_OPERATION = 9;
    protected static final int REMOVE_INDEX_OPERATION = 10;
    protected static final int COUNT_QUERY_OPERATION = 11;
    protected static final int PDXSTRING_QUERY_OPERATION = 12;
    protected static boolean pdxReadSerialized;
    protected static HydraThreadLocal origClassLoader;
    protected int numOfRegions;
    protected boolean isSerialExecution;
    protected boolean isCarefulValidation = false;
    protected boolean ignoreQueryExecTimeOutException;
    protected int queryLimit = -1;
    public static final int MILLIS_TO_WAIT = 60000;
    protected int numVMs;
    protected long minTaskGranularitySec;
    protected long minTaskGranularityMS;
    protected RandomValues randomValues = null;
    protected int maxObjects;
    protected DistributedLockService distLockService;
    public Pool pool;
    protected static final String createCallbackPrefix = "Create event originated in pid ";
    protected static final String updateCallbackPrefix = "Update event originated in pid ";
    protected static final String invalidateCallbackPrefix = "Invalidate event originated in pid ";
    protected static final String destroyCallbackPrefix = "Destroy event originated in pid ";
    protected static String LOCK_SERVICE_NAME;
    protected static String LOCK_NAME;
    public static final String REGION_NAME = "QueryRegion";
    private static Query[] queries;
    private static boolean queriesRead;

    public static synchronized void HydraTask_initialize() {
        if (queryTest == null) {
            boolean isBridgeConfiguration;
            queryTest = new QueryTest();
            GemFireDescription gfd = DistributedSystemHelper.getGemFireDescription();
            Log.getLogWriter().info("gfd.getSysDirName()::" + gfd.getSysDirName());
            Log.getLogWriter().info("gfd.getSystemDirectoryStr()::" + gfd.getSystemDirectoryStr());
            Log.getLogWriter().info("gfd.getSystemDirectory():: " + gfd.getSystemDirectory());
            queryTest.initialize();
            boolean bl = isBridgeConfiguration = TestConfig.tab().stringAt(BridgePrms.names, null) != null;
            if (isBridgeConfiguration) {
                BridgeHelper.startBridgeServer("bridge");
            }
        }
    }

    public static synchronized void HydraTask_initialize_xml() {
        if (queryTest == null) {
            boolean isBridgeConfiguration;
            queryTest = new QueryTest();
            String xmlFilename = TestConfig.tasktab().stringAt(QueryPrms.xmlFilename, TestConfig.tab().stringAt(QueryPrms.xmlFilename, null));
            GemFireDescription gfd = DistributedSystemHelper.getGemFireDescription();
            Log.getLogWriter().info("gfd.getSysDirName()::" + gfd.getSysDirName());
            String baseDir = gfd.getSysDirName();
            baseDir = baseDir.substring(0, baseDir.lastIndexOf(File.separator));
            xmlFilename = xmlFilename.substring(0, xmlFilename.indexOf("."));
            int myId = RemoteTestModule.getMyVmid();
            Log.getLogWriter().info("My Id = " + myId);
            FileUtil.mkdir(baseDir + File.separator + "queryDiskStore" + myId);
            queryTest.initialize(xmlFilename + myId + ".xml");
            boolean bl = isBridgeConfiguration = TestConfig.tab().stringAt(BridgePrms.names, null) != null;
            if (isBridgeConfiguration) {
                BridgeHelper.startBridgeServer("bridge");
            }
        }
    }

    public static synchronized void HydraTask_initialize_clientCache() {
        if (queryTest == null) {
            queryTest = new QueryTest();
            queryTest.initialize_clientCache();
        }
    }

    public void initialize_clientCache() {
        String poolConfigName;
        Cache myCache = CacheHelper.createCache("cache1");
        this.maxObjects = TestConfig.tab().intAt(EventPrms.maxObjects, 20000);
        String regDescriptName = "accessorRegion";
        PoolDescription poolDescript = RegionHelper.getRegionDescription(regDescriptName).getPoolDescription();
        ParRegUtil.createDiskStoreIfNecessary(regDescriptName);
        RegionAttributes attr = RegionHelper.getRegionAttributes(regDescriptName);
        String regionName = RegionHelper.getRegionDescription(regDescriptName).getRegionName();
        if (poolDescript != null && (poolConfigName = RegionHelper.getRegionDescription(regDescriptName).getPoolDescription().getName()) != null) {
            this.pool = PoolHelper.createPool(poolConfigName);
            this.pool.getQueryService();
        }
        Region aRegion = CacheHelper.getCache().createRegion(regionName, attr);
        ParRegUtil.registerInterest(aRegion);
    }

    public void initialize() {
        String xmlFilename = TestConfig.tasktab().stringAt(QueryPrms.xmlFilename, TestConfig.tab().stringAt(QueryPrms.xmlFilename, null));
        this.initialize(xmlFilename);
    }

    public void initialize(String xmlFilename) {
        this.numOfRegions = TestConfig.getInstance().getRegionDescriptions().size();
        this.numOfRegions = this.numOfRegions == 0 ? 1 : this.numOfRegions;
        this.ignoreQueryExecTimeOutException = TestConfig.tab().booleanAt(QueryPrms.ignoreTimeOutException, false);
        Log.getLogWriter().info("Num of regions::" + this.numOfRegions);
        if (xmlFilename != null) {
            this.createCacheFromXml(xmlFilename);
            CacheUtil.setCache(CacheHelper.getCache());
            Set regions = CacheHelper.getCache().rootRegions();
            this.numOfRegions = regions.size();
            for (Region region : regions) {
                this.numOfRegions += region.subregions(true).size();
            }
        } else {
            this.createRootRegions();
        }
        pdxReadSerialized = CacheHelper.getCache().getPdxReadSerialized();
        this.isSerialExecution = EventBB.isSerialExecution();
        this.isCarefulValidation = this.isCarefulValidation || this.isSerialExecution;
        this.queryLimit = TestConfig.tab().intAt(QueryPrms.queryLimit, -1);
        this.numVMs = 0;
        HydraVector gemFireNamesVec = TestConfig.tab().vecAt(GemFirePrms.names);
        HydraVector numVMsVec = TestConfig.tab().vecAt(ClientPrms.vmQuantities);
        if (gemFireNamesVec.size() == numVMsVec.size()) {
            for (int i = 0; i < numVMsVec.size(); ++i) {
                this.numVMs += new Integer((String)numVMsVec.elementAt(i)).intValue();
            }
        } else {
            this.numVMs = new Integer((String)numVMsVec.elementAt(0)) * gemFireNamesVec.size();
        }
        Log.getLogWriter().info("numVMs is " + this.numVMs);
        this.minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        this.minTaskGranularityMS = this.minTaskGranularitySec * 1000L;
        this.maxObjects = TestConfig.tab().intAt(EventPrms.maxObjects, 20000);
        this.randomValues = new RandomValues();
        if (xmlFilename == null) {
            QueryTest.createLockService();
        }
        EventBB.getBB().printSharedCounters();
        EventCountersBB.getBB().printSharedCounters();
    }

    static synchronized void createLockService() {
        if (QueryTest.queryTest.distLockService == null) {
            Log.getLogWriter().info("Creating lock service " + LOCK_SERVICE_NAME);
            QueryTest.queryTest.distLockService = DistributedLockService.create((String)LOCK_SERVICE_NAME, (DistributedSystem)DistributedSystemHelper.getDistributedSystem());
            Log.getLogWriter().info("Created lock service " + LOCK_SERVICE_NAME);
        }
    }

    public static void HydraTask_load() {
        long lastLogTime;
        long LOG_INTERVAL_MILLIS = 10000L;
        long startTime = lastLogTime = System.currentTimeMillis();
        int regionNumber = 0;
        ArrayList regionList = new ArrayList(CacheHelper.getCache().rootRegions());
        do {
            regionNumber = new Random().nextInt(QueryTest.queryTest.numOfRegions);
            regionNumber = (regionNumber + 1) % QueryTest.queryTest.numOfRegions;
            Region aRegion = (Region)regionList.get(regionNumber);
            HashMap<String, Object> aMap = new HashMap<String, Object>();
            for (int i = 1; i <= 100; ++i) {
                String name = NameFactory.getNextPositiveObjectNameInLimit(QueryTest.queryTest.maxObjects);
                aMap.put(name, queryTest.getObjectToAdd(name));
            }
            aRegion.putAll(aMap);
            aMap = null;
            long entries = NameFactory.getPositiveNameCounter();
            if (entries >= (long)QueryTest.queryTest.maxObjects) {
                TestHelper.checkForEventError(EventCountersBB.getBB());
                String aStr = "Done loading " + entries + " entries in " + QueryTest.queryTest.numOfRegions + " regions";
                throw new StopSchedulingTaskOnClientOrder(aStr);
            }
            if (System.currentTimeMillis() - lastLogTime <= 10000L) continue;
            Log.getLogWriter().info("Added " + entries + " entries out of " + QueryTest.queryTest.maxObjects + " in " + QueryTest.queryTest.numOfRegions + " regions");
            lastLogTime = System.currentTimeMillis();
            TestHelper.checkForEventError(EventCountersBB.getBB());
        } while (System.currentTimeMillis() - startTime < QueryTest.queryTest.minTaskGranularityMS);
    }

    public static void HydraTask_populateRegions() {
        ArrayList regionList = new ArrayList(CacheHelper.getCache().rootRegions());
        for (Region aRegion : regionList) {
            HashMap aMap = new HashMap();
            for (int j = 0; j < QueryTest.queryTest.maxObjects; ++j) {
                String objectType = TestConfig.tab().stringAt(QueryPrms.objectType);
                Object val = ObjectHelper.createObject(objectType, j);
                aRegion.put((Object)(j + ""), val);
            }
        }
    }

    public static void HydraTask_doEntryAndQueryOperations() {
        origClassLoader.set(Thread.currentThread().getContextClassLoader());
        PdxTest.initClassLoader();
        if (queryTest != null) {
            queryTest.doEntryAndQueryOperations();
        }
    }

    public Region getRandomRegionWithValueConstrains() {
        Region aRegion = null;
        HashSet allRegions = new HashSet();
        Set rootRegions = CacheHelper.getCache().rootRegions();
        allRegions.addAll(rootRegions);
        for (Region region : rootRegions) {
            allRegions.addAll(region.subregions(true));
        }
        int attempts = 0;
        do {
            int regionNumber = new Random().nextInt(this.numOfRegions);
            aRegion = (Region)CacheHelper.getCache().rootRegions().toArray()[regionNumber];
            Log.getLogWriter().info("Obtained region for region operation: " + aRegion.getName() + " ValueConstraint for the region is: " + aRegion.getAttributes().getValueConstraint());
        } while (aRegion.getAttributes().getValueConstraint() != null && ++attempts < 100);
        if (attempts == 100) {
            throw new TestException("Could not obtain a region with ValueConstrainsts are 100 attempts");
        }
        return aRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doEntryAndQueryOperations() {
        aRegion = this.getRandomRegionWithValueConstrains();
        startTime = System.currentTimeMillis();
        if (this.isSerialExecution) {
            QueryTest.logExecutionNumber();
        }
        isMirrored = aRegion.getAttributes().getMirrorType().isMirrored();
        haveALock = false;
        block13: do {
            TestHelper.checkForEventError(EventCountersBB.getBB());
            useRandomLocks = TestConfig.tab().booleanAt(EventPrms.useRandomLocks);
            if (useRandomLocks) {
                Log.getLogWriter().info("Trying to get distributed lock " + QueryTest.LOCK_NAME + "...");
                haveALock = this.distLockService.lock((Object)QueryTest.LOCK_NAME, -1L, -1L);
                Log.getLogWriter().info("Returned from trying to get distributed lock " + QueryTest.LOCK_NAME + ", lock acquired is " + haveALock);
                if (haveALock) {
                    Log.getLogWriter().info("Obtained distributed lock " + QueryTest.LOCK_NAME);
                }
            }
            try {
                QueryBB.putQueryValidator(new QueryValidator());
                whichOp = this.getOperation(QueryPrms.entryAndQueryOperations, isMirrored);
                switch (whichOp) {
                    case 1: {
                        this.addObject(aRegion, true);
                        ** break;
lbl23:
                        // 1 sources

                        continue block13;
                    }
                    case 3: {
                        this.invalidateObject(aRegion, false);
                        ** break;
lbl27:
                        // 1 sources

                        continue block13;
                    }
                    case 4: {
                        this.destroyObject(aRegion, false);
                        ** break;
lbl31:
                        // 1 sources

                        continue block13;
                    }
                    case 2: {
                        this.updateObject(aRegion);
                        ** break;
lbl35:
                        // 1 sources

                        continue block13;
                    }
                    case 5: {
                        this.readObject(aRegion);
                        ** break;
lbl39:
                        // 1 sources

                        continue block13;
                    }
                    case 6: {
                        this.invalidateObject(aRegion, true);
                        ** break;
lbl43:
                        // 1 sources

                        continue block13;
                    }
                    case 7: {
                        this.destroyObject(aRegion, true);
                        ** break;
lbl47:
                        // 1 sources

                        continue block13;
                    }
                    case 8: {
                        this.doQuery(true);
                        ** break;
lbl51:
                        // 1 sources

                        continue block13;
                    }
                    default: {
                        throw new TestException("Unknown operation " + whichOp);
                    }
                }
            }
            finally {
                if (haveALock) {
                    haveALock = false;
                    this.distLockService.unlock((Object)QueryTest.LOCK_NAME);
                    Log.getLogWriter().info("Released distributed lock " + QueryTest.LOCK_NAME);
                }
            }
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
    }

    protected void addObject(Region aRegion, boolean logAddition) {
        String name = NameFactory.getNextPositiveObjectNameInLimit(this.maxObjects);
        Object anObj = this.getObjectToAdd(aRegion.getAttributes().getValueConstraint().getName());
        String callback = createCallbackPrefix + ProcessMgr.getProcessId();
        if (logAddition) {
            Log.getLogWriter().info("addObject: calling put for name " + name + ", object " + TestHelper.toString(anObj) + " callback is " + callback + ", region is " + aRegion.getFullPath());
        }
        try {
            aRegion.put((Object)name, anObj, (Object)callback);
            QueryBB.putQueryValidator(new QueryValidator("add", name, true, true, anObj));
        }
        catch (RegionDestroyedException e) {
            this.handleRegionDestroyedException(aRegion, e);
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        long numPut = EventBB.incrementCounter("EventBB.NUM_CREATE", EventBB.NUM_CREATE);
    }

    protected void invalidateObject(Region aRegion, boolean isLocalInvalidate) {
        Set aSet = aRegion.keySet();
        if (aSet.size() == 0) {
            Log.getLogWriter().info("invalidateObject: No names in region");
            return;
        }
        Iterator it = aSet.iterator();
        Object name = null;
        if (!it.hasNext()) {
            Log.getLogWriter().info("invalidateObject: Unable to get name from region");
            return;
        }
        name = it.next();
        boolean containsValue = aRegion.containsValueForKey(name);
        boolean alreadyInvalidated = !containsValue;
        Log.getLogWriter().info("containsValue for " + name + ": " + containsValue);
        Log.getLogWriter().info("alreadyInvalidated for " + name + ": " + alreadyInvalidated);
        try {
            String callback = invalidateCallbackPrefix + ProcessMgr.getProcessId();
            if (isLocalInvalidate) {
                Log.getLogWriter().info("invalidateObject: local invalidate for " + name + " callback is " + callback);
                aRegion.localInvalidate(name, (Object)callback);
                Log.getLogWriter().info("invalidateObject: done with local invalidate for " + name);
                if (!alreadyInvalidated) {
                    long numInvalidate = EventBB.incrementCounter("EventBB.NUM_LOCAL_INVALIDATE", EventBB.NUM_LOCAL_INVALIDATE);
                    QueryBB.putQueryValidator(new QueryValidator("localInvalidate", name, true, false, null));
                }
            } else {
                Log.getLogWriter().info("invalidateObject: invalidating name " + name + " callback is " + callback);
                aRegion.invalidate(name, (Object)callback);
                Log.getLogWriter().info("invalidateObject: done invalidating name " + name);
                if (!alreadyInvalidated) {
                    long numInvalidate = EventBB.incrementCounter("EventBB.NUM_INVALIDATE", EventBB.NUM_INVALIDATE);
                    QueryBB.putQueryValidator(new QueryValidator("invalidate", name, true, false, null));
                }
            }
            if (this.isCarefulValidation) {
                this.verifyObjectInvalidated(aRegion, name);
            }
        }
        catch (EntryNotFoundException e) {
            if (this.isCarefulValidation) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void destroyObject(Region aRegion, boolean isLocalDestroy) {
        Set aSet = aRegion.keys();
        Iterator iter = aSet.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("destroyObject: No names in region");
            return;
        }
        try {
            Object name = iter.next();
            this.destroyObject(aRegion, name, isLocalDestroy);
        }
        catch (NoSuchElementException e) {
            throw new TestException("Bug 30171 detected: " + TestHelper.getStackTrace(e));
        }
    }

    private void destroyObject(Region aRegion, Object name, boolean isLocalDestroy) {
        try {
            String callback = destroyCallbackPrefix + ProcessMgr.getProcessId();
            if (isLocalDestroy) {
                Log.getLogWriter().info("destroyObject: local destroy for " + name + " callback is " + callback);
                aRegion.localDestroy(name, (Object)callback);
                Log.getLogWriter().info("destroyObject: done with local destroy for " + name);
                long numDestroy = EventBB.incrementCounter("EventBB.NUM_LOCAL_DESTROY", EventBB.NUM_LOCAL_DESTROY);
                QueryBB.putQueryValidator(new QueryValidator("localDestroy", name, false, false, null));
            } else {
                Log.getLogWriter().info("destroyObject: destroying name " + name + " callback is " + callback);
                aRegion.destroy(name, (Object)callback);
                Log.getLogWriter().info("destroyObject: done destroying name " + name);
                long numDestroy = EventBB.incrementCounter("EventBB.NUM_DESTROY", EventBB.NUM_DESTROY);
                QueryBB.putQueryValidator(new QueryValidator("destroy", name, false, false, null));
            }
        }
        catch (EntryNotFoundException e) {
            if (this.isCarefulValidation) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void updateObject(Region aRegion) {
        Set aSet = aRegion.keys();
        Iterator iter = aSet.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("updateObject: No names in region");
            return;
        }
        Object name = iter.next();
        this.updateObject(aRegion, name);
    }

    protected void updateObject(Region aRegion, Object name) {
        Object anObj = null;
        try {
            anObj = aRegion.get(name);
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Object newObj = this.getUpdateObject(aRegion.getAttributes().getValueConstraint().getName());
        try {
            String callback = updateCallbackPrefix + ProcessMgr.getProcessId();
            Log.getLogWriter().info("updateObject: replacing name " + name + " with " + TestHelper.toString(newObj) + "; old value is " + TestHelper.toString(anObj) + ", callback is " + callback);
            aRegion.put(name, newObj, (Object)callback);
            Log.getLogWriter().info("Done with call to put (update)");
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        QueryBB.putQueryValidator(new QueryValidator("update", name, true, true, newObj));
        long numUpdate = EventBB.incrementCounter("EventBB.NUM_UPDATE", EventBB.NUM_UPDATE);
    }

    protected void readObject(Region aRegion) {
        Object anObj;
        Set aSet = aRegion.keySet();
        if (aSet.size() == 0) {
            Log.getLogWriter().info("readObject: No names in region");
            return;
        }
        long maxNames = NameFactory.getPositiveNameCounter();
        if (maxNames <= 0L) {
            Log.getLogWriter().info("readObject: max positive name counter is " + maxNames);
            return;
        }
        String name = NameFactory.getObjectNameForCounter(TestConfig.tab().getRandGen().nextInt(1, (int)maxNames));
        Log.getLogWriter().info("readObject: getting name " + name);
        try {
            anObj = aRegion.get((Object)name);
            Log.getLogWriter().info("readObject: got value for name " + name + ": " + TestHelper.toString(anObj));
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        QueryBB.putQueryValidator(new QueryValidator("read", name, true, true, anObj));
    }

    private static void readQueries() {
        HydraVector hvQueries;
        Map nameToPoolMap = PoolManager.getAll();
        String poolName = TestConfig.tab().stringAt(PoolPrms.names, null);
        QueryService qs = CacheHelper.getCache().getQueryService();
        if (poolName != null && nameToPoolMap.get(poolName) != null) {
            qs = ((Pool)nameToPoolMap.get(poolName)).getQueryService();
        }
        if ((hvQueries = TestConfig.tab().vecAt(QueryPerfPrms.query, null)) != null) {
            queries = new Query[hvQueries.size()];
            for (int i = 0; i < hvQueries.size(); ++i) {
                QueryTest.queries[i] = qs.newQuery((String)hvQueries.get(i));
            }
        }
        queriesRead = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doQuery(boolean logAddition) {
        if (queries == null) {
            QueryTest.readQueries();
        }
        for (int i = 0; i < queries.length; ++i) {
            Log.getLogWriter().info(" query = " + queries[i]);
            Query query = queries[i];
            try {
                ClassLoader previousCL = Thread.currentThread().getContextClassLoader();
                if (pdxReadSerialized) {
                    Log.getLogWriter().info("Setting class loader to remove domain classes in preparation of a query execute: " + origClassLoader.get());
                    Thread.currentThread().setContextClassLoader((ClassLoader)origClassLoader.get());
                }
                Object result = null;
                try {
                    Cache theCache = CacheHelper.getCache();
                    if (theCache != null) {
                        Log.getLogWriter().info("Clearing the pdx registry with a test hook");
                        ((GemFireCacheImpl)theCache).getPdxRegistry().flushCache();
                    }
                    Log.getLogWriter().info("Executing query " + queries[i].toString());
                    result = query.execute();
                    Log.getLogWriter().info("Done executing " + queries[i].toString());
                    continue;
                }
                catch (QueryExecutionTimeoutException e1) {
                    if (!this.ignoreQueryExecTimeOutException) {
                        throw e1;
                    }
                    Log.getLogWriter().info("Caught and ignored QueryExecutionTimeoutException:  " + e1.getMessage());
                    return;
                }
                finally {
                    if (pdxReadSerialized) {
                        Log.getLogWriter().info("Setting class loader back to one that refers to domain classes: " + previousCL);
                        Thread.currentThread().setContextClassLoader(previousCL);
                    }
                }
            }
            catch (Exception e) {
                throw new TestException("Caught exception during query execution" + TestHelper.getStackTrace(e));
            }
        }
    }

    protected Object getObjectToAdd(String classname) {
        Object obj = null;
        try {
            Class<?> cls = Class.forName(classname, true, Thread.currentThread().getContextClassLoader());
            obj = cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new TestException(e.toString());
        }
        catch (InstantiationException e) {
            throw new TestException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new TestException(e.toString());
        }
        return obj;
    }

    protected Object getUpdateObject(String classname) {
        Object obj = null;
        try {
            Class<?> cls = Class.forName(classname, true, Thread.currentThread().getContextClassLoader());
            obj = cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new TestException(e.toString());
        }
        catch (InstantiationException e) {
            throw new TestException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new TestException(e.toString());
        }
        return obj;
    }

    protected CacheListener getCacheListener() {
        String objectType = TestConfig.tab().stringAt(QueryPrms.objectType);
        if (objectType.indexOf("Pdx") > 0 || objectType.indexOf("Versioned") > 0) {
            return new PdxETListener(this.isCarefulValidation);
        }
        return new ETListener(this.isCarefulValidation);
    }

    protected int getNumVMsWithListeners() {
        throw new TestException("getNumVMsWithListeners must be implemented in a subclass");
    }

    protected void createRootRegions() {
        CacheListener listener = queryTest.getCacheListener();
        CacheHelper.createCache("cache1");
        this.initPdxDiskStore();
        for (int i = 0; i < this.numOfRegions; ++i) {
            String regionDescriptionName = "region" + (i + 1);
            AttributesFactory factory = RegionHelper.getAttributesFactory(regionDescriptionName);
            factory.addCacheListener(listener);
            RegionHelper.createRegion(REGION_NAME + "" + i, factory);
        }
    }

    protected void createCacheFromXml(String xmlFilename) {
        CacheHelper.createCacheFromXml(xmlFilename);
    }

    protected int getOperation(Long whichPrm, boolean disallowLocalEntryOps) {
        long limit = 60000L;
        long startTime = System.currentTimeMillis();
        int op = 0;
        do {
            String operation;
            if ((operation = TestConfig.tab().stringAt(whichPrm)).equals("add")) {
                op = 1;
            } else if (operation.equals("update")) {
                op = 2;
            } else if (operation.equals("invalidate")) {
                op = 3;
            } else if (operation.equals("destroy")) {
                op = 4;
            } else if (operation.equals("read")) {
                op = 5;
            } else if (operation.equals("localInvalidate")) {
                op = 6;
            } else if (operation.equals("localDestroy")) {
                op = 7;
            } else if (operation.equals("query")) {
                op = 8;
            } else if (operation.equals("countquery")) {
                op = 11;
            } else if (operation.equals("createIndex")) {
                op = 9;
            } else if (operation.equals("removeIndex")) {
                op = 10;
            } else if (operation.equals("pdxStringQuery")) {
                op = 12;
            } else {
                throw new TestException("Unknown entry operation: " + operation);
            }
            if (System.currentTimeMillis() - startTime <= limit) continue;
            throw new TestException("Could not find an operation in " + limit + " millis; disallowLocalEntryOps is " + true + "; check that the operations list has allowable choices");
        } while (disallowLocalEntryOps && (op == 6 || op == 7));
        return op;
    }

    protected static void logExecutionNumber() {
        long exeNum = EventBB.getBB().getSharedCounters().incrementAndRead(EventBB.EXECUTION_NUMBER);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
    }

    protected void handleRegionDestroyedException(Region aRegion, RegionDestroyedException anException) {
        if (this.isCarefulValidation) {
            throw new TestException(TestHelper.getStackTrace(anException));
        }
        if (!anException.getRegionFullPath().equals(aRegion.getFullPath())) {
            TestException te = new TestException("Got a RegionDestroyedException when operating on region " + TestHelper.regionToString(aRegion, false) + ", but the region destroyed is '" + anException.getRegionFullPath() + "'");
            te.initCause(anException);
            throw te;
        }
        boolean isDestroyed = aRegion.isDestroyed();
        if (!isDestroyed) {
            throw new TestException("Bug 30645 (likely): isDestroyed returned " + isDestroyed + " for region " + TestHelper.regionToString(aRegion, false) + ", but a region destroyed exception was thrown: " + TestHelper.getStackTrace(anException));
        }
        Log.getLogWriter().info("Got " + RegionDestroyedException.class.getName() + " on " + TestHelper.regionToString(aRegion, false) + "; exception expected, continuing test");
    }

    protected void verifyObjectInvalidated(Region aRegion, Object key) {
        Object entryValue;
        Object entryKey;
        Region.Entry entry;
        boolean containsValueForKey;
        StringBuffer errStr = new StringBuffer();
        boolean containsKey = aRegion.containsKey(key);
        if (!containsKey) {
            errStr.append("Unexpected containsKey " + containsKey + " for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        if (containsValueForKey = aRegion.containsValueForKey(key)) {
            errStr.append("Unexpected containsValueForKey " + containsValueForKey + " for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        if ((entry = aRegion.getEntry(key)) == null) {
            errStr.append("getEntry for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + " returned null\n");
        }
        if (!(entryKey = entry.getKey()).equals(key)) {
            errStr.append("getEntry.getKey() " + entryKey + " does not equal key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        if ((entryValue = entry.getValue()) != null) {
            errStr.append("Expected getEntry.getValue() " + TestHelper.toString(entryValue) + " to be null.\n");
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
    }

    protected void verifyObjectDestroyed(Region aRegion, Object key) {
        Region.Entry entry;
        boolean containsValueForKey;
        StringBuffer errStr = new StringBuffer();
        boolean containsKey = aRegion.containsKey(key);
        if (containsKey) {
            errStr.append("Unexpected containsKey " + containsKey + " for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        if (containsValueForKey = aRegion.containsValueForKey(key)) {
            errStr.append("Unexpected containsValueForKey " + containsValueForKey + " for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        if ((entry = aRegion.getEntry(key)) != null) {
            errStr.append("getEntry for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + " returned was non-null; getKey is " + entry.getKey() + ", value is " + TestHelper.toString(entry.getValue()) + "\n");
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
    }

    private void initPdxDiskStore() {
        String pdxDiskStoreName;
        if (CacheHelper.getCache().getPdxPersistent() && (pdxDiskStoreName = TestConfig.tab().stringAt(CachePrms.pdxDiskStoreName, null)) != null && CacheHelper.getCache().findDiskStore(pdxDiskStoreName) == null) {
            DiskStoreHelper.createDiskStore(pdxDiskStoreName);
        }
    }

    static {
        pdxReadSerialized = false;
        origClassLoader = new HydraThreadLocal();
        LOCK_SERVICE_NAME = "MyLockService";
        LOCK_NAME = "MyLock";
        queries = null;
        queriesRead = false;
    }

    public static class QueryObserverImpl
    extends QueryObserverAdapter {
        boolean isIndexesUsed = false;
        ArrayList indexesUsed = new ArrayList();

        public void beforeIndexLookup(Index index, int oper, Object key) {
            this.indexesUsed.add(index.getName());
        }

        public void afterIndexLookup(Collection results) {
            if (results != null) {
                this.isIndexesUsed = true;
            }
        }

        public void beforeIndexLookup(Index index, int lowerBoundOperator, Object lowerBoundKey, int upperBoundOperator, Object upperBoundKey, Set NotEqualKeys) {
            this.indexesUsed.add(index.getName());
        }
    }
}

