/*
 * Decompiled with CFR 0.152.
 */
package query.common.index;

import cacheperf.CachePerfPrms;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.internal.Assert;
import distcache.gemfire.GemFireCachePrms;
import hydra.CacheHelper;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.Log;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.Collection;
import java.util.Iterator;
import util.TestException;
import util.TestHelper;

public class IndexTest {
    protected static IndexTest indexTest;

    public static void HydraTask_createIndexes() {
        if (indexTest == null) {
            indexTest = new IndexTest();
        }
        indexTest.createIndexes();
    }

    protected void createIndexes() {
        int i;
        HydraVector hvIndexesFromClauses;
        String[] indexes = null;
        String[] indexFromClauses = null;
        HydraVector hvIndexesExprs = TestConfig.tab().vecAt(CachePerfPrms.queryIndex, null);
        if (hvIndexesExprs != null) {
            indexes = new String[hvIndexesExprs.size()];
            for (int i2 = 0; i2 < hvIndexesExprs.size(); ++i2) {
                indexes[i2] = (String)hvIndexesExprs.get(i2);
            }
        }
        if ((hvIndexesFromClauses = TestConfig.tab().vecAt(CachePerfPrms.queryFromClause, null)) != null) {
            indexFromClauses = new String[hvIndexesFromClauses.size()];
            for (i = 0; i < hvIndexesFromClauses.size(); ++i) {
                indexFromClauses[i] = (String)hvIndexesFromClauses.get(i);
            }
        }
        if (hvIndexesExprs != null) {
            Assert.assertTrue((indexFromClauses.length == indexes.length ? 1 : 0) != 0, (Object)"Number of index expressions and index fromclauses in conf file are not same.");
            for (i = 0; i < indexes.length; ++i) {
                try {
                    Log.getLogWriter().info("Creating index: indexedExpression: " + indexes[i] + " fromClause: " + indexFromClauses[i]);
                    CacheHelper.getCache().getQueryService().createIndex("index" + i, indexes[i], indexFromClauses[i]);
                    continue;
                }
                catch (IndexExistsException e) {
                    Log.getLogWriter().info("index already created");
                    continue;
                }
                catch (IndexNameConflictException e) {
                    Log.getLogWriter().info("index already created");
                    continue;
                }
                catch (QueryException e) {
                    String s = "Problem creating index: " + indexes[i] + " " + indexFromClauses[i];
                    throw new HydraRuntimeException(s, (Exception)((Object)e));
                }
            }
        }
    }

    public void createIndex(int regionNumber) {
        String RegionName2 = "QueryRegion" + regionNumber;
    }

    public static synchronized void HydraTask_RemoveIndex() {
        if (indexTest == null) {
            indexTest = new IndexTest();
        }
        indexTest.removeIndex(GemFireCachePrms.getRegionName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeIndex(String RegionName2) {
        Region region = RegionHelper.getRegion(RegionName2);
        if (region == null) {
            Log.getLogWriter().info("The region is not created properly");
            return;
        } else {
            Log.getLogWriter().info("Obtained the region with name :" + RegionName2);
            QueryService qs = CacheHelper.getCache().getQueryService();
            if (qs != null) {
                try {
                    Collection indexes = qs.getIndexes(region);
                    if (indexes == null) {
                        return;
                    }
                    if (indexes.size() == 0) {
                        return;
                    }
                    Iterator iter = indexes.iterator();
                    if (!iter.hasNext()) return;
                    Index idx = (Index)iter.next();
                    String name = idx.getName();
                    qs.removeIndex(idx);
                    Log.getLogWriter().info("Index " + name + " removed successfully");
                    return;
                }
                catch (Exception e) {
                    throw new TestException("Could not remove Index " + TestHelper.getStackTrace(e));
                }
            } else {
                Log.getLogWriter().info("Could not obtain QueryService for the cache ");
            }
        }
    }
}

