/*
 * Decompiled with CFR 0.152.
 */
package query.context;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.internal.IndexTrackingQueryObserver;
import com.gemstone.gemfire.cache.query.internal.QueryObserver;
import com.gemstone.gemfire.cache.query.internal.QueryObserverHolder;
import com.gemstone.gemfire.cache.query.internal.StructImpl;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import event.EventPrms;
import hydra.CacheHelper;
import hydra.HydraVector;
import hydra.Log;
import hydra.Prms;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import objects.ObjectHelper;
import objects.PRPortfolio;
import parReg.ParRegUtil;
import query.QueryPrms;
import query.QueryTest;
import query.context.QueryFunction;
import query.context.QueryFunctionContextBB;
import util.NameFactory;
import util.TestException;

public class QueryFunctionExecTest
extends QueryTest {
    protected static int numOfRegions;
    protected static boolean isSerialExecution;
    protected static final int QUERY_NO_FILTER_OPERATION = 8;
    protected static final int QUERY_SINGLE_FILTER_OPERATION = 9;
    protected static final int QUERY_FILTER_OPERATION = 10;
    protected static final int REGION_CLOSE_REBLANCE_OPERATION = 11;

    public static void HydraTask_initialize_peers() {
        queryTest = new QueryFunctionExecTest();
        isSerialExecution = TestConfig.tab().booleanAt(Prms.serialExecution);
        numOfRegions = TestConfig.getInstance().getRegionDescriptions().size();
        queryTest.initialize();
    }

    public static void HydraTask_populateRegions() {
        queryTest = new QueryFunctionExecTest();
        isSerialExecution = TestConfig.tab().booleanAt(Prms.serialExecution);
        ((QueryFunctionExecTest)queryTest).populateRegions();
    }

    protected void populateRegions() {
        this.maxObjects = TestConfig.tab().intAt(EventPrms.maxObjects, 20000);
        ArrayList regionList = new ArrayList(CacheHelper.getCache().rootRegions());
        for (Region aRegion : regionList) {
            HashMap<Integer, PRPortfolio> aMap = new HashMap<Integer, PRPortfolio>();
            for (int j = 0; j < this.maxObjects; ++j) {
                String name = NameFactory.getNextPositiveObjectNameInLimit(this.maxObjects);
                aMap.put(new Integer(j), new PRPortfolio(name + j, j));
            }
            aRegion.putAll(aMap);
        }
    }

    public static void HydraTask_verifyRegionSizeAndValues() {
        ArrayList regionList = new ArrayList(CacheHelper.getCache().rootRegions());
        Region aRegion = (Region)regionList.get(0);
        if (!aRegion.getName().startsWith("QueryRegion")) {
            throw new TestException("Expected region name: QueryRegionX Actual:" + aRegion.getName());
        }
        int numObj = TestConfig.tab().intAt(EventPrms.maxObjects, 20000);
        if (aRegion.keySet().size() != numObj) {
            throw new TestException("Expected region size: " + numObj + " Actual:" + aRegion.keySet().size());
        }
    }

    @Override
    public void initialize() {
        this.maxObjects = TestConfig.tab().intAt(EventPrms.maxObjects, 20000);
        CacheHelper.createCache("cache1");
        String regionDescriptionName = "region1";
        AttributesFactory factory = RegionHelper.getAttributesFactory(regionDescriptionName);
        Region region1 = RegionHelper.createRegion("QueryRegion1", factory);
        for (int j = 0; j < this.maxObjects; ++j) {
            region1.put((Object)new Integer(j), (Object)new PRPortfolio("name" + j, j));
        }
    }

    public static void HydraTask_initRegisterFunction() {
        QueryFunction prQueryFunction1 = new QueryFunction();
        FunctionService.registerFunction((Function)prQueryFunction1);
    }

    public static void HydraTask_doEntryAndQueryOperations() {
        Log.getLogWriter().info("INSIDE HydraTask_doEntryAndQueryOperations ");
        if (queryTest == null) {
            queryTest = new QueryFunctionExecTest();
        }
        if (queryTest != null) {
            Log.getLogWriter().info("INSIDE HydraTask_doEntryAndQueryOperations IF ");
            ((QueryFunctionExecTest)queryTest).doEntryAndQueryOperations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doEntryAndQueryOperations() {
        this.maxObjects = TestConfig.tab().intAt(EventPrms.maxObjects, 20000);
        Log.getLogWriter().info("INSIDE doEntryAndQueryOperations ");
        Region aRegion = CacheFactory.getAnyInstance().getRegion("QueryRegion1");
        long startTime = System.currentTimeMillis();
        long iter = 0L;
        do {
            Log.getLogWriter().info("INSIDE DO iter = " + ++iter);
            Log.getLogWriter().info("INSIDE TRY iter = " + iter);
            int whichOp = QueryFunctionExecTest.getOperation(QueryPrms.entryAndQueryOperations);
            Log.getLogWriter().info("INSIDE TRY whichOp =  " + whichOp);
            switch (whichOp) {
                case 1: {
                    this.addObject(aRegion, true);
                    break;
                }
                case 3: {
                    this.invalidateObject(aRegion, false);
                    break;
                }
                case 4: {
                    this.destroyObject(aRegion, false);
                    break;
                }
                case 2: {
                    this.updateObject(aRegion);
                    break;
                }
                case 5: {
                    this.readObject(aRegion);
                    break;
                }
                case 8: {
                    Log.getLogWriter().info("Invoking function with no filter");
                    QueryFunctionExecTest.HydraTask_ExecuteFunction_NoFilter();
                    break;
                }
                case 10: {
                    Log.getLogWriter().info("Invoking function with filter keys");
                    QueryFunctionExecTest.HydraTask_ExecuteFunction_Filter();
                    break;
                }
                case 9: {
                    Log.getLogWriter().info("Invoking function with single filter key");
                    QueryFunctionExecTest.HydraTask_ExecuteFunction_Filter_SingleKey();
                    break;
                }
                case 11: {
                    Log.getLogWriter().info("Invoking function PR close and rebalance");
                    QueryFunctionExecTest.HydraTask_close_rebalancePR();
                    break;
                }
                default: {
                    throw new TestException("Unknown operation " + whichOp);
                }
            }
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
    }

    protected static int getOperation(Long whichPrm) {
        long limit = 60000L;
        long startTime = System.currentTimeMillis();
        int op = 0;
        String operation = TestConfig.tab().stringAt(whichPrm);
        if (operation.equals("add")) {
            op = 1;
        } else if (operation.equals("update")) {
            op = 2;
        } else if (operation.equals("invalidate")) {
            op = 3;
        } else if (operation.equals("destroy")) {
            op = 4;
        } else if (operation.equals("read")) {
            op = 5;
        } else if (operation.equals("query_no_filter")) {
            op = 8;
        } else if (operation.equals("query_filter")) {
            op = 10;
        } else if (operation.equals("query_single_filter")) {
            op = 9;
        } else if (operation.equals("region_close_rebalance")) {
            op = 11;
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        if (System.currentTimeMillis() - startTime > limit) {
            throw new TestException("Could not find an operation in " + limit + " check that the operations list has allowable choices");
        }
        return op;
    }

    protected Object getObjectToAdd(Long key) {
        long i = NameFactory.getPositiveNameCounter();
        int index = (int)(i % (long)this.maxObjects);
        String objectType = TestConfig.tab().stringAt(QueryPrms.objectType);
        Object val = ObjectHelper.createObject(objectType, index);
        return val;
    }

    protected void addObject(Region aRegion) {
        long key = NameFactory.getPositiveNameCounter();
        aRegion.put((Object)key, this.getObjectToAdd(key));
    }

    protected void invalidateObject(Region aRegion) {
        boolean alreadyInvalidated;
        Set aSet = aRegion.keySet();
        if (aSet.size() == 0) {
            Log.getLogWriter().info("invalidateObject: No names in region");
            return;
        }
        Iterator it = aSet.iterator();
        Object key = null;
        if (!it.hasNext()) {
            Log.getLogWriter().info("invalidateObject: Unable to get key from region");
            return;
        }
        key = it.next();
        boolean containsValue = aRegion.containsValueForKey(key);
        boolean bl = alreadyInvalidated = !containsValue;
        if (!alreadyInvalidated) {
            aRegion.invalidate(key);
        }
    }

    protected void destroyObject(Region aRegion) {
        Set aSet = aRegion.keySet();
        if (aSet.size() == 0) {
            Log.getLogWriter().info("destroyObject: No names in region");
            return;
        }
        Iterator it = aSet.iterator();
        Object key = null;
        if (!it.hasNext()) {
            Log.getLogWriter().info("destroyObject: Unable to get key from region");
            return;
        }
        key = it.next();
        aRegion.destroy(key);
    }

    protected Object getUpdateObject() {
        String objectType = TestConfig.tab().stringAt(QueryPrms.objectType);
        Object val = ObjectHelper.createObject(objectType, 0);
        return val;
    }

    @Override
    protected void updateObject(Region aRegion) {
        Set aSet = aRegion.keySet();
        if (aSet.size() == 0) {
            Log.getLogWriter().info("updateObject: No names in region");
            return;
        }
        Iterator it = aSet.iterator();
        Object key = null;
        if (!it.hasNext()) {
            Log.getLogWriter().info("updateObject: Unable to get key from region");
            return;
        }
        key = it.next();
        aRegion.put(key, this.getUpdateObject());
    }

    @Override
    protected void readObject(Region aRegion) {
        Set aSet = aRegion.keySet();
        if (aSet.size() == 0) {
            Log.getLogWriter().info("readObject: No names in region");
            return;
        }
        Iterator it = aSet.iterator();
        Object key = null;
        if (!it.hasNext()) {
            Log.getLogWriter().info("readObject: Unable to get key from region");
            return;
        }
        key = it.next();
        aRegion.get(key);
    }

    public static void HydraTask_ExecuteFunction_NoFilter() {
        int i;
        HydraVector hvExpResultSizes = TestConfig.tab().vecAt(QueryPrms.expectedQueryResultSizes, null);
        HydraVector hvQueries = TestConfig.tab().vecAt(QueryPrms.queryStrings, null);
        if (hvQueries == null) {
            throw new TestException("No Queries specified ");
        }
        if (hvExpResultSizes == null) {
            throw new TestException("Need expected query result sizes to run this method ");
        }
        if (hvExpResultSizes.size() != hvQueries.size()) {
            throw new TestException("Query count and their result sizes count should be same in conf file ");
        }
        Object[] expectedResultSizesStrs = new String[hvExpResultSizes.size()];
        Integer[] expectedResultSizes = new Integer[hvExpResultSizes.size()];
        Object[] queries = new String[hvQueries.size()];
        hvQueries.copyInto(queries);
        hvExpResultSizes.copyInto(expectedResultSizesStrs);
        for (int i2 = 0; i2 < expectedResultSizesStrs.length; ++i2) {
            expectedResultSizes[i2] = Integer.parseInt(((String)expectedResultSizesStrs[i2]).trim());
        }
        int[] resultSizes = new int[queries.length];
        for (i = 0; i < queries.length; ++i) {
            SharedCounters counters = QueryFunctionContextBB.getBB().getSharedCounters();
            if (isSerialExecution) {
                counters.zero(QueryFunctionContextBB.NUM_NODES);
            }
            QueryFunction function = new QueryFunction();
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(queries[i]);
            argList.add(RemoteTestModule.getCurrentThread().getThreadId());
            Object result = FunctionService.onRegion((Region)CacheFactory.getAnyInstance().getRegion("QueryRegion1")).withArgs(argList).execute((Function)function).getResult();
            ArrayList resultList = (ArrayList)result;
            resultList.trimToSize();
            ArrayList queryResults = null;
            Log.getLogWriter().info("Size of the resultsList: " + resultList.size());
            if (resultList.size() != 0) {
                queryResults = new ArrayList();
                for (Object obj : resultList) {
                    if (obj == null) continue;
                    queryResults.addAll((ArrayList)obj);
                }
            }
            if (isSerialExecution) {
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                long numNodes = counters.read(QueryFunctionContextBB.NUM_NODES);
                if (numNodes != 3L) {
                    throw new TestException("With no filters function call was not sent to all (3) PR nodes Actual count of nodes " + numNodes);
                }
            }
            if (queryResults == null) {
                throw new TestException("UNEXPECTED queryResults are found to be empty");
            }
            Log.getLogWriter().info("CLIENT SIDE: Size of the query results: " + queryResults.size());
            resultSizes[i] = queryResults.size();
            QueryFunctionExecTest.verifyQueryResults(i, queryResults);
        }
        if (isSerialExecution) {
            Log.getLogWriter().info("CLIENT SIDE: Query Result sizes: " + resultSizes.toString());
            for (i = 0; i < resultSizes.length; ++i) {
                if (resultSizes[i] == expectedResultSizes[i]) continue;
                throw new TestException("Expected result size mismatch for query # " + (i + 1) + " Expected size: " + expectedResultSizes[i] + "Actual size :" + resultSizes[i]);
            }
        }
    }

    public static void HydraTask_ExecuteFunction_Filter_SingleKey() {
        HashSet<Integer> filter = new HashSet<Integer>();
        filter.add(1);
        String[] queries = new String[]{"select distinct * from /QueryRegion1 r1"};
        int[] resultSizes = new int[queries.length];
        for (int i = 0; i < queries.length; ++i) {
            long numNodes;
            SharedCounters counters = QueryFunctionContextBB.getBB().getSharedCounters();
            if (isSerialExecution) {
                counters.zero(QueryFunctionContextBB.NUM_NODES);
            }
            QueryFunction function = new QueryFunction();
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(queries[i]);
            argList.add(RemoteTestModule.getCurrentThread().getThreadId());
            Object result = FunctionService.onRegion((Region)CacheFactory.getAnyInstance().getRegion("QueryRegion1")).withArgs(argList).withFilter(filter).execute((Function)function).getResult();
            ArrayList resultList = (ArrayList)result;
            resultList.trimToSize();
            ArrayList queryResults = null;
            Log.getLogWriter().info("Size of the resultsList: " + resultList.size());
            if (resultList.size() != 0) {
                queryResults = new ArrayList();
                for (Object obj : resultList) {
                    if (obj == null) continue;
                    queryResults.addAll((ArrayList)obj);
                }
            }
            if (isSerialExecution && (numNodes = counters.read(QueryFunctionContextBB.NUM_NODES)) != 1L) {
                throw new TestException("Single filter key function call was not sent to exactly one PR node. Actual count of nodes " + numNodes);
            }
            QueryFunctionExecTest.verifyQueryResults(i, queryResults);
            boolean key1exists = false;
            if (queryResults != null) {
                Log.getLogWriter().info("CLIENT SIDE: Size of the query results: " + queryResults.size());
                resultSizes[i] = queryResults.size();
                for (Object obj : queryResults) {
                    PRPortfolio pfo = null;
                    if (obj instanceof StructImpl) {
                        StructImpl structObj = (StructImpl)obj;
                        Object[] fieldVals = structObj.getFieldValues();
                        pfo = (PRPortfolio)fieldVals[0];
                    } else if (obj instanceof PRPortfolio) {
                        pfo = (PRPortfolio)obj;
                    } else {
                        Log.getLogWriter().info("Unexpected objet type: " + obj.getClass().getName());
                        continue;
                    }
                    Log.getLogWriter().info("Portfolio ID: " + pfo.getId());
                    int ID = pfo.getId();
                    if (ID != 1) continue;
                    key1exists = true;
                }
            } else {
                throw new TestException("UNEXPECTED queryResults are found to be empty");
            }
            if (!isSerialExecution || key1exists) continue;
            throw new TestException("UNEXPECTED queryResults did not contain the filter key = 1");
        }
        Log.getLogWriter().info("CLIENT SIDE: Query Result sizes: " + resultSizes.toString());
    }

    public static void HydraTask_ExecuteFunction_Filter() {
        int bitmap = 0;
        HashSet<Integer> filter = new HashSet<Integer>();
        for (int key = 1; key < 10; ++key) {
            filter.add(key);
        }
        String[] queries = new String[]{"select distinct * from /QueryRegion1 r1"};
        int[] resultSizes = new int[queries.length];
        for (int i = 0; i < queries.length; ++i) {
            Log.getLogWriter().info("CLIENT SIDE: Executing query: " + queries[i]);
            QueryFunction function = new QueryFunction();
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(queries[i]);
            argList.add(RemoteTestModule.getCurrentThread().getThreadId());
            Object result = FunctionService.onRegion((Region)CacheFactory.getAnyInstance().getRegion("QueryRegion1")).withArgs(argList).withFilter(filter).execute((Function)function).getResult();
            ArrayList resultList = (ArrayList)result;
            resultList.trimToSize();
            ArrayList queryResults = null;
            Log.getLogWriter().info("Size of the resultsList: " + resultList.size());
            if (resultList.size() != 0) {
                queryResults = new ArrayList();
                for (Object obj : resultList) {
                    if (obj == null) continue;
                    queryResults.addAll((ArrayList)obj);
                }
            }
            if (queryResults != null) {
                Log.getLogWriter().info("CLIENT SIDE: Size of the query results: " + queryResults.size());
                resultSizes[i] = queryResults.size();
                QueryFunctionExecTest.verifyQueryResults(i, queryResults);
                for (Object obj : queryResults) {
                    PRPortfolio pfo = null;
                    Log.getLogWriter().info("ACTUAL QUERY RESULT OBJ: " + obj.toString());
                    Log.getLogWriter().info("ACTUAL QUERY RESULT OBJ CLASS NAME: " + obj.getClass().getName());
                    if (obj instanceof StructImpl) {
                        StructImpl structObj = (StructImpl)obj;
                        Object[] fieldVals = structObj.getFieldValues();
                        pfo = (PRPortfolio)fieldVals[0];
                    } else {
                        if (!(obj instanceof PRPortfolio)) continue;
                        pfo = (PRPortfolio)obj;
                    }
                    Log.getLogWriter().info("Portfolio ID: " + pfo.getId());
                    int ID = pfo.getId();
                    if (ID > 9 || ID < 1) continue;
                    bitmap |= 1 << ID - 1;
                }
                if (!isSerialExecution) continue;
                if (bitmap != 511) {
                    throw new TestException("BITMAP expected 511 Found: " + bitmap);
                }
                Log.getLogWriter().info("BITMAP = 511 !!! ");
                continue;
            }
            throw new TestException("UNEXPECTED queryResults are found to be empty");
        }
        Log.getLogWriter().info("CLIENT SIDE: Query Result sizes: " + resultSizes.toString());
    }

    public static void HydraTask_Set_BucketRegion_Destroy_QueryObserver() {
        class MyQueryObserver
        extends IndexTrackingQueryObserver {
            MyQueryObserver() {
            }

            public void startQuery(Query query) {
                Region pr = CacheFactory.getAnyInstance().getRegion("QueryRegion1");
                BucketRegion KeyRegion = null;
                for (int i = 10; i < 20; ++i) {
                    KeyRegion = ((PartitionedRegion)pr).getBucketRegion((Object)i);
                    if (KeyRegion == null) continue;
                    Log.getLogWriter().info("Destroying bucket region::");
                    try {
                        KeyRegion.destroyRegion();
                    }
                    catch (RegionDestroyedException e) {
                        Log.getLogWriter().info("OBSERVER::Ignoring RegionDestroyedException");
                        continue;
                    }
                    catch (Exception e) {
                        Log.getLogWriter().info("OBSERVER::Exception class is :" + e.getClass().getName());
                        Log.getLogWriter().info("OBSERVER::Exception cause class is :" + e.getCause().getClass().getName());
                        throw new TestException("OBSERVER::Caught EXCEPTION during Bucket destroy " + e.getMessage());
                    }
                    Log.getLogWriter().info("Destroyed bucket region successfully!!");
                }
            }
        }
        QueryObserverHolder.setInstance((QueryObserver)new MyQueryObserver());
    }

    public static void HydraTask_Set_BucketRegion_BucketRebalance_QueryObserver() {
        class MyQueryObserver
        extends IndexTrackingQueryObserver {
            MyQueryObserver() {
            }

            public void startQuery(Query query) {
                new Thread(){

                    @Override
                    public void run() {
                        ParRegUtil.doRebalance();
                    }
                }.start();
            }
        }
        QueryObserverHolder.setInstance((QueryObserver)new MyQueryObserver());
    }

    public static void HydraTask_ExecuteFunction_RegionDestroyUsingFilter() {
        HashSet<Integer> filter = new HashSet<Integer>();
        for (int key = 10; key < 20; ++key) {
            filter.add(key);
        }
        String[] queries = new String[]{"select distinct * from /QueryRegion1 r1"};
        int[] resultSizes = new int[queries.length];
        try {
            QueryFunction function = new QueryFunction();
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(queries[0]);
            argList.add(RemoteTestModule.getCurrentThread().getThreadId());
            Object result = FunctionService.onRegion((Region)CacheFactory.getAnyInstance().getRegion("QueryRegion1")).withArgs(argList).withFilter(filter).execute((Function)function).getResult();
            throw new TestException("Should have received an QueryInvocationTargetException but no excpetion was thrown");
        }
        catch (FunctionException ex) {
            if (!(ex.getCause() instanceof QueryInvocationTargetException)) {
                Log.getLogWriter().info("Exception cause class is :" + ex.getCause().getClass().getName());
                throw new TestException("Should have received an QueryInvocationTargetException but recieved" + ex.getMessage());
            }
        }
        catch (Exception e) {
            throw new TestException("Caught EXCEPTION during Querying and Region Bucket destroy " + e.getMessage());
        }
    }

    public static void verifyQueryResults(int queryIndex, List queryResults) {
        PRPortfolio pfo = null;
        for (Object obj : queryResults) {
            if (obj instanceof StructImpl) {
                StructImpl structObj = (StructImpl)obj;
                Object[] fieldVals = structObj.getFieldValues();
                pfo = (PRPortfolio)fieldVals[0];
                QueryFunctionExecTest.performSanityChecks(queryIndex, new PRPortfolio[]{pfo, (PRPortfolio)fieldVals[1]});
                continue;
            }
            if (!(obj instanceof PRPortfolio)) continue;
            pfo = (PRPortfolio)obj;
            QueryFunctionExecTest.performSanityChecks(queryIndex, new PRPortfolio[]{pfo, null});
        }
    }

    public static void performSanityChecks(int queryIndex, PRPortfolio[] pfo) {
        switch (queryIndex) {
            case 0: {
                break;
            }
            case 1: {
                if (pfo[0].ID >= 100) break;
                throw new TestException("Result verification for the query failed ID expected below 100, but actually: " + pfo[0].ID);
            }
            case 2: {
                if (pfo[0].status.equals("active")) break;
                throw new TestException("Result verification for the query failed status expected active, but actually: " + pfo[0].status);
            }
            case 3: {
                if (pfo[0].ID >= 100 && pfo[0].status.equals("active")) break;
                throw new TestException("Result verification for the query failed pfo[0].ID = " + pfo[0].ID + " pfo[0].status = " + pfo[0].status);
            }
            case 4: {
                if (pfo[0].ID == pfo[1].ID) break;
                throw new TestException("Result verification for the query failed pfo[0].ID = " + pfo[0].ID + " pfo[1].ID = " + pfo[1].ID);
            }
            case 5: {
                if (pfo[0].ID == pfo[1].ID && pfo[0].status.equals("active")) break;
                throw new TestException("Result verification for the query failed pfo[0].ID = " + pfo[0].ID + " pfo[1].ID = " + pfo[1].ID + " pfo[0].status = " + pfo[0].status);
            }
            case 6: {
                if (pfo[0].ID == pfo[1].ID && pfo[0].ID >= 500 && pfo[1].status.equals("active")) break;
                throw new TestException("Result verification for the query failed pfo[0].ID = " + pfo[0].ID + " pfo[1].ID = " + pfo[1].ID + " pfo[1].status = " + pfo[1].status);
            }
            default: {
                throw new TestException("Unexpected query index");
            }
        }
    }

    public static void HydraTask_close_rebalancePR() {
        Region aRegion = CacheFactory.getAnyInstance().getRegion("QueryRegion1");
        RegionAttributes attrs = aRegion.getAttributes();
        PartitionAttributes pAttrs = attrs.getPartitionAttributes();
        int oldLocalMaxMem = pAttrs.getLocalMaxMemory();
        Log.getLogWriter().info("Initial local max memory = " + oldLocalMaxMem);
        AttributesFactory factory = new AttributesFactory(attrs);
        factory.setPartitionAttributes(attrs.getPartitionAttributes());
        PartitionAttributesFactory paFactory = new PartitionAttributesFactory(attrs.getPartitionAttributes());
        paFactory.setLocalMaxMemory(0);
        aRegion.close();
        factory.setPartitionAttributes(paFactory.create());
        aRegion = RegionHelper.createRegion("QueryRegion1", factory.create());
        Log.getLogWriter().info("Created partitioned region QueryRegion1");
        ParRegUtil.doRebalance();
        aRegion.close();
        paFactory.setLocalMaxMemory(oldLocalMaxMem);
        factory.setPartitionAttributes(paFactory.create());
        aRegion = RegionHelper.createRegion("QueryRegion1", factory.create());
        Log.getLogWriter().info("Created partitioned region QueryRegion1");
    }

    static {
        isSerialExecution = false;
    }
}

