/*
 * Decompiled with CFR 0.152.
 */
package query.remote;

import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.data.Portfolio;
import hydra.Log;
import mapregion.MapBB;
import objects.PSTObject;
import query.remote.QueryResultsValidator;
import util.TestException;

public class DataVerificationQueryResultsValidator
implements QueryResultsValidator {
    @Override
    public boolean validateQueryResults(Object results, int queryIndex, String queryString) {
        Log.getLogWriter().info("Executed query :  " + queryString);
        boolean validated = false;
        if (results instanceof SelectResults) {
            int resultSetSize = ((SelectResults)results).size();
            Log.getLogWriter().info("Result set size:" + resultSetSize);
            switch (queryIndex) {
                case 0: {
                    validated = true;
                    break;
                }
                case 1: 
                case 2: {
                    validated = this.validateResults(queryIndex, (SelectResults)results);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    validated = this.validateSelectStarResults(queryIndex, (SelectResults)results, queryString);
                    break;
                }
                default: {
                    throw new TestException("Not valid Query");
                }
            }
        } else {
            Log.getLogWriter().info("Result set not instanceof SelectResults");
        }
        return validated;
    }

    private boolean validateResults(int queryIndex, SelectResults results) {
        boolean valid = true;
        for (Object elem : results) {
            Object p;
            if (elem instanceof Portfolio) {
                p = (Portfolio)elem;
                if (queryIndex == 1 && !((Portfolio)p).status.equalsIgnoreCase("active")) {
                    valid = false;
                }
                if (queryIndex != 2 || ((Portfolio)p).status.equalsIgnoreCase("inactive")) continue;
                valid = false;
                continue;
            }
            if (!(elem instanceof PSTObject)) continue;
            p = (PSTObject)elem;
            if (queryIndex != 1 || ((PSTObject)p).getIndex() > 0) continue;
            valid = false;
        }
        return valid;
    }

    private boolean validateSelectStarResults(int queryIndex, SelectResults results, String queryString) {
        long puts = MapBB.getBB().getSharedCounters().read(MapBB.NUM_PUT);
        Log.getLogWriter().info("Comparing resultset of size: " + results.size() + " to region size: " + puts + " for query: " + queryString);
        if ((long)results.size() != puts) {
            Log.getLogWriter().info("Size of resultset: " + results.size() + " does not match region size: " + puts + " for query: " + queryString);
            return false;
        }
        for (Object elem : results) {
            if (elem instanceof objects.Portfolio) continue;
            Log.getLogWriter().info(" Expected Portfolio object but is " + elem.getClass());
            return false;
        }
        return true;
    }
}

