/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import java.util.Properties;
import quickstart.BenchmarkAckConsumer;
import quickstart.BenchmarkAckProducer;
import quickstart.ProcessWrapper;
import quickstart.QuickstartTestCase;

public class BenchmarkAckTest
extends QuickstartTestCase {
    protected ProcessWrapper consumer;
    protected ProcessWrapper producer;

    public BenchmarkAckTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.consumer != null) {
            this.consumer.destroy();
        }
        if (this.producer != null) {
            this.producer.destroy();
        }
    }

    @Override
    protected Properties createProperties() {
        Properties properties = super.createProperties();
        properties.setProperty("benchmark.operations-per-sample", "5");
        return properties;
    }

    public void testBenchmarkAck() throws Exception {
        BenchmarkAckTest.getLogWriter().info("[testBenchmarkAck] start up BenchmarkAckConsumer");
        this.consumer = new ProcessWrapper(BenchmarkAckConsumer.class);
        this.consumer.execute(this.createProperties());
        this.consumer.waitForOutputToMatch("^Please start the BenchmarkAckProducer.*$");
        BenchmarkAckTest.getLogWriter().info("[testBenchmarkAck] start up BenchmarkAckProducer");
        this.producer = new ProcessWrapper(BenchmarkAckProducer.class);
        this.producer.execute(this.createProperties());
        BenchmarkAckTest.getLogWriter().info("[testBenchmarkAck] joining to BenchmarkAckProducer");
        this.producer.waitFor();
        this.printProcessOutput(this.producer, "PRODUCER");
        this.consumer.sendInput();
        BenchmarkAckTest.getLogWriter().info("[testBenchmarkAck] joining to BenchmarkAckConsumer");
        this.consumer.waitFor();
        this.printProcessOutput(this.consumer, "CONSUMER");
        this.assertOutputMatchesGoldenFile(this.producer.getOutput(), "BenchmarkAckProducer.txt");
        this.assertOutputMatchesGoldenFile(this.consumer.getOutput(), "BenchmarkAckConsumer.txt");
    }
}

