/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import java.io.File;
import quickstart.DataPersistence;
import quickstart.ProcessWrapper;
import quickstart.QuickstartTestCase;

public class DataPersistenceTest
extends QuickstartTestCase {
    protected ProcessWrapper process;

    public DataPersistenceTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public void testDataPersistence1() throws Exception {
        File persistDir = new File("persistData1");
        persistDir.mkdir();
        DataPersistenceTest.getLogWriter().info("[testDataPersistence1] start up DataPersistence");
        this.process = new ProcessWrapper(DataPersistence.class);
        this.process.execute(this.createProperties());
        DataPersistenceTest.getLogWriter().info("[testDataPersistence1] joining to DataPersistence");
        this.process.waitFor();
        this.printProcessOutput(this.process, "testDataPersistence1");
        this.assertOutputMatchesGoldenFile(this.process.getOutput(), "DataPersistence1.txt");
    }

    public void testDataPersistence2() throws Exception {
        DataPersistenceTest.getLogWriter().info("[testDataPersistence2] start up DataPersistence");
        this.process = new ProcessWrapper(DataPersistence.class);
        this.process.execute(this.createProperties());
        DataPersistenceTest.getLogWriter().info("[testDataPersistence2] joining to DataPersistence");
        this.process.waitFor();
        this.printProcessOutput(this.process, "testDataPersistence2");
        this.assertOutputMatchesGoldenFile(this.process.getOutput(), "DataPersistence2.txt");
    }
}

