/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import quickstart.DeltaPropagationClientFeeder;
import quickstart.DeltaPropagationClientReceiver;
import quickstart.DeltaPropagationServer;
import quickstart.ProcessWrapper;
import quickstart.QuickstartTestCase;

public class DeltaPropagationTest
extends QuickstartTestCase {
    protected ProcessWrapper feederVM;
    protected ProcessWrapper receiverVM;
    protected ProcessWrapper serverVM;

    public DeltaPropagationTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.feederVM != null) {
            this.feederVM.destroy();
        }
        if (this.receiverVM != null) {
            this.receiverVM.destroy();
        }
        if (this.serverVM != null) {
            this.serverVM.destroy();
        }
    }

    public void testDeltaPropagation() throws Exception {
        DeltaPropagationTest.getLogWriter().info("[testDeltaPropagation] start DeltaPropagationTest Server");
        this.serverVM = new ProcessWrapper(DeltaPropagationServer.class);
        this.serverVM.execute(this.createProperties());
        this.serverVM.waitForOutputToMatch("This example demonstrates delta propagation. This program is a server,");
        this.serverVM.waitForOutputToMatch("listening on a port for client requests. The client program connects and");
        this.serverVM.waitForOutputToMatch("requests data. The client in this example is also configured to produce/consume");
        this.serverVM.waitForOutputToMatch("information on data destroys and updates\\.");
        this.serverVM.waitForOutputToMatch("To stop the program, press Ctrl c in console\\.");
        this.serverVM.waitForOutputToMatch("Connecting to the distributed system and creating the cache\\.\\.\\.");
        this.serverVM.waitForOutputToMatch("Connected to the distributed system\\.");
        this.serverVM.waitForOutputToMatch("Created the cache\\.");
        this.serverVM.waitForOutputToMatch("Please press Enter to stop the server\\.");
        DeltaPropagationTest.getLogWriter().info("[testDeltaPropagation] start DeltaPropagationTest Feeder");
        this.feederVM = new ProcessWrapper(DeltaPropagationClientFeeder.class);
        this.feederVM.execute(this.createProperties());
        this.feederVM.waitForOutputToMatch("Connecting to the distributed system and creating the cache\\.");
        this.feederVM.waitForOutputToMatch("Delta is 50%\\.");
        this.feederVM.waitForOutputToMatch("Please press Enter to start the feeder\\.");
        DeltaPropagationTest.getLogWriter().info("[testDeltaPropagation] start DeltaPropagationTest Receiver");
        this.receiverVM = new ProcessWrapper(DeltaPropagationClientReceiver.class);
        this.receiverVM.execute(this.createProperties());
        this.receiverVM.waitForOutputToMatch("Connecting to the distributed system and creating the cache\\.");
        this.receiverVM.waitForOutputToMatch("Please press Enter to stop the receiver\\.");
        this.feederVM.sendInput();
        DeltaPropagationTest.getLogWriter().info("[testDeltaPropagation] joining to feeder");
        this.feederVM.waitFor();
        this.printProcessOutput(this.feederVM, "FEEDER");
        this.assertOutputMatchesGoldenFile(this.feederVM.getOutput(), "DeltaPropagationFeeder.txt");
        Thread.sleep(1000L);
        this.receiverVM.sendInput();
        DeltaPropagationTest.getLogWriter().info("[testDeltaPropagation] joining to receiver");
        this.receiverVM.waitFor();
        this.printProcessOutput(this.receiverVM, "RECEIVER");
        this.assertOutputMatchesGoldenFile(this.receiverVM.getOutput(), "DeltaPropagationReceiver.txt");
        this.serverVM.sendInput();
        DeltaPropagationTest.getLogWriter().info("[testDeltaPropagation] joining to server");
        this.serverVM.waitFor();
        this.printProcessOutput(this.serverVM, "SERVER");
        this.assertOutputMatchesGoldenFile(this.serverVM.getOutput(), "DeltaPropagationServer.txt");
    }
}

