/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import quickstart.DurableClient;
import quickstart.DurableServer;
import quickstart.GoldenComparator;
import quickstart.ProcessWrapper;
import quickstart.QuickstartTestCase;
import quickstart.StringGoldenComparator;

public class DurableTest
extends QuickstartTestCase {
    private static final long SLEEP_BEFORE_CLOSING_CLIENT_MILLIS = 5000L;
    private ProcessWrapper clientFirstTime;
    private ProcessWrapper clientSecondTime;
    private ProcessWrapper server;

    public DurableTest(String name) {
        super(name);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.clientFirstTime != null) {
            this.clientFirstTime.destroy();
        }
        if (this.clientSecondTime != null) {
            this.clientSecondTime.destroy();
        }
        if (this.server != null) {
            this.server.destroy();
        }
    }

    @Override
    protected GoldenComparator createGoldenComparator() {
        return new StringGoldenComparator(this.expectedProblemLines());
    }

    public void testDurable() throws Exception {
        this.writeLogMessage("Starting up the DurableServer...");
        this.server = new ProcessWrapper(DurableServer.class);
        this.server.execute(this.createProperties());
        this.server.waitForOutputToMatch("\\[DurableServer\\] Example region.*has been created in the cache.");
        this.server.waitForOutputToMatch("\\[DurableServer\\] Please start the DurableClient now...");
        this.writeLogMessage("Done starting up the DurableServer.");
        this.writeLogMessage("Starting up the DurableClient...");
        this.clientFirstTime = new ProcessWrapper(DurableClient.class);
        this.clientFirstTime.execute(this.createProperties());
        this.clientFirstTime.failIfOutputMatches("\\[DurableClient\\] Region.*does not exist, exiting...", 2000L);
        this.clientFirstTime.waitForOutputToMatch("\\[DurableClient\\] Press Enter in the server window to do an update on the server.", 10000L);
        this.clientFirstTime.waitForOutputToMatch("\\[DurableClient\\] Then press Enter in the client window to continue.", 10000L);
        this.writeLogMessage("Done starting up the DurableClient.");
        this.writeLogMessage("Initializing the values in the DurableServer...");
        this.server.sendInput();
        this.server.waitForOutputToMatch("\\[DurableServer\\] Press Enter in the server window to update the values in the cache, or 'Exit' to shut down\\.", 10000L);
        this.writeLogMessage("Done updating the values in the DurableServer.");
        this.writeLogMessage("Receiving the new values from /exampleRegion in the DurableClient.");
        this.clientFirstTime.waitForOutputToMatch("    Received afterRegionLive event, sent to durable clients after the server has finished replaying stored events.", 2000L);
        this.clientFirstTime.waitForOutputToMatch("    Received afterCreate event for entry: key1, value1", 2000L);
        this.clientFirstTime.waitForOutputToMatch("    Received afterCreate event for entry: key2, value2", 2000L);
        this.clientFirstTime.waitForOutputToMatch("    Received afterCreate event for entry: key3, value3", 2000L);
        this.clientFirstTime.waitForOutputToMatch("    Received afterCreate event for entry: key4, value4", 2000L);
        this.writeLogMessage("DurableClient has received the new values.");
        this.writeLogMessage("Updating the values in the DurableServer...");
        this.server.sendInput();
        this.server.waitForOutputToMatch("\\[DurableServer\\] Press Enter in the server window to update the values in the cache, or 'Exit' to shut down\\.", 10000L);
        this.writeLogMessage("Done updating the values in the DurableServer.");
        this.writeLogMessage("Receiving the new values from /exampleRegion in the DurableClient.");
        this.clientFirstTime.waitForOutputToMatch("    Received afterUpdate event for entry: key1, value11", 2000L);
        this.clientFirstTime.waitForOutputToMatch("    Received afterUpdate event for entry: key2, value22", 2000L);
        this.clientFirstTime.waitForOutputToMatch("    Received afterUpdate event for entry: key3, value33", 2000L);
        this.clientFirstTime.waitForOutputToMatch("    Received afterUpdate event for entry: key4, value44", 2000L);
        this.writeLogMessage("DurableClient has received the new values.");
        this.writeLogMessage("Showing the new values from /exampleRegion in the DurableClient and closing.");
        this.sleep(5000L);
        this.clientFirstTime.sendInput();
        this.clientFirstTime.waitForOutputToMatch("\\[DurableClient\\]", 2000L);
        this.clientFirstTime.waitForOutputToMatch("\\[DurableClient\\] After the update on the server, the region contains:", 2000L);
        this.clientFirstTime.waitForOutputToMatch("\\[DurableClient\\] key1 => value11", 2000L);
        this.clientFirstTime.waitForOutputToMatch("\\[DurableClient\\] key2 => value22", 2000L);
        this.clientFirstTime.waitForOutputToMatch("\\[DurableClient\\] key3 => value33", 2000L);
        this.clientFirstTime.waitForOutputToMatch("\\[DurableClient\\] key4 => value44", 2000L);
        this.writeLogMessage("DurableClient has displayed the new values.");
        this.writeLogMessage("Closing DurableClient with keepalive=true.");
        this.clientFirstTime.waitForOutputToMatch("\\[DurableClient\\]", 2000L);
        this.clientFirstTime.waitForOutputToMatch("\\[DurableClient\\] Closing the cache and disconnecting from the distributed system...", 2000L);
        this.clientFirstTime.waitForOutputToMatch("\\[DurableClient\\] Finished disconnecting from the distributed system. Exiting...", 10000L);
        this.clientFirstTime.waitFor();
        this.clientFirstTime.destroy();
        this.writeLogMessage("DurableClient has closed with keepalive=true.");
        this.writeLogMessage("Updating the values in the DurableServer...");
        this.server.sendInput();
        this.server.waitForOutputToMatch("\\[DurableServer\\] Press Enter in the server window to update the values in the cache, or 'Exit' to shut down\\.", 10000L);
        this.writeLogMessage("Done updating the values in the DurableServer.");
        this.writeLogMessage("Restarting the DurableClient...");
        this.clientSecondTime = new ProcessWrapper(DurableClient.class);
        this.clientSecondTime.execute(this.createProperties());
        this.clientSecondTime.failIfOutputMatches("\\[DurableClient\\] Region.*does not exist, exiting...", 2000L);
        this.clientSecondTime.waitForOutputToMatch("\\[DurableClient\\] Press Enter in the server window to do an update on the server.", 10000L);
        this.clientSecondTime.waitForOutputToMatch("\\[DurableClient\\] Then press Enter in the client window to continue.", 10000L);
        this.writeLogMessage("Done restarting the DurableClient.");
        this.writeLogMessage("Updating the values in the DurableServer");
        this.server.sendInput();
        this.server.waitForOutputToMatch("\\[DurableServer\\] Press Enter in the server window to update the values in the cache, or 'Exit' to shut down\\.", 10000L);
        this.writeLogMessage("Done updating the values in the DurableServer.");
        this.writeLogMessage("Receiving the new values from /exampleRegion in the DurableClient.");
        this.clientSecondTime.waitForOutputToMatch("    Received afterUpdate event for entry: key3, value333", 10000L);
        this.clientSecondTime.waitForOutputToMatch("    Received afterUpdate event for entry: key4, value444", 10000L);
        this.clientSecondTime.waitForOutputToMatch("    Received afterRegionLive event, sent to durable clients after the server has finished replaying stored events.", 10000L);
        this.clientSecondTime.waitForOutputToMatch("    Received afterUpdate event for entry: key1, value1111", 10000L);
        this.clientSecondTime.waitForOutputToMatch("    Received afterUpdate event for entry: key2, value2222", 10000L);
        this.clientSecondTime.waitForOutputToMatch("    Received afterUpdate event for entry: key3, value3333", 10000L);
        this.clientSecondTime.waitForOutputToMatch("    Received afterUpdate event for entry: key4, value4444", 10000L);
        this.writeLogMessage("DurableClient has received the new values.");
        this.writeLogMessage("Showing the new values from /exampleRegion in the DurableClient and closing.");
        this.sleep(5000L);
        this.clientSecondTime.sendInput("CloseCache");
        this.clientSecondTime.waitForOutputToMatch("\\[DurableClient\\]", 2000L);
        this.clientSecondTime.waitForOutputToMatch("\\[DurableClient\\] After the update on the server, the region contains:", 2000L);
        this.clientSecondTime.waitForOutputToMatch("\\[DurableClient\\] key1 => value1111", 2000L);
        this.clientSecondTime.waitForOutputToMatch("\\[DurableClient\\] key2 => value2222", 2000L);
        this.clientSecondTime.waitForOutputToMatch("\\[DurableClient\\] key3 => value3333", 2000L);
        this.clientSecondTime.waitForOutputToMatch("\\[DurableClient\\] key4 => value4444", 2000L);
        this.writeLogMessage("DurableClient has displayed the new values.");
        this.writeLogMessage("Closing DurableClient with keepalive=false.");
        this.clientSecondTime.waitForOutputToMatch("\\[DurableClient\\] Closing the cache and disconnecting from the distributed system...", 2000L);
        this.clientSecondTime.waitForOutputToMatch("\\[DurableClient\\] Finished disconnecting from the distributed system. Exiting...", 10000L);
        this.clientSecondTime.waitFor();
        this.clientSecondTime.destroy();
        this.writeLogMessage("DurableClient has closed with keepalive=false.");
        this.writeLogMessage("Stopping the DurableServer");
        this.server.sendInput("Exit");
        this.server.waitForOutputToMatch("\\[DurableServer\\] Finished disconnecting from the distributed system. Exiting...", 10000L);
        this.server.waitFor();
        this.writeLogMessage("DurableServer has stopped.");
        this.printProcessOutput(this.clientFirstTime, "clientFirstTime");
        this.printProcessOutput(this.clientSecondTime, "clientSecondTime");
        this.printProcessOutput(this.server, "server");
        this.assertOutputMatchesGoldenFile(this.clientFirstTime.getOutput(), "DurableClientFirst.txt");
        this.assertOutputMatchesGoldenFile(this.clientSecondTime.getOutput(), "DurableClientSecond.txt");
        this.assertOutputMatchesGoldenFile(this.server.getOutput(), "DurableServer.txt");
    }

    private void writeLogMessage(Object message) {
        DurableTest.getLogWriter().info("[DurableTest] " + message);
    }
}

