/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import quickstart.OutputFormatter;
import quickstart.QuickstartTestCase;

public abstract class GoldenComparator
extends Assert {
    private String[] expectedProblemLines;

    protected GoldenComparator(String[] expectedProblemLines) {
        this.expectedProblemLines = expectedProblemLines;
    }

    protected Reader readGoldenFile(String goldenFileName) throws IOException {
        InputStream goldenStream = ClassLoader.getSystemResourceAsStream(goldenFileName);
        GoldenComparator.assertNotNull((String)("Golden file " + goldenFileName + " not found."), (Object)goldenStream);
        return new InputStreamReader(goldenStream);
    }

    public void assertOutputMatchesGoldenFile(String actualOutput, String goldenFileName) throws IOException {
        this.trace("GoldenComparator:assertOutputMatchesGoldenFile");
        BufferedReader goldenReader = new BufferedReader(this.readGoldenFile(goldenFileName));
        BufferedReader actualReader = new BufferedReader(new StringReader(actualOutput));
        List<String> goldenStrings = this.readLines(goldenReader);
        List<String> actualStrings = this.readLines(actualReader);
        this.scanForProblems(actualStrings);
        String actualLine = null;
        String goldenLine = null;
        int lineCount = 0;
        do {
            this.trace("GoldenComparator comparing line " + ++lineCount);
            actualLine = actualStrings.get(lineCount - 1);
            goldenLine = goldenStrings.get(lineCount - 1);
            if (actualLine == null && goldenLine != null) {
                GoldenComparator.fail((String)("EOF reached in actual output but golden file, " + goldenFileName + ", continues at line " + lineCount + ": " + goldenLine + new OutputFormatter(actualStrings)));
                continue;
            }
            if (actualLine != null && goldenLine == null) {
                GoldenComparator.fail((String)("EOF reached in golden file, " + goldenFileName + ", but actual output continues at line " + lineCount + ": " + actualLine + new OutputFormatter(actualStrings)));
                continue;
            }
            if (actualLine == null || goldenLine == null) continue;
            GoldenComparator.assertTrue((String)("Actual output \"" + actualLine + "\" did not match expected pattern \"" + goldenLine + "\" at line " + lineCount + " in " + goldenFileName + ": " + new OutputFormatter(actualStrings)), (boolean)this.compareLines(actualLine, goldenLine));
        } while (actualLine != null && goldenLine != null);
    }

    protected abstract boolean compareLines(String var1, String var2);

    private List<String> readLines(BufferedReader reader) throws IOException {
        ArrayList<String> listOfLines = new ArrayList<String>();
        String line = null;
        do {
            line = reader.readLine();
            listOfLines.add(line);
        } while (line != null);
        return listOfLines;
    }

    private void scanForProblems(List<String> lines) throws IOException {
        this.trace("GoldenComparator:scanForProblems");
        int lineCount = 0;
        for (String line : lines) {
            this.trace("GoldenComparator:scanForProblems scanning line " + ++lineCount);
            this.checkForProblem(lineCount, line);
        }
    }

    private void checkForProblem(int lineCount, String line) {
        if (line == null) {
            return;
        }
        this.checkLineFor(lineCount, line, "warning");
        this.checkLineFor(lineCount, line, "error");
        this.checkLineFor(lineCount, line, "severe");
    }

    private void checkLineFor(int lineCount, String line, String problem) {
        if (line != null && line.toLowerCase().contains(problem)) {
            if (this.expectedProblemLines != null && this.expectedProblemLines.length > 0) {
                for (int i = 0; i < this.expectedProblemLines.length; ++i) {
                    if (!this.compareLines(line, this.expectedProblemLines[i])) continue;
                    return;
                }
            }
            this.trace("About to fail because of " + line);
            GoldenComparator.fail((String)("Actual output contains a problem (warning/error/severe) on line " + lineCount + ": " + line));
        }
    }

    protected void trace(String message) {
        QuickstartTestCase.trace(message);
    }
}

