/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import com.gemstone.gemfire.internal.cache.CacheServerLauncher;
import quickstart.I18nClient;
import quickstart.ProcessWrapper;
import quickstart.QuickstartTestCase;

public class I18nClientTest
extends QuickstartTestCase {
    protected ProcessWrapper client;
    protected ProcessWrapper server;

    public I18nClientTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.client != null) {
            this.client.destroy();
        }
        if (this.server != null) {
            this.server.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testI18nClient() throws Exception {
        boolean serverStarted = false;
        try {
            I18nClientTest.getLogWriter().info("[testI18nClient] start up CacheServer");
            String[] args = new String[]{"start", "cache-xml-file=xml/I18nServer_utf8.xml", "-J-Dgemfire.mcast-port=0", "-J-Dgemfire.log-level=fine"};
            this.server = new ProcessWrapper(CacheServerLauncher.class, args);
            this.server.execute();
            this.server.waitForOutputToMatch("CacheServer pid: [0-9]* status: running");
            this.server.waitFor();
            serverStarted = true;
            I18nClientTest.getLogWriter().info("[testI18nClient] start up I18nClient");
            this.client = new ProcessWrapper(I18nClient.class);
            this.client.execute(this.createProperties());
            I18nClientTest.getLogWriter().info("[testI18nClient] joining to I18nClient");
            this.client.waitFor();
            this.printProcessOutput(this.client);
            this.assertOutputMatchesGoldenFile(this.client.getOutput(), "I18nClient.txt");
            if (!serverStarted) return;
        }
        catch (Throwable throwable) {
            if (!serverStarted) throw throwable;
            ProcessWrapper pw = new ProcessWrapper(CacheServerLauncher.class, new String[]{"stop"});
            pw.execute(this.createProperties());
            pw.waitForOutputToMatch("The CacheServer has stopped.");
            pw.waitFor();
            throw throwable;
        }
        ProcessWrapper pw = new ProcessWrapper(CacheServerLauncher.class, new String[]{"stop"});
        pw.execute(this.createProperties());
        pw.waitForOutputToMatch("The CacheServer has stopped.");
        pw.waitFor();
    }
}

