/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import quickstart.MultiuserSecurityClient;
import quickstart.MultiuserSecurityServer;
import quickstart.ProcessWrapper;
import quickstart.QuickstartTestCase;

public class MultiuserSecurityTest
extends QuickstartTestCase {
    protected ProcessWrapper client;
    protected ProcessWrapper server;
    protected Thread clientThread;
    protected Thread serverThread;

    public MultiuserSecurityTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.client != null) {
            this.client.destroy();
        }
        if (this.server != null) {
            this.server.destroy();
        }
    }

    public void testPutAndGetOperations() throws Exception {
        this.startup("[testPutAndGetOperations]");
        this.client.waitForOutputToMatch(" Your selection: ");
        this.client.sendInput("1");
        this.client.waitForOutputToMatch("Press Enter to continue\\.");
        this.client.sendInput();
        this.client.waitForOutputToMatch("Press Enter to continue\\.");
        this.client.sendInput();
        this.client.waitForOutputToMatch("Press Enter to continue\\.");
        this.client.sendInput();
        this.client.waitFor();
        this.printProcessOutput(this.client, "testPutAndGetOperations-CLIENT");
        this.server.sendInput();
        this.server.waitForOutputToMatch("Closing the cache and disconnecting\\.");
        this.server.waitForOutputToMatch("Closed the Server Cache");
        this.server.waitFor();
        this.printProcessOutput(this.server, "testPutAndGetOperations-SERVER");
        this.assertOutputMatchesGoldenFile(this.client.getOutput(), "MultiuserSecurityClient.txt");
    }

    public void testFunctionExecution() throws Exception {
        this.startup("[testFunctionExecution]");
        this.client.waitForOutputToMatch(" Your selection: ");
        this.client.sendInput("2");
        this.client.waitForOutputToMatch("Press Enter to continue\\.");
        this.client.sendInput();
        this.client.waitForOutputToMatch("Press Enter to continue\\.");
        this.client.sendInput();
        this.client.waitForOutputToMatch("Press Enter to continue\\.");
        this.client.sendInput();
        this.client.waitFor();
        this.printProcessOutput(this.client, "testFunctionExecution-CLIENT");
        this.server.sendInput();
        this.server.waitForOutputToMatch("Closing the cache and disconnecting\\.");
        this.server.waitForOutputToMatch("Closed the Server Cache");
        this.server.waitFor();
        this.printProcessOutput(this.server, "testFunctionExecution-SERVER");
        this.assertOutputMatchesGoldenFile(this.client.getOutput(), "MultiuserSecurityClientFE.txt");
    }

    public void testCQs() throws Exception {
        this.startup("[testCQs]");
        this.client.waitForOutputToMatch(" Your selection: ");
        this.client.sendInput("3");
        this.client.waitForOutputToMatch("Press Enter to continue\\.");
        this.client.sendInput();
        this.client.waitForOutputToMatch("Press Enter to continue\\.");
        this.client.sendInput();
        this.client.waitForOutputToMatch("Press Enter to continue\\.");
        this.client.sendInput();
        this.client.waitForOutputToMatch("Press Enter to continue\\.");
        this.client.sendInput();
        this.client.waitForOutputToMatch("Press Enter to continue\\.");
        this.client.sendInput();
        this.client.waitForOutputToMatch("Press Enter to continue\\.");
        this.client.sendInput();
        this.client.waitFor();
        this.printProcessOutput(this.client, "testCQs-CLIENT");
        this.server.sendInput();
        this.server.waitForOutputToMatch("Closing the cache and disconnecting\\.");
        this.server.waitForOutputToMatch("Closed the Server Cache");
        this.server.waitFor();
        this.printProcessOutput(this.server, "testCQs-SERVER");
        this.assertOutputMatchesGoldenFile(this.client.getOutput(), "MultiuserSecurityClientCQ.txt");
    }

    private void startup(String testName) throws Exception {
        MultiuserSecurityTest.getLogWriter().info(testName + " start up MultiuserSecurityServer");
        this.server = new ProcessWrapper(MultiuserSecurityServer.class);
        this.server.execute(this.createProperties());
        this.server.waitForOutputToMatch("This example demonstrates Security functionalities\\.");
        this.server.waitForOutputToMatch("This program is a server, listening on a port for client requests\\.");
        this.server.waitForOutputToMatch("The client in this example is configured with security properties\\.");
        this.server.waitForOutputToMatch("Setting security properties for server");
        this.server.waitForOutputToMatch("Connecting to the distributed system and creating the cache\\.");
        this.server.waitForOutputToMatch("Example region, /exampleRegion, created in cache\\.");
        this.server.waitForOutputToMatch("Example region, /functionServiceExampleRegion, created in cache and populated\\.");
        this.server.waitForOutputToMatch("Please start the security client and press Enter when the client finishes all the operations\\.");
        MultiuserSecurityTest.getLogWriter().info(testName + " start up MultiuserSecurityClient");
        this.client = new ProcessWrapper(MultiuserSecurityClient.class);
        this.client.execute(this.createProperties());
    }
}

