/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import quickstart.PartitionedRegionVM1;
import quickstart.PartitionedRegionVM2;
import quickstart.ProcessWrapper;
import quickstart.QuickstartTestCase;

public class PartitionedRegionTest
extends QuickstartTestCase {
    protected ProcessWrapper regionVM1;
    protected ProcessWrapper regionVM2;

    public PartitionedRegionTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.regionVM1 != null) {
            this.regionVM1.destroy();
        }
        if (this.regionVM2 != null) {
            this.regionVM2.destroy();
        }
    }

    @Override
    protected String[] expectedProblemLines() {
        return new String[]{"^\\[warning.*PartitionedRegion.*PartitionedRegion Message Processor.*\\] .*Redundancy has dropped below 1 configured copies to 0 actual copies for /PartitionedRegion"};
    }

    public void testPartitionedRegion() throws Exception {
        PartitionedRegionTest.getLogWriter().info("[testPartitionRegion] start up PartitionRegion");
        this.regionVM1 = new ProcessWrapper(PartitionedRegionVM1.class);
        this.regionVM1.execute(this.createProperties());
        this.regionVM1.waitForOutputToMatch("^Please start VM2\\.$");
        this.regionVM2 = new ProcessWrapper(PartitionedRegionVM2.class);
        this.regionVM2.execute(this.createProperties());
        this.regionVM2.waitForOutputToMatch("^Please press Enter in VM1\\.$");
        this.regionVM1.sendInput();
        this.regionVM1.waitForOutputToMatch("^Please press Enter in VM2\\.$");
        this.regionVM2.sendInput();
        this.regionVM2.waitForOutputToMatch("^Please press Enter in VM1 again\\.$");
        this.regionVM1.sendInput();
        this.regionVM1.waitForOutputToMatch("^Please press Enter in VM2 again\\.$");
        this.regionVM2.sendInput();
        this.regionVM1.waitForOutputToMatch(".*Redundancy has dropped.*");
        this.regionVM1.sendInput();
        this.regionVM1.waitFor();
        this.regionVM2.waitFor();
        this.printPartitionOutPut(this.regionVM1, "PartitionRegion in VM1");
        this.printPartitionOutPut(this.regionVM2, "PartitionRegion in VM2");
        this.assertOutputMatchesGoldenFile(this.regionVM1.getOutput(), "PartitionRegionVM1.txt");
        this.assertOutputMatchesGoldenFile(this.regionVM2.getOutput(), "PartitionRegionVM2.txt");
    }

    private void printPartitionOutPut(ProcessWrapper process, String title) {
        System.out.println("\n------------------ BEGIN " + title + " ------------------");
        System.out.println(process.getOutput());
        System.out.println("------------------- END " + title + " -------------------");
    }
}

