/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import quickstart.GoldenComparator;
import quickstart.GoldenStringComparator;
import quickstart.ProcessWrapper;
import quickstart.QuickstartTestCase;

public abstract class PassWithExpectedProblemTestCase
extends QuickstartTestCase {
    private ProcessWrapper process;

    PassWithExpectedProblemTestCase(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.process != null) {
            this.process.destroy();
        }
    }

    @Override
    protected GoldenComparator createGoldenComparator() {
        return new GoldenStringComparator(this.expectedProblemLines());
    }

    @Override
    protected String[] expectedProblemLines() {
        return new String[]{".*" + this.name() + ".*", "^\\[" + this.problem() + ".*\\] This is an expected problem in the output"};
    }

    String name() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    abstract String problem();

    abstract void outputProblem(String var1);

    public void testPassWithExpectedProblem() throws InterruptedException, IOException {
        String[] printMe;
        this.process = new ProcessWrapper(((Object)((Object)this)).getClass());
        this.process.execute(this.createProperties());
        this.process.waitForOutputToMatch("Begin " + this.name() + "\\.main");
        this.process.waitForOutputToMatch("Press Enter to continue\\.");
        this.process.sendInput();
        this.process.waitForOutputToMatch("End " + this.name() + "\\.main");
        this.process.waitFor();
        this.printProcessOutput(this.process);
        String goldenString = "Begin " + this.name() + ".main" + "\n" + "Press Enter to continue." + "\n" + "\n" + "^\\[" + this.problem() + ".*\\] This is an expected problem in the output" + "\n" + "End " + this.name() + ".main" + "\n";
        this.innerPrintOutput(goldenString, "GOLDEN");
        for (String str : printMe = this.expectedProblemLines()) {
            System.out.println(str);
        }
        this.assertOutputMatchesGoldenFile(this.process.getOutput(), goldenString);
    }

    void execute() throws IOException {
        System.out.println("Begin " + this.name() + ".main");
        System.out.println("Press Enter to continue.");
        BufferedReader inputReader = new BufferedReader(new InputStreamReader(System.in));
        inputReader.readLine();
        this.outputProblem("This is an expected problem in the output");
        System.out.println("End " + this.name() + ".main");
    }
}

