/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import java.util.Properties;
import quickstart.ProcessWrapper;
import quickstart.QuickstartTestCase;
import quickstart.SecurityClient;
import quickstart.SecurityServer;

public class SecurityTest
extends QuickstartTestCase {
    protected ProcessWrapper client;
    protected ProcessWrapper server;

    public SecurityTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.client != null) {
            this.client.destroy();
        }
        if (this.server != null) {
            this.server.destroy();
        }
    }

    @Override
    protected Properties createProperties() {
        Properties props = super.createProperties();
        props.setProperty("gemfire.security-log-level", "warning");
        return props;
    }

    public void testSecurity() throws Exception {
        SecurityTest.getLogWriter().info("[testSecurity] start up SecurityServer");
        String[] serverTempArg = new String[]{"ldap", "ou=ldapTesting,dc=pune,dc=gemstone,dc=com"};
        this.server = new ProcessWrapper(SecurityServer.class, serverTempArg);
        this.server.execute(this.createProperties());
        this.server.waitForOutputToMatch("Please start the security client, and press Enter when the client finishes all the operations\\.");
        SecurityTest.getLogWriter().info("[testSecurity] start up SecurityClient");
        String[] clientTempArg = new String[]{"gemfire6", "gemfire6"};
        this.client = new ProcessWrapper(SecurityClient.class, clientTempArg);
        this.client.execute(this.createProperties());
        this.client.waitFor();
        this.printProcessOutput(this.client, "CLIENT");
        this.server.sendInput();
        this.server.waitFor();
        this.printProcessOutput(this.server, "SERVER");
        this.assertOutputMatchesGoldenFile(this.client.getOutput(), "SecurityClient.txt");
        this.assertOutputMatchesGoldenFile(this.server.getOutput(), "SecurityServer.txt");
    }
}

