/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import quickstart.ProcessWrapper;
import quickstart.QuickstartTestCase;
import quickstart.Transactions;

public class TransactionsTest
extends QuickstartTestCase {
    protected ProcessWrapper process;

    public TransactionsTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public void testTransactions() throws Exception {
        TransactionsTest.getLogWriter().info("[testTransactions] start up Transactions");
        this.process = new ProcessWrapper(Transactions.class);
        this.process.execute(this.createProperties());
        TransactionsTest.getLogWriter().info("[testTransactions] sending one line feed");
        this.process.waitForOutputToMatch("Press Enter to continue to next transaction...");
        this.process.sendInput();
        this.process.waitForOutputToMatch("Closing the cache and disconnecting.");
        TransactionsTest.getLogWriter().info("[testTransactions] joining to Transactions");
        this.process.waitFor();
        this.printProcessOutput(this.process);
        this.assertOutputMatchesGoldenFile(this.process.getOutput(), "Transactions.txt");
    }
}

