/*
 * Decompiled with CFR 0.152.
 */
package rebalance;

import com.gemstone.gemfire.admin.Alert;
import com.gemstone.gemfire.admin.AlertListener;
import com.gemstone.gemfire.admin.OperationCancelledException;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import rebalance.RebalanceBB;
import util.TestHelper;

public class CapacityAdminListener
implements AlertListener {
    public static String lmmExceededKey = "local max memory exceeded mb ";

    public void alert(Alert alert) {
        try {
            String alertStr = this.getAlertString(alert);
            Log.getLogWriter().info(alertStr);
            this.lookForLMMExceeded(alert);
        }
        catch (Exception e) {
            String errStr = "Error occurred in vm_" + RemoteTestModule.getMyVmid() + " " + TestHelper.getStackTrace(e);
            Log.getLogWriter().info(errStr);
            RebalanceBB.getBB().getSharedMap().put(RebalanceBB.ErrorKey, errStr);
        }
    }

    protected String getAlertString(Alert alert) {
        int myPID = ProcessMgr.getProcessId();
        StringBuffer aStr = new StringBuffer();
        aStr.append("Invoked " + this.getClass().getName() + " in client with vmID " + RemoteTestModule.getMyVmid() + ", pid " + myPID + "\n");
        aStr.append("   alert.getConnectionName(): " + alert.getConnectionName() + "\n");
        aStr.append("   alert.getDate(): " + alert.getDate() + "\n");
        aStr.append("   alert.getLevel(): " + alert.getLevel() + "\n");
        aStr.append("   alert.getMessage(): " + alert.getMessage() + "\n");
        aStr.append("   alert.getSourceId(): " + alert.getSourceId() + "\n");
        try {
            aStr.append("   alert.getSystemMember(): " + alert.getSystemMember());
        }
        catch (OperationCancelledException e) {
            String errStr = "Bug 39657; Error occurred in vm_" + RemoteTestModule.getMyVmid() + " " + TestHelper.getStackTrace(e);
            Log.getLogWriter().info(errStr);
            RebalanceBB.getBB().getSharedMap().put(RebalanceBB.ErrorKey, errStr);
            aStr.append(errStr);
        }
        return aStr.toString();
    }

    protected void lookForLMMExceeded(Alert alert) {
        String lmmExceededStr;
        String message = alert.getMessage();
        int index = message.indexOf(lmmExceededStr = "has exceeded local maximum memory configuration ");
        if (index >= 0) {
            String subStr = message.substring(index + lmmExceededStr.length(), message.length());
            String[] tokens = subStr.split(" ");
            int mb = Integer.valueOf(tokens[0]);
            String key = lmmExceededKey + mb;
            RebalanceBB.getBB().getSharedMap().put(key, alert.getSystemMember().toString());
            long counter = RebalanceBB.getBB().getSharedCounters().incrementAndRead(RebalanceBB.numExceededLMMAlerts);
            Log.getLogWriter().info("Alert for localMaxMemory exceeded " + mb + " MB was recognized, " + "counter is now " + counter);
        }
    }
}

