/*
 * Decompiled with CFR 0.152.
 */
package rebalance;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.Log;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import parReg.ParRegBB;
import parReg.ParRegUtil;
import rebalance.HashKey;
import rebalance.RebalanceBB;
import rebalance.RebalancePrms;
import recovDelay.BucketState;
import util.NameFactory;
import util.PRObserver;
import util.RandomValues;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.ValueHolder;

public class CapacityTest {
    public static CapacityTest testInstance;
    protected Region aRegion;
    protected static final String primaryMapKey = "primaryMap";
    protected static final String bucketMapKey = "bucketMap";

    public static synchronized void HydraTask_initAccessor() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new CapacityTest();
            testInstance.initializeRegion("accessorRegion", 0);
            testInstance.initializeInstance();
        }
    }

    public static synchronized void HydraTask_initDataStore() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new CapacityTest();
            int LMM = CapacityTest.getLocalMaxMemory();
            testInstance.initializeRegion("dataStoreRegion", LMM);
            testInstance.initializeInstance();
            RebalanceBB.getBB().getSharedCounters().increment(RebalanceBB.numDataStores);
            RebalanceBB.getBB().getSharedMap().put(RebalanceBB.LocalMaxMemoryKey + RemoteTestModule.getMyVmid(), new Integer(LMM));
        }
    }

    public static synchronized void HydraTask_initEdge() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            CacheHelper.createCache("cache1");
            testInstance = new CapacityTest();
            CapacityTest.testInstance.aRegion = RegionHelper.createRegion("accessorRegion");
            testInstance.initializeInstance();
        }
    }

    public static synchronized void HydraTask_initBridge() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            CacheHelper.createCache("cache1");
            testInstance = new CapacityTest();
            CapacityTest.testInstance.aRegion = RegionHelper.createRegion("dataStoreRegion");
            RebalanceBB.getBB().getSharedCounters().increment(RebalanceBB.numDataStores);
            BridgeHelper.startBridgeServer("bridge");
        }
    }

    public static synchronized void HydraTask_replaceDataStore() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            PRObserver.initialize();
            testInstance = new CapacityTest();
            int LMM = CapacityTest.getLocalMaxMemory();
            testInstance.initializeRegion("dataStoreRegion", LMM);
            testInstance.initializeInstance();
            testInstance.verifyReplacedCapacity();
        }
    }

    public void initializeRegion(String regDescriptName, int localMaxMemory) {
        CacheHelper.createCache("cache1");
        AttributesFactory factory = RegionHelper.getAttributesFactory(regDescriptName);
        if (localMaxMemory != -1) {
            RegionAttributes attr = RegionHelper.getRegionAttributes(regDescriptName);
            PartitionAttributes prAttr = attr.getPartitionAttributes();
            PartitionAttributesFactory prFactory = new PartitionAttributesFactory(prAttr);
            prFactory.setLocalMaxMemory(localMaxMemory);
            factory.setPartitionAttributes(prFactory.create());
        }
        String regionName = (String)TestConfig.tab().vecAt(RegionPrms.regionName).get(0);
        this.aRegion = RegionHelper.createRegion(regionName, factory);
    }

    public void initializeInstance() {
        int hashKeyLimit;
        HashKey.hashLimit = hashKeyLimit = RebalancePrms.getHashKeyLimit();
        Log.getLogWriter().info("HashKey.hashLimit is: " + HashKey.hashLimit);
    }

    protected static int getLocalMaxMemory() {
        String searchStr;
        int lmm = -1;
        String lmmStr = RebalancePrms.getLocalMaxMemory();
        int index = lmmStr.indexOf(searchStr = "incrementBy_");
        if (index >= 0) {
            int increment = Integer.valueOf(lmmStr.substring(searchStr.length(), lmmStr.length()));
            int lmmCounter = (int)ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.LocalMaxMemoryCounter);
            lmm = increment * lmmCounter;
        } else {
            lmm = lmmStr.equalsIgnoreCase("default") ? -1 : Integer.valueOf(lmmStr);
        }
        Log.getLogWriter().info("LocalMaxMemory is " + lmm);
        return lmm;
    }

    public static void HydraTask_loadUntilFull() {
        testInstance.loadUntilFull();
    }

    public static void HydraTask_loadUntilNumKeys() {
        testInstance.loadUntilNumKeys();
    }

    public static void HydraTask_addCapacity() {
        testInstance = new CapacityTest();
        testInstance.addCapacity();
    }

    public static void HydraTask_verifyRegionSize() {
        if (testInstance == null) {
            Log.getLogWriter().info("Not verifying keys/values because this vm has not yet been initialized");
        } else {
            testInstance.verifyRegionSize();
        }
    }

    public static void HydraTask_stopStart() {
        testInstance.stopStart();
    }

    public static void HydraTask_rebalance() {
        long controller = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.rebalance);
        if (controller == 1L) {
            ParRegUtil.doRebalance();
        }
    }

    public static synchronized void HydraTask_verifyVariedLMM() {
        testInstance.verifyLmmBasedOnIdealSize();
        testInstance.verifyLmmBasedOnRelativeSize();
    }

    public static void HydraTask_recordLocalSize() {
        long localSize = ((PartitionedRegion)CapacityTest.testInstance.aRegion).getLocalSize();
        Log.getLogWriter().info("Local size is " + localSize);
        RebalanceBB.getBB().getSharedMap().put(RebalanceBB.LocalSizeKey + RemoteTestModule.getMyVmid(), new Long(localSize));
    }

    protected void loadUntilFull() {
        RandomValues randomValues = new RandomValues();
        long LOG_INTERVAL_MILLIS = 10000L;
        long lastLogTime = System.currentTimeMillis();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        long numDataStores = RebalanceBB.getBB().getSharedCounters().read(RebalanceBB.numDataStores);
        do {
            String key = NameFactory.getNextPositiveObjectName();
            ValueHolder anObj = new ValueHolder(key, randomValues);
            this.aRegion.create((Object)key, (Object)anObj);
            if (System.currentTimeMillis() - lastLogTime <= 10000L) continue;
            Log.getLogWriter().info("Added " + NameFactory.getPositiveNameCounter() + " entries into " + TestHelper.regionToString(this.aRegion, false) + ", last key added: " + key + ", last value added: " + anObj.getClass().getName() + " with myValue " + TestHelper.toString(anObj.myValue) + ", extraObject " + TestHelper.toString(anObj.extraObject));
            lastLogTime = System.currentTimeMillis();
            long counter = RebalanceBB.getBB().getSharedCounters().read(RebalanceBB.numExceededLMMAlerts);
            if (counter < numDataStores) continue;
            throw new StopSchedulingTaskOnClientOrder("All vms have exceeded local max memory; current region size is " + this.aRegion.size() + ", last key added: " + key + ", last value added: " + anObj.getClass().getName() + " with myValue " + TestHelper.toString(anObj.myValue) + ", extraObject " + TestHelper.toString(anObj.extraObject));
        } while (System.currentTimeMillis() - startTime < minTaskGranularityMS);
        Object error = RebalanceBB.getBB().getSharedMap().get(RebalanceBB.ErrorKey);
        if (error != null) {
            throw new TestException(error.toString());
        }
    }

    protected void loadUntilNumKeys() {
        int numKeys = RebalancePrms.getNumKeys();
        boolean useHashKey = RebalancePrms.getUseHashKey();
        RandomValues randomValues = new RandomValues();
        long LOG_INTERVAL_MILLIS = 10000L;
        long lastLogTime = System.currentTimeMillis();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        do {
            String keyStr = NameFactory.getNextPositiveObjectName();
            Object aKey = keyStr;
            if (useHashKey) {
                aKey = new HashKey();
                ((HashKey)aKey).key = keyStr;
            }
            ValueHolder anObj = new ValueHolder(keyStr, randomValues);
            this.aRegion.create(aKey, (Object)anObj);
            if (this.aRegion.size() >= numKeys) {
                throw new StopSchedulingTaskOnClientOrder("Region has exceeded target number of keys " + numKeys + "; current region size is " + this.aRegion.size() + ", last key added: " + aKey + ", last value added: " + anObj.getClass().getName() + " with myValue " + TestHelper.toString(anObj.myValue) + ", extraObject " + TestHelper.toString(anObj.extraObject));
            }
            if (System.currentTimeMillis() - lastLogTime <= 10000L) continue;
            Log.getLogWriter().info("Added " + NameFactory.getPositiveNameCounter() + " entries into " + TestHelper.regionToString(this.aRegion, false) + ", last key added: " + aKey + ", last value added: " + anObj.getClass().getName() + " with myValue " + TestHelper.toString(anObj.myValue) + ", extraObject " + TestHelper.toString(anObj.extraObject));
            lastLogTime = System.currentTimeMillis();
        } while (System.currentTimeMillis() - startTime < minTaskGranularityMS);
    }

    protected void addCapacity() {
        PRObserver.installObserverHook();
        Integer myVmId = new Integer(RemoteTestModule.getMyVmid());
        String lmmStr = RebalancePrms.getLocalMaxMemory();
        if (lmmStr == null) {
            CacheHelper.createCache("cache1");
            this.aRegion = RegionHelper.createRegion("dataStoreRegion");
            BridgeHelper.startBridgeServer("bridge");
        } else {
            this.initializeRegion("dataStoreRegion", CapacityTest.getLocalMaxMemory());
        }
        Log.getLogWriter().info("After creating region, region size is " + this.aRegion.size());
        long numDataStores = RebalanceBB.getBB().getSharedCounters().incrementAndRead(RebalanceBB.numDataStores);
        long numDataStoresBefore = numDataStores - 1L;
        if (this.aRegion.getAttributes().getPartitionAttributes().getRedundantCopies() > 0) {
            PRObserver.waitForRebalRecov(myVmId, 1, 1, null, null, false);
        }
        Map[] mapArr = BucketState.getBucketMaps(this.aRegion);
        Map primaryMap = mapArr[0];
        Map bucketMap = mapArr[1];
        Log.getLogWriter().info("Before rebalance, buckets: " + bucketMap + ", primaries: " + primaryMap);
        if ((long)bucketMap.size() != numDataStoresBefore) {
            throw new TestException("Expected " + numDataStoresBefore + " vms to contain buckets, but " + bucketMap.size() + " vms contains buckets, bucketMap: " + bucketMap + ", primaryMap: " + primaryMap);
        }
        ParRegUtil.doRebalance();
        mapArr = BucketState.getBucketMaps(this.aRegion);
        primaryMap = mapArr[0];
        bucketMap = mapArr[1];
        Object value = primaryMap.get(myVmId);
        if (value == null) {
            primaryMap.put(myVmId, new Integer(0));
        }
        if ((value = bucketMap.get(myVmId)) == null) {
            bucketMap.put(myVmId, new Integer(0));
        }
        Log.getLogWriter().info("After rebalance, buckets: " + bucketMap + ", primaries: " + primaryMap);
        if (value == null || (Integer)value == 0) {
            throw new TestException("New capacity vm did not gain any buckets, bucketMap " + bucketMap + ", primaryMap " + primaryMap);
        }
        if ((long)bucketMap.size() != numDataStores) {
            throw new TestException("Expected " + numDataStores + " vms to contain buckets, but " + bucketMap.size() + " vms contains buckets, bucketMap: " + bucketMap + ", primaryMap: " + primaryMap);
        }
        this.verifyRegionSize();
    }

    protected void verifyRegionSize() {
        long maxKey = NameFactory.getPositiveNameCounter();
        Log.getLogWriter().info("Verifying region, expecting " + maxKey + " entries...");
        int size = this.aRegion.size();
        if ((long)size != maxKey) {
            throw new TestException("Expected region size to be " + maxKey + " but it is " + size + "\n");
        }
        Log.getLogWriter().info("Region size is " + size + " as expected");
    }

    protected void stopStart() {
        Map[] mapArr = BucketState.getBucketMaps(this.aRegion);
        Map primaryMap = mapArr[0];
        Map bucketMap = mapArr[1];
        Log.getLogWriter().info("Before stopping, writing current state to blackboard, bucketMap: " + bucketMap + ", primaryMap: " + primaryMap);
        RebalanceBB.getBB().getSharedMap().put(bucketMapKey, bucketMap);
        RebalanceBB.getBB().getSharedMap().put(primaryMapKey, primaryMap);
        Object[] tmpArr = StopStartVMs.getOtherVMs(1, "dataStore");
        List targetVM = (List)tmpArr[0];
        List stopMode = (List)tmpArr[1];
        StopStartVMs.stopStartVMs(targetVM, stopMode);
    }

    protected void verifyReplacedCapacity() {
        PRObserver.waitForRebalRecov(RemoteTestModule.getMyVmid(), 1, 1, null, null, false);
        ParRegUtil.doRebalance();
        Map[] mapArr = BucketState.getBucketMaps(this.aRegion);
        Map primaryMapNow = mapArr[0];
        Map bucketMapNow = mapArr[1];
        Map bucketMapBefore = (Map)RebalanceBB.getBB().getSharedMap().get(bucketMapKey);
        Map primaryMapBefore = (Map)RebalanceBB.getBB().getSharedMap().get(primaryMapKey);
        Integer myVmId = RemoteTestModule.getMyVmid();
        int numBucketsBefore = bucketMapBefore.containsKey(myVmId) ? (Integer)bucketMapBefore.get(myVmId) : bucketMapBefore.put(myVmId, new Integer(0));
        int numBucketsNow = bucketMapNow.containsKey(myVmId) ? (Integer)bucketMapNow.get(myVmId) : bucketMapNow.put(myVmId, new Integer(0));
        int numPrimariesBefore = primaryMapBefore.containsKey(myVmId) ? (Integer)primaryMapBefore.get(myVmId) : primaryMapBefore.put(myVmId, new Integer(0));
        int numPrimariesNow = primaryMapNow.containsKey(myVmId) ? (Integer)primaryMapNow.get(myVmId) : primaryMapNow.put(myVmId, new Integer(0));
        Log.getLogWriter().info("Before stopping/restarting this vm, bucketMap: " + bucketMapBefore + ", primaryMap: " + primaryMapBefore + ", after restarting/rebalancing, bucketMap: " + bucketMapNow + ", primaryMap: " + primaryMapNow);
        int diff = Math.abs(numBucketsNow - numBucketsBefore);
        if (diff > 1) {
            throw new TestException("Number of buckets in this vm before stopping/restarting was " + numBucketsBefore + ", but number of buckets in this vm after restarting/rebalancing is " + numBucketsNow);
        }
        diff = Math.abs(numPrimariesNow - numPrimariesBefore);
        if (diff > 1) {
            throw new TestException("Number of primaries in this vm before stopping/restarting was " + numPrimariesBefore + ", but number of primaries in this vm after restarting/rebalancing is " + numPrimariesNow);
        }
    }

    protected Map<Integer, Integer> getLocalMaxMemoryMap() {
        TreeMap<Integer, Integer> lmmMap = new TreeMap<Integer, Integer>();
        Map sharedMap = RebalanceBB.getBB().getSharedMap().getMap();
        for (Object key : sharedMap.keySet()) {
            if (!(key instanceof String) || !((String)key).startsWith(RebalanceBB.LocalMaxMemoryKey)) continue;
            String keyStr = (String)key;
            Integer vmId = Integer.valueOf(keyStr.substring(RebalanceBB.LocalMaxMemoryKey.length(), keyStr.length()));
            lmmMap.put(vmId, (Integer)sharedMap.get(key));
        }
        return lmmMap;
    }

    protected Map<Integer, Long> getLocalSizeMap() {
        TreeMap<Integer, Long> localSizeMap = new TreeMap<Integer, Long>();
        Map sharedMap = RebalanceBB.getBB().getSharedMap().getMap();
        for (Object key : sharedMap.keySet()) {
            if (!(key instanceof String) || !((String)key).startsWith(RebalanceBB.LocalSizeKey)) continue;
            String keyStr = (String)key;
            Integer vmId = Integer.valueOf(keyStr.substring(RebalanceBB.LocalSizeKey.length(), keyStr.length()));
            localSizeMap.put(vmId, (Long)sharedMap.get(key));
        }
        return localSizeMap;
    }

    protected void verifyLmmBasedOnRelativeSize() {
        long counter = RebalanceBB.getBB().getSharedCounters().read(RebalanceBB.numExceededLMMAlerts);
        if (counter > 0L) {
            throw new TestException("Test config error; expect no alerts for exceeding local max memory, but received " + counter);
        }
        Map<Integer, Integer> lmmMap = this.getLocalMaxMemoryMap();
        Map<Integer, Long> localSizeMap = this.getLocalSizeMap();
        if (lmmMap.size() != localSizeMap.size()) {
            throw new TestException("Test error; lmmMap and localSizeMap are not the same size, lmmMap " + lmmMap + ", localSizeMap " + localSizeMap);
        }
        if (!lmmMap.keySet().equals(localSizeMap.keySet())) {
            throw new TestException("Test error; lmmMap and localSizeMap do not contain the same keys,  lmmMap: " + lmmMap + ", localSizeMap: " + localSizeMap);
        }
        Log.getLogWriter().info("localMaxMemoryMap: " + lmmMap + ", localSizeMap: " + localSizeMap);
        StringBuffer aStr = new StringBuffer();
        StringBuffer errStr = new StringBuffer();
        for (int lmmVmId : lmmMap.keySet()) {
            for (int localSizeVmId : localSizeMap.keySet()) {
                int lmm2;
                int lmm1;
                if (localSizeVmId == lmmVmId || (lmm1 = lmmMap.get(lmmVmId).intValue()) >= (lmm2 = lmmMap.get(localSizeVmId).intValue())) continue;
                long numEntries1 = localSizeMap.get(lmmVmId);
                long numEntries2 = localSizeMap.get(localSizeVmId);
                float lmmFactor = (float)lmm2 / (float)lmm1;
                float localSizeFactor = (float)numEntries2 / (float)numEntries1;
                float numEntries2Ideal = (float)lmm2 * (float)numEntries1 / (float)lmm1;
                float idealPercent = (float)numEntries2 / numEntries2Ideal * 100.0f;
                String logStr = "\nVmId " + lmmVmId + " has localMaxMemory " + lmm1 + " and local num entries " + numEntries1 + "\n" + "VmId " + localSizeVmId + " has localMaxMemory " + lmm2 + " and local num entries " + numEntries2 + "\n" + "   vmId " + localSizeVmId + " localMaxMemory " + lmm2 + " is " + lmmFactor + " times bigger than vmId " + lmmVmId + " with localMaxMemory " + lmm1 + "\n" + "   vmId " + localSizeVmId + " local size " + numEntries2 + " is " + localSizeFactor + " times the local size of vmId " + lmmVmId + " with num entries " + numEntries1 + "\n" + "   ideal local size of vmId " + localSizeVmId + " is " + numEntries2Ideal + "\n" + "   actual local size " + numEntries2 + " is " + idealPercent + " percent of ideal local size " + numEntries2Ideal + "\n";
                if (idealPercent < 90.0f || idealPercent > 110.0f) {
                    String aString = "VmId " + localSizeVmId + " is too far from the ideal number of entries; " + logStr;
                    Log.getLogWriter().info(aString);
                    errStr.append(aString);
                }
                aStr.append(logStr);
            }
        }
        Log.getLogWriter().info(aStr.toString());
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
    }

    protected void verifyLmmBasedOnIdealSize() {
        long counter = RebalanceBB.getBB().getSharedCounters().read(RebalanceBB.numExceededLMMAlerts);
        if (counter > 0L) {
            throw new TestException("Test config error; expect no alerts for exceeding local max memory, but received " + counter);
        }
        Map<Integer, Integer> lmmMap = this.getLocalMaxMemoryMap();
        Map<Integer, Long> localSizeMap = this.getLocalSizeMap();
        Map<Integer, Integer> idealLocalSizeMap = this.getIdealLocalSizeMap();
        Log.getLogWriter().info("localMaxMemoryMap: " + lmmMap);
        Log.getLogWriter().info("localSizeMap: " + localSizeMap);
        Log.getLogWriter().info("idealLocalSizeMap: " + idealLocalSizeMap);
        if (lmmMap.size() != localSizeMap.size() || lmmMap.size() != idealLocalSizeMap.size()) {
            throw new TestException("Test error; lmmMap, localSizeMap, idealLocalSizeMap are not the same size,  lmmMap " + lmmMap + ", localSizeMap " + localSizeMap + ", idealLocalSizeMap " + idealLocalSizeMap);
        }
        if (!lmmMap.keySet().equals(localSizeMap.keySet())) {
            throw new TestException("Test error; lmmMap and localSizeMap do not contain the same keys,  lmmMap: " + lmmMap + ", localSizeMap: " + localSizeMap);
        }
        int sum = 0;
        for (Integer aValue : idealLocalSizeMap.values()) {
            sum += aValue.intValue();
        }
        int redundantCopies = this.aRegion.getAttributes().getPartitionAttributes().getRedundantCopies();
        Log.getLogWriter().info("sum of idealLocalSizeMap values is " + sum + ", region size is " + this.aRegion.size() + " redundantCopies is " + redundantCopies + ", total size of all copies " + this.aRegion.size() * (redundantCopies + 1));
        StringBuffer aStr = new StringBuffer();
        StringBuffer errStr = new StringBuffer();
        for (Integer vmId : localSizeMap.keySet()) {
            Long actualLocalSize = localSizeMap.get(vmId);
            Integer idealLocalSize = idealLocalSizeMap.get(vmId);
            float idealPercent = (float)actualLocalSize.longValue() / (float)idealLocalSize.intValue() * 100.0f;
            String aString = "For vmId " + vmId + " with localMaxMemory " + lmmMap.get(vmId) + " actual local size is " + actualLocalSize + "\n" + "   ideal local size is " + idealLocalSize + "\n" + "   actual local size " + actualLocalSize + " is " + idealPercent + " percent of ideal local size " + idealLocalSize + "\n";
            if (idealPercent < 90.0f || idealPercent > 110.0f) {
                Log.getLogWriter().info("VmId " + vmId + " is too far from the ideal number of entries: " + aString);
                errStr.append(aString);
            }
            aStr.append(aString);
        }
        Log.getLogWriter().info(aStr.toString());
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
    }

    protected Map<Integer, Integer> getIdealLocalSizeMap() {
        int redundantCopies = this.aRegion.getAttributes().getPartitionAttributes().getRedundantCopies();
        int totalCopies = redundantCopies + 1;
        TreeMap<Integer, Integer> lmmMap = new TreeMap<Integer, Integer>(this.getLocalMaxMemoryMap());
        TreeMap<Integer, Long> localSizeMap = new TreeMap<Integer, Long>(this.getLocalSizeMap());
        float baseLmm = ((Integer)lmmMap.values().iterator().next()).intValue();
        float total = 0.0f;
        for (Integer lmm : lmmMap.values()) {
            total += (float)lmm.intValue() / baseLmm;
        }
        float x = (float)(this.aRegion.size() * totalCopies) / total;
        TreeMap<Integer, Integer> resultMap = new TreeMap<Integer, Integer>();
        for (Integer vmId : lmmMap.keySet()) {
            Integer lmmValue = (Integer)lmmMap.get(vmId);
            int numKeysForThisLMM = (int)((float)lmmValue.intValue() / baseLmm * x);
            resultMap.put(vmId, new Integer(numKeysForThisLMM));
        }
        return resultMap;
    }
}

