/*
 * Decompiled with CFR 0.152.
 */
package rebalance;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.control.RebalanceFactory;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache.control.ResourceManager;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.control.ResourceManagerStats;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.GsRandom;
import hydra.Log;
import hydra.RegionHelper;
import hydra.StopSchedulingOrder;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import rebalance.HashKey;
import rebalance.RebalanceBB;
import rebalance.RebalancePrms;
import rebalance.RebalanceUtil;
import recovDelay.BucketState;
import util.NameFactory;
import util.PRObserver;
import util.RandomValues;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.ValueHolder;

public class ServerGroupTest {
    public static ServerGroupTest testInstance;
    protected final int numRegions = 7;
    protected List<Region> regionList = new ArrayList<Region>();
    protected Region extraRegion;
    protected int regionNameIndex = 0;

    public static synchronized void HydraTask_initClient1() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new ServerGroupTest();
            CacheHelper.createCache("cache1");
            for (int i = 1; i <= ServerGroupTest.testInstance.numRegions; ++i) {
                ServerGroupTest.testInstance.regionList.add(testInstance.initializeRegion("clientPrRegionGroup1"));
            }
        }
    }

    public static synchronized void HydraTask_initClient2() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new ServerGroupTest();
            CacheHelper.createCache("cache1");
            for (int i = 1; i <= ServerGroupTest.testInstance.numRegions; ++i) {
                ServerGroupTest.testInstance.regionList.add(testInstance.initializeRegion("clientPrRegionGroup2"));
            }
            ServerGroupTest.testInstance.extraRegion = RegionHelper.createRegion("clientExtraRegion");
        }
    }

    public static synchronized void HydraTask_initServer1() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new ServerGroupTest();
            CacheHelper.createCache("cache1");
            for (int i = 1; i <= ServerGroupTest.testInstance.numRegions; ++i) {
                ServerGroupTest.testInstance.regionList.add(testInstance.initializeRegion("serverPrRegion"));
            }
            BridgeHelper.startBridgeServer("bridge1");
        }
    }

    public static synchronized void HydraTask_initServer2() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new ServerGroupTest();
            CacheHelper.createCache("cache1");
            for (int i = 1; i <= ServerGroupTest.testInstance.numRegions; ++i) {
                ServerGroupTest.testInstance.regionList.add(testInstance.initializeRegion("serverPrRegion"));
            }
            ServerGroupTest.testInstance.extraRegion = RegionHelper.createRegion("serverExtraRegion");
            BridgeHelper.startBridgeServer("bridge2");
        }
    }

    public Region initializeRegion(String regDescriptName) {
        CacheHelper.createCache("cache1");
        String regionName = RegionHelper.getRegionDescription(regDescriptName).getRegionName();
        regionName = regionName + ++this.regionNameIndex;
        Region aRegion = RegionHelper.createRegion(regionName, regDescriptName);
        return aRegion;
    }

    public static void HydraTask_rebalance() {
        for (Region aRegion : ServerGroupTest.testInstance.regionList) {
            Map[] mapArr = BucketState.getBucketMaps(aRegion);
            Log.getLogWriter().info("Before rebalance: For " + aRegion.getFullPath() + ", Primary map: " + mapArr[0] + ", bucket map: " + mapArr[1]);
        }
        ResourceManager resMan = CacheHelper.getCache().getResourceManager();
        RebalanceFactory factory = resMan.createRebalanceFactory();
        try {
            Log.getLogWriter().info("Starting rebalancing");
            long startTime = System.currentTimeMillis();
            RebalanceOperation rebalanceOp = factory.start();
            RebalanceResults rebalanceResults = rebalanceOp.getResults();
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            Log.getLogWriter().info("Rebalance completed in " + duration + " ms");
            Log.getLogWriter().info(RebalanceUtil.RebalanceResultsToString(rebalanceResults, "Rebalance"));
            for (Region aRegion : ServerGroupTest.testInstance.regionList) {
                Map[] mapArr = BucketState.getBucketMaps(aRegion);
                Log.getLogWriter().info("After rebalance: For " + aRegion.getFullPath() + ", Primary map: " + mapArr[0] + ", bucket map: " + mapArr[1]);
            }
        }
        catch (InterruptedException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        if (RebalanceBB.getBB().getSharedMap().containsKey("TestIsDone")) {
            throw new StopSchedulingOrder("Test has finished");
        }
    }

    public static void HydraTask_loadPRs() {
        testInstance.loadUntilTenuredPercent(50, ServerGroupTest.testInstance.regionList);
    }

    public static void HydraTask_loadExtraRegion() {
        ArrayList<Region> regList = new ArrayList<Region>();
        regList.add(ServerGroupTest.testInstance.extraRegion);
        try {
            testInstance.loadUntilTenuredPercent(80, regList);
        }
        catch (StopSchedulingTaskOnClientOrder ex) {
            RebalanceBB.getBB().getSharedMap().put("TestIsDone", new Boolean(true));
            throw ex;
        }
    }

    protected void loadUntilTenuredPercent(int percent, List<Region> regList) {
        int numKeys = RebalancePrms.getNumKeys();
        boolean useHashKey = RebalancePrms.getUseHashKey();
        GsRandom rand = TestConfig.tab().getRandGen();
        RandomValues randomValues = new RandomValues();
        long LOG_INTERVAL_MILLIS = 10000L;
        long lastLogTime = System.currentTimeMillis();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        ResourceManagerStats stats = ((InternalResourceManager)CacheHelper.getCache().getResourceManager()).getStats();
        long criticalThreshold = stats.getCriticalThreshold();
        long stopLoadThreshold = (long)((float)criticalThreshold * ((float)percent / 100.0f));
        Log.getLogWriter().info("criticalThreshold is " + criticalThreshold + ", load stops when tenured heap reaches " + stopLoadThreshold);
        int regionIndex = 0;
        do {
            Region aRegion = regList.get(regionIndex);
            regionIndex = (regionIndex + 1) % regList.size();
            int randInt = rand.nextInt(1, 100);
            String keyStr = NameFactory.getNextPositiveObjectName();
            Object aKey = keyStr;
            if (useHashKey) {
                aKey = new HashKey();
                ((HashKey)aKey).key = keyStr;
            }
            ValueHolder anObj = new ValueHolder(keyStr, randomValues);
            aRegion.create(aKey, (Object)anObj);
            if (stats.getTenuredHeapUsed() >= stopLoadThreshold) {
                throw new StopSchedulingTaskOnClientOrder("Region(s) have exceeded " + percent + " percent of criticalThreshold " + "; current tenured heap used " + stats.getTenuredHeapUsed() + " tenured heap limit to halt load: " + stopLoadThreshold + "; current region size is " + aRegion.size() + ", last key added: " + aKey + ", last value added: " + anObj.getClass().getName() + " with myValue " + TestHelper.toString(anObj.myValue) + ", extraObject " + TestHelper.toString(anObj.extraObject));
            }
            if (System.currentTimeMillis() - lastLogTime <= 10000L) continue;
            Log.getLogWriter().info("Added " + NameFactory.getPositiveNameCounter() + " entries into " + TestHelper.regionToString(aRegion, false) + "; current tenured heap used " + stats.getTenuredHeapUsed() + " tenured heap limit to halt load: " + stopLoadThreshold + ", last key added: " + aKey + ", last value added: " + anObj.getClass().getName() + " with myValue " + TestHelper.toString(anObj.myValue) + ", extraObject " + TestHelper.toString(anObj.extraObject));
            lastLogTime = System.currentTimeMillis();
        } while (System.currentTimeMillis() - startTime < minTaskGranularityMS);
    }
}

