/*
 * Decompiled with CFR 0.152.
 */
package rebalance;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.distributed.DistributedSystem;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.GatewayHubHelper;
import hydra.GsRandom;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.TestConfig;
import hydra.blackboard.SharedCondition;
import hydra.blackboard.SharedCounters;
import hydra.blackboard.SharedLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import parReg.ParRegBB;
import perffmwk.PerfStatMgr;
import perffmwk.PerfStatValue;
import rebalance.RecoveryStopStart;
import rebalance.RegionEntryComparator;
import rebalance.WANRecoveryBB;
import rebalance.WANRecoveryPrms;
import util.BaseValueHolder;
import util.NameFactory;
import util.OperationsClient;
import util.RandomValues;
import util.SilenceListener;
import util.TestException;
import util.TestHelper;
import util.ValueHolder;

public class WANRecoveryTest
extends OperationsClient {
    protected static final int ITERATIONS = 1000;
    protected static WANRecoveryTest testInstance;
    protected RandomValues randomValues = null;
    static Boolean firstTimePublishing;

    public static void createLocatorTask() {
        DistributedSystemHelper.createLocator();
    }

    public static void startAndConnectLocatorTask() {
        DistributedSystemHelper.startLocatorAndAdminDS();
    }

    public static void stopLocatorTask() {
        DistributedSystemHelper.stopLocator();
    }

    public static synchronized void HydraTask_initializeBridgeServer() {
        if (testInstance == null) {
            testInstance = new WANRecoveryTest();
            testInstance.initializeOperationsClient();
            testInstance.initializeBridgeServer();
        }
    }

    protected void initializeBridgeServer() {
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        RegionHelper.createRegion(ConfigPrms.getRegionConfig());
        BridgeHelper.startBridgeServer(ConfigPrms.getBridgeConfig());
        this.createGatewayHub();
        this.randomValues = new RandomValues();
    }

    public static synchronized void HydraTask_startGatewayHubTask() {
        testInstance.startGatewayHub(ConfigPrms.getGatewayConfig());
    }

    protected void startGatewayHub(String gatewayConfig) {
        GatewayHubHelper.addGateways(gatewayConfig);
        GatewayHubHelper.startGatewayHub();
        GatewayHub hub = GatewayHubHelper.getGatewayHub();
        if (hub.getStartupPolicy().equals("primary")) {
            ParRegBB.getBB().getSharedMap().put(RecoveryStopStart.DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
        }
    }

    public static synchronized void HydraTask_initializeBridgeClient() {
        if (testInstance == null) {
            testInstance = new WANRecoveryTest();
            testInstance.initializeOperationsClient();
            testInstance.initializeBridgeClient();
        }
    }

    protected void initializeBridgeClient() {
        if (CacheHelper.getCache() == null) {
            CacheHelper.createCache(ConfigPrms.getCacheConfig());
            Region aRegion = RegionHelper.createRegion(ConfigPrms.getRegionConfig());
            aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
        }
        this.randomValues = new RandomValues();
    }

    protected void createGatewayHub() {
        String gatewayHubConfig = ConfigPrms.getGatewayHubConfig();
        if (gatewayHubConfig != null) {
            GatewayHubHelper.createGatewayHub(gatewayHubConfig);
        }
    }

    public static void HydraTask_recyclePrimary() {
        testInstance.recyclePrimary();
    }

    protected void recyclePrimary() {
        Log.getLogWriter().info("Invoked recyclePrimary");
        long executionNumber = WANRecoveryBB.getBB().getSharedCounters().incrementAndRead(WANRecoveryBB.executionNumber);
        Log.getLogWriter().info("recyclePrimary EXECUTION_NUMBER = " + executionNumber);
        int maxExecutions = WANRecoveryPrms.getMaxExecutions();
        if (executionNumber == (long)maxExecutions) {
            Log.getLogWriter().info("Last round of execution, maxExecutions = " + maxExecutions);
        }
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        Cache theCache = CacheHelper.getCache();
        TestHelper.waitForCounter(WANRecoveryBB.getBB(), "numPublishers", WANRecoveryBB.numPublishers, 1L, false, 500L);
        long numPublishers = WANRecoveryBB.getBB().getSharedCounters().read(WANRecoveryBB.numPublishers);
        TestHelper.waitForCounter(WANRecoveryBB.getBB(), "publishing", WANRecoveryBB.publishing, numPublishers, true, 180000L);
        RecoveryStopStart.HydraTask_stopStartDataStoreVm();
        TestHelper.waitForCounter(WANRecoveryBB.getBB(), "donePublishing", WANRecoveryBB.donePublishing, numPublishers, true, 60000L);
        MasterController.sleepForMs(5000);
        WANRecoveryBB.getBB().getSharedCounters().zero(WANRecoveryBB.validationComplete);
        Log.getLogWriter().info("Cleared WANRecoveryBB.validationComplete counter");
        SharedLock hcLock = WANRecoveryBB.getBB().getSharedLock();
        hcLock.lock();
        SharedCondition cond = hcLock.getCondition("recyclePrimaryComplete");
        Log.getLogWriter().info("notifying all VMs for WANRecoveryBB.SharedLock.SharedCondition.recyclePrimaryComplete");
        cond.signalAll();
        Log.getLogWriter().info("notifed all VMs for WANRecoveryBB.SharedLock.SharedCondition.recyclePrimaryComplete");
        hcLock.unlock();
        Log.getLogWriter().info("unlocked WANRecoveryBB.SharedLock");
        if (executionNumber == (long)maxExecutions) {
            throw new StopSchedulingOrder("numExecutions = " + executionNumber);
        }
    }

    public static void HydraTask_putSequentialKeys() {
        testInstance.putSequentialKeys();
        testInstance.validateSequentialKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putSequentialKeys() {
        Boolean bl = firstTimePublishing;
        synchronized (bl) {
            if (firstTimePublishing.equals(Boolean.TRUE)) {
                long numPublishers = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
                WANRecoveryBB.getBB().getSharedCounters().setIfLarger(WANRecoveryBB.numPublishers, numPublishers);
                firstTimePublishing = Boolean.FALSE;
            }
        }
        TestHelper.checkForEventError(WANRecoveryBB.getBB());
        long executionNumber = WANRecoveryBB.getBB().getSharedCounters().read(WANRecoveryBB.executionNumber);
        Log.getLogWriter().info("putSequentialKeys EXECUTION_NUMBER = " + executionNumber);
        int maxExecutions = WANRecoveryPrms.getMaxExecutions();
        if (executionNumber == (long)maxExecutions) {
            Log.getLogWriter().info("Last round of execution, maxExecutions = " + maxExecutions);
        }
        Region aRegion = this.getRandomRegion(true);
        Log.getLogWriter().info("Working on Region " + aRegion.getName());
        String key = NameFactory.getNextPositiveObjectName();
        Long val = new Long(NameFactory.getCounterForName(key));
        Log.getLogWriter().info("Working on key " + key + " in Region " + aRegion.getFullPath());
        for (int i = 1; i <= 1000; ++i) {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                aRegion.put((Object)key, (Object)new ValueHolder(val, this.randomValues, new Integer(i)));
            } else {
                aRegion.replace((Object)key, (Object)new ValueHolder(val, this.randomValues, new Integer(i)));
            }
            if (i != 500) continue;
            long ctr = WANRecoveryBB.getBB().getSharedCounters().incrementAndRead(WANRecoveryBB.publishing);
            Log.getLogWriter().info("putSequentialKeys: incremented WANRecoveryBB.publishing = " + ctr);
        }
        long ctr = WANRecoveryBB.getBB().getSharedCounters().incrementAndRead(WANRecoveryBB.donePublishing);
        Log.getLogWriter().info("putSequentialKeys: incremented WANRecoveryBB.donePublishing = " + ctr);
        SharedLock hcLock = WANRecoveryBB.getBB().getSharedLock();
        hcLock.lock();
        SharedCondition cond = hcLock.getCondition("recyclePrimaryComplete");
        Log.getLogWriter().info("Waiting to be notified for WANRecoveryBB.SharedLock.SharedCondition.recyclePrimaryComplete");
        try {
            cond.await();
            Log.getLogWriter().info("Notified for WANRecoveryBB.SharedLock.SharedCondition.recyclePrimaryComplete");
        }
        catch (InterruptedException e) {
            Log.getLogWriter().info("SharedCondition await() interrupted, continuing ...");
        }
        finally {
            hcLock.unlock();
            Log.getLogWriter().info("Unlocked for WANRecoveryBB.SharedLock");
        }
        WANRecoveryBB.getBB().getSharedCounters().zero(WANRecoveryBB.publishing);
        WANRecoveryBB.getBB().getSharedCounters().zero(WANRecoveryBB.donePublishing);
        Log.getLogWriter().info("putSequentialKeys: reset WANRecoveryBB publishing and donePublishing counters");
        if (executionNumber == (long)maxExecutions) {
            throw new StopSchedulingOrder("numExecutions = " + executionNumber);
        }
    }

    public static void HydraTask_doEntryOperations() {
        testInstance.doEntryOperations();
    }

    protected void doEntryOperations() {
        GsRandom rng = TestConfig.tab().getRandGen();
        Region aRegion = this.getRandomRegion(true);
        Log.getLogWriter().info("Working on Region " + aRegion.getName());
        this.doEntryOperations(aRegion);
    }

    public static void closeCacheAndDisconnectFromDS() {
        CacheHelper.closeCache();
        DistributedSystemHelper.disconnect();
    }

    protected void validateSequentialKeys() {
        SilenceListener.waitForSilence(30L, 5000L);
        Set rootRegions = CacheHelper.getCache().rootRegions();
        for (Region aRegion : rootRegions) {
            this.validateRegion(aRegion, true);
        }
        Log.getLogWriter().info("Validation complete");
        WANRecoveryBB.getBB().getSharedCounters().increment(WANRecoveryBB.validationComplete);
        long numPublishers = WANRecoveryBB.getBB().getSharedCounters().read(WANRecoveryBB.numPublishers);
        TestHelper.waitForCounter(WANRecoveryBB.getBB(), "validationComplete", WANRecoveryBB.validationComplete, numPublishers, true, 120000L);
    }

    public static void HydraCloseTask_validateKeysInRegion() {
        testInstance.validateKeysInRegion();
    }

    protected void validateKeysInRegion() {
        SilenceListener.waitForSilence(30L, 5000L);
        Region aRegion22 = null;
        Set rootRegions = CacheHelper.getCache().rootRegions();
        for (Region aRegion22 : rootRegions) {
            Set subRegions = aRegion22.subregions(true);
            for (Region aRegion22 : subRegions) {
                this.validateRegion(aRegion22, false);
            }
        }
        Log.getLogWriter().info("Validation complete");
    }

    protected void validateRegion(Region aRegion, boolean verifyModVal) {
        Log.getLogWriter().info("Validating entries for Region " + aRegion.getName());
        Set serverKeys = aRegion.keySetOnServer();
        int expectedRegionSize = serverKeys.size();
        Set localKeys = aRegion.keySet();
        int regionSize = localKeys.size();
        if (regionSize == 0 && expectedRegionSize == 0) {
            return;
        }
        StringBuffer aStr = new StringBuffer();
        Set myEntries = aRegion.entrySet();
        Object[] entries = myEntries.toArray();
        RegionEntryComparator myComparator = new RegionEntryComparator();
        Arrays.sort(entries, myComparator);
        Log.getLogWriter().info("Checking " + regionSize + " entries against " + expectedRegionSize + " entries in the server's region");
        aStr.append("Expecting " + expectedRegionSize + " entries in Region " + aRegion.getFullPath() + ", found " + entries.length + "\n");
        for (int i = 0; i < entries.length; ++i) {
            Region.Entry entry = (Region.Entry)entries[i];
            String key = (String)entry.getKey();
            BaseValueHolder val = (BaseValueHolder)entry.getValue();
            if (verifyModVal) {
                aStr.append("\t" + key + " : " + val.modVal + "\n");
                continue;
            }
            if (val != null) {
                aStr.append("\t" + key + " : " + val.myValue + "\n");
                continue;
            }
            aStr.append("\t" + key + " : " + " null\n");
        }
        if (regionSize <= 10) {
            Log.getLogWriter().info(aStr.toString());
        }
        aStr = new StringBuffer();
        if (regionSize != expectedRegionSize) {
            aStr.append("Expected " + expectedRegionSize + " keys in Region " + aRegion.getFullPath() + " but found " + regionSize + "\n");
        }
        Log.getLogWriter().info("Checking for missing or extra keys in client region");
        ArrayList unexpectedKeys = new ArrayList(localKeys);
        unexpectedKeys.removeAll(serverKeys);
        if (unexpectedKeys.size() > 0) {
            aStr.append("Extra keys (not found on server): " + unexpectedKeys + "\n");
        }
        ArrayList missingKeys = new ArrayList(serverKeys);
        missingKeys.removeAll(localKeys);
        if (missingKeys.size() > 0) {
            aStr.append("Missing keys (found on server, but not locally) = " + missingKeys + "\n");
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString() + " " + TestHelper.getStackTrace());
        }
        for (int i = 0; i < entries.length; ++i) {
            Region.Entry entry = (Region.Entry)entries[i];
            String key = (String)entry.getKey();
            BaseValueHolder val = (BaseValueHolder)entry.getValue();
            if (!verifyModVal || val.modVal == 1000) continue;
            throw new TestException("Value for key " + key + " is " + val.modVal + ", expected " + 1000);
        }
    }

    protected Region getRandomRegion(boolean allowRootRegion) {
        Region rootRegion = this.getRandomRootRegion();
        Set subregionsSet = rootRegion.subregions(true);
        Log.getLogWriter().fine("getRandomRegion (" + rootRegion.getName() + " has the following subregions: " + subregionsSet);
        if (subregionsSet.size() == 0) {
            if (allowRootRegion) {
                return rootRegion;
            }
            return null;
        }
        ArrayList<Object> aList = null;
        try {
            Object[] array = subregionsSet.toArray();
            aList = new ArrayList<Object>(array.length);
            for (int i = 0; i < array.length; ++i) {
                aList.add(array[i]);
            }
        }
        catch (NoSuchElementException e) {
            throw new TestException("Bug 30171 detected: " + TestHelper.getStackTrace(e));
        }
        if (allowRootRegion) {
            aList.add(rootRegion);
        }
        if (aList.size() == 0) {
            return null;
        }
        int randInt = TestConfig.tab().getRandGen().nextInt(0, aList.size() - 1);
        Region aRegion = (Region)aList.get(randInt);
        if (aRegion == null) {
            throw new TestException("Bug 30171 detected: aRegion is null");
        }
        return aRegion;
    }

    protected Region createDynamicRegion(String parentName, String drName) {
        Region dr = null;
        Log.getLogWriter().info("Creating dynamic region " + parentName + "/" + drName);
        try {
            dr = DynamicRegionFactory.get().createDynamicRegion(parentName, drName);
        }
        catch (CacheException ce) {
            throw new TestException(TestHelper.getStackTrace(ce));
        }
        Log.getLogWriter().info("Created dynamic region " + TestHelper.regionToString(dr, true));
        return dr;
    }

    protected Region getRandomRootRegion() {
        Set rootRegions = CacheHelper.getCache().rootRegions();
        Log.getLogWriter().fine("getRandomRootRegion found " + rootRegions);
        int randInt = TestConfig.tab().getRandGen().nextInt(0, rootRegions.size() - 1);
        Object[] regionList = rootRegions.toArray();
        Region rootRegion = (Region)regionList[randInt];
        return rootRegion;
    }

    public static synchronized void HydraEndTask_verifyConflation() {
        if (testInstance == null) {
            testInstance = new WANRecoveryTest();
            testInstance.verifyConflation();
        }
    }

    protected void verifyConflation() {
        SharedCounters sc = WANRecoveryBB.getBB().getSharedCounters();
        long missedUpdates = sc.read(WANRecoveryBB.missedUpdates);
        Log.getLogWriter().info("verifyConflation: missedUpdates = " + missedUpdates);
        double eventsConflated = this.getConflatedEventCount();
        Log.getLogWriter().info("verifyConflation: eventsConflated = " + eventsConflated);
        if (eventsConflated <= 0.0) {
            throw new TestException("Tuning required.  Test expected Gateway batchConflation, but GatewayStatistics.eventsNotQueuedConflated = " + eventsConflated);
        }
    }

    protected double getConflatedEventCount() {
        String spec = "*bridge* GatewayStatistics * eventsNotQueuedConflated filter=none combine=combineAcrossArchives ops=max";
        List aList = PerfStatMgr.getInstance().readStatistics(spec);
        if (aList == null) {
            Log.getLogWriter().info("Getting stats for spec " + spec + " returned null");
            return 0.0;
        }
        double eventsConflated = 0.0;
        for (int i = 0; i < aList.size(); ++i) {
            PerfStatValue stat = (PerfStatValue)aList.get(i);
            eventsConflated += stat.getMax();
        }
        return eventsConflated;
    }

    private static boolean isCausedByForcedDisconnect(Exception e) {
        Log.getLogWriter().info("checkForForcedDisconnect processed Exception " + e);
        String errStr = e.toString();
        boolean causedByForcedDisconnect = errStr.indexOf("com.gemstone.gemfire.ForcedDisconnectException") >= 0;
        return causedByForcedDisconnect;
    }

    static {
        firstTimePublishing = Boolean.TRUE;
    }
}

