/*
 * Decompiled with CFR 0.152.
 */
package recovDelay;

import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.RegionAttributes;
import hydra.BridgeHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.HydraSubthread;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.util.List;
import parReg.KnownKeysTest;
import parReg.ParRegBB;
import parReg.ParRegPrms;
import parReg.ParRegUtil;
import util.PRObserver;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;

public class KillDuringRecoveryTest
extends KnownKeysTest {
    public static synchronized void HydraTask_HA_accessorInitialize() {
        if (testInstance == null) {
            testInstance = new KillDuringRecoveryTest();
            ((KnownKeysTest)testInstance).initInstance("accessorRegion");
            if (isBridgeConfiguration) {
                ParRegUtil.registerInterest(KillDuringRecoveryTest.testInstance.aRegion);
            }
        }
    }

    public static synchronized void HydraTask_HA_dataStoreInitialize() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            PRObserver.initialize(RemoteTestModule.getMyVmid());
            testInstance = new KillDuringRecoveryTest();
            ((KnownKeysTest)testInstance).initInstance("dataStoreRegion");
            ParRegBB.getBB().getSharedMap().put(DataStoreVmStr + RemoteTestModule.getMyVmid(), new Integer(RemoteTestModule.getMyVmid()));
            if (isBridgeConfiguration) {
                BridgeHelper.startBridgeServer("bridge");
            }
        }
    }

    @Override
    public void stopStartVms() {
        long exeNum = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.ExecutionNumber);
        Log.getLogWriter().info("Beginning stopStartVms with execution number " + exeNum);
        PRObserver.initialize();
        int numVMsToStop = TestConfig.tab().intAt(ParRegPrms.numVMsToStop);
        RegionAttributes attr = this.aRegion.getAttributes();
        PartitionAttributes prAttr = attr.getPartitionAttributes();
        long recoveryDelay = prAttr.getRecoveryDelay();
        long startupRecoveryDelay = prAttr.getStartupRecoveryDelay();
        Log.getLogWriter().info("In RecovDelayTest.stopStartVms(), stopping and restarting " + numVMsToStop + " vm(s)");
        if (recoveryDelay >= 0L) {
            int i;
            if (startupRecoveryDelay >= 0L) {
                throw new TestException("Test configuration problem: Recovery is set to run for both stopping and starting, recoveryDelay " + recoveryDelay + ", startupRecoveryDelay " + startupRecoveryDelay + ", this is not supported by this test");
            }
            if (numVMsToStop <= 1) {
                throw new TestException("Test configuration problem: ParRegPrms.numVMsToStop is 1 so cannot stop any more vms while recovery is running; numVMsToStop must be > 1");
            }
            Object[] tmpArr = StopStartVMs.getOtherVMs(numVMsToStop, "dataStore");
            List targetVMs = (List)tmpArr[0];
            List stopModes = (List)tmpArr[1];
            List survivingVMs = (List)tmpArr[2];
            ClientVmInfo leaderVM = (ClientVmInfo)targetVMs.get(0);
            targetVMs.remove(0);
            int leaderStopMode = ClientVmMgr.toStopMode((String)stopModes.get(0));
            stopModes.remove(0);
            Thread[] threadArr = new Thread[targetVMs.size()];
            for (i = 0; i < targetVMs.size(); ++i) {
                final ClientVmInfo info = (ClientVmInfo)targetVMs.get(i);
                final int stopMode = ClientVmMgr.toStopMode((String)stopModes.get(i));
                final int vmID = info.getVmid();
                Thread workThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Log.getLogWriter().info("Starting monitor thread to wait for departed recovery in vmID " + vmID);
                            PRObserver.waitForRebalRecovToStart(vmID, Long.MAX_VALUE, 50);
                            ClientVmMgr.stop("Test is stopping " + info + " during recovery", stopMode, -31, info);
                            Log.getLogWriter().info("Terminating monitor thread to wait for departed recovery in vmID " + vmID);
                        }
                        catch (ClientVmNotFoundException e) {
                            throw new TestException(TestHelper.getStackTrace(e));
                        }
                    }
                });
                workThread = new HydraSubthread(workThread);
                workThread.setName("Monitor thread for kill during departed recovery");
                threadArr[i] = workThread;
                threadArr[i].start();
            }
            Log.getLogWriter().info("Test is stopping 1 vm out of " + numVMsToStop + " to trigger " + "recovery in remaining vms so " + (numVMsToStop - 1) + " additional vm(s) can be stopped " + "during recovery; vm to first be stopped is " + leaderVM + ", vms to follow: " + targetVMs);
            try {
                ClientVmMgr.stop("Test is stopping first vmID " + leaderVM, leaderStopMode, -31, leaderVM);
            }
            catch (ClientVmNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            for (i = 0; i < threadArr.length; ++i) {
                try {
                    threadArr[i].join();
                    continue;
                }
                catch (InterruptedException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
            }
            PRObserver.waitForRebalRecov(survivingVMs, numVMsToStop, 1, null, null, true);
            targetVMs.add(leaderVM);
            StopStartVMs.startVMs(targetVMs);
        } else if (startupRecoveryDelay >= 0L) {
            int i;
            Object[] tmpArr = StopStartVMs.getOtherVMs(numVMsToStop, "dataStore");
            List targetVMs = (List)tmpArr[0];
            List stopModes = (List)tmpArr[1];
            List survivingVMs = (List)tmpArr[2];
            StopStartVMs.stopVMs(targetVMs, stopModes);
            PRObserver.verifyNoRebalRecov(targetVMs);
            PRObserver.verifyNoRebalRecov(survivingVMs);
            StopStartVMs.startVMs(targetVMs);
            Thread[] threadArr = new Thread[targetVMs.size()];
            for (i = 0; i < targetVMs.size(); ++i) {
                final ClientVmInfo info = (ClientVmInfo)targetVMs.get(i);
                final int stopMode = ClientVmMgr.toStopMode((String)stopModes.get(i));
                final int vmID = info.getVmid();
                Thread workThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Log.getLogWriter().info("Starting monitor thread to wait for startup recovery in vmID " + vmID);
                            PRObserver.waitForRebalRecovToStart(vmID, Long.MAX_VALUE, 50);
                            ClientVmMgr.stop("Test is stopping " + vmID + " during recovery", stopMode, -31, info);
                            Log.getLogWriter().info("Terminating monitor thread to wait for startup recovery in vmID " + vmID);
                        }
                        catch (ClientVmNotFoundException e) {
                            throw new TestException(TestHelper.getStackTrace(e));
                        }
                    }
                });
                workThread = new HydraSubthread(workThread);
                workThread.setName("Monitor thread for kill during startup recovery");
                threadArr[i] = workThread;
                workThread.start();
            }
            for (i = 0; i < threadArr.length; ++i) {
                try {
                    threadArr[i].join();
                    continue;
                }
                catch (InterruptedException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
            }
            PRObserver.initialize();
            StopStartVMs.startVMs(targetVMs);
            PRObserver.waitForRebalRecov(targetVMs, 1, 1, null, null, false);
        } else {
            throw new TestException("Test configuration problem: Recovery is not set to run for stopping or starting, recoveryDelay " + recoveryDelay + ", startupRecoveryDelay " + startupRecoveryDelay);
        }
        Log.getLogWriter().info("Done in KillDuringRecoveryTest.stopStartVms()");
    }
}

