/*
 * Decompiled with CFR 0.152.
 */
package recovDelay;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.MasterController;
import hydra.PartitionPrms;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import parReg.ParRegBB;
import parReg.ParRegTest;
import parReg.ParRegUtil;
import recovDelay.BucketInfo;
import recovDelay.BucketState;
import recovDelay.PrState;
import recovDelay.RecovDelayBB;
import recovDelay.RecovDelayPrms;
import util.BaseValueHolder;
import util.NameBB;
import util.NameFactory;
import util.PRObserver;
import util.PRObserverBB;
import util.StopStartBB;
import util.StopStartPrms;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.ValueHolder;

public class RecovDelayTest {
    public static RecovDelayTest testInstance;
    protected static final String vmIDStr = "VmId_";
    protected static final String redundantCopiesKey = "RedundantCopies";
    protected static final String START_WITH_ALL = "startWithAll";
    protected static final String SERIAL_STARTUP = "serialStartup";
    protected static final String CONCURRENT_STARTUP = "concurrentStartup";
    protected Region aRegion;
    protected String startStrategy = null;
    protected String stopStrategy = null;
    protected int recoveryDelay = 0;
    protected int startupRecoveryDelay = 0;
    protected int redundantCopies = 0;
    protected int totalBucketCopies = 0;
    protected int numDataStoreVMs = 0;
    protected int totalNumVMsToStop = 0;
    protected List stoppedVMs = null;
    protected List vmsToStart = null;
    protected List liveVMs = null;
    protected ParRegTest parRegTestInstance = null;
    protected List masterBucketInfoList = null;
    protected Map masterPrMap = null;
    protected Set masterBucketIdSet = null;
    protected boolean uniqueHostTest = false;
    protected Map hostMap = null;
    protected boolean startupRecoveryRace = false;
    protected final int NEVER = -1;
    protected final int IMMEDIATE = 0;

    public static synchronized void HydraTask_initializeDataStore() {
        if (testInstance == null) {
            testInstance = new RecovDelayTest();
            testInstance.initializeRegion("dataStoreRegion");
            testInstance.initializeInstance();
            RecovDelayBB.getBB().getSharedMap().put(vmIDStr + RemoteTestModule.getMyVmid(), RemoteTestModule.getMyHost());
        }
    }

    public static synchronized void HydraTask_initializeAccessor() {
        if (testInstance == null) {
            testInstance = new RecovDelayTest();
            testInstance.initializeRegion("accessorRegion");
            testInstance.initializeInstance();
            PRObserver.initialize();
        }
    }

    public void initializeRegion(String regDescriptName) {
        CacheHelper.createCache("cache1");
        PRObserver.installObserverHook();
        AttributesFactory factory = RegionHelper.getAttributesFactory(regDescriptName);
        RegionAttributes attr = RegionHelper.getRegionAttributes(regDescriptName);
        PartitionAttributes prAttr = attr.getPartitionAttributes();
        PartitionAttributesFactory prFactory = new PartitionAttributesFactory(prAttr);
        int redundantCopies = (Integer)RecovDelayBB.getBB().getSharedMap().get(redundantCopiesKey);
        prFactory.setRedundantCopies(redundantCopies);
        factory.setPartitionAttributes(prFactory.create());
        String regionName = TestConfig.tab().stringAt(RegionPrms.regionName);
        this.aRegion = RegionHelper.createRegion(regionName, factory);
    }

    public void initializeInstance() {
        this.startStrategy = TestConfig.tab().stringAt(RecovDelayPrms.startStrategy);
        this.stopStrategy = TestConfig.tab().stringAt(RecovDelayPrms.stopStrategy);
        if (!this.startStrategy.equalsIgnoreCase("group") && !this.startStrategy.equalsIgnoreCase("single")) {
            throw new TestException("Unknown startStrategy " + this.startStrategy);
        }
        if (!this.stopStrategy.equalsIgnoreCase("group") && !this.stopStrategy.equalsIgnoreCase("single")) {
            throw new TestException("Unknown stopStrategy " + this.stopStrategy);
        }
        this.recoveryDelay = Integer.valueOf((String)TestConfig.tab().vecAt(PartitionPrms.recoveryDelay).get(1));
        this.startupRecoveryDelay = Integer.valueOf((String)TestConfig.tab().vecAt(PartitionPrms.startupRecoveryDelay).get(1));
        this.redundantCopies = this.aRegion.getAttributes().getPartitionAttributes().getRedundantCopies();
        this.totalBucketCopies = this.redundantCopies + 1;
        this.numDataStoreVMs = TestConfig.tab().intAt(RecovDelayPrms.numDataStoreVMs);
        this.totalNumVMsToStop = TestConfig.tab().intAt(RecovDelayPrms.totalNumVMsToStop);
        this.parRegTestInstance = new ParRegTest();
        this.parRegTestInstance.aRegion = this.aRegion;
        this.parRegTestInstance.highAvailability = false;
        this.parRegTestInstance.hasPRCacheLoader = false;
        this.parRegTestInstance.redundantCopies = this.redundantCopies;
        this.uniqueHostTest = DistributedSystemHelper.getGemFireDescription().getEnforceUniqueHost();
        Log.getLogWriter().info("startStrategy: " + this.startStrategy + "\n" + "stopStrategy: " + this.stopStrategy + "\n" + "recoveryDelay: " + this.recoveryDelay + "\n" + "startupRecoveryDelay: " + this.startupRecoveryDelay + "\n" + "totalNumVMsToStop: " + this.totalNumVMsToStop + "\n" + "redundantCopies: " + this.redundantCopies + "\n" + "totalBucketCopies: " + this.totalBucketCopies + "\n" + "numDataStoreVMs: " + this.numDataStoreVMs + "\n" + "uniqueHostTest: " + this.uniqueHostTest);
    }

    protected void initAfterLoad() {
        this.stoppedVMs = new ArrayList();
        this.liveVMs = new ArrayList(ClientVmMgr.getOtherClientVmids());
        this.masterBucketInfoList = BucketInfo.getAllBuckets(this.aRegion);
        this.masterPrMap = PrState.getPrMap(this.masterBucketInfoList);
        this.masterBucketIdSet = this.getBucketIds(this.masterBucketInfoList);
        Log.getLogWriter().info(PrState.prMapToString(this.masterPrMap));
        HashMap regionSnapshot = new HashMap();
        for (Object key : this.aRegion.keySet()) {
            Object value = this.aRegion.get(key);
            regionSnapshot.put(key, ((BaseValueHolder)value).myValue);
        }
        ParRegBB.getBB().getSharedMap().put("RegionSnapshot", regionSnapshot);
        ParRegBB.getBB().getSharedMap().put("DestroyedKeys", new HashSet());
        Map sharedMap = RecovDelayBB.getBB().getSharedMap().getMap();
        Iterator<Object> it = sharedMap.keySet().iterator();
        this.hostMap = new HashMap();
        while (it.hasNext()) {
            Object key = it.next();
            if (!(key instanceof String) || !((String)key).startsWith(vmIDStr)) continue;
            this.hostMap.put(key, sharedMap.get(key));
        }
        Log.getLogWriter().info("hostMap is " + this.hostMap);
    }

    public static void HydraTask_load() {
        testInstance.load();
    }

    public static void HydraTask_checkForBalance() {
        testInstance.checkForBalance(RecovDelayTest.testInstance.masterPrMap);
    }

    public static void HydraTask_controller() {
        testInstance.controller();
    }

    public static void HydraTask_initAfterLoad() {
        testInstance.initAfterLoad();
    }

    public static void HydraTask_initRedundantCopies() {
        String copies = TestConfig.tab().stringAt(RecovDelayPrms.redundantCopies);
        if (copies.equalsIgnoreCase("zero")) {
            RecovDelayBB.getBB().getSharedMap().put(redundantCopiesKey, new Integer(0));
        } else if (copies.equalsIgnoreCase("nonZero")) {
            int value = TestConfig.tab().getRandGen().nextInt(1, 3);
            RecovDelayBB.getBB().getSharedMap().put(redundantCopiesKey, new Integer(value));
        } else {
            try {
                int value = Integer.valueOf(copies);
                RecovDelayBB.getBB().getSharedMap().put(redundantCopiesKey, new Integer(value));
            }
            catch (NumberFormatException e) {
                throw new TestException("Unknown RecovDelayPrms.redundantCopies setting: " + copies);
            }
        }
    }

    public static void HydraTask_waitForStartupRecovery() {
        if (RecovDelayTest.testInstance.startupRecoveryDelay >= 0 && RecovDelayTest.testInstance.redundantCopies != 0) {
            ArrayList startupVMs = new ArrayList(StopStartBB.getBB().getSharedMap().getMap().values());
            List vmsExpectingRecovery = StopStartVMs.getMatchVMs(startupVMs, "dataStore");
            PRObserver.waitForRebalRecov(vmsExpectingRecovery, 1, 1, null, null, false);
        }
    }

    protected void load() {
        long LOG_INTERVAL_MILLIS = 10000L;
        int initialNumKeys = TestConfig.tab().intAt(RecovDelayPrms.initialNumKeys);
        long lastLogTime = System.currentTimeMillis();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, -1L);
        long minTaskGranularityMS = -1L;
        if (minTaskGranularitySec != -1L) {
            minTaskGranularityMS = minTaskGranularitySec * 1000L;
        }
        long startTime = System.currentTimeMillis();
        do {
            long loadCounter;
            if ((loadCounter = RecovDelayBB.getBB().getSharedCounters().incrementAndRead(RecovDelayBB.loadCounter)) > (long)initialNumKeys) {
                String aStr = "In loadRegion, loadCounter is " + loadCounter + ", initialNumKeys is " + initialNumKeys + ", region size is " + this.aRegion.size();
                Log.getLogWriter().info(aStr);
                NameBB.getBB().printSharedCounters();
                throw new StopSchedulingTaskOnClientOrder(aStr);
            }
            String key = NameFactory.getNextPositiveObjectName();
            ValueHolder value = new ValueHolder(key, null);
            this.aRegion.put((Object)key, (Object)value);
            if (System.currentTimeMillis() - lastLogTime <= 10000L) continue;
            Log.getLogWriter().info("Added " + NameFactory.getPositiveNameCounter() + " out of " + initialNumKeys + " entries into " + TestHelper.regionToString(this.aRegion, false));
            lastLogTime = System.currentTimeMillis();
        } while (System.currentTimeMillis() - startTime < minTaskGranularityMS);
    }

    protected void controller() {
        PRObserver.initialize();
        if (this.stoppedVMs.size() < this.totalNumVMsToStop) {
            this.controllerStopVMs();
            if (this.stoppedVMs.size() > this.totalNumVMsToStop) {
                throw new TestException("Test problem; stopped too many vms: " + this.stoppedVMs.size());
            }
        } else {
            if (this.vmsToStart == null) {
                this.vmsToStart = new ArrayList(this.stoppedVMs);
            }
            this.controllerStartVMs();
            if (this.vmsToStart.size() == 0) {
                throw new StopSchedulingTaskOnClientOrder(this.stoppedVMs.size() + " vms have been stopped and restarted");
            }
        }
    }

    protected void controllerStopVMs() {
        Log.getLogWriter().info("In controllerStopVMs, stopStrategy is " + this.stopStrategy + ", recoveryDelay is " + this.recoveryDelay);
        HashSet<Object> currentHostSet = new HashSet<Object>();
        for (int i = 0; i < this.liveVMs.size(); ++i) {
            currentHostSet.add(RecovDelayBB.getBB().getSharedMap().get(vmIDStr + this.liveVMs.get(i)));
        }
        int numToStopThisTime = 1;
        if (this.stopStrategy.equalsIgnoreCase("group")) {
            numToStopThisTime = this.redundantCopies == 0 ? TestConfig.tab().getRandGen().nextInt(1, this.liveVMs.size() - 1) : (this.uniqueHostTest && this.recoveryDelay >= 0 && currentHostSet.size() <= this.redundantCopies ? Math.max(currentHostSet.size() - 1, 1) : Math.min(this.redundantCopies, this.liveVMs.size() - 1));
        }
        List vmsStoppedThisTime = null;
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("Stopping group vms concurrently");
            vmsStoppedThisTime = this.stopVMs(this.liveVMs, numToStopThisTime);
        } else {
            Log.getLogWriter().info("Stopping group vms serially");
            vmsStoppedThisTime = new ArrayList();
            for (int i = 1; i <= numToStopThisTime; ++i) {
                List aList = this.stopVMs(this.liveVMs, 1);
                vmsStoppedThisTime.addAll(aList);
            }
        }
        this.stoppedVMs.addAll(vmsStoppedThisTime);
        if (this.recoveryDelay == -1) {
            this.waitForNever();
            this.validateNoRecovery();
        } else if (this.recoveryDelay == 0) {
            if (this.redundantCopies == 0) {
                this.waitForNever();
                this.validateNoRecovery();
            } else {
                this.validateRecoveryNow(this.liveVMs, numToStopThisTime, false);
            }
        } else if (this.recoveryDelay > 0) {
            if (this.redundantCopies == 0) {
                this.waitForNever();
                this.validateNoRecovery();
            } else {
                this.validateRecoveryWithDelay(this.recoveryDelay, this.liveVMs, numToStopThisTime, false);
            }
        } else {
            throw new TestException("unknown recoveryDelay " + this.recoveryDelay);
        }
        Log.getLogWriter().info("After stopping, PR picture is: " + PrState.prMapToString(PrState.getPrMap(this.aRegion)));
        this.validatePRAfterStopping(numToStopThisTime);
    }

    protected void controllerStartVMs() {
        int i;
        Log.getLogWriter().info("In controllerStartVMs, startStrategy is " + this.startStrategy + ", startupRecoveryDelay is " + this.startupRecoveryDelay);
        boolean numStarted = false;
        ArrayList startedVMs = null;
        if (this.startStrategy.equalsIgnoreCase("group")) {
            int numToStart = TestConfig.tab().getRandGen().nextInt(1, this.vmsToStart.size());
            startedVMs = new ArrayList();
            for (i = 1; i <= numToStart; ++i) {
                int index = TestConfig.tab().getRandGen().nextInt(0, this.vmsToStart.size() - 1);
                startedVMs.add(this.vmsToStart.get(index));
                this.vmsToStart.remove(index);
            }
        } else {
            startedVMs = new ArrayList();
            startedVMs.add(this.vmsToStart.get(0));
            this.vmsToStart.remove(0);
        }
        StopStartVMs.startVMs(startedVMs);
        ArrayList previousLiveVMs = new ArrayList();
        previousLiveVMs.addAll(this.liveVMs);
        for (i = 0; i < startedVMs.size(); ++i) {
            this.liveVMs.add(((ClientVmInfo)startedVMs.get(i)).getVmid());
        }
        Log.getLogWriter().info("liveVMs: " + this.liveVMs);
        if (this.startupRecoveryDelay == -1) {
            this.waitForNever();
            this.validateNoRecovery();
        } else if (this.startupRecoveryDelay == 0) {
            if (this.redundantCopies == 0) {
                this.waitForNever();
                this.validateNoRecovery();
            } else {
                this.validateRecoveryNow(startedVMs, 1, true);
            }
        } else if (this.startupRecoveryDelay > 0) {
            if (this.redundantCopies == 0) {
                this.waitForNever();
                this.validateNoRecovery();
            } else {
                this.validateRecoveryWithDelay(this.startupRecoveryDelay, startedVMs, 1, true);
            }
        } else {
            throw new TestException("unknown startupRecoveryDelay " + this.startupRecoveryDelay);
        }
        Log.getLogWriter().info("After starting, PR picture is: " + PrState.prMapToString(PrState.getPrMap(this.aRegion)));
        this.validatePRAfterStarting(previousLiveVMs, startedVMs);
    }

    protected void validatePRAfterStopping(int numStoppedThisTime) {
        HashSet<Object> currentHostSet = new HashSet<Object>();
        for (int i = 0; i < this.liveVMs.size(); ++i) {
            currentHostSet.add(RecovDelayBB.getBB().getSharedMap().get(vmIDStr + this.liveVMs.get(i)));
        }
        int currentNumDataStoreVMs = this.numDataStoreVMs - this.stoppedVMs.size();
        boolean expectRecovery = this.recoveryDelay != -1 && this.redundantCopies > 0 && this.uniqueHostTest && currentHostSet.size() > 1;
        Log.getLogWriter().info("Validating PR after stopping,\ncurrent number of data store vms: " + currentNumDataStoreVMs + "\n" + "redundantCopies: " + this.redundantCopies + "\n" + "num stopped this time: " + numStoppedThisTime + "\n" + "total num stopped vms: " + this.stoppedVMs.size() + "\n" + "expect recovery: " + expectRecovery);
        Map regionSnapshot = (Map)ParRegBB.getBB().getSharedMap().get("RegionSnapshot");
        int expectedRedundantCopies = 0;
        if (expectRecovery) {
            expectedRedundantCopies = Math.min(currentNumDataStoreVMs - 1, this.redundantCopies);
            if (this.uniqueHostTest) {
                expectedRedundantCopies = Math.min(currentHostSet.size() - 1, this.redundantCopies);
            }
            if (numStoppedThisTime > this.redundantCopies || this.uniqueHostTest && expectedRedundantCopies < this.redundantCopies) {
                this.adjustRegionSnapshotForLostKeys(regionSnapshot);
            }
        } else {
            if (this.stoppedVMs.size() > this.redundantCopies || this.uniqueHostTest && currentHostSet.size() == 1) {
                this.adjustRegionSnapshotForLostKeys(regionSnapshot);
            }
            expectedRedundantCopies = -1;
        }
        this.verifyBucketsInVMs(this.stoppedVMs, this.liveVMs);
        Log.getLogWriter().info("Num expected bucket copies (not including primary): " + expectedRedundantCopies);
        ParRegBB.getBB().getSharedMap().put("RegionSnapshot", regionSnapshot);
        this.parRegTestInstance.redundantCopies = expectedRedundantCopies;
        this.parRegTestInstance.verifyFromSnapshot();
        if (this.uniqueHostTest) {
            ParRegUtil.verifyBucketsOnUniqueHosts(this.aRegion);
        }
    }

    protected void validatePRAfterStarting(List previousLiveVMs, List vmsStartedThisTime) {
        boolean capacityAdded;
        HashSet<Object> currentHostSet = new HashSet<Object>();
        for (int i = 0; i < this.liveVMs.size(); ++i) {
            currentHostSet.add(RecovDelayBB.getBB().getSharedMap().get(vmIDStr + this.liveVMs.get(i)));
        }
        HashSet<Object> previousHostSet = new HashSet<Object>();
        for (int i = 0; i < previousLiveVMs.size(); ++i) {
            Integer vmID = (Integer)previousLiveVMs.get(i);
            previousHostSet.add(RecovDelayBB.getBB().getSharedMap().get(vmIDStr + vmID));
        }
        HashSet newHosts = new HashSet(currentHostSet);
        newHosts.removeAll(previousHostSet);
        int currentNumDataStoreVMs = this.numDataStoreVMs - this.vmsToStart.size();
        boolean expectRecovery = this.startupRecoveryDelay != -1 && this.redundantCopies > 0;
        boolean redundancyIncreased = currentNumDataStoreVMs - vmsStartedThisTime.size() < this.totalBucketCopies;
        boolean bl = capacityAdded = currentNumDataStoreVMs > this.totalBucketCopies;
        if (this.uniqueHostTest) {
            boolean bl2 = redundancyIncreased = redundancyIncreased && newHosts.size() > 0;
            capacityAdded = redundancyIncreased ? vmsStartedThisTime.size() > 1 : true;
        }
        Log.getLogWriter().info("Validating PR after starting,\ncurrent number of data store vms: " + currentNumDataStoreVMs + "\n" + "redundantCopies: " + this.redundantCopies + "\n" + "num started this time: " + vmsStartedThisTime.size() + "\n" + "capacity added: " + capacityAdded + "\n" + "redundancy increased: " + redundancyIncreased + "\n" + "expect recovery: " + expectRecovery + "\n" + "liveVMs: " + this.liveVMs + "\n" + "current hosts with vms: " + currentHostSet + "\n" + "previous hosts: " + previousHostSet + "\n" + "new hosts: " + newHosts);
        if (this.uniqueHostTest) {
            ParRegUtil.verifyBucketsOnUniqueHosts(this.aRegion);
        }
        if (capacityAdded) {
            if (redundancyIncreased) {
                if (vmsStartedThisTime.size() == 1) {
                    throw new TestException("Test problem; only 1 vm was started, but expected > 1");
                }
                if (expectRecovery) {
                    if (this.startupRecoveryDelay == 0) {
                        this.startupRecoveryRace = true;
                    } else {
                        BucketState.checkPrimaryBalance(this.aRegion);
                    }
                } else if (!this.uniqueHostTest) {
                    this.verifyBucketsInVMs(vmsStartedThisTime, null);
                    if (!this.startupRecoveryRace) {
                        BucketState.checkPrimaryBalance(this.aRegion);
                    }
                }
            } else if (!this.uniqueHostTest) {
                this.verifyBucketsInVMs(vmsStartedThisTime, null);
                if (!this.startupRecoveryRace) {
                    BucketState.checkPrimaryBalance(this.aRegion);
                }
            }
        } else if (redundancyIncreased) {
            if (expectRecovery) {
                if (!this.startupRecoveryRace) {
                    BucketState.checkPrimaryBalance(this.aRegion);
                }
                if (!this.uniqueHostTest) {
                    this.verifyBucketsInVMs(null, this.liveVMs);
                }
            } else if (!this.uniqueHostTest) {
                this.verifyBucketsInVMs(vmsStartedThisTime, null);
                if (!this.startupRecoveryRace) {
                    BucketState.checkPrimaryBalance(this.aRegion);
                }
            }
        } else {
            throw new TestException("Test error, capacityAdded " + capacityAdded + ", redundancyIncreased " + redundancyIncreased);
        }
        int expectedRedundantCopies = 0;
        expectedRedundantCopies = expectRecovery ? (this.uniqueHostTest ? Math.min(currentHostSet.size() - 1, this.redundantCopies) : Math.min(currentNumDataStoreVMs - 1, this.redundantCopies)) : -1;
        Log.getLogWriter().info("Num expected bucket copies (not including primary): " + expectedRedundantCopies);
        this.parRegTestInstance.redundantCopies = expectedRedundantCopies;
        this.parRegTestInstance.verifyFromSnapshot();
    }

    protected void validateNoRecovery() {
        Log.getLogWriter().info("In validateNoRecovery");
        long rebalRecovStartCounter = PRObserverBB.getBB().getSharedCounters().read(PRObserverBB.rebalRecovStartCounter);
        if (rebalRecovStartCounter != 0L) {
            throw new TestException("Expected no recovery to occur, but rebalRecovStartCounter is " + rebalRecovStartCounter);
        }
        Log.getLogWriter().info("In validateNoRecovery, no recovery occurred");
    }

    protected void validateRecoveryNow(List vmsExpectingRecovery, int numRecovPerVM, boolean isStartupRecovery) {
        int WAIT_MILLIS = 20000;
        int SLEEP_MILLIS = 500;
        boolean started = PRObserver.waitForAnyRebalRecovToStart(20000L, 500);
        if (!started) {
            throw new TestException("Expected recovery to begin, but after waiting 20000 ms, recovery has not started");
        }
        Log.getLogWriter().info("In validateRecoveryNow, recovery has begun");
        if (isStartupRecovery) {
            PRObserver.waitForRebalRecov(vmsExpectingRecovery, 1, 1, null, null, false);
        } else {
            PRObserver.waitForRebalRecov(vmsExpectingRecovery, numRecovPerVM, 1, null, null, true);
        }
    }

    protected void validateRecoveryWithDelay(int delayMillis, List vmsExpectingRecovery, int numRecovPerVM, boolean isStartupRecovery) {
        long waitTimeMillis = delayMillis + 120000;
        boolean started = PRObserver.waitForAnyRebalRecovToStart(waitTimeMillis, 1000);
        if (!started) {
            throw new TestException("In validateRecoveryWithDelay, after waiting " + waitTimeMillis + " ms recovery did not start,  recovery delay: " + delayMillis + " ms");
        }
        long approxTimerStartTime = PRObserverBB.getBB().getSharedCounters().read(PRObserverBB.approxTimerStartTime);
        long expectedRecovStartTime = approxTimerStartTime + (long)delayMillis;
        long recovStartTime = PRObserverBB.getBB().getSharedCounters().read(PRObserverBB.rebalRecovStartTime);
        long diff = Math.abs(recovStartTime - expectedRecovStartTime);
        long threshold = 15000L;
        String aStr = "In validateRecoveryWithDelay, delay ms: " + delayMillis + ", approxTimerStartTime: " + approxTimerStartTime + ", expected recovery start time: " + expectedRecovStartTime + ", actual earliest recovery start time: " + recovStartTime + ", difference between actual earliest recovery start time and expected recovery start time (ms): " + diff;
        Log.getLogWriter().info(aStr);
        if (diff > threshold) {
            throw new TestException("Recovery did not start within " + threshold + " ms of expected start time, " + aStr);
        }
        if (isStartupRecovery) {
            PRObserver.waitForRebalRecov(vmsExpectingRecovery, 1, 1, null, null, false);
        } else {
            PRObserver.waitForRebalRecov(vmsExpectingRecovery, numRecovPerVM, 1, null, null, true);
        }
    }

    protected void checkForBalance(Map prMap) {
        Log.getLogWriter().info("Checking PR balance...");
        Iterator it = prMap.keySet().iterator();
        int numMembers = prMap.size();
        TreeMap<Integer, Integer> balance_numBuckets = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Integer> balance_numPrimaries = new TreeMap<Integer, Integer>();
        TreeMap<String, Integer> balance_numEntries = new TreeMap<String, Integer>();
        int totalNumBuckets = 0;
        int totalNumEntries = 0;
        while (it.hasNext()) {
            Integer vmId = (Integer)it.next();
            PrState state = (PrState)prMap.get(vmId);
            List bucketList = state.getBucketInfoList();
            int numBuckets = bucketList.size();
            totalNumBuckets += numBuckets;
            Integer anInteger = (Integer)balance_numBuckets.get(vmId);
            anInteger = anInteger == null ? new Integer(numBuckets) : new Integer(anInteger + numBuckets);
            balance_numBuckets.put(vmId, anInteger);
            for (int i = 0; i < bucketList.size(); ++i) {
                BucketInfo info = (BucketInfo)bucketList.get(i);
                boolean isPrimary = info.getIsPrimary();
                if (isPrimary) {
                    anInteger = (Integer)balance_numPrimaries.get(vmId);
                    anInteger = anInteger == null ? new Integer(1) : new Integer(anInteger + 1);
                    balance_numPrimaries.put(vmId, anInteger);
                }
                int bucketId = info.getBucketId();
                int numEntries = info.getEntriesMap().size();
                String key = "vmId " + vmId + ", " + "bucketId" + bucketId;
                anInteger = (Integer)balance_numEntries.get(key);
                if (anInteger != null) {
                    throw new TestException("Test problem; key " + key + " already has an entry");
                }
                anInteger = new Integer(numEntries);
                balance_numEntries.put(key, anInteger);
                totalNumEntries += numEntries;
            }
        }
        Log.getLogWriter().info("Primaries: " + balance_numPrimaries);
        Log.getLogWriter().info("Buckets: " + balance_numBuckets);
        StringBuffer aStr = new StringBuffer();
        it = balance_numPrimaries.keySet().iterator();
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int totalPrimaryBuckets = 0;
        while (it.hasNext()) {
            Integer vmId = (Integer)it.next();
            int value = (Integer)balance_numPrimaries.get(vmId);
            min = Math.min(min, value);
            max = Math.max(max, value);
            totalPrimaryBuckets += value;
        }
        double allowableSpan = Math.ceil((double)totalPrimaryBuckets * 0.1);
        int span = Math.abs(max - min);
        if ((double)span > allowableSpan) {
            aStr.append("Primaries are not balanced, least number of primaries in a vm: " + min + ", most number of primaries in a vm: " + max + "; " + balance_numPrimaries);
        }
        it = balance_numBuckets.keySet().iterator();
        min = Integer.MAX_VALUE;
        max = Integer.MIN_VALUE;
        int totalBuckets = 0;
        while (it.hasNext()) {
            Integer vmId = (Integer)it.next();
            int value = (Integer)balance_numBuckets.get(vmId);
            min = Math.min(min, value);
            max = Math.max(max, value);
            totalBuckets += value;
        }
        allowableSpan = Math.ceil((double)totalBuckets * 0.1);
        span = Math.abs(max - min);
        if ((double)span > allowableSpan) {
            aStr.append("Buckets are not balanced, least number of buckets in a vm: " + min + ", most number of buckets in a vm: " + max + "; " + balance_numBuckets);
        }
        it = balance_numEntries.keySet().iterator();
        min = Integer.MAX_VALUE;
        max = Integer.MIN_VALUE;
        int totalEntries = 0;
        while (it.hasNext()) {
            String vmIdBucketIdKey = (String)it.next();
            int value = (Integer)balance_numEntries.get(vmIdBucketIdKey);
            min = Math.min(min, value);
            max = Math.max(max, value);
            totalEntries += value;
        }
        allowableSpan = Math.ceil((double)totalEntries * 0.1);
        span = Math.abs(max - min);
        if ((double)span > allowableSpan) {
            aStr.append("Entries are not balanced, least number of entries in a bucket: " + min + ", most number of entries in a bucket: " + max + "; " + balance_numEntries);
        }
        if (aStr.length() > 0) {
            Log.getLogWriter().info(PrState.prMapToString(prMap));
            throw new TestException(aStr.toString());
        }
        Log.getLogWriter().info("PR is balanced");
    }

    protected void waitForNever() {
        int bufferMillis;
        int neverMillis = bufferMillis = 45000;
        if (this.recoveryDelay > 0 || this.startupRecoveryDelay > 0) {
            neverMillis = Math.max(this.recoveryDelay, this.startupRecoveryDelay) + bufferMillis;
        }
        Log.getLogWriter().info("Waiting for never (" + neverMillis + " millis)...");
        MasterController.sleepForMs(neverMillis);
        Log.getLogWriter().info("Done waiting for never (" + neverMillis + " millis)...");
    }

    protected void verifyBucketsInVMs(List emptyVMs, List nonEmptyVMs) {
        Integer vmID;
        Object vm;
        int i;
        Map bucketMap = BucketState.getBucketMaps(this.aRegion)[1];
        if (emptyVMs != null) {
            for (i = 0; i < emptyVMs.size(); ++i) {
                vm = emptyVMs.get(i);
                vmID = null;
                vmID = vm instanceof Integer ? (Integer)vm : new Integer(((ClientVmInfo)vm).getVmid());
                if (bucketMap.get(vmID) == null) continue;
                throw new TestException("Expected vm " + vm + " to contain no buckets, but it contains " + bucketMap.get(vmID));
            }
        }
        if (nonEmptyVMs != null) {
            for (i = 0; i < nonEmptyVMs.size(); ++i) {
                vm = nonEmptyVMs.get(i);
                vmID = null;
                vmID = vm instanceof Integer ? (Integer)vm : new Integer(((ClientVmInfo)vm).getVmid());
                if (bucketMap.get(vmID) != null) continue;
                throw new TestException("Expected vm " + vm + " to contain buckets, but it is empty");
            }
        }
    }

    protected List stopVMs(List availableVMs, int numToStop) {
        if (availableVMs.size() < numToStop) {
            throw new TestException("Test requested to stop " + numToStop + " vms, but there are only " + availableVMs.size() + " vms available");
        }
        if (numToStop <= 0) {
            throw new TestException("Cannot stop " + numToStop + " vms");
        }
        ArrayList<ClientVmInfo> vmList = new ArrayList<ClientVmInfo>();
        ArrayList<String> stopModeList = new ArrayList<String>();
        do {
            int randInt = TestConfig.tab().getRandGen().nextInt(0, availableVMs.size() - 1);
            Integer vmID = (Integer)availableVMs.get(randInt);
            ClientVmInfo targetVm = new ClientVmInfo(vmID, null, null);
            vmList.add(targetVm);
            availableVMs.remove(randInt);
            String choice = TestConfig.tab().stringAt(StopStartPrms.stopModes);
            stopModeList.add(choice);
        } while (vmList.size() < numToStop);
        StopStartVMs.stopVMs(vmList, stopModeList);
        return vmList;
    }

    protected Set getBucketIds(List aBucketList) {
        TreeSet<Integer> aSet = new TreeSet<Integer>();
        for (int bucketId = 0; bucketId < aBucketList.size(); ++bucketId) {
            List aList = (List)aBucketList.get(bucketId);
            if (aList == null || aList.size() == 0) continue;
            aSet.add(new Integer(bucketId));
        }
        return aSet;
    }

    protected Set getLostBuckets() {
        List<List<BucketInfo>> currBucketList = BucketInfo.getAllBuckets(this.aRegion);
        Set currBucketIds = this.getBucketIds(currBucketList);
        currBucketList = null;
        TreeSet lostBucketIds = new TreeSet(this.masterBucketIdSet);
        lostBucketIds.removeAll(currBucketIds);
        Log.getLogWriter().info("Lost buckets: " + lostBucketIds);
        return lostBucketIds;
    }

    protected void adjustRegionSnapshotForLostKeys(Map regionSnapshot) {
        Set lostBucketIds = this.getLostBuckets();
        Iterator it = lostBucketIds.iterator();
        while (it.hasNext()) {
            int bucketId = (Integer)it.next();
            List bucketInfoList = (List)this.masterBucketInfoList.get(bucketId);
            BucketInfo info = (BucketInfo)bucketInfoList.get(0);
            Map entriesMap = info.getEntriesMap();
            for (Object key : entriesMap.keySet()) {
                regionSnapshot.remove(key);
            }
        }
    }
}

