/*
 * Decompiled with CFR 0.152.
 */
package regions.validate;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.distributed.DistributedSystem;
import hydra.EnvHelper;
import hydra.GemFireDescription;
import hydra.HostDescription;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.TestConfig;
import java.util.Properties;
import java.util.Set;
import regions.validate.CacheXmlPrms;

public class CacheXmlClient {
    static Cache myCache = null;
    static DistributedSystem ds = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void createCacheWithXMLTask() {
        String gemfireName = System.getProperty("gemfireName");
        GemFireDescription gfd = TestConfig.getInstance().getGemFireDescription(gemfireName);
        Properties p = gfd.getDistributedSystemProperties();
        HostDescription hd = gfd.getHostDescription();
        String cacheXmlFile = TestConfig.tasktab().stringAt(CacheXmlPrms.cacheXmlFile, TestConfig.tab().stringAt(CacheXmlPrms.cacheXmlFile, null));
        p.setProperty("cache-xml-file", EnvHelper.expandEnvVars(cacheXmlFile, hd));
        ds = DistributedSystem.connect((Properties)p);
        myCache = null;
        try {
            myCache = CacheFactory.create((DistributedSystem)ds);
        }
        catch (CacheException e) {
            String s = "Unable to create cache using: " + ds;
            throw new HydraRuntimeException(s, (Exception)((Object)e));
        }
        catch (IllegalStateException is) {
            String s = "IllegalStateException!!! ";
        }
        finally {
            if (myCache == null) {
                myCache = CacheFactory.getAnyInstance();
                Log.getLogWriter().info("CacheFactory.getAnyInstance() returned " + myCache);
            }
            if (myCache != null) {
                Set regions = myCache.rootRegions();
                Log.getLogWriter().info("Cache contains " + regions.size() + " entries " + regions);
                for (Region r : regions) {
                    String regionName = r.getName();
                    RegionAttributes attr = r.getAttributes();
                    Scope scope = attr.getScope();
                    Log.getLogWriter().info("Region = " + regionName + " with Scope = " + scope);
                }
            } else {
                Log.getLogWriter().info("CacheFactory create returned null, no cache");
            }
        }
    }

    public static void putDataTask() {
        Set regions = myCache.rootRegions();
        for (Region r : regions) {
            Log.getLogWriter().info("Putting 10000 entries in " + r.getName());
            for (int count = 0; count < 10000; ++count) {
                String key = "Object_" + count;
                r.put((Object)key, (Object)new Integer(count));
            }
            Log.getLogWriter().info("Put 10000 entries in " + r.getName());
        }
    }

    public static synchronized void closeCacheTask() {
        if (myCache != null) {
            myCache.close();
        }
    }
}

