/*
 * Decompiled with CFR 0.152.
 */
package regions.validate;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.internal.Assert;
import hydra.Log;
import objects.ObjectHelper;
import regions.validate.InUse;
import regions.validate.ObjectValue;
import regions.validate.ValidateBlackboard;
import regions.validate.ValidatePrms;
import regions.validate.Value;
import util.NameFactory;

public class ValidateLoader
implements CacheLoader {
    private static InUse IN_USE = InUse.singleton;

    public Object load(LoaderHelper helper) throws CacheLoaderException {
        Value oldValue;
        ValidateBlackboard bb;
        Object key = helper.getKey();
        if (helper.getRegion().getAttributes().getScope().isDistributed()) {
            String s = "netSearch not working.  See bug 30895";
            throw new UnsupportedOperationException(s);
        }
        LogWriter logger = Log.getLogWriter();
        boolean DEBUG = ValidatePrms.isDebug();
        if (DEBUG) {
            logger.info("Loading " + key);
        }
        if (!(bb = ValidateBlackboard.getInstance()).replace(key, oldValue = bb.get(key), IN_USE)) {
            try {
                Thread.sleep(200L);
                if (DEBUG) {
                    logger.info("Waiting to use " + key);
                }
            }
            catch (InterruptedException ex) {
                logger.info("Interrupted while waiting to load " + key);
                return null;
            }
        }
        if (oldValue instanceof ObjectValue) {
            return ((ObjectValue)oldValue).getValue();
        }
        String objectType = ValidatePrms.getObjectType();
        long l = NameFactory.getCounterForName(key);
        Object value = ObjectHelper.createObject(objectType, (int)l);
        if (DEBUG) {
            logger.info("Loaded " + key + " -> " + value);
        }
        ObjectValue newValue = new ObjectValue(value);
        Assert.assertTrue((boolean)bb.replace(key, IN_USE, newValue));
        return value;
    }

    public void close() {
    }
}

