/*
 * Decompiled with CFR 0.152.
 */
package resman;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.LowMemoryException;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.TransactionInDoubtException;
import com.gemstone.gemfire.cache.control.RebalanceFactory;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache.control.ResourceManager;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.IndexInvalidException;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryExecutionLowMemoryException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import getInitialImage.InitImagePrms;
import hydra.CacheHelper;
import hydra.GsRandom;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.StopSchedulingOrder;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import parReg.ParRegBB;
import parReg.ParRegUtil;
import rebalance.RebalanceUtil;
import resman.ResourceManBB;
import resman.ResourceManPrms;
import util.NameFactory;
import util.PRObserver;
import util.RandomValues;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;
import util.ValueHolder;

public class MemManTest {
    public static MemManTest testInstance;
    protected List<Region> regionList;
    protected int regionNameIndex = 0;
    protected AtomicLong lowMemCounter = new AtomicLong();
    protected AtomicInteger gcController = new AtomicInteger();

    public static synchronized void HydraTask_initAccessor() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new MemManTest();
            int numRegions = ResourceManPrms.getNumRegions();
            testInstance.initializeInstance();
            for (int i = 1; i <= numRegions; ++i) {
                MemManTest.testInstance.regionList.add(testInstance.initializeRegion("accessorRegion", 0));
            }
        }
    }

    public static synchronized void HydraTask_initDataStore() {
        if (testInstance == null) {
            PRObserver.installObserverHook();
            testInstance = new MemManTest();
            testInstance.initializeInstance();
            int numRegions = ResourceManPrms.getNumRegions();
            for (int i = 1; i <= numRegions; ++i) {
                MemManTest.testInstance.regionList.add(testInstance.initializeRegion("dataStoreRegion", -1));
            }
        }
    }

    public static synchronized void HydraTask_initDistributedRegion() {
        if (testInstance == null) {
            testInstance = new MemManTest();
            testInstance.initializeInstance();
            int numRegions = ResourceManPrms.getNumRegions();
            for (int i = 1; i <= numRegions; ++i) {
                MemManTest.testInstance.regionList.add(testInstance.initializeRegion("distributedRegion", -1));
            }
        }
    }

    public static void HydraTask_rebalance() {
        ResourceManager resMan = CacheHelper.getCache().getResourceManager();
        RebalanceFactory factory = resMan.createRebalanceFactory();
        try {
            Log.getLogWriter().info("Starting rebalancing");
            long startTime = System.currentTimeMillis();
            RebalanceOperation rebalanceOp = factory.start();
            RebalanceResults rebalanceResults = rebalanceOp.getResults();
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            Log.getLogWriter().info("Rebalance completed in " + duration + " ms");
            Log.getLogWriter().info(RebalanceUtil.RebalanceResultsToString(rebalanceResults, "Rebalance"));
        }
        catch (InterruptedException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void HydraTask_rebalanceOnce() {
        long rebalance = ParRegBB.getBB().getSharedCounters().incrementAndRead(ParRegBB.rebalance);
        if (rebalance == 1L) {
            ResourceManager resMan = CacheHelper.getCache().getResourceManager();
            RebalanceFactory factory = resMan.createRebalanceFactory();
            try {
                Log.getLogWriter().info("Starting rebalancing");
                long startTime = System.currentTimeMillis();
                RebalanceOperation rebalanceOp = factory.start();
                RebalanceResults rebalanceResults = rebalanceOp.getResults();
                long endTime = System.currentTimeMillis();
                long duration = endTime - startTime;
                Log.getLogWriter().info("Rebalance completed in " + duration + " ms");
                Log.getLogWriter().info(RebalanceUtil.RebalanceResultsToString(rebalanceResults, "Rebalance"));
                RebalanceUtil.isBalanceImproved(rebalanceResults);
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
    }

    public static void HydraTask_verifyPRMetaData() {
        long verifyController = ResourceManBB.getBB().getSharedCounters().incrementAndRead(ResourceManBB.verifyController1);
        if (verifyController == 1L) {
            for (Region aRegion : MemManTest.testInstance.regionList) {
                Log.getLogWriter().info("Verifying " + aRegion.getFullPath());
                ParRegUtil.verifyPRMetaData(aRegion);
            }
        }
    }

    public static void HydraTask_verifyPrimaries() {
        long verifyController = ResourceManBB.getBB().getSharedCounters().incrementAndRead(ResourceManBB.verifyController2);
        if (verifyController == 1L) {
            for (Region aRegion : MemManTest.testInstance.regionList) {
                Log.getLogWriter().info("Verifying " + aRegion.getFullPath());
                int redundantCopies = aRegion.getAttributes().getPartitionAttributes().getRedundantCopies();
                ParRegUtil.verifyPrimaries(aRegion, redundantCopies);
            }
        }
    }

    public static void HydraTask_verifyBucketCopies() {
        long verifyController = ResourceManBB.getBB().getSharedCounters().incrementAndRead(ResourceManBB.verifyController3);
        if (verifyController == 1L) {
            for (Region aRegion : MemManTest.testInstance.regionList) {
                Log.getLogWriter().info("Verifying " + aRegion.getFullPath());
                int redundantCopies = aRegion.getAttributes().getPartitionAttributes().getRedundantCopies();
                ParRegUtil.verifyBucketCopies(aRegion, redundantCopies);
            }
        }
    }

    public Region initializeRegion(String regDescriptName, int localMaxMemory) {
        CacheHelper.createCache("cache1");
        AttributesFactory factory = RegionHelper.getAttributesFactory(regDescriptName);
        if (localMaxMemory != -1) {
            RegionAttributes attr = RegionHelper.getRegionAttributes(regDescriptName);
            PartitionAttributes prAttr = attr.getPartitionAttributes();
            PartitionAttributesFactory prFactory = new PartitionAttributesFactory(prAttr);
            prFactory.setLocalMaxMemory(localMaxMemory);
            factory.setPartitionAttributes(prFactory.create());
        }
        String regionName = (String)TestConfig.tab().vecAt(RegionPrms.regionName).get(0);
        regionName = regionName + ++this.regionNameIndex;
        Region aRegion = RegionHelper.createRegion(regionName, factory);
        return aRegion;
    }

    public void initializeInstance() {
        this.regionList = new ArrayList<Region>();
        ResourceManBB.getBB().getSharedCounters().zero(ResourceManBB.firstLowMemoryExceptionTime);
        ResourceManBB.getBB().getSharedCounters().add(ResourceManBB.firstLowMemoryExceptionTime, Long.MAX_VALUE);
        ResourceManBB.getBB().getSharedCounters().zero(ResourceManBB.testStartTime);
        ResourceManBB.getBB().getSharedCounters().add(ResourceManBB.testStartTime, Long.MAX_VALUE);
        Log.getLogWriter().info("Resetting all the Counters in ResourceManBB");
    }

    public static void HydraTask_doOpsBeyondCritical() {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        testInstance.doOpsWithHeavyCreates(minTaskGranularityMS, true);
        long firstExceptionTime = ResourceManBB.getBB().getSharedCounters().read(ResourceManBB.firstLowMemoryExceptionTime);
        if (firstExceptionTime < Long.MAX_VALUE) {
            long testStartTime = ResourceManBB.getBB().getSharedCounters().read(ResourceManBB.testStartTime);
            long timeToFirstException = firstExceptionTime - testStartTime;
            Log.getLogWriter().info("It took " + timeToFirstException + " ms to get the first LowMemoryException. testStartTime=" + testStartTime + " timeToFirstException:" + timeToFirstException + " firstExceptionTime:" + firstExceptionTime);
            long timeToEndTest = firstExceptionTime + 2L * timeToFirstException;
            long now = System.currentTimeMillis();
            long testDuration = now - testStartTime;
            long testDurationSinceLowMemException = now - firstExceptionTime;
            if (now >= timeToEndTest) {
                throw new StopSchedulingOrder("Test has run for " + testDuration + " ms and did not run out of memory, including " + timeToFirstException + " ms to get the first LowMemoryException and " + testDurationSinceLowMemException + " ms beyond that");
            }
            Log.getLogWriter().info("Test has run for " + testDuration + " ms including " + timeToFirstException + " ms to get the first LowMemoryException; test will run for another " + (timeToEndTest - now) + " ms ");
        }
    }

    public static void HydraTask_doQueryAndIndexOps() {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        testInstance.doQueryAndIndexOps(minTaskGranularityMS, true);
        long firstExceptionTime = ResourceManBB.getBB().getSharedCounters().read(ResourceManBB.firstLowMemoryExceptionTime);
        if (firstExceptionTime < Long.MAX_VALUE) {
            long testStartTime = ResourceManBB.getBB().getSharedCounters().read(ResourceManBB.testStartTime);
            long timeToFirstException = firstExceptionTime - testStartTime;
            Log.getLogWriter().info("It took " + timeToFirstException + " ms to get the first LowMemoryException. testStartTime=" + testStartTime + " timeToFirstException:" + timeToFirstException + " firstExceptionTime:" + firstExceptionTime);
            long timeToEndTest = firstExceptionTime + 2L * timeToFirstException;
            long now = System.currentTimeMillis();
            long testDuration = now - testStartTime;
            long testDurationSinceLowMemException = now - firstExceptionTime;
            if (now >= timeToEndTest) {
                throw new StopSchedulingOrder("Test has run for " + testDuration + " ms and did not run out of memory, including " + timeToFirstException + " ms to get the first LowMemoryException and " + testDurationSinceLowMemException + " ms beyond that");
            }
            Log.getLogWriter().info("Test has run for " + testDuration + " ms including " + timeToFirstException + " ms to get the first LowMemoryException; test will run for another " + (timeToEndTest - now) + " ms ");
        }
    }

    public static void HydraTask_doOpsUntilCritical() {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        boolean becameCritical = testInstance.doOpsWithHeavyCreates(minTaskGranularityMS, true);
        if (becameCritical) {
            throw new StopSchedulingTaskOnClientOrder("System has become critical");
        }
    }

    public static void HydraTask_doOpsNotCritical() throws LowMemoryException {
        long msToRun = 10000L;
        testInstance.doOpsWithHeavyCreates(msToRun, false);
    }

    public static void HydraTask_doGC() {
        int value = MemManTest.testInstance.gcController.incrementAndGet();
        if (value == 1) {
            Log.getLogWriter().info("Calling gc...");
            System.gc();
            Log.getLogWriter().info("Done calling gc...");
        }
        Log.getLogWriter().info("Sleeping 60000 to allow system to recognize we are not critical");
        MasterController.sleepForMs(60000);
    }

    protected boolean doOpsWithHeavyCreates(long millisToRun, boolean allowCritical) throws LowMemoryException {
        Log.getLogWriter().info("Running ops for " + millisToRun + " ms");
        ResourceManBB.getBB().getSharedCounters().setIfSmaller(ResourceManBB.testStartTime, System.currentTimeMillis());
        RandomValues randomValues = new RandomValues();
        long LOG_INTERVAL_MILLIS = 10000L;
        long lastLogTime = System.currentTimeMillis();
        long startTime = System.currentTimeMillis();
        GsRandom rand = TestConfig.tab().getRandGen();
        int regionIndex = 0;
        boolean becameCritical = false;
        boolean useTransactions = InitImagePrms.useTransactions();
        do {
            boolean rolledback;
            block35: {
                Region aRegion = this.regionList.get(regionIndex);
                regionIndex = (regionIndex + 1) % this.regionList.size();
                int randInt = rand.nextInt(1, 100);
                rolledback = false;
                if (useTransactions) {
                    TxHelper.begin();
                }
                try {
                    if (randInt <= 80) {
                        String key;
                        randInt = rand.nextInt(1, 100);
                        if (randInt <= 33) {
                            key = NameFactory.getNextPositiveObjectName();
                            Object result = aRegion.get((Object)key);
                            if (result == null) {
                                throw new TestException("get returned null for key " + key + " loader should be installed");
                            }
                        } else if (randInt <= 66 && !useTransactions) {
                            int putAllSize = ResourceManPrms.getPutAllSize();
                            if (putAllSize < 1) {
                                throw new TestException("Did not specify a value for ResourceManPrms.putAllSize");
                            }
                            HashMap<String, ValueHolder> putAllMap = new HashMap<String, ValueHolder>();
                            for (int i = 1; i <= putAllSize; ++i) {
                                String key2 = NameFactory.getNextPositiveObjectName();
                                ValueHolder anObj = new ValueHolder(key2, randomValues);
                                putAllMap.put(key2, anObj);
                            }
                            aRegion.putAll(putAllMap);
                        } else {
                            key = NameFactory.getNextPositiveObjectName();
                            ValueHolder anObj = new ValueHolder(key, randomValues);
                            aRegion.create((Object)key, (Object)anObj);
                        }
                        break block35;
                    }
                    randInt = rand.nextInt(1, 100);
                    try {
                        Iterator it = aRegion.keySet().iterator();
                        if (!it.hasNext()) break block35;
                        Object key = it.next();
                        if (randInt <= 25) {
                            aRegion.invalidate(key);
                            break block35;
                        }
                        if (randInt <= 50) {
                            aRegion.destroy(key);
                            break block35;
                        }
                        if (randInt <= 75) {
                            aRegion.get(key);
                            break block35;
                        }
                        aRegion.put(key, (Object)new ValueHolder(key, randomValues));
                    }
                    catch (EntryNotFoundException it) {}
                }
                catch (TransactionDataNodeHasDepartedException e) {
                    if (!useTransactions) {
                        throw new TestException("Unexpected TransactionDataNodeHasDepartedException " + TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("Caught TransactionDataNodeHasDepartedException.  Expected with concurrent execution, continuing test.");
                    Log.getLogWriter().info("Rolling back transaction.");
                    try {
                        TxHelper.rollback();
                        Log.getLogWriter().info("Done Rolling back Transaction");
                    }
                    catch (TransactionException te) {
                        Log.getLogWriter().info("Caught exception " + (Object)((Object)te) + " on rollback() after catching TransactionDataNodeHasDeparted during tx ops.  Expected, continuing test.");
                    }
                    rolledback = true;
                }
                catch (TransactionDataRebalancedException e) {
                    if (!useTransactions) {
                        throw new TestException("Unexpected Exception " + (Object)((Object)e) + ". " + TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + ".  Expected with concurrent execution, continuing test.");
                    Log.getLogWriter().info("Rolling back transaction.");
                    try {
                        TxHelper.rollback();
                        Log.getLogWriter().info("Done Rolling back Transaction");
                    }
                    catch (TransactionException te) {
                        Log.getLogWriter().info("Caught exception " + (Object)((Object)te) + " on rollback() after catching Exception " + (Object)((Object)e) + " during tx ops.  Expected, continuing test.");
                    }
                    rolledback = true;
                }
                catch (LowMemoryException e) {
                    becameCritical = true;
                    if (allowCritical) {
                        long timeMS = System.currentTimeMillis();
                        ResourceManBB.getBB().getSharedCounters().setIfSmaller(ResourceManBB.firstLowMemoryExceptionTime, new Long(timeMS));
                        long value = this.lowMemCounter.incrementAndGet();
                        if (value == 1L) {
                            Log.getLogWriter().info("The first LowMemoryException for this vm has occurred at ms:" + timeMS);
                        }
                        if (useTransactions) {
                            Log.getLogWriter().info("Caught expected LowMemoryException, continuing test");
                            Log.getLogWriter().info("Rolling back transaction.");
                            TxHelper.rollback();
                            rolledback = true;
                            Log.getLogWriter().info("Done Rolling back Transaction");
                        }
                    }
                    throw e;
                }
            }
            if (useTransactions && !rolledback) {
                try {
                    TxHelper.commit();
                }
                catch (TransactionDataNodeHasDepartedException e) {
                    Log.getLogWriter().info("Caught TransactionDataNodeHasDepartedException.  Expected with concurrent execution, continuing test.");
                }
                catch (TransactionDataRebalancedException e) {
                    Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + " .  Expected with concurrent execution, continuing test.");
                }
                catch (TransactionInDoubtException e) {
                    Log.getLogWriter().info("Caught TransactionInDoubtException.  Expected with concurrent execution, continuing test.");
                }
                catch (ConflictException e) {
                    Log.getLogWriter().info("Caught ConflictException. Expected with concurrent execution, continuing test.");
                }
            }
            if (System.currentTimeMillis() - lastLogTime <= 10000L) continue;
            StringBuffer logStr = new StringBuffer();
            for (Region theRegion : this.regionList) {
                logStr.append(TestHelper.regionToString(theRegion, false) + " is size " + theRegion.size() + "\n");
            }
            Log.getLogWriter().info(logStr.toString());
            lastLogTime = System.currentTimeMillis();
        } while (System.currentTimeMillis() - startTime < millisToRun);
        Log.getLogWriter().info("Done running ops for " + millisToRun + " ms");
        return becameCritical;
    }

    protected boolean doQueryAndIndexOps(long millisToRun, boolean allowCritical) throws LowMemoryException {
        Log.getLogWriter().info("Running query ops for " + millisToRun + " ms");
        ResourceManBB.getBB().getSharedCounters().setIfSmaller(ResourceManBB.testStartTime, System.currentTimeMillis());
        RandomValues randomValues = new RandomValues();
        long LOG_INTERVAL_MILLIS = 10000L;
        long lastLogTime = System.currentTimeMillis();
        long GC_INTERVAL_MILLIS = 30000L;
        long lastGcTime = System.currentTimeMillis();
        long startTime = System.currentTimeMillis();
        GsRandom rand = TestConfig.tab().getRandGen();
        int regionIndex = 0;
        boolean becameCritical = false;
        int numOperationsCanceled = 0;
        int totalQueries = 0;
        int totalIndexCreatesAttempted = 0;
        do {
            block19: {
                Region aRegion = this.regionList.get(regionIndex);
                regionIndex = (regionIndex + 1) % this.regionList.size();
                try {
                    Query query;
                    QueryService queryService = CacheHelper.getCache().getQueryService();
                    int randInt = rand.nextInt(1, 100);
                    if (randInt < 5) {
                        Index index = queryService.getIndex(aRegion, "testIndex");
                        if (index == null) {
                            try {
                                ++totalIndexCreatesAttempted;
                                queryService.createIndex("testIndex", "ID", "/" + aRegion.getName());
                                break block19;
                            }
                            catch (IndexExistsException indexExistsException) {
                                break block19;
                            }
                            catch (IndexNameConflictException indexNameConflictException) {
                                break block19;
                            }
                            catch (IndexInvalidException iie) {
                                if (iie.getMessage() != null && iie.getMessage().equals(LocalizedStrings.IndexCreationMsg_CANCELED_DUE_TO_LOW_MEMORY.toLocalizedString())) {
                                    throw new QueryExecutionLowMemoryException();
                                }
                                break block19;
                            }
                        }
                        queryService.removeIndex(index);
                        break block19;
                    }
                    if (randInt < 15) {
                        String queryString = "Select * From /" + aRegion.getName();
                        query = queryService.newQuery(queryString);
                        ++totalQueries;
                        query.execute();
                    } else {
                        String queryString = "Select * From /" + aRegion.getName() + " limit 5";
                        query = queryService.newQuery(queryString);
                        ++totalQueries;
                        query.execute();
                    }
                }
                catch (FunctionDomainException e) {
                    throw new TestException("Unexpected function domain exception", e);
                }
                catch (TypeMismatchException e) {
                    throw new TestException("Unexpected type mismatch exception", e);
                }
                catch (NameResolutionException e) {
                    throw new TestException("Unexpected name resolution exception", e);
                }
                catch (QueryInvocationTargetException e) {
                    throw new TestException("Unexpected query invocation target exception", e);
                }
                catch (QueryExecutionLowMemoryException e) {
                    ++numOperationsCanceled;
                    becameCritical = true;
                    if (allowCritical) {
                        long timeMS = System.currentTimeMillis();
                        ResourceManBB.getBB().getSharedCounters().setIfSmaller(ResourceManBB.firstLowMemoryExceptionTime, new Long(timeMS));
                        long value = this.lowMemCounter.incrementAndGet();
                        if (value == 1L) {
                            Log.getLogWriter().info("The first LowMemoryException for this vm has occurred at ms:" + timeMS);
                        }
                    }
                    throw e;
                }
            }
            if (System.currentTimeMillis() - lastLogTime > 10000L) {
                StringBuffer logStr = new StringBuffer();
                Log.getLogWriter().info("has canceled" + numOperationsCanceled + " operations out of " + totalQueries + " queries and " + totalIndexCreatesAttempted + " attempted index creations");
                lastLogTime = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - lastGcTime <= 30000L) continue;
            System.gc();
            Log.getLogWriter().info("gc... hopefully clean up some query garbage");
            lastGcTime = System.currentTimeMillis();
        } while (System.currentTimeMillis() - startTime < millisToRun);
        Log.getLogWriter().info("Done running query ops for " + millisToRun + " ms.  Low memory canceled " + numOperationsCanceled + " operations out of " + totalQueries + " queries and " + totalIndexCreatesAttempted + " attempted index creations");
        return becameCritical;
    }
}

