/*
 * Decompiled with CFR 0.152.
 */
package resultsUtil;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import resultsUtil.FileLineReader;
import util.TestHelper;

public class BugReportTemplate {
    private static final long MAX_MS_TO_RUN = 300000L;
    static final String templateFileName = "bugReportTemplate.txt";
    private List<String> bgExecFileList = new ArrayList<String>();
    private List<String> vmLogFileList = new ArrayList<String>();
    private String taskMasterLogFileName = null;
    private String errorsDotTextFileName = null;
    private List<String> hprofFileList = new ArrayList<String>();
    private List<String> hotspotFileList = new ArrayList<String>();
    private String masterLogFileName = null;
    private String testPropFileName = null;
    private String latestPropFileName = null;
    private String localConfFileName = null;
    private StringBuffer templateStr = new StringBuffer();
    private String hydraRunDirPath = null;
    private boolean writeToStdOut = false;

    public static void createTemplateFile(String dirPath, boolean toStdOut) {
        try {
            BugReportTemplate brt = new BugReportTemplate();
            brt.hydraRunDirPath = dirPath;
            brt.writeToStdOut = toStdOut;
            brt._createTemplateFile();
        }
        catch (Exception e) {
            System.out.println("Bug report template generation failed due to " + TestHelper.getStackTrace(e));
        }
    }

    protected void _createTemplateFile() throws InterruptedException {
        Thread createTemplateThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    BugReportTemplate.this.buildTemplateFileText();
                }
                catch (Exception e) {
                    System.out.println("Bug report template generation failed due to " + TestHelper.getStackTrace(e));
                }
            }
        });
        createTemplateThread.start();
        createTemplateThread.join(300000L);
        if (createTemplateThread.getState() != Thread.State.TERMINATED) {
            createTemplateThread.interrupt();
            this.templateStr.insert(0, "****************************************************************\n   Run analysis exceeded time limit of 300000 ms\n   and is incomplete (might be due to large log files)\n****************************************************************\n\n");
        }
        this.writeTemplateFile();
    }

    protected void buildTemplateFileText() {
        this.categorizeFiles();
        this.templateStr.append(this.getHeaderInfo());
        String batteryTestName = this.getBatteryTestName();
        if (batteryTestName != null) {
            this.templateStr.append("\n\nTest was run from " + batteryTestName + "\n");
        }
        this.templateStr.append("\nTest:\n" + this.getTestSpecification());
        try {
            FileLineReader reader = new FileLineReader(this.localConfFileName);
            this.templateStr.append("\n\nRun with local.conf:");
            String line = reader.readNextLine();
            while (line != null) {
                this.templateStr.append("\n" + line);
                line = reader.readNextLine();
            }
        }
        catch (FileNotFoundException e) {
            this.templateStr.append("\n\nNo local.conf for this run");
        }
        String randomSeed = this.getRandomSeed();
        if (randomSeed == null) {
            this.templateStr.append("\n\nUnable to find randomSeed\n");
        } else {
            this.templateStr.append("\n\n//randomSeed extracted from test:\n");
            this.templateStr.append(this.getRandomSeed());
        }
        this.templateStr.append("\n\n" + this.doErrorAnalysis() + "\n");
    }

    private String getTestSpecification() {
        StringBuffer returnStr = new StringBuffer();
        String prefix = null;
        String fileName = null;
        boolean isMultiLineTestSpec = false;
        if (this.testPropFileName == null) {
            if (this.latestPropFileName == null) {
                returnStr.append("  Unable to determine test that was run\n");
            } else {
                fileName = this.latestPropFileName;
                prefix = "TestName=";
                isMultiLineTestSpec = false;
            }
        } else {
            fileName = this.testPropFileName;
            prefix = "testName=";
            isMultiLineTestSpec = true;
        }
        try {
            FileLineReader reader = new FileLineReader(fileName);
            String line = reader.readNextLine();
            if (line != null && line.startsWith(prefix)) {
                returnStr.append(line.substring(prefix.length(), line.length()));
            }
            if (isMultiLineTestSpec) {
                line = reader.readNextLine();
                while (line != null) {
                    returnStr.append("\n   " + line);
                    line = reader.readNextLine();
                }
            }
        }
        catch (FileNotFoundException e) {
            returnStr.append("  Unable to determine test that was run\n");
        }
        return returnStr.toString();
    }

    private String getBatteryTestName() {
        File runDir = new File(this.hydraRunDirPath);
        String parent = runDir.getParent();
        if (parent != null) {
            File parentDir = new File(parent);
            String batteryTestLogFileName = "batterytest.log";
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equals("batterytest.log");
                }
            };
            File[] logFiles = parentDir.listFiles(filter);
            if (logFiles.length > 0) {
                for (File aFile : logFiles) {
                    FileLineReader reader;
                    try {
                        reader = new FileLineReader(aFile);
                    }
                    catch (FileNotFoundException e) {
                        return null;
                    }
                    String line = reader.readNextLine();
                    while (line != null) {
                        String searchStr = "  testFileName = ";
                        if (line.startsWith(searchStr)) {
                            return line.substring(searchStr.length());
                        }
                        line = reader.readNextLine();
                    }
                }
            }
        }
        return null;
    }

    private String getRandomSeed() {
        FileLineReader reader;
        try {
            reader = new FileLineReader(this.latestPropFileName);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        String searchStr = "hydra.Prms-randomSeed=";
        String line = reader.readNextLine();
        while (line != null) {
            if (line.startsWith(searchStr)) {
                return line + ";";
            }
            line = reader.readNextLine();
        }
        return null;
    }

    private String getHeaderInfo() {
        FileLineReader reader;
        if (this.masterLogFileName == null) {
            return "";
        }
        StringBuffer returnStr = new StringBuffer();
        String searchStr = "####################################################";
        int searchStrFoundCntr = 0;
        try {
            reader = new FileLineReader(this.masterLogFileName);
        }
        catch (FileNotFoundException e) {
            return "";
        }
        String line = reader.readNextLine();
        while (line != null) {
            returnStr.append(this.extractLine("Host name:", line));
            returnStr.append(this.extractLine("OS name:", line));
            returnStr.append(this.extractLine("Architecture:", line));
            returnStr.append(this.extractLine("OS version:", line));
            returnStr.append(this.extractLine("Java version:", line));
            returnStr.append(this.extractLine("Java vm name:", line));
            returnStr.append(this.extractLine("Java vendor:", line));
            returnStr.append(this.extractLine("Java home:", line));
            int index = line.indexOf(searchStr);
            if (index > 0 && ++searchStrFoundCntr == 2) {
                returnStr.append("\n" + line + "\n");
                line = reader.readNextLine();
                while (line != null) {
                    returnStr.append(line + "\n");
                    if (line.indexOf(searchStr) >= 0) {
                        return returnStr.toString();
                    }
                    line = reader.readNextLine();
                }
            }
            line = reader.readNextLine();
        }
        return returnStr.toString();
    }

    private Object extractLine(String searchStr, String baseStr) {
        int index = baseStr.indexOf(searchStr);
        if (index >= 0) {
            int index2 = baseStr.indexOf("\n", index);
            if (index2 >= 0) {
                return baseStr.substring(index, index2 + 1) + "\n";
            }
            return baseStr.substring(index, baseStr.length()) + "\n";
        }
        return "";
    }

    private void writeTemplateFile() {
        if (this.writeToStdOut) {
            System.out.println(this.templateStr);
        } else {
            try {
                String resultsFileName = this.hydraRunDirPath + File.separator + templateFileName;
                PrintWriter aFile = new PrintWriter(new FileOutputStream(new File(resultsFileName)));
                aFile.print(this.templateStr.toString());
                aFile.flush();
                aFile.close();
            }
            catch (FileNotFoundException e) {
                System.out.println("Unable to create bugReportTemplate.txt due to " + e.toString());
            }
        }
    }

    protected void categorizeFiles() {
        File hydraRunDir = new File(this.hydraRunDirPath);
        String[] dirContents = hydraRunDir.list();
        String parent = hydraRunDir.getAbsolutePath() + File.separator;
        for (String fileName : dirContents) {
            String prefix;
            if (fileName.endsWith(".log")) {
                if (fileName.startsWith("bgexec")) {
                    this.bgExecFileList.add(parent + fileName);
                    continue;
                }
                if (fileName.startsWith("vm_")) {
                    this.vmLogFileList.add(parent + fileName);
                    continue;
                }
                if (fileName.startsWith("taskmaster")) {
                    this.taskMasterLogFileName = parent + fileName;
                    continue;
                }
                if (fileName.startsWith("hs_")) {
                    this.hotspotFileList.add(parent + fileName);
                    continue;
                }
                if (!fileName.startsWith("Master")) continue;
                this.masterLogFileName = parent + fileName;
                continue;
            }
            if (fileName.endsWith(".hprof")) {
                this.hprofFileList.add(parent + fileName);
                continue;
            }
            if (!fileName.endsWith(".prop") || this.hydraRunDirPath.indexOf(prefix = fileName.substring(0, fileName.indexOf(".prop"))) < 0) continue;
            this.testPropFileName = parent + fileName;
        }
        this.errorsDotTextFileName = parent + "errors.txt";
        this.latestPropFileName = parent + "latest.prop";
        this.localConfFileName = parent + "local.conf";
    }

    private String doErrorAnalysis() {
        FileLineReader reader = null;
        try {
            reader = new FileLineReader(this.errorsDotTextFileName);
        }
        catch (FileNotFoundException e) {
            return "No errors reported in this run";
        }
        StringBuffer errorAnalysisStr = new StringBuffer();
        String firstErrStr = BugReportTemplate.getFirstError(reader);
        errorAnalysisStr.append("*** Test failed with this error:\n" + firstErrStr);
        this.reportProblemFiles(errorAnalysisStr);
        if (firstErrStr != null && firstErrStr.indexOf("\nHANG") >= 0) {
            String hangAnalysisStr = this.doHangAnalysis(firstErrStr);
            errorAnalysisStr.append(hangAnalysisStr);
        } else {
            HashSet<String> deadlockSet = new HashSet<String>();
            for (String fileName : this.bgExecFileList) {
                BugReportTemplate.searchBgExecFile(null, fileName, null, deadlockSet);
            }
            BugReportTemplate.reportJavaLevelDeadlocks(deadlockSet, errorAnalysisStr);
        }
        return errorAnalysisStr.toString();
    }

    private void reportProblemFiles(StringBuffer reportStr) {
        block3: {
            block2: {
                if (this.hotspotFileList.size() <= 0) break block2;
                reportStr.append("\nFound the following files:\n");
                for (String fileName : this.hotspotFileList) {
                    reportStr.append("   " + fileName + "\n");
                }
                break block3;
            }
            if (this.hprofFileList.size() <= 0) break block3;
            reportStr.append("\nFound the following files:\n");
            for (String fileName : this.hprofFileList) {
                reportStr.append("   " + fileName + "\n");
            }
        }
    }

    private String doHangAnalysis(String errStr) {
        String MCTaskLoopHangStr = "HANG MasterController.doTaskLoop -- treating as hang";
        if (errStr.indexOf("HANG MasterController.doTaskLoop -- treating as hang") >= 0) {
            return "";
        }
        String failedToStopStr = "hydra.HydraTimeoutException: Failed to stop client vms within";
        if (errStr.indexOf("hydra.HydraTimeoutException: Failed to stop client vms within") >= 0) {
            // empty if block
        }
        String normalHangStr = "HANG a client exceeded max result wait sec";
        if (errStr.indexOf("HANG a client exceeded max result wait sec") >= 0) {
            Date loggingDate;
            String clientIDStr = BugReportTemplate.getClientIdentifierStr(errStr);
            if (clientIDStr == null) {
                return "";
            }
            String hangLoggingStr = this.getHangLoggingStr();
            if (hangLoggingStr == null) {
                return "";
            }
            Date hangDateTime = this.getDateFromLoggingLine(hangLoggingStr);
            if (hangDateTime == null) {
                return "";
            }
            String[] anArr = this.getClientLoggingSurroundingHang(clientIDStr, hangDateTime);
            String lastLineBeforeHang = anArr[0];
            String firstLoggingAfterHang = anArr[1];
            String taskResultLogging = anArr[2];
            String hangAnalysisStr = this.getStackAnalysis(clientIDStr);
            if (lastLineBeforeHang == null) {
                return "";
            }
            if (hangAnalysisStr == null) {
                return "";
            }
            Date lastLoggingDate = this.getDateFromLoggingLine(lastLineBeforeHang);
            if (lastLoggingDate == null) {
                return "";
            }
            String waitForRepliesLogging = this.getWaitForRepliesLogging(lastLoggingDate, hangDateTime, clientIDStr);
            StringBuffer returnStr = new StringBuffer();
            returnStr.append("\n*** Last client logging by hung thread\n" + lastLineBeforeHang);
            if (waitForRepliesLogging != null) {
                returnStr.append("\n\n*** From system.log of hung thread\n" + waitForRepliesLogging);
            }
            long timeDiff = hangDateTime.getTime() - lastLoggingDate.getTime();
            returnStr.append("\n\n*** Test declared hung " + timeDiff + " ms after last client logging\n" + hangLoggingStr);
            returnStr.append("\n\n" + hangAnalysisStr);
            if (firstLoggingAfterHang != null && (loggingDate = this.getDateFromLoggingLine(firstLoggingAfterHang)) != null) {
                timeDiff = loggingDate.getTime() - hangDateTime.getTime();
                returnStr.append("\n\n*** Hung thread logged " + timeDiff + " ms after hang declared\n" + firstLoggingAfterHang);
            }
            if (taskResultLogging != null && (loggingDate = this.getDateFromLoggingLine(taskResultLogging)) != null) {
                timeDiff = loggingDate.getTime() - hangDateTime.getTime();
                returnStr.append("\n\n*** Task result for hung thread logged " + timeDiff + " ms after hang declared\n" + taskResultLogging);
            }
            return returnStr.toString();
        }
        return "";
    }

    private String getWaitForRepliesLogging(Date lastLoggingDate, Date hangDateTime, String clientIDStr) {
        String[] contents;
        String pid = BugReportTemplate.getPidStr(clientIDStr);
        File hydraDir = new File(this.hydraRunDirPath);
        for (String fileName : contents = hydraDir.list()) {
            String[] systemDirContents;
            if (!fileName.endsWith("_" + pid)) continue;
            File systemDir = new File(this.hydraRunDirPath + File.separator + fileName);
            for (String systemLogFileName : systemDirContents = systemDir.list()) {
                FileLineReader reader;
                if (!systemLogFileName.startsWith("system") || !systemLogFileName.endsWith(".log")) continue;
                StringBuffer returnStr = new StringBuffer();
                try {
                    reader = new FileLineReader(this.hydraRunDirPath + File.separator + fileName + File.separator + systemLogFileName);
                }
                catch (FileNotFoundException e) {
                    return null;
                }
                String line = reader.readNextLine();
                while (line != null) {
                    Date thisLoggingDate;
                    if (line.indexOf(clientIDStr) >= 0 && (line.indexOf("wait for replies completed") >= 0 || line.indexOf("waiting for replies") >= 0) && (thisLoggingDate = this.getDateFromLoggingLine(line)).after(lastLoggingDate) && thisLoggingDate.before(hangDateTime)) {
                        if (returnStr.length() > 0) {
                            returnStr.append("\n\n");
                        }
                        returnStr.append(line);
                    }
                    line = reader.readNextLine();
                }
                if (returnStr.length() > 0) {
                    return returnStr.toString();
                }
                return null;
            }
        }
        return null;
    }

    private String[] getClientLoggingSurroundingHang(String clientIDStr, Date hangDateTime) {
        if (hangDateTime != null) {
            String loggingTargetStr = "<" + clientIDStr + ">";
            String searchStr = "thr_";
            int index = clientIDStr.indexOf(searchStr);
            if (index <= 0) {
                return null;
            }
            int index2 = clientIDStr.indexOf("_", index + searchStr.length());
            String targetLogFileSubstr = clientIDStr.substring(0, index) + clientIDStr.substring(index2 + 1, clientIDStr.length());
            for (String fileName : this.vmLogFileList) {
                FileLineReader reader;
                if (fileName.indexOf(targetLogFileSubstr) < 0) continue;
                try {
                    reader = new FileLineReader(fileName);
                }
                catch (FileNotFoundException e) {
                    return null;
                }
                String line = reader.readNextLine();
                Date dateTimeOfLastLineBeforeHang = null;
                String lastLineBeforeHang = null;
                String firstLineAfterHang = null;
                while (line != null) {
                    Date logLineDateTime;
                    if (line.indexOf(loggingTargetStr) >= 0 && (logLineDateTime = this.getDateFromLoggingLine(line)) != null) {
                        if (logLineDateTime.before(hangDateTime)) {
                            if (dateTimeOfLastLineBeforeHang == null || logLineDateTime.after(dateTimeOfLastLineBeforeHang) || logLineDateTime.equals(dateTimeOfLastLineBeforeHang)) {
                                dateTimeOfLastLineBeforeHang = logLineDateTime;
                                lastLineBeforeHang = line;
                            }
                        } else {
                            if (line.indexOf("Task result:") >= 0) {
                                return new String[]{lastLineBeforeHang, firstLineAfterHang, line};
                            }
                            if (firstLineAfterHang == null) {
                                firstLineAfterHang = line;
                            }
                        }
                    }
                    line = reader.readNextLine();
                }
                return new String[]{lastLineBeforeHang, firstLineAfterHang, null};
            }
        }
        return null;
    }

    private String getHangLoggingStr() {
        try {
            FileLineReader reader = new FileLineReader(this.taskMasterLogFileName);
            String line = reader.readNextLine();
            while (line != null) {
                if (line.indexOf("HANG") >= 0) {
                    return line;
                }
                line = reader.readNextLine();
            }
        }
        catch (FileNotFoundException e) {
            return null;
        }
        return null;
    }

    private Date getDateFromLoggingLine(String loggingLine) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd kk:mm:ss.SSS");
        String dateRegex = ".*(\\d\\d\\d\\d)/(\\d\\d)/(\\d\\d) (\\d\\d):(\\d\\d):(\\d\\d).(\\d\\d\\d).*";
        if (loggingLine.matches(dateRegex)) {
            int index = loggingLine.indexOf(" ") + 1;
            return dateFormat.parse(loggingLine, new ParsePosition(index));
        }
        return null;
    }

    private String getStackAnalysis(String clientIDStr) {
        ArrayList<String> stackList = new ArrayList<String>();
        HashSet<String> deadlockSet = new HashSet<String>();
        for (String fileName : this.bgExecFileList) {
            BugReportTemplate.searchBgExecFile(clientIDStr, fileName, stackList, deadlockSet);
        }
        StringBuffer stackAnalysisStr = new StringBuffer();
        if (stackList.size() == 0) {
            stackAnalysisStr.append("Stacks not found for " + clientIDStr + "\n");
        } else {
            ArrayList<Integer> changingStacks = new ArrayList<Integer>();
            int numDifferentStacks = 0;
            for (int i = 1; i < stackList.size(); ++i) {
                boolean isEqual = ((String)stackList.get(i - 1)).equals(stackList.get(i));
                if (isEqual) continue;
                ++numDifferentStacks;
                changingStacks.add(i);
            }
            stackAnalysisStr.append("*** Hung thread\n" + (String)stackList.get(0) + "\n");
            if (numDifferentStacks == 0) {
                stackAnalysisStr.append("Stack for hung thread " + clientIDStr + " was found " + stackList.size() + " times and was unchanging.");
            } else {
                Iterator i$ = changingStacks.iterator();
                while (i$.hasNext()) {
                    int stackListIndex = (Integer)i$.next();
                    stackAnalysisStr.append("*** Stack changed\n" + (String)stackList.get(stackListIndex) + "\n");
                }
                stackAnalysisStr.append("Stack for hung thread " + clientIDStr + " was found " + stackList.size() + " times and changed " + numDifferentStacks + " times.");
            }
        }
        BugReportTemplate.reportJavaLevelDeadlocks(deadlockSet, stackAnalysisStr);
        return stackAnalysisStr.toString();
    }

    private static void reportJavaLevelDeadlocks(Set<String> deadlockSet, StringBuffer reportStr) {
        if (deadlockSet.size() == 0) {
            return;
        }
        for (String deadlockStr : deadlockSet) {
            reportStr.append("\n\n" + deadlockStr);
        }
    }

    private static String getPidStr(String clientIDStr) {
        String regEx;
        int index = clientIDStr.lastIndexOf("_");
        String pidStr = clientIDStr.substring(index + 1, clientIDStr.length());
        if (pidStr.matches(regEx = "(\\d)+")) {
            return pidStr;
        }
        return null;
    }

    private static void searchBgExecFile(String clientIDStr, String bgExecFileName, List<String> stackList, Set<String> deadlockSet) {
        try {
            String stackIDStr = null;
            if (clientIDStr != null) {
                stackIDStr = "\"" + clientIDStr + "\"";
            }
            FileLineReader reader = new FileLineReader(bgExecFileName);
            String line = reader.readNextLine();
            StringBuffer stackStr = new StringBuffer();
            StringBuffer deadlockStr = new StringBuffer();
            boolean inStack = false;
            boolean inDeadlock = false;
            while (line != null) {
                if (inDeadlock) {
                    deadlockStr.append(line + "\n");
                    if (line.startsWith("Found ") && line.indexOf("deadlock") > 0) {
                        inDeadlock = false;
                        deadlockSet.add(deadlockStr.toString());
                        deadlockStr = new StringBuffer();
                    }
                } else if (inStack) {
                    if (line.length() == 0) {
                        inStack = false;
                        stackList.add(stackStr.toString());
                        stackStr = new StringBuffer();
                    } else {
                        stackStr.append(line + "\n");
                    }
                } else if (stackIDStr != null && line.indexOf(stackIDStr) >= 0) {
                    stackStr.append(line + "\n");
                    inStack = true;
                } else if (line.indexOf("Java-level deadlock") >= 0) {
                    inDeadlock = true;
                    deadlockStr.append("*** From " + bgExecFileName + "\n");
                    deadlockStr.append(line + "\n");
                }
                line = reader.readNextLine();
            }
        }
        catch (FileNotFoundException e) {
            return;
        }
    }

    private static String getClientIdentifierStr(String errStr) {
        String searchStr = "CLIENT ";
        int index = errStr.indexOf(searchStr);
        if (index >= 0) {
            int firstIndex;
            int lastIndex;
            for (lastIndex = firstIndex = index + searchStr.length(); lastIndex < errStr.length() && Character.isWhitespace(errStr.charAt(lastIndex)); ++lastIndex) {
            }
            while (lastIndex < errStr.length() && !Character.isWhitespace(errStr.charAt(lastIndex))) {
                ++lastIndex;
            }
            String clientIdentifierStr = errStr.substring(firstIndex, lastIndex);
            return clientIdentifierStr;
        }
        return null;
    }

    private static String getFirstError(FileLineReader reader) {
        StringBuffer firstErrStr = new StringBuffer();
        String line = reader.readNextLine();
        while (line != null) {
            if (BugReportTemplate.isErrorDelimiter(line)) {
                return firstErrStr.toString();
            }
            firstErrStr.append(line + "\n");
            line = reader.readNextLine();
        }
        return firstErrStr.toString();
    }

    private static boolean isErrorDelimiter(String line) {
        if (line.length() == 0) {
            return false;
        }
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) == '-') continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        String runDirName;
        if (args.length != 0) {
            System.out.println("Usage: java BugReportTemplate\n       -DhydraRunDir=<dir path>\n         Directory of a hydra run. This is optional. If not \n         specified then the current directory is used.\n       -DwriteToStdOut=<true|false>\n         If true, then write the bug report template to standard\n         out, if false then write to a file named bugReportTemplate.txt\n         in the hydra run directory. Defaults to false\n");
            System.exit(0);
        }
        if ((runDirName = System.getProperty("hydraRunDir")) == null) {
            runDirName = System.getProperty("user.dir");
        }
        boolean writeToStdOut = Boolean.valueOf(System.getProperty("writeToStdOut"));
        BugReportTemplate.createTemplateFile(runDirName, writeToStdOut);
    }
}

