/*
 * Decompiled with CFR 0.152.
 */
package resultsUtil;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import resultsUtil.FileLineReader;
import resultsUtil.RegressionSummary;

public class MasterLogInfo {
    private static MasterLogInfo info = new MasterLogInfo();
    public static Set RevisionSet = new HashSet();
    public static Set JavaHomeSet = new HashSet();
    public static Set JavaVersionSet = new HashSet();
    public static Set JavaVendorSet = new HashSet();
    public static Set BuildIdSet = new HashSet();
    public static Set ProductVersionSet = new HashSet();
    public static Set ArchitectureSet = new HashSet();
    public static Set SourceRepositorySet = new HashSet();

    public static void saveMasterLogInfo(String dirPath) {
        info._saveMasterLogInfo(dirPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _saveMasterLogInfo(String dirPath) {
        File masterLogFile = RegressionSummary.getFileInDir(dirPath, "Master(.*).log");
        if (masterLogFile == null) {
            return;
        }
        try (FileLineReader flr = null;){
            flr = new FileLineReader(masterLogFile);
            String line = flr.readNextLine();
            while (line != null) {
                if (line.indexOf("Source Revision:") >= 0) {
                    String revNum = line.substring(line.indexOf(":") + 1, line.length());
                    revNum = revNum.trim();
                    RevisionSet.add(revNum);
                } else if (line.indexOf("Java version:") >= 0) {
                    String javaVersion = line.substring(line.indexOf(":") + 1, line.length());
                    javaVersion = javaVersion.trim();
                    JavaVersionSet.add(javaVersion);
                } else if (line.indexOf("Java home:") >= 0) {
                    String javaHome = line.substring(line.indexOf(":") + 1, line.length());
                    javaHome = javaHome.trim();
                    JavaHomeSet.add(javaHome);
                } else if (line.indexOf("Java vendor:") >= 0) {
                    String javaVendor = line.substring(line.indexOf(":") + 1, line.length());
                    javaVendor = javaVendor.trim();
                    JavaVendorSet.add(javaVendor);
                } else if (line.indexOf("Build Id:") >= 0) {
                    String buildId = line.substring(line.indexOf(":") + 1, line.length());
                    buildId = buildId.trim();
                    BuildIdSet.add(buildId);
                } else if (line.indexOf("Architecture:") >= 0) {
                    String archit = line.substring(line.indexOf(":") + 1, line.length());
                    archit = archit.trim();
                    ArchitectureSet.add(archit);
                } else if (line.indexOf("Source Repository:") >= 0) {
                    String source = line.substring(line.indexOf(":") + 1, line.length());
                    source = source.trim();
                    SourceRepositorySet.add(source);
                } else {
                    String aStr = "Product Version:";
                    int index = line.indexOf(aStr);
                    if (index >= 0) {
                        String versionStr = line.substring(index + aStr.length(), line.length());
                        versionStr = versionStr.trim();
                        ProductVersionSet.add(versionStr);
                    }
                }
                line = flr.readNextLine();
            }
        }
    }
}

