/*
 * Decompiled with CFR 0.152.
 */
package resultsUtil;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import resultsUtil.BatteryTestLogInfo;
import resultsUtil.FileLineReader;
import resultsUtil.MasterLogInfo;

public class SummaryInfo {
    private String buildInfo = null;
    private String svnRevision = null;
    private String svnRepository = null;
    private String hostName = null;
    private String osInfo = null;
    private String javaHome = null;
    private String javaVersion = null;
    private String architecture = null;
    private String javaVendor = null;
    private String productVersion = null;
    private String elapsedTime = null;
    private float diskUsage = 0.0f;
    private String date = null;
    private List testResultList = new ArrayList();
    private static final String buildInfoLabel = "Build: ";
    private static final String svnRevisionLabel = "SVN revision: ";
    private static final String svnRepositoryLabel = "Source repository: ";
    private static final String hostNameLabel = "Host: ";
    private static final String osLabel = "OS: ";
    private static final String javaHomeLabel = "Java home: ";
    private static final String javaVersionLabel = "Java version: ";
    private static final String architectureLabel = "Architecture: ";
    private static final String javaVendorLabel = "Java vendor: ";
    private static final String productVersionLabel = "Product version: ";
    private static final String elapsedTimeLabel = "Elapsed time: ";
    private static final String diskUsageLabel = "Disk usage: ";

    public SummaryInfo(String filePath) throws Exception {
        this.importFromFile(filePath);
    }

    public SummaryInfo() {
    }

    public int getNumTests() {
        return this.testResultList.size();
    }

    public void addTest(String testSummary) {
        this.testResultList.add(testSummary);
    }

    public void addToDiskUsage(String diskUsageArg) throws Exception {
        if (!diskUsageArg.equalsIgnoreCase("unknown")) {
            char lastChar = diskUsageArg.charAt(diskUsageArg.length() - 1);
            float diskValue = 0.0f;
            String numberStr = diskUsageArg;
            if (!Character.isDigit(lastChar)) {
                numberStr = diskUsageArg.substring(0, diskUsageArg.length() - 1);
            }
            try {
                diskValue = Float.valueOf(numberStr).floatValue();
            }
            catch (NumberFormatException e) {
                throw new Exception("Cannot convert " + numberStr + " to float");
            }
            if (lastChar == 'K') {
                diskValue *= 1024.0f;
            } else if (lastChar == 'M') {
                diskValue = diskValue * 1024.0f * 1024.0f;
            } else if (lastChar == 'G') {
                diskValue = diskValue * 1024.0f * 1024.0f * 1024.0f;
            }
            this.diskUsage += diskValue;
        }
    }

    public String toString() {
        StringBuffer aStr = this.getHeadingString();
        for (int i = 0; i < this.testResultList.size(); ++i) {
            aStr.append(this.testResultList.get(i) + "\n");
        }
        return aStr.toString();
    }

    public void updateAndCombine(BatteryTestLogInfo btInfo) {
        if (MasterLogInfo.BuildIdSet.size() == 0) {
            if (btInfo.getBuildNumber() != null) {
                this.buildInfo = this.combine(this.buildInfo, btInfo.getBuildNumber());
            }
        } else {
            this.buildInfo = this.combine(this.buildInfo, MasterLogInfo.BuildIdSet);
        }
        this.svnRevision = this.combine(this.svnRevision, MasterLogInfo.RevisionSet);
        this.svnRepository = this.combine(this.svnRepository, MasterLogInfo.SourceRepositorySet);
        this.hostName = this.combine(this.hostName, btInfo.getHostName());
        String osType = this.getOSType();
        if (osType.length() > 0) {
            osType = osType + " ";
        }
        this.osInfo = osType + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version");
        this.javaHome = this.combine(this.javaHome, MasterLogInfo.JavaHomeSet);
        this.javaVersion = this.combine(this.javaVersion, MasterLogInfo.JavaVersionSet);
        this.architecture = this.combine(this.architecture, MasterLogInfo.ArchitectureSet);
        this.javaVendor = this.combine(this.javaVendor, MasterLogInfo.JavaVendorSet);
        this.productVersion = this.combine(this.productVersion, MasterLogInfo.ProductVersionSet);
        this.productVersion = this.combine(this.productVersion, btInfo.getProductVersion());
        if (btInfo.getFirstDate() == null || btInfo.getLastDate() == null) {
            this.elapsedTime = "Elapsed time not available";
        } else {
            String elapsedStr;
            long elapsed = btInfo.getLastDate().getTime() - btInfo.getFirstDate().getTime();
            long millis = elapsed % 1000L;
            long hours = (elapsed /= 1000L) / 3600L;
            long minutes = (elapsed -= hours * 3600L) / 60L;
            long seconds = elapsed - minutes * 60L;
            this.elapsedTime = elapsedStr = this.expandNum(hours, 2) + ":" + this.expandNum(minutes, 2) + ":" + this.expandNum(seconds, 2) + "." + this.expandNum(millis, 3);
        }
        if (btInfo.getFirstDate() != null) {
            SimpleDateFormat format = new SimpleDateFormat("MMM dd yyyy");
            this.date = format.format(btInfo.getFirstDate());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importFromFile(String filePath) throws Exception {
        File aFile = new File(filePath);
        try (FileLineReader flr = null;){
            flr = new FileLineReader(filePath);
            String line = flr.readNextLine();
            this.buildInfo = this.getStringDelimitedBy(line, buildInfoLabel, null);
            line = flr.readNextLine();
            this.svnRevision = this.getStringDelimitedBy(line, svnRevisionLabel, ", ");
            this.svnRepository = this.getStringDelimitedBy(line, svnRepositoryLabel, null);
            line = flr.readNextLine();
            this.hostName = this.getStringDelimitedBy(line, hostNameLabel, ", ");
            this.architecture = this.getStringDelimitedBy(line, architectureLabel, null);
            line = flr.readNextLine();
            this.osInfo = this.getStringDelimitedBy(line, osLabel, null);
            line = flr.readNextLine();
            this.javaVersion = this.getStringDelimitedBy(line, javaVersionLabel, ",");
            this.javaHome = this.getStringDelimitedBy(line, javaHomeLabel, ",");
            line = flr.readNextLine();
            this.javaVendor = this.getStringDelimitedBy(line, javaVendorLabel, null);
            line = flr.readNextLine();
            this.productVersion = this.getStringDelimitedBy(line, productVersionLabel, null);
            line = flr.readNextLine();
            this.elapsedTime = this.getStringDelimitedBy(line, elapsedTimeLabel, null);
            line = flr.readNextLine();
            String diskStr = this.getStringDelimitedBy(line, diskUsageLabel, null);
            this.addToDiskUsage(diskStr);
            this.date = flr.readNextLine();
            line = flr.readNextLine();
            while (line != null) {
                this.testResultList.add(line);
                line = flr.readNextLine();
            }
        }
    }

    protected String getStringDelimitedBy(String aStr, String prefixDelim, String suffixDelim) {
        int prefixIndex = aStr.indexOf(prefixDelim);
        if (prefixIndex >= 0) {
            if (suffixDelim == null) {
                return aStr.substring(prefixIndex + prefixDelim.length(), aStr.length());
            }
            int suffixIndex = aStr.indexOf(suffixDelim, prefixIndex);
            if (suffixIndex >= 0) {
                return aStr.substring(prefixIndex + prefixDelim.length(), suffixIndex);
            }
            return null;
        }
        return null;
    }

    protected StringBuffer getHeadingString() {
        StringBuffer headingStr = new StringBuffer();
        headingStr.append(this.formatHeaderLine(buildInfoLabel, this.buildInfo) + "\n");
        headingStr.append(this.formatHeaderLine(svnRevisionLabel, this.svnRevision) + ", " + this.formatHeaderLine(svnRepositoryLabel, this.svnRepository) + "\n");
        headingStr.append(this.formatHeaderLine(hostNameLabel, this.hostName) + ", " + this.formatHeaderLine(architectureLabel, this.architecture) + "\n");
        headingStr.append(this.formatHeaderLine(osLabel, this.osInfo) + "\n");
        headingStr.append(this.formatHeaderLine(javaVersionLabel, this.javaVersion) + ", " + this.formatHeaderLine(javaHomeLabel, this.javaHome) + "\n");
        headingStr.append(this.formatHeaderLine(javaVendorLabel, this.javaVendor) + "\n");
        headingStr.append(this.formatHeaderLine(productVersionLabel, this.productVersion) + "\n");
        headingStr.append(this.formatHeaderLine(elapsedTimeLabel, this.elapsedTime) + "\n");
        headingStr.append(this.formatHeaderLine(diskUsageLabel, SummaryInfo.getReadableBytes(this.diskUsage) + "\n"));
        if (this.date == null) {
            headingStr.append("Date unknown\n");
        } else {
            headingStr.append(this.date + "\n");
        }
        return headingStr;
    }

    private String formatHeaderLine(String label, String info) {
        if (info == null) {
            return label + "unknown";
        }
        return label + info;
    }

    protected String combine(String existingInfo, String newInfo) {
        if (existingInfo == null) {
            return newInfo;
        }
        if (existingInfo.indexOf(newInfo) < 0) {
            return existingInfo + " " + newInfo;
        }
        return existingInfo;
    }

    protected String combine(String existingInfo, Set newInfo) {
        String returnInfo = existingInfo;
        for (String element : newInfo) {
            if (returnInfo == null) {
                returnInfo = element;
                continue;
            }
            if (returnInfo.indexOf(element) >= 0) continue;
            returnInfo = returnInfo + " " + element;
        }
        return returnInfo;
    }

    private String expandNum(long aNum, int numDigits) {
        String aStr = "" + aNum;
        while (aStr.length() < numDigits) {
            aStr = "0" + aStr;
        }
        return aStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOSType() {
        File aFile = new File("/etc/motd");
        try (FileLineReader flr = null;){
            flr = new FileLineReader(aFile);
            String line = flr.readNextLine();
            while (line != null) {
                if (line.indexOf("Red Hat") >= 0) {
                    String string = "RedHat";
                    return string;
                }
                if (line.indexOf("SLES") >= 0) {
                    String string = "SLES";
                    return string;
                }
                if (line.indexOf("SUSE") >= 0) {
                    String string = "SUSE";
                    return string;
                }
                if (line.indexOf("SunOS") >= 0) {
                    int index = line.indexOf("SunOS") + "SunOS".length();
                    while (Character.isWhitespace(line.charAt(index))) {
                        ++index;
                    }
                    StringBuffer osNum = new StringBuffer();
                    while (!Character.isWhitespace(line.charAt(index))) {
                        osNum.append(line.charAt(index));
                        ++index;
                    }
                    String string = "SunOS-" + osNum;
                    return string;
                }
                line = flr.readNextLine();
            }
            String string = "";
            return string;
        }
    }

    protected static String getReadableBytes(float numBytes) {
        float M = 1048576.0f;
        float G = 1.0737418E9f;
        if (numBytes > 1.0737418E9f) {
            float readable = numBytes / 1.0737418E9f;
            return "" + (double)Math.round((double)readable * 10.0) / 10.0 + "G";
        }
        if (numBytes > 1048576.0f) {
            float readable = numBytes / 1048576.0f;
            return "" + (double)Math.round((double)readable * 10.0) / 10.0 + "M";
        }
        if (numBytes <= 0.0f) {
            return "unknown";
        }
        return "" + numBytes + "B";
    }
}

