/*
 * Decompiled with CFR 0.152.
 */
package resumeTx;

import com.gemstone.gemfire.cache.CommitConflictException;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.cache.TransactionInDoubtException;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.distributed.DistributedMember;
import hydra.CacheHelper;
import hydra.Log;
import hydra.Prms;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import resumeTx.ResumeTxPrms;
import util.TestException;
import util.TestHelper;
import util.TxHelper;

public class CommitTx
implements Function,
Declarable {
    public void execute(FunctionContext context) {
        DistributedMember dm = CacheHelper.getCache().getDistributedSystem().getDistributedMember();
        boolean isHA = ResumeTxPrms.getHighAvailability();
        boolean isSerialExecution = TestConfig.tab().booleanAt(Prms.serialExecution);
        boolean committed = true;
        ArrayList argumentList = (ArrayList)context.getArguments();
        String forDM = (String)argumentList.get(0);
        TransactionId txId = (TransactionId)argumentList.get(1);
        Log.getLogWriter().info("executing " + this.getClass().getName() + " in member " + dm + ", invoked from " + forDM + " on txId " + txId);
        if (TxHelper.tryResume(txId, 10L, TimeUnit.SECONDS)) {
            Log.getLogWriter().fine("CommitTx RESUMED " + txId);
            try {
                TxHelper.commit();
            }
            catch (CommitConflictException e) {
                committed = false;
                if (isSerialExecution) {
                    throw e;
                }
                Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + " on commit.  Expected with concurrent execution, continuing test");
            }
            catch (TransactionDataRebalancedException e) {
                if (isHA) {
                    throw e;
                }
                throw new TestException("Unexpected Exception " + (Object)((Object)e) + " on commit of " + txId + ", " + TestHelper.getStackTrace(e));
            }
            catch (TransactionDataNodeHasDepartedException e) {
                if (isHA) {
                    throw e;
                }
                throw new TestException("Unexpected Exception " + (Object)((Object)e) + " on commit of " + txId + ", " + TestHelper.getStackTrace(e));
            }
            catch (TransactionInDoubtException e) {
                if (isHA) {
                    throw e;
                }
                throw new TestException("Unexpected Exception " + (Object)((Object)e) + " on commit of " + txId + ", " + TestHelper.getStackTrace(e));
            }
        } else {
            if (isSerialExecution) {
                throw new TestException(txId + " is not suspended in this member, cannot commit, " + TestHelper.getStackTrace());
            }
            Log.getLogWriter().fine(txId + " is not suspended in this member with tryResume time limit, cannot commit.  Expected with concurrent execution, continuing test.");
        }
        Log.getLogWriter().info("CommitTx returning " + committed + " for txId = " + txId);
        context.getResultSender().lastResult((Object)committed);
    }

    public String getId() {
        return this.getClass().getName();
    }

    public boolean hasResult() {
        return true;
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public void init(Properties props) {
    }

    public boolean isHA() {
        return false;
    }
}

