/*
 * Decompiled with CFR 0.152.
 */
package resumeTx;

import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.distributed.DistributedMember;
import hydra.CacheHelper;
import hydra.Log;
import hydra.Prms;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import resumeTx.ResumeTxBB;
import resumeTx.ResumeTxPrms;
import resumeTx.RtxUtil;
import tx.OpList;
import util.TestException;
import util.TestHelper;
import util.TxHelper;

public class ExecuteTx
implements Function,
Declarable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FunctionContext context) {
        DistributedMember dm = CacheHelper.getCache().getDistributedSystem().getDistributedMember();
        boolean isHA = ResumeTxPrms.getHighAvailability();
        boolean isSerialExecution = TestConfig.tab().booleanAt(Prms.serialExecution);
        ArrayList argumentList = (ArrayList)context.getArguments();
        String forDM = (String)argumentList.get(0);
        TransactionId txId = (TransactionId)argumentList.get(1);
        Log.getLogWriter().info("executing " + this.getClass().getName() + " in member " + dm + ", invoked from " + forDM + " on txId " + txId);
        OpList opList = null;
        boolean executedOps = false;
        if (TxHelper.tryResume(txId, 10L, TimeUnit.SECONDS)) {
            block19: {
                Log.getLogWriter().fine("ExecuteTx RESUMED " + txId);
                try {
                    opList = RtxUtil.doOperations();
                    executedOps = true;
                }
                catch (TransactionDataNodeHasDepartedException e) {
                    if (!isHA) {
                        throw new TestException("Unexpected Exception " + (Object)((Object)e) + " while executing tx ops on " + txId + ", " + TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + ".  Expected with HA, continuing test.");
                    Log.getLogWriter().info("Rolling back transaction.");
                    try {
                        TxHelper.rollback();
                        Log.getLogWriter().info("Done Rolling back Transaction");
                    }
                    catch (Exception te) {
                        Log.getLogWriter().info("Caught exception " + te + " on rollback() after catching TransactionDataNodeHasDeparted during tx ops.  Expected, continuing test.");
                    }
                }
                catch (TransactionDataRebalancedException e) {
                    if (!isHA) {
                        throw new TestException("Unexpected Exception " + (Object)((Object)e) + " while executing tx ops on " + txId + ", " + TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("Caught Exception " + (Object)((Object)e) + ".  Expected with HA, continuing test.");
                    Log.getLogWriter().info("Rolling back transaction.");
                    try {
                        TxHelper.rollback();
                        Log.getLogWriter().info("Done Rolling back Transaction");
                    }
                    catch (Exception te) {
                        Log.getLogWriter().info("Caught exception " + te + " on rollback() after catching Exception " + (Object)((Object)e) + " during tx ops.  Expected, continuing test.");
                    }
                }
                catch (TestException e) {
                    if (isHA) {
                        Log.getLogWriter().info("Caught Exception " + e + ".  Expected with HA, continuing test.");
                        break block19;
                    }
                    Log.getLogWriter().info("Unexpected Exception " + e + " caught while executing tx ops for " + txId + ", " + TestHelper.getStackTrace(e));
                    throw e;
                }
                finally {
                    TxHelper.suspend();
                }
            }
            if (isSerialExecution && executedOps) {
                ResumeTxBB.updateOpList(opList);
            }
        } else {
            Log.getLogWriter().fine(txId + " is not hosted in this VM, returning executedOps = " + executedOps);
        }
        Log.getLogWriter().info("ExecuteTx returning " + executedOps + " for txId = " + txId);
        context.getResultSender().lastResult((Object)new Boolean(executedOps));
    }

    public String getId() {
        return this.getClass().getName();
    }

    public boolean hasResult() {
        return true;
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public void init(Properties props) {
    }

    public boolean isHA() {
        return false;
    }
}

