/*
 * Decompiled with CFR 0.152.
 */
package resumeTx;

import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.distributed.DistributedMember;
import hydra.CacheHelper;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import resumeTx.ResumableKnownKeysTest;
import resumeTx.ResumeTxBB;
import resumeTx.RtxUtilVersionHelper;
import util.KeyIntervals;
import util.NameFactory;
import util.RandomValues;
import util.TestException;
import util.TestHelper;
import util.TxHelper;
import util.ValueHolder;

public class KnownKeysFcn
implements Function {
    static final int MAX_TXNS = 10;
    static final int OPS_PER_FCN = 10;
    static List<TransactionId> txIdList = null;
    static List<Integer> suspendCount = null;
    static List keysToDoList = null;
    static RandomValues rv = new RandomValues();

    public boolean hasResult() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FunctionContext context) {
        Log.getLogWriter().info("Executing KnownKeysFcn");
        List args = (List)context.getArguments();
        Log.getLogWriter().info("In KnownKeysFcn with args: " + args);
        String clientOrigin = (String)args.get(0);
        Log.getLogWriter().info("In KnownKeysFcn.execute, originated from " + clientOrigin);
        String command = (String)args.get(1);
        Log.getLogWriter().info("Executing KnownKeysFcn, command is " + command);
        if (command.equals("initialize")) {
            KnownKeysFcn.initialize();
            context.getResultSender().lastResult((Object)"initialize completed");
        } else if (command.equals("ops")) {
            TransactionId txId = (TransactionId)args.get(2);
            Log.getLogWriter().info("TxId is " + txId);
            CacheTransactionManager ctm = CacheHelper.getCache().getCacheTransactionManager();
            if (!ctm.exists(txId)) {
                throw new TestException("onTransaction chose vmId " + RemoteTestModule.getMyVmid() + " to execute function for " + txId + " but exists(" + txId + ") returned false");
            }
            boolean resumed = ctm.tryResume(txId, Integer.MAX_VALUE, TimeUnit.SECONDS);
            if (!resumed) {
                throw new TestException(txId + " did not resume");
            }
            Log.getLogWriter().info("Resumed " + txId);
            boolean opsCompleted = this.doOps(10);
            TxHelper.suspend();
            int index = txIdList.indexOf(txId);
            List<Integer> list = suspendCount;
            synchronized (list) {
                suspendCount.set(index, suspendCount.get(index) + 1);
            }
            HashMap<String, Constable> resultMap = new HashMap<String, Constable>();
            resultMap.put("suspendCount", suspendCount.get(index));
            resultMap.put("opsCompleted", Boolean.valueOf(opsCompleted));
            if (opsCompleted) {
                String key = "txListForVmId_" + RemoteTestModule.getMyVmid();
                ResumeTxBB.getBB().getSharedMap().remove(key);
            }
            Log.getLogWriter().info("Returning " + resultMap + " from KnownKeysFcn with origin " + clientOrigin);
            context.getResultSender().lastResult(resultMap);
        } else {
            throw new TestException("Unknown command: " + command);
        }
    }

    public String getId() {
        return "KnownKeysFcn";
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public boolean isHA() {
        return false;
    }

    protected static synchronized void initialize() {
        if (txIdList == null) {
            txIdList = Collections.synchronizedList(new ArrayList());
            keysToDoList = Collections.synchronizedList(new ArrayList());
            suspendCount = Collections.synchronizedList(new ArrayList());
            HashSet baseLocalKeys = null;
            String baseRegionName = null;
            HashSet localKeys = new HashSet();
            for (Region aRegion : CacheHelper.getCache().rootRegions()) {
                if (!aRegion.getAttributes().getDataPolicy().withPartitioning()) continue;
                Set primaryKeys = PartitionRegionHelper.getLocalPrimaryData((Region)aRegion).keySet();
                if (baseLocalKeys == null) {
                    baseLocalKeys = new HashSet();
                    baseLocalKeys.addAll(primaryKeys);
                    baseRegionName = aRegion.getFullPath();
                } else if (!baseLocalKeys.equals(primaryKeys)) {
                    HashSet missing = new HashSet(baseLocalKeys);
                    missing.removeAll(primaryKeys);
                    HashSet unexpected = new HashSet(primaryKeys);
                    unexpected.removeAll(baseLocalKeys);
                    throw new TestException("Local key set for " + aRegion.getFullPath() + " is not equal to key set of " + baseRegionName + "; keys missing in " + aRegion.getFullPath() + ": " + missing + ", keys unexpected: " + unexpected);
                }
                localKeys.addAll(primaryKeys);
            }
            keysToDoList.addAll(localKeys);
            int numKeyIntervalKeys = ResumableKnownKeysTest.testInstance.keyIntervals.getNumKeys();
            DistributedMember myDM = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
            Region aRegion = CacheHelper.getCache().getRegion("region1");
            for (int i = numKeyIntervalKeys + 1; i <= numKeyIntervalKeys + ResumableKnownKeysTest.testInstance.numNewKeys; ++i) {
                String key = NameFactory.getObjectNameForCounter(i);
                DistributedMember primaryDM = PartitionRegionHelper.getPrimaryMemberForKey((Region)aRegion, (Object)key);
                if (primaryDM == null || !primaryDM.equals(myDM)) continue;
                keysToDoList.add(key);
            }
            CacheTransactionManager ctm = CacheHelper.getCache().getCacheTransactionManager();
            for (int i = 1; i < 10; ++i) {
                TxHelper.begin();
                TransactionId txId = ctm.getTransactionId();
                txIdList.add(txId);
                TxHelper.suspend();
                suspendCount.add(new Integer(1));
            }
            String key = "txListForVmId_" + RemoteTestModule.getMyVmid();
            try {
                ResumeTxBB.getBB().getSharedMap().put(key, RtxUtilVersionHelper.convertTransactionIDListToByteArrayList(txIdList));
            }
            catch (Exception e) {
                throw new TestException("Exception occurred while writing transaction Id list to Blackboard" + e);
            }
        }
    }

    protected boolean resumeATransaction() {
        Log.getLogWriter().info("Looking for a txn to resume...");
        CacheTransactionManager ctm = CacheHelper.getCache().getCacheTransactionManager();
        int numFullAttempts = 10;
        for (int i = 1; i <= 10; ++i) {
            for (TransactionId txId : txIdList) {
                if (txId == null || !ctm.tryResume(txId)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doOps(int numOps) {
        KeyIntervals ki = ResumableKnownKeysTest.testInstance.keyIntervals;
        Log.getLogWriter().info("Doing " + numOps + " ops");
        block13: for (int i = 1; i <= numOps; ++i) {
            Object key = null;
            List list = keysToDoList;
            synchronized (list) {
                if (keysToDoList.size() <= 0) {
                    Log.getLogWriter().info("No ops remaining");
                    return true;
                }
                key = keysToDoList.remove(TestConfig.tab().getRandGen().nextInt(0, keysToDoList.size() - 1));
            }
            Log.getLogWriter().info("Obtained key " + key);
            int op = ki.opForKeyIndex(NameFactory.getCounterForName(key));
            switch (op) {
                case 1000: {
                    continue block13;
                }
                case 1001: {
                    for (Region aRegion : CacheHelper.getCache().rootRegions()) {
                        Log.getLogWriter().info("Operation: invalidating " + key + " in region " + aRegion.getFullPath());
                        aRegion.invalidate(key);
                    }
                    continue block13;
                }
                case 1002: {
                    for (Region aRegion : CacheHelper.getCache().rootRegions()) {
                        Log.getLogWriter().info("Operation: locally invalidating " + key + " in region " + aRegion.getFullPath());
                        aRegion.localInvalidate(key);
                    }
                    continue block13;
                }
                case 1003: {
                    for (Region aRegion : CacheHelper.getCache().rootRegions()) {
                        Log.getLogWriter().info("Operation: destroying " + key + " in region " + aRegion.getFullPath());
                        aRegion.destroy(key);
                    }
                    continue block13;
                }
                case 1004: {
                    for (Region aRegion : CacheHelper.getCache().rootRegions()) {
                        Log.getLogWriter().info("Operation: locally destroying " + key + " in region " + aRegion.getFullPath());
                        aRegion.localDestroy(key);
                    }
                    continue block13;
                }
                case 1005: {
                    ValueHolder newValue = new ValueHolder(key, rv);
                    newValue.myValue = "updated_" + NameFactory.getCounterForName(key);
                    for (Region aRegion : CacheHelper.getCache().rootRegions()) {
                        Log.getLogWriter().info("Operation: updating " + key + " to value " + TestHelper.toString(newValue) + " in region " + aRegion.getFullPath());
                        aRegion.put(key, (Object)newValue);
                    }
                    continue block13;
                }
                case 1006: {
                    for (Region aRegion : CacheHelper.getCache().rootRegions()) {
                        Log.getLogWriter().info("Operation: getting " + key + " in region " + aRegion.getFullPath());
                        aRegion.get(key);
                    }
                    continue block13;
                }
                case -1: {
                    ValueHolder newValue = new ValueHolder(key, rv);
                    for (Region aRegion : CacheHelper.getCache().rootRegions()) {
                        Log.getLogWriter().info("Operation: creating " + key + " in region " + aRegion.getFullPath());
                        aRegion.put(key, (Object)newValue);
                    }
                    continue block13;
                }
                default: {
                    throw new TestException("Unknown operation: " + op);
                }
            }
        }
        Log.getLogWriter().info("Done doing " + numOps + " ops");
        return false;
    }

    public static void HydraTask_writeTxnsToBlackboard() throws Exception {
        String key = "txListForVmId_" + RemoteTestModule.getMyVmid();
        ResumeTxBB.getBB().getSharedMap().put(key, RtxUtilVersionHelper.convertTransactionIDListToByteArrayList(txIdList));
    }
}

