/*
 * Decompiled with CFR 0.152.
 */
package resumeTx;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.EntryOperation;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import resumeTx.ResumeTxBB;
import util.NameFactory;

public class ModRoutingObject
implements PartitionResolver,
DataSerializable,
Comparable {
    private Object key;
    private long counterValue;
    private int modValue;

    public ModRoutingObject() {
    }

    ModRoutingObject(Object key) {
        this.key = (String)key;
        this.counterValue = NameFactory.getCounterForName(key);
        int numDataStores = (Integer)ResumeTxBB.getBB().getSharedMap().get(ResumeTxBB.NUM_DATASTORES);
        this.modValue = (int)this.counterValue % numDataStores;
    }

    public Object getKey() {
        return this.key;
    }

    public long getCounterValue() {
        return this.counterValue;
    }

    public long getModValue() {
        return this.modValue;
    }

    public String toString() {
        return this.counterValue + "_" + this.modValue;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModRoutingObject)) {
            return false;
        }
        ModRoutingObject o = (ModRoutingObject)obj;
        if (!this.key.equals(o.getKey())) {
            return false;
        }
        if (this.counterValue != o.getCounterValue()) {
            return false;
        }
        return (long)this.modValue == o.getModValue();
    }

    public int hashCode() {
        return this.modValue;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public Serializable getRoutingObject(EntryOperation op) {
        return (ModRoutingObject)op.getKey();
    }

    public void close() {
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject((Object)this.key, (DataOutput)out);
        DataSerializer.writeLong((Long)this.counterValue, (DataOutput)out);
        DataSerializer.writeInteger((Integer)this.modValue, (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.key = DataSerializer.readObject((DataInput)in);
        this.counterValue = DataSerializer.readLong((DataInput)in);
        this.modValue = DataSerializer.readInteger((DataInput)in);
    }

    public static final ModRoutingObject createFromData(DataInput in) throws IOException, ClassNotFoundException {
        ModRoutingObject result = new ModRoutingObject();
        InternalDataSerializer.invokeFromData((DataSerializable)result, (DataInput)in);
        return result;
    }

    public int compareTo(Object o) {
        ModRoutingObject mro = (ModRoutingObject)o;
        return (int)(this.counterValue - mro.counterValue);
    }
}

