/*
 * Decompiled with CFR 0.152.
 */
package resumeTx;

import hydra.Log;
import hydra.blackboard.Blackboard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tx.OpList;
import tx.Operation;
import util.TestException;
import util.TestHelper;

public class ResumeTxBB
extends Blackboard {
    static String BB_NAME = "ResumeTx_Blackboard";
    static String BB_TYPE = "RMI";
    private static ResumeTxBB bbInstance = null;
    public static String NUM_DATASTORES = "NUM_DATASTORES";
    public static String OPLIST = "OPLIST";
    public static String ERRSTR = "ERRSTR";
    public static String TX_COMPLETED = "TX_COMPLETED";
    public static String TX_HOST_DATAPOLICY = "TX_HOST_DATAPOLICY";
    public static String TX_ACTIVE = "TX_ACTIVE";
    public static String ACTIVE_TXNS = "ACTIVE_TXNS";
    public static String EXPECTED_KEYS_VALUES = "EXPECTED_KEYS_VALUES";
    public static String DESTROYED_ENTRIES = "DESTROYED_ENTRIES";
    public static int numCompletedTxns;
    public static int numResumes;
    public static int numCommits;
    public static int numFailedCommits;
    public static int numSuccessfulCommits;
    public static int numRollbacks;
    public static int numBegins;
    public static int numFailedTries;
    public static int numResumesAtCompletion;
    public static int valueCounter;
    public static int loadController;
    public static int resumeOrder;
    public static int readyToTryResume;
    public static int inTryResume;

    public static void clearOpList() {
        ResumeTxBB.getBB().getSharedMap().put(OPLIST, new OpList());
        Log.getLogWriter().fine("ResumeTXBB: OpList cleared");
    }

    public static void updateOpList(OpList newList) {
        OpList opList = (OpList)ResumeTxBB.getBB().getSharedMap().get(OPLIST);
        opList.addAll(newList, true);
        ResumeTxBB.getBB().getSharedMap().put(OPLIST, opList);
        Log.getLogWriter().fine("ResumeTXBB: after update, OpList = " + opList);
    }

    public static void computeExpectedKeysValues() {
        OpList opList = (OpList)ResumeTxBB.getBB().getSharedMap().get(OPLIST);
        HashMap<String, Map> expectedKeysValues = new HashMap<String, Map>();
        HashMap<String, List> destroyedEntries = new HashMap<String, List>();
        for (int i = 0; i < opList.numOps(); ++i) {
            Operation op = opList.getOperation(i);
            String opName = op.getOpName();
            String regionName = op.getRegionName();
            Object key = op.getKey();
            Object oldValue = op.getOldValue();
            Object newValue = op.getNewValue();
            Log.getLogWriter().fine("opList(" + i + ") = " + op.toString());
            if (!expectedKeysValues.containsKey(regionName)) {
                expectedKeysValues.put(regionName, new HashMap());
            }
            Map keyValuePair = (Map)expectedKeysValues.get(regionName);
            if (opName.equals("entry-destroy")) {
                keyValuePair.remove(key);
                if (!destroyedEntries.containsKey(regionName)) {
                    destroyedEntries.put(regionName, new ArrayList());
                }
                List keys = (List)destroyedEntries.get(regionName);
                keys.add(key);
                destroyedEntries.put(regionName, keys);
            } else if (opName.equals("entry-create") || opName.equals("entry-getWithNewKey")) {
                keyValuePair.put(key, newValue);
            } else if (opName.equals("entry-inval")) {
                keyValuePair.put(key, null);
            } else if (opName.equals("entry-update") || opName.equals("entry-getWithExistingKey")) {
                keyValuePair.put(key, newValue);
            } else {
                Log.getLogWriter().info("Unexpected operation " + op.toString());
                throw new TestException("VerifyTx: Unexpected operation: " + op.toString() + TestHelper.getStackTrace());
            }
            expectedKeysValues.put(regionName, keyValuePair);
        }
        ResumeTxBB.getBB().getSharedMap().put(EXPECTED_KEYS_VALUES, expectedKeysValues);
        ResumeTxBB.getBB().getSharedMap().put(DESTROYED_ENTRIES, destroyedEntries);
        Log.getLogWriter().fine("expectedKeysValue = " + expectedKeysValues.toString());
        Log.getLogWriter().fine("destroyedEntries = " + destroyedEntries.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResumeTxBB getBB() {
        if (bbInstance != null) return bbInstance;
        Class<ResumeTxBB> clazz = ResumeTxBB.class;
        synchronized (ResumeTxBB.class) {
            if (bbInstance != null) return bbInstance;
            bbInstance = new ResumeTxBB(BB_NAME, BB_TYPE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return bbInstance;
        }
    }

    public ResumeTxBB() {
    }

    public ResumeTxBB(String name, String type) {
        super(name, type, ResumeTxBB.class);
    }
}

