/*
 * Decompiled with CFR 0.152.
 */
package resumeTx;

import com.gemstone.gemfire.cache.CommitConflictException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.cache.TransactionInDoubtException;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionInvocationTargetException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.TXId;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.GsRandom;
import hydra.Log;
import hydra.Prms;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import resumeTx.BeginTx;
import resumeTx.ExecuteTx;
import resumeTx.ModRoutingObject;
import resumeTx.ResumeTxBB;
import resumeTx.ResumeTxPrms;
import resumeTx.RtxUtil;
import resumeTx.RtxUtilVersionHelper;
import resumeTx.TXController;
import resumeTx.TryResume;
import resumeTx.TxInfo;
import resumeTx.VerifyTx;
import tx.TxPrms;
import util.BaseValueHolder;
import util.NameFactory;
import util.SilenceListener;
import util.StopStartPrms;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;

public class ResumeTxTest {
    public static ResumeTxTest testInstance = null;
    private boolean isBridgeClient = false;
    private boolean isHA = false;
    protected long minTaskGranularitySec;
    protected long minTaskGranularityMS;
    protected static final int BEGIN_TX = 1001;
    protected static final int EXECUTE_TX_OPS = 1002;
    protected static final int EXECUTE_NONTX_OPS = 1003;
    protected static final int COMMIT = 1004;
    protected static final int ROLLBACK = 1005;

    public static void StartTask_initialize() {
        RegionDescription rd = RegionHelper.getRegionDescription(ConfigPrms.getRegionConfig());
        ResumeTxBB.getBB().getSharedMap().put(ResumeTxBB.TX_HOST_DATAPOLICY, rd.getDataPolicy());
    }

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new ResumeTxTest();
            testInstance.initialize();
        }
    }

    protected void initialize() {
        this.isHA = ResumeTxPrms.getHighAvailability();
        this.minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, 10L);
        this.minTaskGranularityMS = this.minTaskGranularitySec * 1000L;
        ResumeTxBB.getBB().getSharedMap().put(ResumeTxBB.ACTIVE_TXNS, new HashMap());
        Log.getLogWriter().info("testInstance = " + testInstance.toString());
    }

    public static void HydraTask_concTxWithFE() throws Exception {
        testInstance.concTxWithFE();
    }

    protected void concTxWithFE() throws Exception {
        long startTime = System.currentTimeMillis();
        RtxUtil.logExecutionNumber();
        do {
            String errStr;
            if ((errStr = (String)ResumeTxBB.getBB().getSharedMap().get(ResumeTxBB.ERRSTR)) != null && errStr.length() > 0) {
                throw new TestException(errStr + " " + TestHelper.getStackTrace());
            }
            try {
                this.doTransactions();
            }
            catch (ServerConnectivityException e) {
                if (!this.isHA) {
                    throw new TestException((Object)((Object)e) + TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Caught " + (Object)((Object)e) + " while executing txOps.  Expected with HA, continuing test");
            }
            catch (FunctionException e) {
                Throwable causedBy = e.getCause();
                Log.getLogWriter().info("causedBy = " + causedBy);
                Throwable lastCause = TestHelper.getLastCausedBy(e);
                Log.getLogWriter().info("lastCause = " + lastCause);
                if (causedBy instanceof CommitConflictException) {
                    Log.getLogWriter().info("Caught " + (Object)((Object)e) + ", expected with concurrent execution, continuing test");
                    continue;
                }
                if (causedBy instanceof TransactionDataRebalancedException || causedBy instanceof TransactionDataNodeHasDepartedException || causedBy instanceof TransactionInDoubtException || causedBy instanceof ServerConnectivityException) {
                    if (this.isHA) {
                        Log.getLogWriter().info("Caught " + (Object)((Object)e) + ", expected with HA, continuing test");
                        continue;
                    }
                    throw new TestException("Caught " + (Object)((Object)e) + " " + TestHelper.getStackTrace(e));
                }
                if (e instanceof FunctionInvocationTargetException || causedBy instanceof FunctionInvocationTargetException || causedBy instanceof TransactionDataRebalancedException || lastCause instanceof FunctionInvocationTargetException || lastCause instanceof TransactionException) {
                    if (!this.isHA) {
                        throw new TestException((Object)((Object)e) + TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("Caught " + (Object)((Object)e) + " while executing txOps.  Expected with HA, continuing test");
                    continue;
                }
                throw new TestException((Object)((Object)e) + TestHelper.getStackTrace(e));
            }
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
    }

    public void doTransactions() throws Exception {
        GsRandom rand = TestConfig.tab().getRandGen();
        int minExecutions = ResumeTxPrms.getMinExecutions();
        TxInfo txInfo = null;
        TransactionId txId = null;
        int action = 0;
        ResumeTxBB bb = ResumeTxBB.getBB();
        SharedMap bbMap = bb.getSharedMap();
        bb.getSharedLock().lock();
        Map activeTxnsWrapped = (Map)bbMap.get(ResumeTxBB.ACTIVE_TXNS);
        Map<TXId, TxInfo> activeTxns = RtxUtilVersionHelper.convertWrapperMapToActiveTxMap(activeTxnsWrapped);
        Object[] txIds = activeTxns.keySet().toArray();
        Log.getLogWriter().fine("before update " + ResumeTxTest.activeTxnsToString(activeTxns));
        int numThreads = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        int numActiveTxns = activeTxns.size();
        if (numActiveTxns < numThreads) {
            action = 1001;
        } else {
            for (int i = 0; i < txIds.length; ++i) {
                txId = (TransactionId)txIds[i];
                txInfo = activeTxns.get(txId);
                int numExecutions = txInfo.getNumExecutions();
                if (numExecutions <= minExecutions) continue;
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    action = 1004;
                    Log.getLogWriter().info("doTransactions: commit(" + txId + ")");
                    break;
                }
                action = 1005;
                Log.getLogWriter().info("doTransactions: rollback(" + txId + ")");
                break;
            }
            if (action == 0) {
                action = 1002;
                int randInt = TestConfig.tab().getRandGen().nextInt(0, txIds.length - 1);
                txId = (TransactionId)txIds[randInt];
                txInfo = activeTxns.get(txId);
                Log.getLogWriter().info("doTransactions: executeTxOps(" + txId + ")");
            }
        }
        bb.getSharedLock().unlock();
        boolean success = true;
        switch (action) {
            case 1001: {
                Log.getLogWriter().info("doTransactions: begin()");
                txInfo = this.begin();
                break;
            }
            case 1004: {
                success = this.commit(txInfo);
                break;
            }
            case 1005: {
                success = this.rollback(txInfo);
                break;
            }
            case 1002: {
                success = this.executeTxOps(txInfo);
                break;
            }
            default: {
                throw new TestException("Unrecognized action " + action);
            }
        }
        if (success) {
            txId = txInfo.getTxId();
            bb.getSharedLock().lock();
            activeTxnsWrapped = (Map)bbMap.get(ResumeTxBB.ACTIVE_TXNS);
            activeTxns = RtxUtilVersionHelper.convertWrapperMapToActiveTxMap(activeTxnsWrapped);
            switch (action) {
                case 1001: {
                    activeTxns.put((TXId)txId, txInfo);
                    break;
                }
                case 1004: 
                case 1005: {
                    activeTxns.remove(txId);
                    break;
                }
                case 1002: {
                    txInfo = activeTxns.get(txId);
                    if (txInfo == null) break;
                    txInfo.incrementNumExecutions();
                    activeTxns.put((TXId)txId, txInfo);
                    break;
                }
                default: {
                    throw new TestException("Unrecognized action " + action);
                }
            }
            bbMap.put(ResumeTxBB.ACTIVE_TXNS, RtxUtilVersionHelper.convertActiveTxMapToWrapperMap(activeTxns));
            Log.getLogWriter().fine("after update " + ResumeTxTest.activeTxnsToString(activeTxns));
            bb.getSharedLock().unlock();
        }
    }

    public static void CloseTask_finishAllActiveTx() throws Exception {
        testInstance.finishAllActiveTx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishAllActiveTx() throws Exception {
        boolean isSerialExecution = TestConfig.tab().booleanAt(Prms.serialExecution);
        ResumeTxBB bb = ResumeTxBB.getBB();
        SharedMap bbMap = bb.getSharedMap();
        bb.getSharedLock().lock();
        Map activeTxnsWrapped = (Map)bbMap.get(ResumeTxBB.ACTIVE_TXNS);
        Map<TXId, TxInfo> activeTxns = RtxUtilVersionHelper.convertWrapperMapToActiveTxMap(activeTxnsWrapped);
        Object[] txIds = activeTxns.keySet().toArray();
        for (int i = 0; i < txIds.length; ++i) {
            TransactionId txId = (TransactionId)txIds[i];
            TxInfo txInfo = activeTxns.get(txId);
            try {
                this.commit(txInfo);
                continue;
            }
            catch (FunctionException e) {
                Throwable causedBy = e.getCause();
                if (causedBy instanceof CommitConflictException) {
                    if (isSerialExecution) {
                        throw new TestException("Caught " + (Object)((Object)e) + " " + TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("Caught " + (Object)((Object)e) + ", expected with concurrentExecution, continuing test");
                    continue;
                }
                if (causedBy instanceof TransactionDataRebalancedException || causedBy instanceof TransactionDataNodeHasDepartedException || causedBy instanceof TransactionInDoubtException || causedBy instanceof FunctionInvocationTargetException) {
                    if (this.isHA) {
                        Log.getLogWriter().info("Caught " + (Object)((Object)e) + ", expected with HA, continuing test");
                        continue;
                    }
                    throw new TestException("Caught " + (Object)((Object)e) + " " + TestHelper.getStackTrace(e));
                }
                throw new TestException("Caught " + (Object)((Object)e) + " " + TestHelper.getStackTrace(e));
            }
            finally {
                activeTxns.remove(txId);
            }
        }
        bbMap.put(ResumeTxBB.ACTIVE_TXNS, RtxUtilVersionHelper.convertActiveTxMapToWrapperMap(activeTxns));
        bb.getSharedLock().unlock();
        Log.getLogWriter().fine("after update, ActiveTxns = " + activeTxns);
    }

    protected TxInfo begin() {
        Execution e;
        DistributedSystem ds = CacheHelper.getCache().getDistributedSystem();
        Pool pool = PoolManager.find((String)"brloader");
        if (pool != null) {
            this.isBridgeClient = true;
        }
        ArrayList<String> aList = new ArrayList<String>();
        aList.add(ResumeTxTest.getClientIdString());
        TxInfo txInfo = new TxInfo();
        DataPolicy txHostDataPolicy = (DataPolicy)ResumeTxBB.getBB().getSharedMap().get(ResumeTxBB.TX_HOST_DATAPOLICY);
        if (txHostDataPolicy.withPartitioning()) {
            Region aRegion = (Region)CacheHelper.getCache().rootRegions().iterator().next();
            Object[] keySet = aRegion.keySet().toArray();
            Object aKey = null;
            if (keySet.length > 0) {
                int randInt = TestConfig.tab().getRandGen().nextInt(0, keySet.length - 1);
                aKey = keySet[randInt];
            } else {
                aKey = NameFactory.getNextPositiveObjectName();
                aRegion.put(aKey, RtxUtil.txUtilInstance.getNewValue(aKey));
            }
            HashSet<Object> filterSet = new HashSet<Object>();
            filterSet.add(aKey);
            e = FunctionService.onRegion((Region)aRegion).withArgs(aList).withFilter(filterSet);
            Log.getLogWriter().info("executing function BeginTx on region " + aRegion.getName() + " withArgs " + aList + " and filterSet " + filterSet);
            txInfo.setRegionName(aRegion.getName());
            txInfo.setKey(aKey);
            txInfo.setRoutingObject(new ModRoutingObject(aKey));
        } else if (this.isBridgeClient) {
            e = FunctionService.onServer((Pool)pool).withArgs(aList);
            Log.getLogWriter().info("executing function BeginTx onServer( " + pool.getName() + ") withArgs " + aList);
        } else {
            Object[] members = DistributedSystemHelper.getMembers().toArray();
            int randInt = TestConfig.tab().getRandGen().nextInt(0, members.length - 1);
            DistributedMember targetDM = (DistributedMember)members[randInt];
            e = FunctionService.onMember((DistributedSystem)ds, (DistributedMember)targetDM).withArgs(aList);
            Log.getLogWriter().info("executing function BeginTx on member(" + targetDM + ") withArgs " + aList);
        }
        ResultCollector rc = e.execute((Function)new BeginTx());
        List resultList = (List)rc.getResult();
        TransactionId txId = (TransactionId)resultList.get(0);
        txInfo.setTxId(txId);
        ResumeTxBB.getBB().getSharedMap().put(ResumeTxBB.TX_ACTIVE, Boolean.TRUE);
        ResumeTxBB.clearOpList();
        Log.getLogWriter().info("begin returning " + txInfo);
        return txInfo;
    }

    protected boolean executeTxOps(TxInfo txInfo) {
        Execution e;
        Log.getLogWriter().fine("in executeTxOps with txInfo = " + txInfo.toString());
        boolean isSerialExecution = TestConfig.tab().booleanAt(Prms.serialExecution);
        TransactionId txId = txInfo.getTxId();
        Pool pool = PoolManager.find((String)"brloader");
        if (pool != null) {
            this.isBridgeClient = true;
        }
        ArrayList<String> aList = new ArrayList<String>();
        aList.add(ResumeTxTest.getClientIdString());
        aList.add((String)txId);
        DataPolicy txHostDataPolicy = (DataPolicy)ResumeTxBB.getBB().getSharedMap().get(ResumeTxBB.TX_HOST_DATAPOLICY);
        if (txHostDataPolicy.withPartitioning()) {
            String regionName = txInfo.getRegionName();
            Region aRegion = RegionHelper.getRegion(regionName);
            Object aKey = txInfo.getKey();
            HashSet<Object> filterSet = new HashSet<Object>();
            filterSet.add(aKey);
            e = FunctionService.onRegion((Region)aRegion).withArgs(aList).withFilter(filterSet);
            Log.getLogWriter().info("executing function ExecuteTx on region " + aRegion.getName() + " with aList " + aList + " and filterSet " + filterSet);
        } else if (this.isBridgeClient) {
            e = FunctionService.onServers((Pool)pool).withArgs(aList);
            Log.getLogWriter().info("executing function ExecuteTx onServers(" + pool.getName() + ") withArgs " + aList);
        } else {
            e = FunctionService.onMembers((DistributedSystem)DistributedSystemHelper.getDistributedSystem()).withArgs(aList);
            Log.getLogWriter().info("executing function ExecuteTx on all members withArgs " + aList);
        }
        boolean executedOps = false;
        ResultCollector rc = e.execute((Function)new ExecuteTx());
        List resultList = (List)rc.getResult();
        for (int i = 0; i < resultList.size(); ++i) {
            boolean result = (Boolean)resultList.get(i);
            if (!result) continue;
            if (executedOps && result) {
                throw new TestException("More than one member returned true (executedOps) from Commit Function for " + txId);
            }
            executedOps = true;
        }
        Log.getLogWriter().info("ExecuteTx executedOps = " + executedOps);
        if (!executedOps && isSerialExecution) {
            throw new TestException(txId + " not suspended in any member, orphaned tx?");
        }
        return executedOps;
    }

    protected boolean executeNonTxOps() {
        boolean result = true;
        Log.getLogWriter().info("executeNonTxOps() - TBD");
        Log.getLogWriter().info("executeNonTxOps returning " + result);
        return result;
    }

    protected boolean commit(TxInfo txInfo) {
        TransactionId txId = txInfo.getTxId();
        boolean txCompleted = true;
        Log.getLogWriter().info("Commit function returned (txCompleted) " + txCompleted);
        return txCompleted;
    }

    protected boolean rollback(TxInfo txInfo) {
        TransactionId txId = txInfo.getTxId();
        boolean txCompleted = true;
        Log.getLogWriter().info("Rollback function returned (txCompleted) " + txCompleted);
        return txCompleted;
    }

    public static void HydraTask_serialRRTxWithFE() throws Exception {
        testInstance.serialRRTxWithFE();
    }

    protected void serialRRTxWithFE() throws Exception {
        GsRandom rand = TestConfig.tab().getRandGen();
        boolean firstInRound = RtxUtil.logRoundRobinNumber();
        RtxUtil.logExecutionNumber();
        long rrNumber = RtxUtil.getRoundRobinNumber();
        long whichRound = rrNumber % 2L;
        boolean isHA = ResumeTxPrms.getHighAvailability();
        TransactionId txId = null;
        Pool pool = PoolManager.find((String)"brloader");
        if (pool != null) {
            this.isBridgeClient = true;
        }
        ArrayList<String> aList = new ArrayList<String>();
        aList.add(ResumeTxTest.getClientIdString());
        DataPolicy txHostDataPolicy = (DataPolicy)ResumeTxBB.getBB().getSharedMap().get(ResumeTxBB.TX_HOST_DATAPOLICY);
        if (whichRound == 1L) {
            Log.getLogWriter().info("In round " + rrNumber + " to begin tx, firstInRound is " + firstInRound);
            if (firstInRound) {
                Log.getLogWriter().info("This thread is first in the round, beginning the tx");
                TxInfo txInfo = this.begin();
                Map activeTxnsWrapped = (Map)ResumeTxBB.getBB().getSharedMap().get(ResumeTxBB.ACTIVE_TXNS);
                Map<TXId, TxInfo> activeTxns = RtxUtilVersionHelper.convertWrapperMapToActiveTxMap(activeTxnsWrapped);
                txId = txInfo.getTxId();
                activeTxns.put((TXId)txId, txInfo);
                ResumeTxBB.getBB().getSharedMap().put(ResumeTxBB.ACTIVE_TXNS, RtxUtilVersionHelper.convertActiveTxMapToWrapperMap(activeTxns));
                ResumeTxBB.getBB().getSharedMap().put(ResumeTxBB.TX_ACTIVE, Boolean.TRUE);
                ResumeTxBB.clearOpList();
            } else {
                boolean txActive = (Boolean)ResumeTxBB.getBB().getSharedMap().get(ResumeTxBB.TX_ACTIVE);
                if (txActive) {
                    boolean executedOps;
                    Map activeTxnsWrapped = (Map)ResumeTxBB.getBB().getSharedMap().get(ResumeTxBB.ACTIVE_TXNS);
                    Map<TXId, TxInfo> activeTxns = RtxUtilVersionHelper.convertWrapperMapToActiveTxMap(activeTxnsWrapped);
                    Object[] txIds = activeTxns.keySet().toArray();
                    TxInfo txInfo = activeTxns.get(txIds[0]);
                    txId = txInfo.getTxId();
                    aList.add((String)txId);
                    try {
                        executedOps = this.executeTxOps(txInfo);
                    }
                    catch (Exception ex) {
                        Log.getLogWriter().info("Caught " + ex + " while executing tx ops");
                        executedOps = false;
                        Throwable causedBy = ex.getCause();
                        Throwable lastCause = TestHelper.getLastCausedBy(ex);
                        Log.getLogWriter().info("lastCause = " + lastCause);
                        if (ex instanceof FunctionInvocationTargetException || causedBy instanceof FunctionInvocationTargetException || causedBy instanceof TransactionDataRebalancedException || lastCause instanceof FunctionInvocationTargetException || lastCause instanceof TransactionException) {
                            if (!isHA) {
                                throw new TestException(ex + TestHelper.getStackTrace(ex));
                            }
                            Log.getLogWriter().info("Caught " + ex + " while executing txOps.  Expected with HA, continuing test");
                        }
                        throw new TestException(ex + TestHelper.getStackTrace(ex));
                    }
                    txInfo.incrementNumExecutions();
                    activeTxns.put((TXId)txId, txInfo);
                    ResumeTxBB.getBB().getSharedMap().put(ResumeTxBB.ACTIVE_TXNS, RtxUtilVersionHelper.convertActiveTxMapToWrapperMap(activeTxns));
                    ResumeTxBB.getBB().getSharedMap().put(ResumeTxBB.TX_ACTIVE, executedOps);
                }
            }
        } else {
            boolean txActive = (Boolean)ResumeTxBB.getBB().getSharedMap().get(ResumeTxBB.TX_ACTIVE);
            if (firstInRound) {
                Map activeTxnsWrapped = (Map)ResumeTxBB.getBB().getSharedMap().get(ResumeTxBB.ACTIVE_TXNS);
                Map<TXId, TxInfo> activeTxns = RtxUtilVersionHelper.convertWrapperMapToActiveTxMap(activeTxnsWrapped);
                Object[] txIds = activeTxns.keySet().toArray();
                TxInfo txInfo = activeTxns.get(txIds[0]);
                txId = txInfo.getTxId();
                Log.getLogWriter().info("In round " + rrNumber + " to close " + txId + ", firstInRound is " + firstInRound);
                boolean txCompleted = false;
                if (txActive) {
                    if (isHA) {
                        this.stopStartDataStores();
                    }
                    int commitPercentage = TxPrms.getCommitPercentage();
                    int n = TestConfig.tab().getRandGen().nextInt(0, 100);
                    SilenceListener.waitForSilence(30L, 5000L);
                    if (txCompleted) {
                        this.verifyTx(txInfo);
                    }
                } else if (isHA) {
                    Log.getLogWriter().info("Tx Failed/RolledBack during execute round, skipping commit");
                } else {
                    throw new TestException("Unexpected failure during execute round prevents commit of tx " + txId);
                }
                activeTxns.remove(txId);
                ResumeTxBB.getBB().getSharedMap().put(ResumeTxBB.ACTIVE_TXNS, RtxUtilVersionHelper.convertActiveTxMapToWrapperMap(activeTxns));
                ResumeTxBB.getBB().getSharedMap().put(ResumeTxBB.TX_COMPLETED, new Boolean(txCompleted));
            } else if (this.isBridgeClient) {
                Log.getLogWriter().info("In round " + rrNumber + " validate edge client keysValues");
                boolean verify = (Boolean)ResumeTxBB.getBB().getSharedMap().get(ResumeTxBB.TX_COMPLETED);
                if (verify) {
                    this.edgeClientValidation(txId);
                }
            }
        }
    }

    protected void verifyTx(TxInfo txInfo) {
        DistributedSystem ds = CacheHelper.getCache().getDistributedSystem();
        ResumeTxBB.computeExpectedKeysValues();
        ArrayList<String> aList = new ArrayList<String>();
        aList.add(ResumeTxTest.getClientIdString());
        TransactionId txId = txInfo.getTxId();
        aList.add((String)txId);
        Pool pool = PoolManager.find((String)"brloader");
        Execution e = null;
        if (pool != null) {
            Log.getLogWriter().info("executing function VerifyTx onServers on pool " + pool.getName() + " withArgs " + aList);
            e = FunctionService.onServers((Pool)pool).withArgs(aList);
        } else {
            DataPolicy txHostDataPolicy = (DataPolicy)ResumeTxBB.getBB().getSharedMap().get(ResumeTxBB.TX_HOST_DATAPOLICY);
            if (txHostDataPolicy.withPartitioning()) {
                String regionName = txInfo.getRegionName();
                Region aRegion = RegionHelper.getRegion(regionName);
                Log.getLogWriter().info("executing function VerifyTx on region " + aRegion.getName() + " withArgs " + aList);
                e = FunctionService.onRegion((Region)aRegion).withArgs(aList);
            } else {
                Log.getLogWriter().info("executing function VerifyTx onMembers(ds) withArgs " + aList);
                e = FunctionService.onMembers((DistributedSystem)ds).withArgs(aList);
            }
        }
        ResultCollector rc = e.execute((Function)new VerifyTx());
        List resultList = (List)rc.getResult();
        Iterator it = resultList.iterator();
        while (it.hasNext()) {
            boolean success = (Boolean)it.next();
            if (success) continue;
            throw new TestException("Failed validation of expected key/values\n" + ResumeTxBB.getBB().getSharedMap().get(ResumeTxBB.ERRSTR));
        }
        Log.getLogWriter().info("Successful validation of expected keys and values");
    }

    private void edgeClientValidation(TransactionId txId) {
        Log.getLogWriter().info("Verifying expected keys/values in edge client based on " + txId);
        StringBuffer errStr = new StringBuffer();
        boolean success = true;
        Map destroyedEntries = (Map)ResumeTxBB.getBB().getSharedMap().get(ResumeTxBB.DESTROYED_ENTRIES);
        Log.getLogWriter().fine("destroyedEntries = " + destroyedEntries);
        for (String regionName : destroyedEntries.keySet()) {
            Region aRegion = RegionHelper.getRegion(regionName);
            List keys = (List)destroyedEntries.get(regionName);
            for (int i = 0; i < keys.size(); ++i) {
                Object key = keys.get(i);
                if (!aRegion.containsKey(key)) continue;
                Log.getLogWriter().info("Expected containsKey to be false, for " + regionName + ":" + key + ", but it was true (key was destroyed in " + txId + ")");
                errStr.append("Expected containsKey to be false, for " + regionName + ":" + key + ", but it was true (key was destroyed in " + txId + ") \n");
            }
        }
        Map expectedKeysValues = (Map)ResumeTxBB.getBB().getSharedMap().get(ResumeTxBB.EXPECTED_KEYS_VALUES);
        Log.getLogWriter().fine("expectedKeysValues = " + expectedKeysValues);
        for (String regionName : expectedKeysValues.keySet()) {
            Region aRegion = RegionHelper.getRegion(regionName);
            Map keyValuePair = (Map)expectedKeysValues.get(regionName);
            for (Object key : keyValuePair.keySet()) {
                Object value = keyValuePair.get(key);
                if (!aRegion.containsKey(key)) {
                    Log.getLogWriter().info("Expected containsKey() to be true for " + regionName + ":" + key + ", but it was false.  txId = " + txId);
                    errStr.append("Expected containsKey() to be true for " + regionName + ":" + key + ", but it was false, txId = " + txId + "\n");
                }
                if (value == null && aRegion.containsValueForKey(key)) {
                    Log.getLogWriter().info("Expected containsValueForKey to be false, for " + regionName + ":" + key + ", but it was true, txId = " + txId);
                    errStr.append("Expected containsValueForKey to be false, for " + regionName + ":" + key + ", but it was true, txId = " + txId + "\n");
                }
                if (value != null && !aRegion.containsValueForKey(key)) {
                    Log.getLogWriter().info("Expected containsValueForKey() to be true for " + regionName + ":" + key + ", but it was false, txId = " + txId);
                    errStr.append("Expected containsValueForKey() to be true for " + regionName + ":" + key + ", but it was false, txId = " + txId + "\n");
                }
                Object actualValue = null;
                Region.Entry entry = aRegion.getEntry(key);
                if (entry != null) {
                    actualValue = entry.getValue();
                }
                if (actualValue instanceof BaseValueHolder) {
                    actualValue = ((BaseValueHolder)actualValue).modVal;
                    Log.getLogWriter().fine("actualValue for " + regionName + ":" + key + " is an Integer " + actualValue);
                    if (actualValue.equals(value)) continue;
                    Log.getLogWriter().info("Expected value for " + regionName + ":" + key + " to be " + value + ", but found " + actualValue + " txId = " + txId);
                    errStr.append("Expected value for " + regionName + ":" + key + " to be " + value + ", but found " + actualValue + " " + TestHelper.getStackTrace() + " txId = " + txId + "\n");
                    continue;
                }
                Log.getLogWriter().info("WARNING: actual value retrieved from cache is not a ValueHolder, is " + actualValue);
            }
        }
        if (errStr.length() > 0) {
            throw new TestException("edge client validation failed for " + txId + "\n" + errStr.toString());
        }
        Log.getLogWriter().info("Done executing VerifyTx - validation successful");
    }

    public static void HydraTask_TXController() {
        testInstance.TXController();
    }

    protected void TXController() {
        Execution e;
        DistributedSystem ds = CacheHelper.getCache().getDistributedSystem();
        int numThreads = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        Log.getLogWriter().info("numThreads executing tasks = " + numThreads);
        RtxUtil.logExecutionNumber();
        Pool pool = PoolManager.find((String)"brloader");
        if (pool != null) {
            this.isBridgeClient = true;
        }
        ArrayList<Object> aList = new ArrayList<Object>();
        aList.add(ResumeTxTest.getClientIdString());
        aList.add(new Integer(numThreads));
        TxInfo txInfo = new TxInfo();
        DataPolicy txHostDataPolicy = (DataPolicy)ResumeTxBB.getBB().getSharedMap().get(ResumeTxBB.TX_HOST_DATAPOLICY);
        if (txHostDataPolicy.withPartitioning()) {
            Region aRegion = (Region)CacheHelper.getCache().rootRegions().iterator().next();
            Object[] keySet = aRegion.keySet().toArray();
            Object aKey = null;
            if (keySet.length > 0) {
                int randInt = TestConfig.tab().getRandGen().nextInt(0, keySet.length - 1);
                aKey = keySet[randInt];
            } else {
                aKey = NameFactory.getNextPositiveObjectName();
                aRegion.put(aKey, RtxUtil.txUtilInstance.getNewValue(aKey));
            }
            HashSet<Object> filterSet = new HashSet<Object>();
            filterSet.add(aKey);
            e = FunctionService.onRegion((Region)aRegion).withArgs(aList).withFilter(filterSet);
            Log.getLogWriter().info("executing function TXController on region " + aRegion.getName() + " withArgs " + aList + " and filterSet " + filterSet);
            txInfo.setRegionName(aRegion.getName());
            txInfo.setKey(aKey);
            txInfo.setRoutingObject(new ModRoutingObject(aKey));
        } else if (this.isBridgeClient) {
            e = FunctionService.onServer((Pool)pool).withArgs(aList);
            Log.getLogWriter().info("executing function TXController onServer( " + pool.getName() + ") withArgs " + aList);
        } else {
            Object[] members = DistributedSystemHelper.getMembers().toArray();
            int randInt = TestConfig.tab().getRandGen().nextInt(0, members.length - 1);
            DistributedMember targetDM = (DistributedMember)members[randInt];
            e = FunctionService.onMember((DistributedSystem)ds, (DistributedMember)targetDM).withArgs(aList);
            Log.getLogWriter().info("executing function TXController on member(" + targetDM + ") withArgs " + aList);
        }
        aList.add(txInfo);
        ResultCollector rc = e.execute((Function)new TXController());
        List resultList = (List)rc.getResult();
        boolean success = (Boolean)resultList.get(0);
        if (!success) {
            throw new TestException("TXController function returned " + success + ", " + TestHelper.getStackTrace());
        }
    }

    public static void HydraTask_tryResumeWithWait() throws Exception {
        testInstance.tryResumeWithWait();
    }

    protected void tryResumeWithWait() throws Exception {
        try {
            TestHelper.waitForCounter(ResumeTxBB.getBB(), "ResumeTxBB.readyToTryResume", ResumeTxBB.readyToTryResume, 1L, true, 5000L);
        }
        catch (TestException e) {
            Log.getLogWriter().info("Caught " + e + ": hydra probably stopped scheduling TXController, ignoring");
        }
        Map activeTxnsWrapped = (Map)ResumeTxBB.getBB().getSharedMap().get(ResumeTxBB.ACTIVE_TXNS);
        Map<TXId, TxInfo> activeTxns = RtxUtilVersionHelper.convertWrapperMapToActiveTxMap(activeTxnsWrapped);
        Object[] txIds = activeTxns.keySet().toArray();
        TransactionId txId = (TransactionId)txIds[0];
        TxInfo txInfo = activeTxns.get(txId);
        this.tryResume(txInfo);
        ResumeTxBB.getBB().getSharedCounters().decrement(ResumeTxBB.inTryResume);
    }

    protected boolean tryResume(TxInfo txInfo) {
        Execution e;
        TransactionId txId = txInfo.getTxId();
        Pool pool = PoolManager.find((String)"brloader");
        if (pool != null) {
            this.isBridgeClient = true;
        }
        ArrayList<String> aList = new ArrayList<String>();
        aList.add(ResumeTxTest.getClientIdString());
        aList.add((String)txId);
        DataPolicy txHostDataPolicy = (DataPolicy)ResumeTxBB.getBB().getSharedMap().get(ResumeTxBB.TX_HOST_DATAPOLICY);
        if (txHostDataPolicy.withPartitioning()) {
            String regionName = txInfo.getRegionName();
            Region aRegion = RegionHelper.getRegion(regionName);
            Object aKey = txInfo.getKey();
            HashSet<Object> filterSet = new HashSet<Object>();
            filterSet.add(aKey);
            e = FunctionService.onRegion((Region)aRegion).withArgs(aList).withFilter(filterSet);
            Log.getLogWriter().info("executing function TryResume on region " + aRegion.getName() + " with aList " + aList + " and filterSet " + filterSet);
        } else if (this.isBridgeClient) {
            e = FunctionService.onServers((Pool)pool).withArgs(aList);
            Log.getLogWriter().info("executing function TryResume onServers(" + pool.getName() + ") withArgs " + aList);
        } else {
            e = FunctionService.onMembers((DistributedSystem)DistributedSystemHelper.getDistributedSystem()).withArgs(aList);
            Log.getLogWriter().info("executing function TryResume on all members withArgs " + aList);
        }
        boolean status = false;
        ResultCollector rc = e.execute((Function)new TryResume());
        List resultList = (List)rc.getResult();
        for (int i = 0; i < resultList.size(); ++i) {
            boolean result = (Boolean)resultList.get(i);
            if (!result) continue;
            status = true;
        }
        Log.getLogWriter().info("TryResume returning  " + status);
        return status;
    }

    public static void HydraTask_stopStartDataStores() {
        testInstance.stopStartDataStores();
    }

    protected void stopStartDataStores() {
        DataPolicy txHostDataPolicy = (DataPolicy)ResumeTxBB.getBB().getSharedMap().get(ResumeTxBB.TX_HOST_DATAPOLICY);
        int numVMsToStop = TestConfig.tab().intAt(StopStartPrms.numVMsToStop);
        int randInt = TestConfig.tab().getRandGen().nextInt(1, numVMsToStop);
        String matchStr = "client";
        if (txHostDataPolicy.withPartitioning()) {
            matchStr = "dataStore";
        }
        if (BridgeHelper.getEndpoints().size() > 0) {
            matchStr = "bridge";
        }
        Object[] objArr = StopStartVMs.getOtherVMs(randInt, matchStr);
        List clientVmInfoList = (List)objArr[0];
        List stopModeList = (List)objArr[1];
        StopStartVMs.stopStartVMs(clientVmInfoList, stopModeList);
    }

    public static String activeTxnsToString(Map activeTxns) {
        StringBuffer txStr = new StringBuffer();
        txStr.append("ActiveTxns has " + activeTxns.size() + " entries\n");
        Object[] txIds = activeTxns.keySet().toArray();
        for (int i = 0; i < txIds.length; ++i) {
            TransactionId txId = (TransactionId)txIds[i];
            TxInfo txInfo = (TxInfo)activeTxns.get(txId);
            txStr.append("ActiveTxns(" + i + ") = {" + txId + ":" + txInfo.toString() + "}\n");
        }
        return txStr.toString();
    }

    private static String getClientIdString() {
        return "vm_" + RemoteTestModule.getMyVmid() + "_thr_" + RemoteTestModule.getCurrentThread().getThreadId();
    }
}

