/*
 * Decompiled with CFR 0.152.
 */
package resumeTx;

import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.distributed.DistributedMember;
import hydra.CacheHelper;
import hydra.Log;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import resumeTx.ResumeTxBB;
import util.TxHelper;

public class TryResume
implements Function,
Declarable {
    public void execute(FunctionContext context) {
        DistributedMember dm = CacheHelper.getCache().getDistributedSystem().getDistributedMember();
        ArrayList argumentList = (ArrayList)context.getArguments();
        String forDM = (String)argumentList.get(0);
        TransactionId txId = (TransactionId)argumentList.get(1);
        Log.getLogWriter().info("executing " + this.getClass().getName() + " in member " + dm + ", invoked from " + forDM + " on txId " + txId);
        ResumeTxBB.getBB().getSharedCounters().increment(ResumeTxBB.inTryResume);
        boolean txResumed = false;
        if (TxHelper.tryResume(txId, 3600L, TimeUnit.SECONDS)) {
            Log.getLogWriter().fine("TryResume RESUMED " + txId);
            txResumed = true;
            TxHelper.suspend();
        } else {
            Log.getLogWriter().info("tryResume with wait failed, tx exists = " + TxHelper.exists(txId));
        }
        Log.getLogWriter().info("TryResume returning " + txResumed + " for txId = " + txId + " exists = " + TxHelper.exists(txId));
        context.getResultSender().lastResult((Object)new Boolean(txResumed));
    }

    public String getId() {
        return this.getClass().getName();
    }

    public boolean hasResult() {
        return true;
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public void init(Properties props) {
    }

    public boolean isHA() {
        return false;
    }
}

