/*
 * Decompiled with CFR 0.152.
 */
package roles;

import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.RegionRoleListener;
import com.gemstone.gemfire.cache.RoleEvent;
import hydra.Log;
import java.util.Properties;
import roles.RolesBB;
import util.AbstractListener;

public class RegionListener
extends AbstractListener
implements RegionRoleListener,
Declarable {
    public void afterRoleGain(RoleEvent event) {
        this.logCall("afterRoleGain", (CacheEvent)event);
        long count = RolesBB.getBB().getSharedCounters().incrementAndRead(RolesBB.actualRoleGainEvents);
        Log.getLogWriter().info("After incrementing counter, actualRoleGainEvents = " + count);
        String key = RolesBB.RegionAvailablePrefix + System.getProperty("clientName");
        RolesBB.getBB().getSharedMap().put(key, new Boolean(true));
        RolesBB.getBB().printSharedMap();
    }

    public void afterRoleLoss(RoleEvent event) {
        this.logCall("afterRoleLoss", (CacheEvent)event);
        long count = RolesBB.getBB().getSharedCounters().incrementAndRead(RolesBB.actualRoleLossEvents);
        Log.getLogWriter().info("After incrementing counter, actualRoleLossEvents = " + count);
        String key = RolesBB.RegionAvailablePrefix + System.getProperty("clientName");
        RolesBB.getBB().getSharedMap().put(key, new Boolean(false));
        RolesBB.getBB().printSharedMap();
    }

    public void afterCreate(EntryEvent event) {
        this.logCall("afterCreate", (CacheEvent)event);
        this.countQueuedEvents((CacheEvent)event);
    }

    public void afterDestroy(EntryEvent event) {
        this.logCall("afterDestroy", (CacheEvent)event);
        this.countQueuedEvents((CacheEvent)event);
    }

    public void afterInvalidate(EntryEvent event) {
        this.logCall("afterInvalidate", (CacheEvent)event);
        this.countQueuedEvents((CacheEvent)event);
    }

    public void afterRegionDestroy(RegionEvent event) {
        this.logCall("afterRegionDestroy", (CacheEvent)event);
        this.countQueuedEvents((CacheEvent)event);
    }

    public void afterRegionInvalidate(RegionEvent event) {
        this.logCall("afterRegionInvalidate", (CacheEvent)event);
        this.countQueuedEvents((CacheEvent)event);
    }

    public void afterUpdate(EntryEvent event) {
        this.logCall("afterUpdate", (CacheEvent)event);
        this.countQueuedEvents((CacheEvent)event);
    }

    public void close() {
        this.logCall("close", null);
    }

    public void afterRegionClear(RegionEvent event) {
        this.logCall("afterRegionClear", (CacheEvent)event);
        this.countQueuedEvents((CacheEvent)event);
    }

    public void afterRegionCreate(RegionEvent event) {
        this.logCall("afterRegionCreate", (CacheEvent)event);
        this.countQueuedEvents((CacheEvent)event);
    }

    public void afterRegionLive(RegionEvent event) {
        this.logCall("afterRegionLive", (CacheEvent)event);
        this.countQueuedEvents((CacheEvent)event);
    }

    private void countQueuedEvents(CacheEvent event) {
    }

    public void init(Properties prop) {
        this.logCall("init(Properties)", null);
    }
}

