/*
 * Decompiled with CFR 0.152.
 */
package roles;

import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.Log;
import hydra.MasterController;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import roles.RolesBB;
import roles.RolesPrms;
import util.CacheUtil;
import util.TestException;
import util.TestHelper;

public class RolesTest {
    public static void EndTask_validateReliableQueuedOps() {
        long expected = RolesBB.getBB().getSharedCounters().read(RolesBB.expectedQueuedEvents);
        long actual = RolesBB.getBB().getSharedCounters().read(RolesBB.actualQueuedEvents);
        if (actual < expected) {
            throw new TestException("Expected to receive at least " + expected + " queued Operations, but received " + actual);
        }
        Log.getLogWriter().info("reliableOps delivery validated: expected at least " + expected + " events, received " + actual);
    }

    public static void EndTask_validateRoleChangeEvents() {
        SharedCounters sc = RolesBB.getBB().getSharedCounters();
        long expected = sc.read(RolesBB.expectedRoleLossEvents);
        long actual = sc.read(RolesBB.actualRoleLossEvents);
        if (actual < (expected *= (long)(TestHelper.getNumVMs() - 1))) {
            throw new TestException("Expected to receive at least " + expected + " RoleLoss events, but instead received " + actual);
        }
        Log.getLogWriter().info("RoleLossEvents delivery validated: expected at least " + expected + " events, received " + actual);
        expected = sc.read(RolesBB.expectedRoleGainEvents);
        actual = sc.read(RolesBB.actualRoleGainEvents);
        if (actual < (expected *= (long)(TestHelper.getNumVMs() - 1))) {
            throw new TestException("Expected to receive " + expected + " RoleGain events, but instead received " + actual);
        }
        Log.getLogWriter().info("RoleGainEvents delivery validated: expected at least " + expected + " events, received " + actual);
    }

    public static void EndTask_validateRegionRoleExceptionsProcessed() {
        SharedCounters sc = RolesBB.getBB().getSharedCounters();
        long regionAccessExceptions = sc.read(RolesBB.regionAccessExceptions);
        long regionDistributionExceptions = sc.read(RolesBB.regionDistributionExceptions);
        StringBuffer aStr = new StringBuffer();
        if (regionAccessExceptions == 0L) {
            aStr.append("Test may not have caused any RegionAccessExceptions: regionAccessExceptions = " + regionAccessExceptions + "\n");
        }
        if (regionDistributionExceptions == 0L) {
            aStr.append("Test may not have caused any RegionDistributionExceptions: regionDistributionExceptions = " + regionDistributionExceptions + "\n");
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
        Log.getLogWriter().info("Test processed " + regionAccessExceptions + " RegionAccessExceptions and " + regionDistributionExceptions + " RegionDistributionExceptions");
    }

    public static void stopAndStartClient() throws ClientVmNotFoundException {
        RolesTest.stopClient();
        MasterController.sleepForMs(10000);
        long counter = RolesBB.getBB().getSharedCounters().add(RolesBB.expectedQueuedEvents, (long)RolesTest.getNumQueuedOps());
        Log.getLogWriter().info("After incrementing counter, expectedQueuedEvents = " + counter);
        RolesTest.startClient();
        MasterController.sleepForMs(10000);
    }

    public static void stopClientAsync() throws ClientVmNotFoundException {
        String stopMode = TestConfig.tab().stringAt(RolesPrms.stopMode, "MEAN_KILL");
        String startMode = TestConfig.tab().stringAt(RolesPrms.startMode, "ON_DEMAND");
        Long key = RolesPrms.clientsToStop;
        String clientToStop = TestConfig.tasktab().stringAt(key, TestConfig.tab().stringAt(key));
        ClientVmInfo info = ClientVmMgr.stopAsync("stop client", ClientVmMgr.toStopMode(stopMode), ClientVmMgr.toStartMode(startMode), new ClientVmInfo(null, clientToStop, null));
        Log.getLogWriter().info("stopped client " + info);
        long count = RolesBB.getBB().getSharedCounters().incrementAndRead(RolesBB.expectedRoleLossEvents);
        Log.getLogWriter().info("after incrementing counter, RolesBB.expectedRoleLossEvents = " + count);
    }

    public static void startClientAsync() throws ClientVmNotFoundException {
        try {
            ClientVmInfo clientVmInfo = ClientVmMgr.startAsync("start client");
        }
        catch (ClientVmNotFoundException e) {
            Log.getLogWriter().info("Could not start consumer, perhaps no vms waiting to be started, continuing");
        }
        long count = RolesBB.getBB().getSharedCounters().incrementAndRead(RolesBB.expectedRoleGainEvents);
        Log.getLogWriter().info("after incrementing counter, RolesBB.expectedRoleGainEvents = " + count);
    }

    public static void stopClient() throws ClientVmNotFoundException {
        String stopMode = TestConfig.tab().stringAt(RolesPrms.stopMode, "MEAN_KILL");
        String startMode = TestConfig.tab().stringAt(RolesPrms.startMode, "ON_DEMAND");
        Long key = RolesPrms.clientsToStop;
        String clientToStop = TestConfig.tasktab().stringAt(key, TestConfig.tab().stringAt(key));
        ClientVmInfo info = ClientVmMgr.stop("stop client", ClientVmMgr.toStopMode(stopMode), ClientVmMgr.toStartMode(startMode), new ClientVmInfo(null, clientToStop, null));
        Log.getLogWriter().info("stopped client" + info);
        long count = RolesBB.getBB().getSharedCounters().incrementAndRead(RolesBB.expectedRoleLossEvents);
        Log.getLogWriter().info("after incrementing counter, RolesBB.expectedRoleLossEvents = " + count);
    }

    public static void startClient() throws ClientVmNotFoundException {
        try {
            ClientVmInfo clientVmInfo = ClientVmMgr.start("start client");
        }
        catch (ClientVmNotFoundException e) {
            Log.getLogWriter().info("Could not start client!");
        }
        long count = RolesBB.getBB().getSharedCounters().incrementAndRead(RolesBB.expectedRoleGainEvents);
        Log.getLogWriter().info("after incrementing counter, RolesBB.expectedRoleGainEvents = " + count);
    }

    public static double getNumQueuedOps() {
        GemFireCacheImpl myCache = (GemFireCacheImpl)CacheUtil.getCache();
        CachePerfStats stats = myCache.getCachePerfStats();
        int reliableQueuedOps = stats.getReliableQueuedOps();
        Log.getLogWriter().info("GemFireCache.getCachePerfStats().getReliableQueuedOps() returns " + reliableQueuedOps);
        return reliableQueuedOps;
    }
}

