/*
 * Decompiled with CFR 0.152.
 */
package rollingupgrade;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.GemFireVersion;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.shared.Version;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ConfigPrms;
import hydra.DiskStoreDescription;
import hydra.DistributedSystemHelper;
import hydra.HydraThreadGroup;
import hydra.Log;
import hydra.MasterController;
import hydra.PoolDescription;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parReg.ParRegUtil;
import rollingupgrade.RollingUpgradeBB;
import rollingupgrade.RollingUpgradePrms;
import util.BaseValueHolder;
import util.DeclarativeGenerator;
import util.NameFactory;
import util.OperationsClient;
import util.SilenceListener;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;

public class RollingUpgradeTest
extends OperationsClient {
    private static RollingUpgradeTest testInstance = new RollingUpgradeTest();
    protected List<Region> allRegions = new ArrayList<Region>();
    static Cache theCache = null;
    private static final String xmlFileNameKeyPrefix = "xmlForVmId_";
    private static final String allRegionsSnapshotKey = "allRegionsSnapshot";

    public static synchronized void HydraTask_createLocator() throws Throwable {
        DistributedSystemHelper.createLocator();
    }

    public static synchronized void HydraTask_startLocatorAndDS() throws Throwable {
        DistributedSystemHelper.startLocatorAndDS();
    }

    public static synchronized void HydraTask_initialize() {
        testInstance = new RollingUpgradeTest();
        theCache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
        Log.getLogWriter().info("The cache: " + theCache);
        Log.getLogWriter().info("Current gemfire version: " + Version.CURRENT);
        RollingUpgradeTest.createRegions();
        if (ConfigPrms.getBridgeConfig() != null) {
            BridgeHelper.startBridgeServer("bridge");
        } else {
            RollingUpgradeTest.registerInterest();
        }
        Log.getLogWriter().info("Use cache xml :" + TestConfig.tab().booleanAt(RollingUpgradePrms.useCacheXml, false));
        if (TestConfig.tab().booleanAt(RollingUpgradePrms.useCacheXml, false)) {
            Log.getLogWriter().info("Generating cache xml");
            if (ConfigPrms.getBridgeConfig() != null) {
                RollingUpgradeTest.HydraTask_createXmlFile();
            } else {
                RollingUpgradeTest.createXmlFile_Client(ConfigPrms.getRegionConfig(), ConfigPrms.getCacheConfig());
            }
        }
    }

    public static synchronized void HydraTask_initializeWithXml() {
        RollingUpgradeTest.createRegionsWithXml();
        String tgname = RemoteTestModule.getCurrentThread().getThreadGroupName();
        Log.getLogWriter().info("Current thread groip name is: " + tgname);
        if (tgname.equals("edge")) {
            RollingUpgradeTest.registerInterest();
        }
    }

    public static synchronized void HydraTask_initController() {
        testInstance = new RollingUpgradeTest();
    }

    protected static void registerInterest() {
        Log.getLogWriter().info("Calling registerInterest for different regions");
        Set rootRegions = CacheHelper.getCache().rootRegions();
        for (Region aRegion : rootRegions) {
            Log.getLogWriter().info("Calling registerInterest for all keys, result interest policy KEYS_VALUES for region " + aRegion.getFullPath());
            aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
            Log.getLogWriter().info("Done calling registerInterest for all keys, result interest policy KEYS_VALUES, " + aRegion.getFullPath() + " size is " + aRegion.size());
        }
    }

    private static void createRegions() {
        String regionConfig = ConfigPrms.getRegionConfig();
        Region aRegion = RegionHelper.createRegion(regionConfig);
        Log.getLogWriter().info("Root regions in the cache: " + CacheHelper.getCache().rootRegions().toString());
        RollingUpgradeTest.testInstance.allRegions.add(aRegion);
    }

    protected static String getXmlFileName(int vmId) {
        String xmlFileNamePrefix = "vmId_";
        String fileName = "vmId_" + vmId + ".xml";
        return fileName;
    }

    public static synchronized void HydraTask_createXmlFile() {
        String fileName = RollingUpgradeTest.getXmlFileName(RemoteTestModule.getMyVmid());
        File aFile = new File(fileName);
        if (aFile.exists()) {
            return;
        }
        DeclarativeGenerator.createDeclarativeXml(fileName, CacheHelper.getCache(), false, true);
        RollingUpgradeBB.getBB().getSharedMap().put(xmlFileNameKeyPrefix + RemoteTestModule.getMyVmid(), aFile.getAbsolutePath());
    }

    public static synchronized void createXmlFile_Client(String regionDescriptName, String cacheConfig) {
        String fileName = RollingUpgradeTest.getXmlFileName(RemoteTestModule.getMyVmid());
        File aFile = new File(fileName);
        if (aFile.exists()) {
            return;
        }
        PoolDescription poolDescr = RegionHelper.getRegionDescription(regionDescriptName).getPoolDescription();
        DiskStoreDescription desc = RegionHelper.getRegionDescription(regionDescriptName).getDiskStoreDescription();
        String diskStoreName = null;
        if (desc != null) {
            diskStoreName = desc.getName();
        }
        Log.getLogWriter().info("About to generate xml, diskStoreName is " + diskStoreName);
        Log.getLogWriter().info("About to generate xml, poolDescr is " + poolDescr);
        if (poolDescr != null) {
            CacheHelper.generateCacheXmlFile(cacheConfig, null, regionDescriptName, null, null, poolDescr.getName(), diskStoreName, null, fileName);
        }
        RollingUpgradeBB.getBB().getSharedMap().put(xmlFileNameKeyPrefix + RemoteTestModule.getMyVmid(), aFile.getAbsolutePath());
    }

    private static void createRegionsWithXml() {
        String bbKey = xmlFileNameKeyPrefix + RemoteTestModule.getMyVmid();
        String xmlFilePath = (String)RollingUpgradeBB.getBB().getSharedMap().get(bbKey);
        theCache = CacheHelper.createCacheFromXml(xmlFilePath);
        Log.getLogWriter().info(TestHelper.regionHierarchyToString());
    }

    public static void HydraTask_doOperationsAndPauseVerify() {
        testInstance.doOperationsAndPauseVerify();
    }

    public static void HydraTask_doOperations() {
        testInstance.doOperations();
    }

    private void doOperations() {
        long opsTaskGranularitySec = TestConfig.tab().longAt(RollingUpgradePrms.opsTaskGranularitySec);
        long minTaskGranularityMS = opsTaskGranularitySec * 1000L;
        this.performOps(minTaskGranularityMS);
        if (RollingUpgradeBB.getBB().getSharedCounters().read(RollingUpgradeBB.recycledAllVMs) != 0L) {
            throw new StopSchedulingTaskOnClientOrder("All vms have paused");
        }
    }

    private void doOperationsAndPauseVerify() {
        int numTotalVMs = StopStartVMs.getAllVMs().size();
        long opsTaskGranularitySec = TestConfig.tab().longAt(RollingUpgradePrms.opsTaskGranularitySec);
        long minTaskGranularityMS = opsTaskGranularitySec * 1000L;
        if (RollingUpgradeBB.getBB().getSharedCounters().read(RollingUpgradeBB.pausing) == 0L) {
            this.performOps(minTaskGranularityMS);
        }
        Log.getLogWriter().info("Done performing one invocation of performOps()");
        if (RollingUpgradeBB.getBB().getSharedCounters().read(RollingUpgradeBB.pausing) > 0L) {
            RollingUpgradeBB.getBB().getSharedCounters().increment(RollingUpgradeBB.pausing);
            HydraThreadGroup tg1 = TestConfig.getInstance().getThreadGroup("bridge");
            HydraThreadGroup tg2 = TestConfig.getInstance().getThreadGroup("edge");
            int threadCount = tg1.getTotalThreads() + tg2.getTotalThreads();
            int desiredCounterValue = threadCount + 1;
            TestHelper.waitForCounter(RollingUpgradeBB.getBB(), "RollingUpgradeBB.pausing", RollingUpgradeBB.pausing, desiredCounterValue, true, -1L, 2000L);
            SilenceListener.waitForSilence(30L, 2000L);
            long leader = RollingUpgradeBB.getBB().getSharedCounters().incrementAndRead(RollingUpgradeBB.leader);
            if (leader == 1L) {
                this.writeSnapshot();
                RollingUpgradeBB.getBB().getSharedCounters().increment(RollingUpgradeBB.snapshotWritten);
                RollingUpgradeBB.getBB().getSharedCounters().decrement(RollingUpgradeBB.pausing);
            } else {
                TestHelper.waitForCounter(RollingUpgradeBB.getBB(), "RollingUpgradeBB.snapshotWritten", RollingUpgradeBB.snapshotWritten, 1L, true, -1L, 2000L);
                this.verifyFromSnapshot();
                RollingUpgradeBB.getBB().getSharedCounters().decrement(RollingUpgradeBB.pausing);
            }
            if (RollingUpgradeBB.getBB().getSharedCounters().read(RollingUpgradeBB.pausing) == 1L) {
                RollingUpgradeBB.getBB().getSharedCounters().setIfSmaller(RollingUpgradeBB.pausing, 0L);
            }
            TestHelper.waitForCounter(RollingUpgradeBB.getBB(), "RollingUpgradeBB.pausing", RollingUpgradeBB.pausing, 0L, true, -1L, 2000L);
        }
        if (RollingUpgradeBB.getBB().getSharedCounters().read(RollingUpgradeBB.recycledAllVMs) != 0L) {
            throw new StopSchedulingTaskOnClientOrder("All vms have paused");
        }
    }

    private void performOps(long taskTimeMS) {
        super.initializeOperationsClient();
        Cache theCache = CacheHelper.getCache();
        if (theCache == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        do {
            Set rootRegions = theCache.rootRegions();
            for (Region aRegion : rootRegions) {
                super.doEntryOperations(aRegion);
            }
            Log.getLogWriter().info("Done performing one batch of operations");
        } while (System.currentTimeMillis() - startTime < taskTimeMS);
    }

    public static void HydraTask_UpgradeController() {
        testInstance.rollUpgradeVMs(true);
    }

    public static void HydraTask_UpgradeControllerNoVerify() {
        testInstance.rollUpgradeVMs(false);
    }

    public static void HydraTask_verifySnapshot() {
        testInstance.verifySnapshot();
    }

    private void rollUpgradeVMs(boolean waitForVerification) {
        List locatorVMs = StopStartVMs.getMatchVMs(StopStartVMs.getAllVMs(), "locator");
        List bridgeVMs = StopStartVMs.getMatchVMs(StopStartVMs.getAllVMs(), "bridge");
        List edgeVMs = StopStartVMs.getMatchVMs(StopStartVMs.getAllVMs(), "edge");
        do {
            if (waitForVerification) {
                TestHelper.waitForCounter(RollingUpgradeBB.getBB(), "RollingUpgradeBB.pausing", RollingUpgradeBB.pausing, 0L, true, -1L, 2000L);
            }
            ClientVmInfo vmInfo = null;
            if (locatorVMs.size() != 0) {
                vmInfo = (ClientVmInfo)locatorVMs.get(0);
                locatorVMs.remove(0);
            } else if (bridgeVMs.size() != 0) {
                vmInfo = (ClientVmInfo)bridgeVMs.get(0);
                bridgeVMs.remove(0);
            } else if (edgeVMs.size() != 0) {
                vmInfo = (ClientVmInfo)edgeVMs.get(0);
                edgeVMs.remove(0);
            }
            MasterController.sleepForMs(15000);
            StopStartVMs.stopVM(vmInfo, "nice_exit");
            Log.getLogWriter().info("Sleeping for 2 seconds to allow ops to run...");
            MasterController.sleepForMs(2000);
            StopStartVMs.startVM(vmInfo);
            MasterController.sleepForMs(15000);
            if (waitForVerification) {
                RollingUpgradeBB.getBB().getSharedCounters().setIfSmaller(RollingUpgradeBB.snapshotWritten, 0L);
                RollingUpgradeBB.getBB().getSharedCounters().setIfSmaller(RollingUpgradeBB.leader, 0L);
                RollingUpgradeBB.getBB().getSharedCounters().increment(RollingUpgradeBB.pausing);
            }
            Log.getLogWriter().info("Locator VMs size: " + locatorVMs.size());
            Log.getLogWriter().info("Bridge VMs size: " + bridgeVMs.size());
            Log.getLogWriter().info("Edge VMs size: " + edgeVMs.size());
        } while (locatorVMs.size() != 0 || bridgeVMs.size() != 0 || edgeVMs.size() != 0);
        RollingUpgradeBB.getBB().getSharedCounters().increment(RollingUpgradeBB.recycledAllVMs);
    }

    public static void HydraTask_UpgradeLocators() throws Exception {
        if (testInstance == null) {
            testInstance = new RollingUpgradeTest();
        }
        testInstance.upgradeLocators();
    }

    private void upgradeLocators() throws Exception {
        List vmInfoList = StopStartVMs.getAllVMs();
        int myVmID = RemoteTestModule.getMyVmid();
        ArrayList<ClientVmInfo> locatorVMs = new ArrayList<ClientVmInfo>();
        Log.getLogWriter().info("VMInfo list" + vmInfoList);
        for (int i = 0; i < vmInfoList.size(); ++i) {
            Object anObj = vmInfoList.get(i);
            Log.getLogWriter().info("VM info obj :" + anObj);
            if (!(anObj instanceof ClientVmInfo)) continue;
            ClientVmInfo info = (ClientVmInfo)anObj;
            Log.getLogWriter().info("info.getClientName()" + info.getClientName());
            if (info.getClientName().indexOf("locator") < 0 || info.getVmid() == myVmID) continue;
            locatorVMs.add(info);
        }
        Log.getLogWriter().info("locatorVMs" + locatorVMs);
        while (locatorVMs.size() != 0) {
            ClientVmInfo vmInfo = null;
            if (locatorVMs.size() != 0) {
                vmInfo = (ClientVmInfo)locatorVMs.get(0);
                locatorVMs.remove(0);
            }
            MasterController.sleepForMs(15000);
            StopStartVMs.stopVM(vmInfo, "nice_exit");
            Log.getLogWriter().info("Sleeping for 2 seconds to allow ops to run...");
            MasterController.sleepForMs(2000);
            StopStartVMs.startVM(vmInfo);
            MasterController.sleepForMs(15000);
            Log.getLogWriter().info("Locator VMs size: " + locatorVMs.size());
        }
        MasterController.sleepForMs(15000);
        ClientVmMgr.stopAsync("Killing self at version: " + GemFireVersion.getGemFireVersion(), -20, -30);
    }

    private void verifySnapshot() {
        SilenceListener.waitForSilence(60L, 2000L);
        long leader = RollingUpgradeBB.getBB().getSharedCounters().incrementAndRead(RollingUpgradeBB.leader);
        if (leader == 1L) {
            this.writeSnapshot();
            RollingUpgradeBB.getBB().getSharedCounters().increment(RollingUpgradeBB.snapshotWritten);
        } else {
            TestHelper.waitForCounter(RollingUpgradeBB.getBB(), "RollingUpgradeBB.snapshotWritten", RollingUpgradeBB.snapshotWritten, 1L, true, -1L, 2000L);
            this.verifyFromSnapshot();
        }
    }

    Map writeSnapshot() {
        HashMap allRegionsSnapshot = new HashMap();
        Set regions = CacheHelper.getCache().rootRegions();
        Log.getLogWriter().info("Preparing to write snapshot for " + regions.size() + " regions");
        for (Region aRegion : regions) {
            HashMap regionSnapshot = new HashMap();
            for (Object key : aRegion.keySet()) {
                Object value = null;
                if (aRegion.containsValueForKey(key)) {
                    value = aRegion.get(key);
                }
                if (value instanceof BaseValueHolder) {
                    regionSnapshot.put(key, ((BaseValueHolder)value).myValue);
                    continue;
                }
                regionSnapshot.put(key, value);
            }
            allRegionsSnapshot.put(aRegion.getFullPath(), regionSnapshot);
            Log.getLogWriter().info("Region snapshot for " + aRegion.getFullPath() + " is size " + regionSnapshot.size() + " and contains keys " + regionSnapshot.keySet());
        }
        RollingUpgradeBB.getBB().getSharedMap().put(allRegionsSnapshotKey, allRegionsSnapshot);
        Log.getLogWriter().info("Put snapshot for " + regions.size() + " regions into blackboard at key " + allRegionsSnapshotKey);
        return allRegionsSnapshot;
    }

    protected void verifyFromSnapshot() {
        Map allRegionsSnapshot = (Map)RollingUpgradeBB.getBB().getSharedMap().get(allRegionsSnapshotKey);
        if (allRegionsSnapshot == null) {
            Log.getLogWriter().info("Not verifying from snapshot because the snapshot in the blackboard is null");
            return;
        }
        Set snapshotRegionNames = allRegionsSnapshot.keySet();
        HashSet<String> definedRegionNames = new HashSet<String>();
        for (Region aRegion : theCache.rootRegions()) {
            definedRegionNames.add(aRegion.getFullPath());
            Set subRegSet = aRegion.subregions(true);
            for (Region subReg : subRegSet) {
                definedRegionNames.add(subReg.getFullPath());
            }
        }
        HashSet missingRegionsInCache = new HashSet(snapshotRegionNames);
        missingRegionsInCache.removeAll(definedRegionNames);
        HashSet extraRegionsInCache = new HashSet(definedRegionNames);
        extraRegionsInCache.removeAll(snapshotRegionNames);
        if (missingRegionsInCache.size() != 0) {
            throw new TestException("Expected to find regions " + missingRegionsInCache + " defined in cache");
        }
        if (extraRegionsInCache.size() != 0) {
            throw new TestException("Found unexpected regions defined in cache: " + extraRegionsInCache);
        }
        for (String regionName : allRegionsSnapshot.keySet()) {
            Map regionSnapshot = (Map)allRegionsSnapshot.get(regionName);
            Region aRegion = theCache.getRegion(regionName);
            if (aRegion == null) {
                throw new TestException("Region " + regionName + " could not be found in cache");
            }
            this.verifyFromSnapshot(aRegion, regionSnapshot);
        }
    }

    public void verifyFromSnapshot(Region aRegion, Map regionSnapshot) {
        StringBuffer errStr = new StringBuffer();
        int snapshotSize = regionSnapshot.size();
        int regionSize = aRegion.size();
        long startVerifyTime = System.currentTimeMillis();
        Log.getLogWriter().info("Verifying " + aRegion.getFullPath() + "  of size " + aRegion.size() + " against snapshot containing " + regionSnapshot.size() + " entries...");
        if (snapshotSize != regionSize) {
            ((LocalRegion)aRegion).dumpBackingMap();
            errStr.append("Expected region " + aRegion.getFullPath() + " to be size " + snapshotSize + ", but it is " + regionSize + "\n");
        }
        for (Object key : regionSnapshot.keySet()) {
            try {
                ParRegUtil.verifyContainsKey(aRegion, key, true);
            }
            catch (TestException e) {
                errStr.append(e.getMessage() + "\n");
            }
            boolean containsValueForKey = aRegion.containsValueForKey(key);
            Object expectedValue = regionSnapshot.get(key);
            try {
                ParRegUtil.verifyContainsValueForKey(aRegion, key, expectedValue != null);
            }
            catch (TestException e) {
                errStr.append(e.getMessage() + "\n");
            }
            if (!containsValueForKey) continue;
            try {
                Object actualValue = aRegion.get(key);
                if (actualValue instanceof BaseValueHolder) {
                    ParRegUtil.verifyMyValue(key, expectedValue, actualValue, ParRegUtil.EQUAL);
                    continue;
                }
                if (actualValue instanceof byte[] && expectedValue instanceof byte[]) {
                    byte[] actual = (byte[])actualValue;
                    byte[] expected = (byte[])expectedValue;
                    if (actual.length == expected.length) continue;
                    throw new TestException("Expected value for key " + key + " to be " + TestHelper.toString(expectedValue) + ", but it is " + TestHelper.toString(actualValue));
                }
                throw new TestException("Expected value for key " + key + " to be " + TestHelper.toString(expectedValue) + ", but it is " + TestHelper.toString(actualValue));
            }
            catch (TestException e) {
                errStr.append(e.getMessage() + "\n");
            }
        }
        HashSet aRegionKeySet = new HashSet(aRegion.keySet());
        Set snapshotKeySet = regionSnapshot.keySet();
        aRegionKeySet.removeAll(snapshotKeySet);
        if (aRegionKeySet.size() != 0) {
            errStr.append("Found the following unexpected keys in " + aRegion.getFullPath() + ": " + aRegionKeySet + "\n");
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
        Log.getLogWriter().info("Done verifying " + aRegion.getFullPath() + " from snapshot containing " + snapshotSize + " entries, " + "verification took " + (System.currentTimeMillis() - startVerifyTime) + "ms");
    }

    public static void HydraTask_loadRegions() {
        testInstance.loadRegions();
    }

    public void loadRegions() {
        Log.getLogWriter().info("cache : " + CacheHelper.getCache());
        Set rootRegions = CacheHelper.getCache().rootRegions();
        long numToLoadPerRegion = RollingUpgradePrms.getNumToLoad();
        HashMap<String, BaseValueHolder> putAllMap = new HashMap<String, BaseValueHolder>();
        int putAllMapMaximum = 500;
        Log.getLogWriter().info("rootRegions : " + rootRegions);
        Log.getLogWriter().info("Creating " + numToLoadPerRegion + " entries in each of " + rootRegions.size() + " regions...");
        long loadCoordinator = RollingUpgradeBB.getBB().getSharedCounters().incrementAndRead(RollingUpgradeBB.loadCoordinator);
        while (loadCoordinator <= numToLoadPerRegion) {
            String key = NameFactory.getNextPositiveObjectName();
            BaseValueHolder value = this.getValueForKey(key);
            putAllMap.put(key, value);
            if (putAllMap.size() >= 500) {
                for (Region aRegion : rootRegions) {
                    Log.getLogWriter().info("Putting(1) " + putAllMap.size() + " entries into " + aRegion.getFullPath());
                    aRegion.putAll(putAllMap);
                }
                putAllMap = new HashMap();
            }
            loadCoordinator = RollingUpgradeBB.getBB().getSharedCounters().incrementAndRead(RollingUpgradeBB.loadCoordinator);
        }
        if (putAllMap.size() > 0) {
            for (Region aRegion : rootRegions) {
                Log.getLogWriter().info("Putting(2) " + putAllMap.size() + " entries into " + aRegion.getFullPath());
                aRegion.putAll(putAllMap);
            }
        }
        Log.getLogWriter().info(TestHelper.regionHierarchyToString());
    }
}

