/*
 * Decompiled with CFR 0.152.
 */
package security;

import hydra.EnvHelper;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import security.CredentialGenerator;

public class PKCSCredentialGenerator
extends CredentialGenerator {
    public static String keyStoreDir = PKCSCredentialGenerator.getKeyStoreDir();
    public static boolean usesIBMJSSE;

    private static boolean usesIBMProviders() {
        Provider[] providers = Security.getProviders();
        for (int index = 0; index < providers.length; ++index) {
            if (providers[index].getName().toLowerCase().startsWith("ibm")) continue;
            return false;
        }
        return true;
    }

    private static String getKeyStoreDir() {
        usesIBMJSSE = PKCSCredentialGenerator.usesIBMProviders();
        if (usesIBMJSSE) {
            return "/lib/keys/ibm";
        }
        return "/lib/keys";
    }

    @Override
    public CredentialGenerator.ClassCode classCode() {
        return CredentialGenerator.ClassCode.PKCS;
    }

    @Override
    public String getAuthInit() {
        return "templates.security.PKCSAuthInit.create";
    }

    @Override
    public String getAuthenticator() {
        return "templates.security.PKCSAuthenticator.create";
    }

    @Override
    public Properties getInvalidCredentials(int index) {
        Properties props = new Properties();
        String keyStoreFile = "$JTESTS" + keyStoreDir + "/gemfire11.keystore";
        props.setProperty("security-keystorepath", EnvHelper.expandPath(keyStoreFile));
        props.setProperty("security-alias", "gemfire11");
        props.setProperty("security-keystorepass", "gemfire");
        return props;
    }

    @Override
    public Properties getValidCredentials(int index) {
        Properties props = new Properties();
        int aliasnum = index % 10 + 1;
        String keyStoreFile = "$JTESTS" + keyStoreDir + "/gemfire" + aliasnum + ".keystore";
        props.setProperty("security-keystorepath", EnvHelper.expandPath(keyStoreFile));
        props.setProperty("security-alias", "gemfire" + aliasnum);
        props.setProperty("security-keystorepass", "gemfire");
        return props;
    }

    @Override
    public Properties getValidCredentials(Principal principal) {
        Properties props = new Properties();
        String keyStoreFile = "$JTESTS" + keyStoreDir + "/" + principal.getName() + ".keystore";
        props.setProperty("security-keystorepath", EnvHelper.expandPath(keyStoreFile));
        props.setProperty("security-alias", principal.getName());
        props.setProperty("security-keystorepass", "gemfire");
        return props;
    }

    @Override
    protected Properties initialize() throws IllegalArgumentException {
        Properties props = new Properties();
        String keyStoreFile = "$JTESTS" + keyStoreDir + "/publickeyfile";
        props.setProperty("security-publickey-filepath", EnvHelper.expandPath(keyStoreFile));
        props.setProperty("security-publickey-pass", "gemfire");
        return props;
    }
}

