/*
 * Decompiled with CFR 0.152.
 */
package security;

import com.gemstone.gemfire.security.AuthenticationFailedException;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.Properties;
import security.CredentialGenerator;

public class SSLCredentialGenerator
extends CredentialGenerator {
    private File findTrustedJKS() {
        File ssldir = new File(System.getProperty("JTESTS") + "/ssl");
        return new File(ssldir, "trusted.keystore");
    }

    private File findUntrustedJKS() {
        File ssldir = new File(System.getProperty("JTESTS") + "/ssl");
        return new File(ssldir, "untrusted.keystore");
    }

    private Properties getValidJavaSSLProperties() {
        File jks = this.findTrustedJKS();
        try {
            Properties props = new Properties();
            props.setProperty("javax.net.ssl.trustStore", jks.getCanonicalPath());
            props.setProperty("javax.net.ssl.trustStorePassword", "password");
            props.setProperty("javax.net.ssl.keyStore", jks.getCanonicalPath());
            props.setProperty("javax.net.ssl.keyStorePassword", "password");
            return props;
        }
        catch (IOException ex) {
            throw new AuthenticationFailedException("SSL: Exception while opening the key store: " + ex);
        }
    }

    private Properties getInvalidJavaSSLProperties() {
        File jks = this.findUntrustedJKS();
        try {
            Properties props = new Properties();
            props.setProperty("javax.net.ssl.trustStore", jks.getCanonicalPath());
            props.setProperty("javax.net.ssl.trustStorePassword", "password");
            props.setProperty("javax.net.ssl.keyStore", jks.getCanonicalPath());
            props.setProperty("javax.net.ssl.keyStorePassword", "password");
            return props;
        }
        catch (IOException ex) {
            throw new AuthenticationFailedException("SSL: Exception while opening the key store: " + ex);
        }
    }

    private Properties getSSLProperties() {
        Properties props = new Properties();
        props.setProperty("ssl-enabled", "true");
        props.setProperty("ssl-require-authentication", "true");
        props.setProperty("ssl-ciphers", "SSL_RSA_WITH_RC4_128_MD5");
        props.setProperty("ssl-protocols", "SSLv3");
        return props;
    }

    @Override
    protected Properties initialize() throws IllegalArgumentException {
        this.javaProps = this.getValidJavaSSLProperties();
        return this.getSSLProperties();
    }

    @Override
    public CredentialGenerator.ClassCode classCode() {
        return CredentialGenerator.ClassCode.SSL;
    }

    @Override
    public String getAuthInit() {
        return null;
    }

    @Override
    public String getAuthenticator() {
        return null;
    }

    @Override
    public Properties getValidCredentials(int index) {
        this.javaProps = this.getValidJavaSSLProperties();
        return this.getSSLProperties();
    }

    @Override
    public Properties getValidCredentials(Principal principal) {
        this.javaProps = this.getValidJavaSSLProperties();
        return this.getSSLProperties();
    }

    @Override
    public Properties getInvalidCredentials(int index) {
        this.javaProps = this.getInvalidJavaSSLProperties();
        return this.getSSLProperties();
    }
}

