/*
 * Decompiled with CFR 0.152.
 */
package snapshot;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionedRegionStorageException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.control.RebalanceFactory;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache.control.ResourceManager;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.persistence.PartitionOfflineException;
import com.gemstone.gemfire.cache.snapshot.RegionSnapshotService;
import com.gemstone.gemfire.cache.snapshot.SnapshotFilter;
import com.gemstone.gemfire.cache.snapshot.SnapshotIterator;
import com.gemstone.gemfire.cache.snapshot.SnapshotOptions;
import com.gemstone.gemfire.cache.snapshot.SnapshotReader;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.pdx.PdxInstance;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.FileUtil;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.PartitionDescription;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import parReg.ParRegUtil;
import pdx.PdxTest;
import rebalance.RebalanceUtil;
import snapshot.ImportListener;
import snapshot.ImportWriter;
import snapshot.SnapshotBB;
import snapshot.SnapshotPrms;
import util.AdminHelper;
import util.BaseValueHolder;
import util.CliHelper;
import util.CliHelperPrms;
import util.NameBB;
import util.NameFactory;
import util.PersistenceUtil;
import util.RandomValues;
import util.StopStartPrms;
import util.StopStartVMs;
import util.SummaryLogListener;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.VHDataSerializable;
import util.VHDataSerializableInstantiator;
import util.VHDataSerializer;
import util.ValueHolder;

public class SnapshotTest {
    public static SnapshotTest testInstance = null;
    private static final String STARTING_STEP = "Starting";
    private static final String EXECUTE_OPS_STEP = "ExecuteOps";
    private static final String EXPORT_STEP = "Exporting";
    private static final String RECYCLE_STEP = "Stopping/Starting";
    private static final String IMPORT_STEP = "Importing";
    private static final String VERIFY_STEP = "Verifying";
    private RandomValues randomValues = new RandomValues();
    private boolean uniqueKeys = true;
    private String exportStrategy = null;
    private String restrictSnapshotOperationsTo = null;
    private boolean configuredForSnapshotOps = true;
    private List<Region> allRegions = new ArrayList<Region>();
    private static final String allRegionNamesKey = "allRegions";
    private static final String allRegionsSnapshotKey = "allRegionsSnapshot";
    private static final String snapshotDirPrefix = "snapshotDir";
    private boolean leaderInThisVM = false;
    private boolean cacheClosed = false;
    private boolean isEdgeClient = false;
    private boolean isBridgeServer = false;
    private boolean isPRAccessor = false;
    private boolean useFilterOnExport = false;
    private boolean useFilterOnImport = false;
    private boolean useSnapshotFilter = false;
    private boolean expirationConfigured = false;
    List killTargetVMs = null;
    List dataStoreVMs = null;
    List accessorVMs = null;
    private AtomicInteger verifyCoordinator = new AtomicInteger(0);
    private AtomicInteger startingCoordinator = new AtomicInteger(0);
    private AtomicInteger exportCoordinator = new AtomicInteger(0);
    private AtomicInteger importCoordinator = new AtomicInteger(0);
    private AtomicInteger rebalanceCoordinator = new AtomicInteger(0);
    private static HydraThreadLocal opsCompleted = new HydraThreadLocal();
    private static final String uniqueKeyIndex = "uniqueKeyIndexForThread_";
    protected static final int ENTRY_ADD_OPERATION = 1;
    protected static final int ENTRY_DESTROY_OPERATION = 2;
    protected static final int ENTRY_INVALIDATE_OPERATION = 3;
    protected static final int ENTRY_LOCAL_DESTROY_OPERATION = 4;
    protected static final int ENTRY_LOCAL_INVALIDATE_OPERATION = 5;
    protected static final int ENTRY_UPDATE_OPERATION = 6;
    protected static final int ENTRY_GET_OPERATION = 7;
    protected static final int ENTRY_GET_NEW_OPERATION = 8;
    protected static final int ENTRY_PUTALL_OPERATION = 9;
    protected static final int CACHE_OPERATIONS = 10;
    protected static final String getCallbackPrefix = "Get originated in pid ";
    protected static final String createCallbackPrefix = "Create event originated in pid ";
    protected static final String updateCallbackPrefix = "Update event originated in pid ";
    protected static final String invalidateCallbackPrefix = "Invalidate event originated in pid ";
    protected static final String destroyCallbackPrefix = "Destroy event originated in pid ";
    protected static final String regionInvalidateCallbackPrefix = "Region invalidate event originated in pid ";
    protected static final String regionDestroyCallbackPrefix = "Region destroy event originated in pid ";

    public static synchronized void HydraTask_initialize() throws Throwable {
        if (testInstance == null) {
            int localMaxMemory;
            RegionAttributes attrs;
            String bridgeConfig;
            testInstance = new SnapshotTest();
            Cache theCache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
            Region aRegion = RegionHelper.createRegion(ConfigPrms.getRegionConfig());
            if (aRegion.getAttributes().getPoolName() != null) {
                SnapshotTest.testInstance.isEdgeClient = true;
                aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
                Log.getLogWriter().info("registered interest in ALL_KEYS for " + aRegion.getFullPath());
            }
            if ((bridgeConfig = ConfigPrms.getBridgeConfig()) != null) {
                SnapshotTest.testInstance.isBridgeServer = true;
                BridgeHelper.startBridgeServer(bridgeConfig);
            }
            if ((attrs = aRegion.getAttributes()).getDataPolicy().withPartitioning() && (localMaxMemory = attrs.getPartitionAttributes().getLocalMaxMemory()) == 0) {
                SnapshotTest.testInstance.isPRAccessor = true;
            }
            if (attrs.getEntryIdleTimeout() != ExpirationAttributes.DEFAULT || attrs.getEntryTimeToLive() != ExpirationAttributes.DEFAULT) {
                SnapshotTest.testInstance.expirationConfigured = true;
            }
            testInstance.initializeInstance();
            SnapshotTest.testInstance.allRegions.add(aRegion);
            Log.getLogWriter().info(aRegion.getFullPath() + " containing " + aRegion.size() + " entries has been created");
        }
        testInstance.initializeInstancePerThread();
    }

    public static synchronized void HydraTask_createColocatedRegions() throws Throwable {
        if (testInstance == null) {
            testInstance = new SnapshotTest();
            testInstance.createColocatedRegions();
            testInstance.initializeInstance();
        }
        testInstance.initializeInstancePerThread();
    }

    public void createColocatedRegions() {
        if (CacheHelper.getCache() == null) {
            Cache c = CacheHelper.createCache(ConfigPrms.getCacheConfig());
            String regionConfig = ConfigPrms.getRegionConfig();
            AttributesFactory aFactory = RegionHelper.getAttributesFactory(regionConfig);
            RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
            String regionBase = rd.getRegionName();
            PartitionDescription pd = rd.getPartitionDescription();
            PartitionAttributesFactory prFactory = pd.getPartitionAttributesFactory();
            PartitionAttributes prAttrs = null;
            String colocatedWith = null;
            int numRegions = SnapshotPrms.getNumColocatedRegions();
            for (int i = 0; i < numRegions; ++i) {
                String regionName = regionBase + "_" + (i + 1);
                if (i > 0) {
                    colocatedWith = regionBase + "_" + i;
                    prFactory.setColocatedWith(colocatedWith);
                    prAttrs = prFactory.create();
                    aFactory.setPartitionAttributes(prAttrs);
                }
                Region aRegion = RegionHelper.createRegion(regionName, aFactory);
                Log.getLogWriter().info(aRegion.getFullPath() + " containing " + aRegion.size() + " entries has been created");
                SnapshotTest.testInstance.allRegions.add(aRegion);
            }
        }
    }

    public static void HydraTask_startBridgeServer() {
        BridgeHelper.startBridgeServer(ConfigPrms.getBridgeConfig());
    }

    public static synchronized void HydraTask_initializeController() {
        if (testInstance == null) {
            testInstance = new SnapshotTest();
            testInstance.initializeInstance();
            SnapshotBB.getBB().getSharedMap().put("taskStep", STARTING_STEP);
        }
    }

    private void initializeInstance() {
        this.uniqueKeys = SnapshotPrms.getUseUniqueKeys();
        this.exportStrategy = SnapshotPrms.getExportStrategy();
        this.useFilterOnExport = SnapshotPrms.useFilterOnExport();
        this.useFilterOnImport = SnapshotPrms.useFilterOnImport();
        if (this.useFilterOnExport || this.useFilterOnImport) {
            this.useSnapshotFilter = true;
        }
        if (this.useFilterOnExport) {
            this.useFilterOnImport = false;
        }
        if (this.useFilterOnImport) {
            this.useFilterOnExport = false;
        }
        this.restrictSnapshotOperationsTo = SnapshotPrms.getRestrictSnapshotOperationsTo();
        if (this.restrictSnapshotOperationsTo.equalsIgnoreCase("PRAccessors")) {
            if (!this.isPRAccessor) {
                this.configuredForSnapshotOps = false;
            }
        } else if (this.restrictSnapshotOperationsTo.equalsIgnoreCase("edgeClients")) {
            if (!this.isEdgeClient) {
                this.configuredForSnapshotOps = false;
            }
        } else if (RemoteTestModule.getMyClientName().indexOf("killTarget") >= 0) {
            this.configuredForSnapshotOps = false;
        }
        SnapshotBB.getBB().getSharedMap().put("shutDownAllKey", new Boolean(false));
        if (SnapshotPrms.getRegisterSerializer()) {
            Log.getLogWriter().info("Registering " + VHDataSerializer.class.getName());
            DataSerializer.register(VHDataSerializer.class);
        }
    }

    private void initializeInstancePerThread() {
        opsCompleted.set(new Boolean(false));
        int thisThreadID = RemoteTestModule.getCurrentThread().getThreadId();
        String mapKey = uniqueKeyIndex + thisThreadID;
        Object mapValue = SnapshotBB.getBB().getSharedMap().get(mapKey);
        if (mapValue == null) {
            SnapshotBB.getBB().getSharedMap().put(mapKey, thisThreadID);
        } else {
            SnapshotBB.getBB().getSharedMap().put(mapKey, mapValue);
        }
    }

    public static void HydraTask_loadRegion() {
        SnapshotTest.initPdxClassLoader();
        int numToLoad = SnapshotPrms.getNumToLoad();
        boolean allAddsCompleted = testInstance.loadRegion(numToLoad);
        if (allAddsCompleted) {
            throw new StopSchedulingTaskOnClientOrder("Put " + numToLoad + " entries in each of " + SnapshotTest.testInstance.allRegions.size() + " regions");
        }
    }

    public static void HydraTask_resetUniqueKeyIndex() {
        int myThreadId;
        long max = NameBB.getBB().getSharedCounters().read(NameBB.POSITIVE_NAME_COUNTER);
        int incValue = TestHelper.getNumThreads();
        int myKeyIndexValue = myThreadId = RemoteTestModule.getCurrentThread().getThreadId();
        while ((long)myKeyIndexValue < max) {
            myKeyIndexValue += incValue;
        }
        Log.getLogWriter().info("POSITIVE_NAME_COUNTER = " + max + ", setting this threads uniqueKeyIndex to " + myKeyIndexValue);
        SnapshotBB.getBB().getSharedMap().put(uniqueKeyIndex + myThreadId, myKeyIndexValue);
    }

    public static void HydraTask_snapshotController() {
        testInstance.snapshotController();
        SnapshotBB.getBB().printSharedCounters();
    }

    public static void HydraTask_snapshotResponder() throws Exception {
        SnapshotTest.initPdxClassLoader();
        testInstance.snapshotResponder();
    }

    private static void verifyPRs() {
        StringBuffer aStr = new StringBuffer();
        for (Region aRegion : SnapshotTest.testInstance.allRegions) {
            if (!PartitionRegionHelper.isPartitionedRegion((Region)aRegion)) continue;
            PartitionAttributes prAttrs = aRegion.getAttributes().getPartitionAttributes();
            int redundantCopies = prAttrs.getRedundantCopies();
            Log.getLogWriter().info("Verifying PR " + aRegion.getFullPath() + " with " + redundantCopies + " redundantCopies");
            try {
                ParRegUtil.verifyPRMetaData(aRegion);
            }
            catch (Exception e) {
                aStr.append(TestHelper.getStackTrace(e) + "\n");
            }
            catch (TestException e) {
                aStr.append(TestHelper.getStackTrace(e) + "\n");
            }
            try {
                ParRegUtil.verifyPrimariesWithWait(aRegion, redundantCopies);
            }
            catch (Exception e) {
                aStr.append(e.toString() + "\n");
            }
            try {
                ParRegUtil.verifyBucketCopies(aRegion, redundantCopies);
            }
            catch (Exception e) {
                aStr.append(e.toString() + "\n");
            }
            catch (TestException e) {
                aStr.append(e.toString() + "\n");
            }
            try {
                SnapshotTest.verifyColocatedRegions(aRegion);
            }
            catch (Exception e) {
                aStr.append(e.toString() + "\n");
            }
            catch (TestException e) {
                aStr.append(e.toString() + "\n");
            }
            if (aStr.length() > 0) {
                throw new TestException(aStr.toString());
            }
            Log.getLogWriter().info("Done verifying PR internal consistency for " + aRegion.getFullPath());
        }
    }

    private static void verifyColocatedRegions(Region regionA) {
        Object[] keys = PartitionRegionHelper.getLocalPrimaryData((Region)regionA).keySet().toArray();
        Map colocatedRegionsMap = PartitionRegionHelper.getColocatedRegions((Region)regionA);
        Object[] regionNames = colocatedRegionsMap.keySet().toArray();
        Log.getLogWriter().info("Verifying PR " + regionA.getFullPath() + " with " + colocatedRegionsMap.size() + " colocated regions");
        for (Object regionName : regionNames) {
            Region regionB = (Region)colocatedRegionsMap.get(regionName);
            for (Object aKey : keys) {
                DistributedMember primaryA = PartitionRegionHelper.getPrimaryMemberForKey((Region)regionA, (Object)aKey);
                DistributedMember primaryB = PartitionRegionHelper.getPrimaryMemberForKey((Region)regionB, (Object)aKey);
                if (primaryB == null || primaryA.equals(primaryB)) continue;
                throw new TestException("verifyColocatedRegions reports that primary for " + aKey + " is " + primaryA + " for " + regionA.getName() + ", but the primary for the same entry in " + regionB.getName() + " is " + primaryB);
            }
            Log.getLogWriter().info("Done verifying consistency in colocated regions");
        }
    }

    private void snapshotController() {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        String currentTaskStep = (String)SnapshotBB.getBB().getSharedMap().get("taskStep");
        Log.getLogWriter().info("In snapshotController, currentTaskStep is " + currentTaskStep);
        int numTestManagedLocatorThreads = 0;
        if (!TestConfig.tab().booleanAt(Prms.manageLocatorAgents)) {
            numTestManagedLocatorThreads = 2;
        }
        if (currentTaskStep.equals(STARTING_STEP)) {
            SnapshotTest.logExecutionNumber();
            SnapshotTest.checkForLastIteration();
            TestHelper.waitForCounter(SnapshotBB.getBB(), "SnapshotBB.doneStartingCounter", SnapshotBB.doneStartingCounter, TestHelper.getNumThreads() - 1 - numTestManagedLocatorThreads, true, -1L, 1000L);
            SnapshotBB.getBB().getSharedCounters().zero(SnapshotBB.doneExecutingOpsCounter);
            SnapshotBB.getBB().getSharedCounters().zero(SnapshotBB.doneExportingCounter);
            SnapshotBB.getBB().getSharedCounters().zero(SnapshotBB.doneImportingCounter);
            SnapshotBB.getBB().getSharedCounters().zero(SnapshotBB.doneVerifyingCounter);
            SnapshotBB.getBB().getSharedCounters().zero(SnapshotBB.exportLeader);
            SnapshotBB.getBB().getSharedCounters().zero(SnapshotBB.importLeader);
            SnapshotBB.getBB().getSharedCounters().zero(SnapshotBB.rebalanceLeader);
            SnapshotBB.getBB().printSharedCounters();
            currentTaskStep = EXECUTE_OPS_STEP;
            Log.getLogWriter().info("Changing currentTaskStep to " + currentTaskStep);
            SnapshotBB.getBB().getSharedMap().put("taskStep", currentTaskStep);
            SnapshotBB.getBB().getSharedCounters().increment(SnapshotBB.doneStartingCounter);
            return;
        }
        if (currentTaskStep.equals(EXECUTE_OPS_STEP)) {
            TestHelper.waitForCounter(SnapshotBB.getBB(), "SnapshotBB.doneExecutingOpsCounter", SnapshotBB.doneExecutingOpsCounter, TestHelper.getNumThreads() - 1 - numTestManagedLocatorThreads, true, -1L, 10000L);
            SummaryLogListener.waitForSilence(30L, 1000L);
            currentTaskStep = EXPORT_STEP;
            SnapshotBB.getBB().getSharedCounters().zero(SnapshotBB.doneStartingCounter);
            Log.getLogWriter().info("Changing currentTaskStep to " + currentTaskStep);
            SnapshotBB.getBB().getSharedMap().put("taskStep", currentTaskStep);
            SnapshotBB.getBB().getSharedCounters().increment(SnapshotBB.doneExecutingOpsCounter);
            return;
        }
        if (currentTaskStep.equals(EXPORT_STEP)) {
            List vmInfoList = StopStartVMs.getAllVMs();
            int myVmID = RemoteTestModule.getMyVmid();
            for (ClientVmInfo info : vmInfoList) {
                if (info.getVmid() != myVmID) continue;
                vmInfoList.remove(info);
            }
            this.killTargetVMs = StopStartVMs.getMatchVMs(vmInfoList, "killTarget");
            ArrayList<String> stopMode = new ArrayList<String>();
            stopMode.add("mean_kill");
            StopStartVMs.stopVMs(this.killTargetVMs, stopMode);
            this.dataStoreVMs = StopStartVMs.getMatchVMs(vmInfoList, "dataStore");
            this.accessorVMs = StopStartVMs.getMatchVMs(vmInfoList, "accessor");
            TestHelper.waitForCounter(SnapshotBB.getBB(), "SnapshotBB.doneExportingCounter", SnapshotBB.doneExportingCounter, 1L, true, -1L, 5000L);
            currentTaskStep = RECYCLE_STEP;
            SnapshotBB.getBB().getSharedMap().put("expectOfflineException", new Boolean(true));
            Log.getLogWriter().info("Changing currentTaskStep to " + currentTaskStep);
            SnapshotBB.getBB().getSharedMap().put("taskStep", currentTaskStep);
            if (this.exportStrategy.equalsIgnoreCase("cmdLineTool")) {
                List vmList = SnapshotTest.shutDownAll();
                PersistenceUtil.doOfflineExport();
                StopStartVMs.startVMs(vmList);
            }
            return;
        }
        if (currentTaskStep.equals(RECYCLE_STEP)) {
            SnapshotBB.getBB().getSharedCounters().zero(SnapshotBB.rebalanceLeader);
            long counter = SnapshotBB.getBB().getSharedCounters().read(SnapshotBB.timeToStop);
            if (counter >= 1L) {
                throw new StopSchedulingOrder("Num controller executions is " + SnapshotBB.getBB().getSharedCounters().read(SnapshotBB.executionNumber));
            }
            if (!this.exportStrategy.equalsIgnoreCase("cmdLineTool")) {
                StopStartVMs.stopVMs(this.accessorVMs, this.getStopModes(this.accessorVMs));
                StopStartVMs.stopVMs(this.dataStoreVMs, this.getStopModes(this.dataStoreVMs));
                Iterator it = this.killTargetVMs.iterator();
                while (it.hasNext()) {
                    this.dataStoreVMs.add((ClientVmInfo)it.next());
                }
                StopStartVMs.startVMs(this.dataStoreVMs);
                StopStartVMs.startVMs(this.accessorVMs);
            }
            SnapshotBB.getBB().getSharedMap().put("expectOfflineException", new Boolean(false));
            currentTaskStep = IMPORT_STEP;
            Log.getLogWriter().info("Changing currentTaskStep to " + currentTaskStep);
            SnapshotBB.getBB().getSharedMap().put("taskStep", currentTaskStep);
            return;
        }
        if (currentTaskStep.equals(IMPORT_STEP)) {
            TestHelper.waitForCounter(SnapshotBB.getBB(), "SnapshotBB.doneImportingCounter", SnapshotBB.doneImportingCounter, TestHelper.getNumThreads() - 1 - numTestManagedLocatorThreads, true, -1L, 5000L);
            currentTaskStep = VERIFY_STEP;
            Log.getLogWriter().info("Changing currentTaskStep to " + currentTaskStep);
            SnapshotBB.getBB().getSharedMap().put("taskStep", currentTaskStep);
            SnapshotBB.getBB().getSharedCounters().increment(SnapshotBB.doneImportingCounter);
            return;
        }
        if (currentTaskStep.equals(VERIFY_STEP)) {
            TestHelper.waitForCounter(SnapshotBB.getBB(), "SnapshotBB.doneVerifyingCounter", SnapshotBB.doneVerifyingCounter, TestHelper.getNumThreads() - 1 - numTestManagedLocatorThreads, true, -1L, 5000L);
            currentTaskStep = STARTING_STEP;
            Log.getLogWriter().info("Changing currentTaskStep to " + currentTaskStep);
            SnapshotBB.getBB().getSharedMap().put("taskStep", currentTaskStep);
            SnapshotBB.getBB().getSharedCounters().increment(SnapshotBB.doneVerifyingCounter);
            return;
        }
    }

    private List getStopModes(List vmList) {
        ArrayList<String> returnList = new ArrayList<String>();
        Iterator it = vmList.iterator();
        while (it.hasNext()) {
            String choice = TestConfig.tab().stringAt(StopStartPrms.stopModes);
            returnList.add(choice);
            it.next();
        }
        return returnList;
    }

    public static List shutDownAll() {
        AdminDistributedSystem adminDS = AdminHelper.getAdminDistributedSystem();
        if (adminDS == null) {
            throw new TestException("Test is configured to use shutDownAllMembers, but this vm must be an admin vm to use it");
        }
        SnapshotBB.getBB().getSharedMap().put("shutDownAllKey", new Boolean(true));
        List vmList = StopStartVMs.getAllVMs();
        Object[] tmp = StopStartVMs.shutDownAllMembers(adminDS);
        SnapshotBB.getBB().getSharedMap().put("shutDownAllKey", new Boolean(false));
        List shutDownAllVMs = (List)tmp[0];
        Set shutDownAllResults = (Set)tmp[1];
        if (shutDownAllResults.size() != vmList.size() && !SnapshotPrms.executeConcurrentRebalance()) {
            throw new TestException("Expected shutDownAllMembers to return " + vmList.size() + " members in its result, but it returned " + shutDownAllResults.size() + ": " + shutDownAllResults);
        }
        return vmList;
    }

    public static synchronized void HydraTask_initializeResponder() {
        testInstance.initializeResponder();
    }

    private void initializeResponder() {
        for (Region aRegion : this.allRegions) {
            aRegion.getAttributesMutator().addCacheListener((CacheListener)new ImportListener());
            aRegion.getAttributesMutator().setCacheWriter((CacheWriter)new ImportWriter());
            Log.getLogWriter().info("After adding ImportListener and ImportWriter via AttributesMutator, Region = " + TestHelper.regionToString(aRegion, true));
        }
    }

    private void snapshotResponder() throws Exception {
        String currentTaskStep = (String)SnapshotBB.getBB().getSharedMap().get("taskStep");
        Log.getLogWriter().info("In snapshotResponder, currentTaskStep is " + currentTaskStep);
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        int numTestManagedLocatorThreads = 0;
        if (!TestConfig.tab().booleanAt(Prms.manageLocatorAgents)) {
            numTestManagedLocatorThreads = 2;
        }
        if (currentTaskStep.equals(STARTING_STEP)) {
            if (this.startingCoordinator.incrementAndGet() == 1) {
                Log.getLogWriter().info("Initializing for startup...");
                this.leaderInThisVM = false;
                this.cacheClosed = false;
            }
            SnapshotBB.getBB().getSharedCounters().increment(SnapshotBB.doneStartingCounter);
            TestHelper.waitForCounter(SnapshotBB.getBB(), "SnapshotBB.doneStartingCounter", SnapshotBB.doneStartingCounter, TestHelper.getNumThreads() - numTestManagedLocatorThreads, true, -1L, 1000L);
            return;
        }
        if (currentTaskStep.equals(EXECUTE_OPS_STEP)) {
            if (!((Boolean)opsCompleted.get()).booleanValue()) {
                this.doOperations(minTaskGranularityMS);
                opsCompleted.set(new Boolean(true));
            }
            SnapshotBB.getBB().getSharedCounters().increment(SnapshotBB.doneExecutingOpsCounter);
            TestHelper.waitForCounter(SnapshotBB.getBB(), "SnapshotBB.doneExecutingOpsCounter", SnapshotBB.doneExecutingOpsCounter, TestHelper.getNumThreads() - numTestManagedLocatorThreads, true, -1L, 10000L);
            return;
        }
        if (currentTaskStep.equals(EXPORT_STEP)) {
            if (this.configuredForSnapshotOps && this.exportCoordinator.incrementAndGet() == 1) {
                long leader = SnapshotBB.getBB().getSharedCounters().incrementAndRead(SnapshotBB.exportLeader);
                if (leader == 1L) {
                    this.leaderInThisVM = true;
                    Log.getLogWriter().info("This thread is the leader; it will write the snapshot");
                    this.writeSnapshot();
                    if (this.exportStrategy.equalsIgnoreCase("cmdLineTool")) {
                        Log.getLogWriter().info("Controller is executing export via the command line tool");
                    } else {
                        this.doExportStep();
                    }
                    SnapshotBB.getBB().getSharedCounters().increment(SnapshotBB.doneExportingCounter);
                }
            } else if (SnapshotPrms.executeConcurrentOps()) {
                this.doOperations(minTaskGranularityMS);
            } else if (SnapshotPrms.executeConcurrentRebalance()) {
                MasterController.sleepForMs(10);
                if (!this.leaderInThisVM && this.rebalanceCoordinator.incrementAndGet() == 1) {
                    long leader = SnapshotBB.getBB().getSharedCounters().incrementAndRead(SnapshotBB.rebalanceLeader);
                    if (leader == 1L) {
                        this.cacheClosed = true;
                        CacheHelper.closeCache();
                    }
                } else {
                    try {
                        this.doRebalance();
                    }
                    catch (TestException e) {
                        boolean undergoingShutDownAll = (Boolean)SnapshotBB.getBB().getSharedMap().get("shutDownAllKey");
                        if (!undergoingShutDownAll && !this.cacheClosed) {
                            throw new TestException(TestHelper.getStackTrace(e));
                        }
                    }
                    catch (Exception e) {
                        this.handleRebalanceException(e);
                    }
                }
            }
            TestHelper.waitForCounter(SnapshotBB.getBB(), "SnapshotBB.doneExportingCounter", SnapshotBB.doneExportingCounter, 1L, true, -1L, 5000L);
            return;
        }
        if (currentTaskStep.equals(RECYCLE_STEP)) {
            this.leaderInThisVM = false;
            MasterController.sleepForMs(5000);
            return;
        }
        if (currentTaskStep.equals(IMPORT_STEP)) {
            long leader;
            if (this.configuredForSnapshotOps && this.importCoordinator.incrementAndGet() == 1 && (leader = SnapshotBB.getBB().getSharedCounters().incrementAndRead(SnapshotBB.importLeader)) == 1L) {
                this.leaderInThisVM = true;
                Log.getLogWriter().info("This thread is the leader; it will import from the snapshot");
                boolean useSnapshotReader = !this.useFilterOnImport && TestConfig.tab().getRandGen().nextInt(1, 100) < 10;
                this.doImportStep(useSnapshotReader);
                long numEvents = SnapshotBB.getBB().getSharedCounters().read(SnapshotBB.eventsDuringImport);
                if (!(SnapshotPrms.executeConcurrentOps() || this.expirationConfigured || useSnapshotReader || numEvents <= 0L)) {
                    Log.getLogWriter().info("CacheListener and/or CacheWriter callbacks invoked during import: " + numEvents + " processed");
                    throw new TestException("CacheListener and/or CacheWriter callbacks invoked during import: " + numEvents + " processed");
                }
                SnapshotBB.getBB().getSharedCounters().zero(SnapshotBB.eventsDuringImport);
            }
            SnapshotBB.getBB().getSharedCounters().increment(SnapshotBB.doneImportingCounter);
            TestHelper.waitForCounter(SnapshotBB.getBB(), "SnapshotBB.doneImportingCounter", SnapshotBB.doneImportingCounter, TestHelper.getNumThreads() - 1 - numTestManagedLocatorThreads, false, -1L, 5000L);
            for (Region aRegion : this.allRegions) {
                CacheListener[] listeners;
                AttributesMutator mutator = aRegion.getAttributesMutator();
                for (CacheListener l : listeners = aRegion.getAttributes().getCacheListeners()) {
                    if (!(l instanceof ImportListener)) continue;
                    mutator.removeCacheListener(l);
                }
                mutator.setCacheWriter(null);
                Log.getLogWriter().info("After removing ImportListener and ImportWriter via AttributesMutator, Region = " + TestHelper.regionToString(aRegion, true));
            }
            TestHelper.waitForCounter(SnapshotBB.getBB(), "SnapshotBB.doneImportingCounter", SnapshotBB.doneImportingCounter, TestHelper.getNumThreads() - numTestManagedLocatorThreads, false, -1L, 5000L);
            return;
        }
        if (currentTaskStep.equals(VERIFY_STEP)) {
            if (this.verifyCoordinator.incrementAndGet() == 1) {
                this.doVerificationStep();
            }
            SnapshotBB.getBB().getSharedCounters().increment(SnapshotBB.doneVerifyingCounter);
            TestHelper.waitForCounter(SnapshotBB.getBB(), "SnapshotBB.doneVerifyingCounter", SnapshotBB.doneVerifyingCounter, TestHelper.getNumThreads() - numTestManagedLocatorThreads, true, -1L, 3000L);
            return;
        }
    }

    protected SnapshotFilter getSnapshotFilter() {
        int i = TestConfig.tab().getRandGen().nextInt(0, 2);
        Object filter = new KeySnapshotFilter();
        if (i == 2) {
            filter = new ValueSnapshotFilter();
        } else if (i == 3) {
            filter = new ValueTypeSnapshotFilter();
        }
        Log.getLogWriter().info("getSnapshotFilter returning instance of " + filter.getClass().getName());
        return filter;
    }

    private void doExportStep() {
        for (Region aRegion : SnapshotTest.testInstance.allRegions) {
            if (this.useSnapshotFilter) {
                int numToCreate = SnapshotPrms.numFilterObjects();
                for (int i = 1; i <= numToCreate; ++i) {
                    String key = "FilterObject_" + i;
                    String value = "object to be filtered via snapshot.save() or snapshot.load(): this should never be a value in the cache once snapshot restored";
                    aRegion.put((Object)key, (Object)value);
                }
                Log.getLogWriter().info("Wrote " + numToCreate + " FilterObject entries to " + aRegion.getFullPath());
            }
            RegionSnapshotService snapshotService = aRegion.getSnapshotService();
            String currDirName = System.getProperty("user.dir");
            String snapshotDirName = "snapshotDir_" + RemoteTestModule.getMyVmid();
            snapshotDirName = currDirName + File.separator + snapshotDirName;
            FileUtil.mkdir(snapshotDirName);
            String filename = "snapshot-vm_" + RemoteTestModule.getMyVmid() + "_" + RemoteTestModule.getMyClientName() + aRegion.getFullPath().replace('/', '-') + ".gfd";
            File snapshotFile = new File(snapshotDirName, filename);
            long startTime = System.currentTimeMillis();
            if (!this.exportStrategy.equalsIgnoreCase("cmdLineTool")) {
                if (this.exportStrategy.equalsIgnoreCase("apiFromAllVms")) {
                    throw new TestException("Parallel snapshot option not supported in GemFire 7.0");
                }
                Log.getLogWriter().info("Starting export of " + aRegion.getFullPath() + " containing " + aRegion.size() + " entries to " + snapshotFile.getAbsoluteFile());
                SnapshotOptions options = snapshotService.createOptions();
                if (this.useFilterOnExport) {
                    options.setFilter(this.getSnapshotFilter());
                }
                try {
                    if (this.exportStrategy.equalsIgnoreCase("useCli")) {
                        String command = "export data --region=" + aRegion.getFullPath() + " --file=" + snapshotFile.getAbsolutePath() + " --member=" + DistributedSystemHelper.getDistributedSystem().getDistributedMember().getName();
                        CliHelper.execCommandOnRemoteCli(command, true);
                    } else {
                        Log.getLogWriter().info("Calling snapshotService.save(...)");
                        snapshotService.save(snapshotFile, SnapshotOptions.SnapshotFormat.GEMFIRE, options);
                    }
                }
                catch (IOException ioe) {
                    boolean memberDepartedEvent;
                    String errStr = ioe.toString();
                    boolean bl = memberDepartedEvent = errStr.indexOf("memberDeparted event") >= 0;
                    if (memberDepartedEvent) {
                        Log.getLogWriter().info("Caught " + ioe + ", retrying export");
                        try {
                            snapshotService.save(snapshotFile, SnapshotOptions.SnapshotFormat.GEMFIRE, options);
                        }
                        catch (IOException e) {
                            throw new TestException("Caught " + e + " on retry of export region snapshot to " + snapshotFile.getAbsoluteFile() + " " + TestHelper.getStackTrace(ioe));
                        }
                    }
                    throw new TestException("Caught " + ioe + " while exporting region snapshot to " + snapshotFile.getAbsoluteFile() + " " + TestHelper.getStackTrace(ioe));
                }
            }
            long endTime = System.currentTimeMillis();
            Log.getLogWriter().info("Export of " + aRegion.getFullPath() + " containing " + aRegion.size() + " entries to " + snapshotFile.getAbsoluteFile() + " took " + (endTime - startTime) + " ms");
        }
    }

    private void doImportStep(boolean useSnapshotReader) {
        String currDirName = System.getProperty("user.dir");
        File snapshotFile2 = null;
        for (Region aRegion : SnapshotTest.testInstance.allRegions) {
            boolean isPartitioned = aRegion.getAttributes().getDataPolicy().withPartitioning();
            boolean isOfflineExport = this.exportStrategy.equalsIgnoreCase("cmdLineTool");
            String prefix = snapshotDirPrefix;
            List<File> dirList = SnapshotTest.getSnapshotDirs(new File(currDirName), prefix);
            if (!isOfflineExport || !isPartitioned) {
                dirList = SnapshotTest.getOneSnapshotDir(dirList, aRegion);
            }
            for (File aDir : dirList) {
                List<File> fileList = SnapshotTest.getSnapshotFiles(aDir, aRegion);
                for (File snapshotFile2 : fileList) {
                    if (useSnapshotReader) {
                        long startTime = System.currentTimeMillis();
                        Log.getLogWriter().info("Starting SnapshotReader.read() of " + snapshotFile2.getAbsoluteFile() + " into " + aRegion.getFullPath());
                        try {
                            SnapshotIterator it = SnapshotReader.read((File)snapshotFile2);
                            while (it.hasNext()) {
                                Map.Entry entry = it.next();
                                aRegion.putIfAbsent(entry.getKey(), entry.getValue());
                            }
                            long endTime = System.currentTimeMillis();
                            Log.getLogWriter().info("SnapshotReader.read() of " + aRegion.getFullPath() + " from " + snapshotFile2.getAbsoluteFile() + " took " + (endTime - startTime) + " ms.  Region contains " + aRegion.size() + " entries");
                        }
                        catch (Exception e) {
                            throw new TestException("Caught " + e + " while using SnapshotReader.read() to import region snapshot from " + snapshotFile2.getAbsoluteFile() + " " + TestHelper.getStackTrace(e));
                        }
                    }
                    RegionSnapshotService snapshotService = aRegion.getSnapshotService();
                    Log.getLogWriter().info("Starting RegionSnapshotService.load() from " + snapshotFile2.getAbsoluteFile() + " into " + aRegion.getFullPath());
                    SnapshotOptions options = snapshotService.createOptions();
                    if (this.useFilterOnImport) {
                        options.setFilter(this.getSnapshotFilter());
                    }
                    long startTime = System.currentTimeMillis();
                    try {
                        if (CliHelperPrms.getUseCli()) {
                            String command = "import data --region=" + aRegion.getFullPath() + " --file=" + snapshotFile2.getAbsolutePath() + " --member=" + DistributedSystemHelper.getDistributedSystem().getDistributedMember().getName();
                            CliHelper.execCommandOnRemoteCli(command, true);
                        } else {
                            snapshotService.load(snapshotFile2, SnapshotOptions.SnapshotFormat.GEMFIRE, options);
                        }
                        long endTime = System.currentTimeMillis();
                        Log.getLogWriter().info("Import of " + aRegion.getFullPath() + " from " + snapshotFile2.getAbsoluteFile() + " took " + (endTime - startTime) + " ms.  Region contains " + aRegion.size() + " entries");
                    }
                    catch (Exception e) {
                        throw new TestException("Caught " + e + " while importing region snapshot from " + snapshotFile2.getAbsoluteFile() + " " + TestHelper.getStackTrace(e));
                    }
                    boolean result = snapshotFile2.delete();
                    if (!result) {
                        throw new TestException("Unable to delete file " + snapshotFile2.getAbsolutePath());
                    }
                    Log.getLogWriter().info("Removed " + snapshotFile2.getAbsolutePath());
                }
            }
        }
    }

    private static List<File> getOneSnapshotDir(List<File> dirList, Region aRegion) {
        ArrayList<File> oneDirList = new ArrayList<File>();
        for (File dir : dirList) {
            List<File> fileList = SnapshotTest.getSnapshotFiles(dir, aRegion);
            if (fileList.size() <= 0) continue;
            oneDirList.add(dir);
            return oneDirList;
        }
        throw new TestException("No snapshotDir could be found for region " + aRegion.getFullPath() + " in " + dirList.toString());
    }

    private static List<File> getSnapshotDirs(File aDir, String prefix) {
        class DirFilter
        implements FileFilter {
            String prefix;

            public DirFilter(String prefix) {
                this.prefix = prefix;
            }

            @Override
            public boolean accept(File fn) {
                return fn.isDirectory() && fn.getName().startsWith(this.prefix);
            }
        }
        return FileUtil.getFiles(aDir, new DirFilter(prefix), false);
    }

    private static List<File> getSnapshotFiles(File snapshotDir, Region aRegion) {
        class RegionFilter
        implements FileFilter {
            String regionName;

            public RegionFilter(Region aRegion) {
                this.regionName = aRegion.getFullPath().replace('/', '-');
            }

            @Override
            public boolean accept(File f) {
                String fn = f.getName();
                Log.getLogWriter().info("RegionFilter comparing against filename " + f.getName() + " and regionName " + this.regionName);
                return fn.startsWith("snapshot") && fn.endsWith(this.regionName + ".gfd");
            }
        }
        return FileUtil.getFiles(snapshotDir, new RegionFilter(aRegion), false);
    }

    private void doVerificationStep() {
        if (!SnapshotPrms.executeConcurrentOps() && !this.expirationConfigured) {
            SnapshotTest.verifyPRs();
            this.verifyFromSnapshot();
        } else {
            Log.getLogWriter().info("Not verifying region contents with concurrentOperations or expiration");
        }
    }

    private boolean loadRegion(long numKeysToLoad) {
        long startTime;
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long logIntervalMS = 10000L;
        long lastLogTime = startTime = System.currentTimeMillis();
        int numCreated = 0;
        while (System.currentTimeMillis() - startTime < minTaskGranularityMS) {
            String key = NameFactory.getNextPositiveObjectName();
            long nameCounter = NameFactory.getCounterForName(key);
            ++numCreated;
            if (nameCounter <= numKeysToLoad) {
                for (Region aRegion : this.allRegions) {
                    aRegion.put((Object)key, this.getValueForKey(key));
                    if (System.currentTimeMillis() - lastLogTime <= logIntervalMS) continue;
                    Log.getLogWriter().info("Created " + numCreated + " entries per region so far this task; number remaining to create " + (numKeysToLoad - nameCounter));
                    lastLogTime = System.currentTimeMillis();
                }
                continue;
            }
            return true;
        }
        return false;
    }

    void writeSnapshot() {
        Log.getLogWriter().info("Preparing to write snapshot for " + this.allRegions.size() + " regions");
        HashMap allRegionsSnapshot = new HashMap();
        for (Region aRegion : this.allRegions) {
            HashMap regionSnapshot = new HashMap();
            for (Object key : aRegion.keySet()) {
                Object value = null;
                if (aRegion.containsValueForKey(key)) {
                    value = aRegion.get(key);
                }
                if (value instanceof BaseValueHolder) {
                    regionSnapshot.put(key, ((BaseValueHolder)value).myValue);
                    continue;
                }
                if (SnapshotTest.instanceOfPdxInstance(value)) {
                    BaseValueHolder vh = SnapshotTest.toValueHolder(value);
                    regionSnapshot.put(key, vh.myValue);
                    continue;
                }
                regionSnapshot.put(key, value);
            }
            allRegionsSnapshot.put(aRegion.getFullPath(), regionSnapshot);
            Log.getLogWriter().info("Region snapshot for " + aRegion.getFullPath() + " is size " + regionSnapshot.size() + " and contains keys " + regionSnapshot.keySet());
        }
        SnapshotBB.getBB().getSharedMap().put(allRegionsSnapshotKey, allRegionsSnapshot);
        Log.getLogWriter().info("Put snapshot for " + this.allRegions.size() + " regions into blackboard at key " + allRegionsSnapshotKey);
    }

    private void verifyFromSnapshot() {
        Cache theCache = CacheHelper.getCache();
        Map allRegionsSnapshot = (Map)SnapshotBB.getBB().getSharedMap().get(allRegionsSnapshotKey);
        Set snapshotRegionNames = allRegionsSnapshot.keySet();
        HashSet<String> definedRegionNames = new HashSet<String>();
        for (Region aRegion : theCache.rootRegions()) {
            definedRegionNames.add(aRegion.getFullPath());
            Set subRegSet = aRegion.subregions(true);
            for (Region subReg : subRegSet) {
                definedRegionNames.add(subReg.getFullPath());
            }
        }
        HashSet missingRegionsInCache = new HashSet(snapshotRegionNames);
        missingRegionsInCache.removeAll(definedRegionNames);
        HashSet extraRegionsInCache = new HashSet(definedRegionNames);
        extraRegionsInCache.removeAll(snapshotRegionNames);
        if (missingRegionsInCache.size() != 0) {
            throw new TestException("Expected to find regions " + missingRegionsInCache + " defined in cache");
        }
        if (extraRegionsInCache.size() != 0) {
            throw new TestException("Found unexpected regions defined in cache: " + extraRegionsInCache);
        }
        for (String regionName : allRegionsSnapshot.keySet()) {
            Map regionSnapshot = (Map)allRegionsSnapshot.get(regionName);
            Region aRegion = theCache.getRegion(regionName);
            if (aRegion == null) {
                throw new TestException("Region " + regionName + " could not be found in cache");
            }
            this.verifyFromSnapshot(aRegion, regionSnapshot);
        }
    }

    public void verifyFromSnapshot(Region aRegion, Map regionSnapshot) {
        StringBuffer errStr = new StringBuffer();
        int snapshotSize = regionSnapshot.size();
        int regionSize = aRegion.size();
        long startVerifyTime = System.currentTimeMillis();
        Log.getLogWriter().info("Verifying " + aRegion.getFullPath() + "  of size " + aRegion.size() + " against snapshot containing " + regionSnapshot.size() + " entries...");
        if (snapshotSize != regionSize) {
            errStr.append("Expected region " + aRegion.getFullPath() + " to be size " + snapshotSize + ", but it is " + regionSize + "\n");
        }
        for (Object key : regionSnapshot.keySet()) {
            try {
                ParRegUtil.verifyContainsKey(aRegion, key, true);
            }
            catch (TestException e) {
                errStr.append(e.getMessage() + "\n");
            }
            boolean containsValueForKey = aRegion.containsValueForKey(key);
            Object expectedValue = regionSnapshot.get(key);
            try {
                ParRegUtil.verifyContainsValueForKey(aRegion, key, expectedValue != null);
            }
            catch (TestException e) {
                errStr.append(e.getMessage() + "\n");
            }
            if (!containsValueForKey) continue;
            try {
                Object actualValue = aRegion.get(key);
                if (actualValue instanceof BaseValueHolder) {
                    ParRegUtil.verifyMyValue(key, expectedValue, actualValue, ParRegUtil.EQUAL);
                    continue;
                }
                if (SnapshotTest.instanceOfPdxInstance(actualValue)) {
                    actualValue = SnapshotTest.toValueHolder(actualValue);
                    ParRegUtil.verifyMyValue(key, expectedValue, actualValue, ParRegUtil.EQUAL);
                    continue;
                }
                if (actualValue instanceof byte[] && expectedValue instanceof byte[]) {
                    byte[] actual = (byte[])actualValue;
                    byte[] expected = (byte[])expectedValue;
                    if (actual.length == expected.length) continue;
                    throw new TestException("Expected value for key " + key + " to be " + TestHelper.toString(expectedValue) + ", but it is " + TestHelper.toString(actualValue));
                }
                throw new TestException("Expected value for key " + key + " to be " + TestHelper.toString(expectedValue) + ", but it is " + TestHelper.toString(actualValue));
            }
            catch (TestException e) {
                errStr.append(e.getMessage() + "\n");
            }
        }
        HashSet aRegionKeySet = new HashSet(aRegion.keySet());
        Set snapshotKeySet = regionSnapshot.keySet();
        aRegionKeySet.removeAll(snapshotKeySet);
        if (aRegionKeySet.size() != 0) {
            errStr.append("Found the following unexpected keys in " + aRegion.getFullPath() + ": " + aRegionKeySet + "\n");
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
        Log.getLogWriter().info("Done verifying " + aRegion.getFullPath() + " from snapshot containing " + snapshotSize + " entries, " + "verification took " + (System.currentTimeMillis() - startVerifyTime) + "ms");
    }

    protected void doRebalance() {
        Cache myCache = CacheHelper.getCache();
        if (myCache == null) {
            throw new TestException("doRebalance() expects hydra client to have created cache and PR via initialization tasks");
        }
        Log.getLogWriter().info("In doRebalance ... rebalancing PRs in the cache");
        ResourceManager rm = myCache.getResourceManager();
        RebalanceFactory factory = rm.createRebalanceFactory();
        long startTime = System.currentTimeMillis();
        RebalanceOperation rebalanceOp = factory.start();
        RebalanceResults rebalanceResults = null;
        try {
            rebalanceResults = rebalanceOp.getResults();
        }
        catch (InterruptedException ie) {
            Log.getLogWriter().info("getResults() caught exception " + ie);
            throw new TestException("Unexpected exception " + TestHelper.getStackTrace(ie));
        }
        Long stopTime = new Long(System.currentTimeMillis());
        Long rebalanceTime = stopTime - startTime;
        Log.getLogWriter().info("Completed rebalance in " + rebalanceTime + " ms, results = " + rebalanceOp.toString());
        Log.getLogWriter().info(RebalanceUtil.RebalanceResultsToString(rebalanceResults, "rebalance"));
    }

    protected void doOperations(long msToRun) throws Exception {
        Log.getLogWriter().info("In doOperations, running for " + msToRun + " seconds");
        long startTime = System.currentTimeMillis();
        int numOps = 0;
        Region aRegion = null;
        do {
            try {
                aRegion = this.allRegions.get(TestConfig.tab().getRandGen().nextInt(0, this.allRegions.size() - 1));
                int whichOp = this.getOperation(aRegion);
                switch (whichOp) {
                    case 1: {
                        this.addEntry(aRegion);
                        break;
                    }
                    case 3: {
                        this.invalidateEntry(aRegion, false);
                        break;
                    }
                    case 2: {
                        this.destroyEntry(aRegion, false);
                        break;
                    }
                    case 6: {
                        this.updateEntry(aRegion);
                        break;
                    }
                    case 7: {
                        this.getExistingKey(aRegion);
                        break;
                    }
                    case 8: {
                        this.getNewKey(aRegion);
                        break;
                    }
                    case 5: {
                        this.invalidateEntry(aRegion, true);
                        break;
                    }
                    case 4: {
                        this.destroyEntry(aRegion, true);
                        break;
                    }
                    case 9: {
                        this.putAll(aRegion);
                        break;
                    }
                    default: {
                        throw new TestException("Unknown operation " + whichOp);
                    }
                }
                Log.getLogWriter().info("Completed op " + ++numOps + " for this task");
            }
            catch (Exception e) {
                this.handleOperationExceptions(aRegion, e);
            }
        } while (System.currentTimeMillis() - startTime < msToRun);
        Log.getLogWriter().info("Done in doOperations");
    }

    protected int getOperation(Region aRegion) {
        Long opsPrm = SnapshotPrms.operations;
        Long upperThresholdOpsPrm = SnapshotPrms.upperThresholdOperations;
        Long lowerThresholdOpsPrm = SnapshotPrms.lowerThresholdOperations;
        int upperThreshold = SnapshotPrms.getUpperThreshold();
        int lowerThreshold = SnapshotPrms.getLowerThreshold();
        int size = aRegion.size();
        if (size >= upperThreshold) {
            return this.getOperation(upperThresholdOpsPrm);
        }
        if (size <= lowerThreshold) {
            return this.getOperation(lowerThresholdOpsPrm);
        }
        return this.getOperation(opsPrm);
    }

    protected int getOperation(Long whichPrm) {
        int op = 0;
        String operation = TestConfig.tab().stringAt(whichPrm);
        if (operation.equals("add")) {
            op = 1;
        } else if (operation.equals("update")) {
            op = 6;
        } else if (operation.equals("invalidate")) {
            op = 3;
        } else if (operation.equals("destroy")) {
            op = 2;
        } else if (operation.equals("get")) {
            op = 7;
        } else if (operation.equals("getNew")) {
            op = 8;
        } else if (operation.equals("localInvalidate")) {
            op = 5;
        } else if (operation.equals("localDestroy")) {
            op = 4;
        } else if (operation.equals("putAll")) {
            op = 9;
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        return op;
    }

    protected void getExistingKey(Region aRegion) {
        Object key = this.obtainExistingKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("No keys available in " + aRegion.getFullPath() + ", cannot do get on existing key");
            return;
        }
        Log.getLogWriter().info("Getting existing key " + key + " from region " + aRegion.getFullPath());
        Object result = aRegion.get(key);
        Log.getLogWriter().info("Done getting existing key " + key + ", returned value " + result);
    }

    protected Object addEntry(Region aRegion) {
        Object key = this.obtainNewKey();
        this.addEntry(aRegion, key);
        return key;
    }

    protected void addEntry(Region aRegion, Object key) {
        Object anObj = this.getValueForKey(key);
        String callback = createCallbackPrefix + ProcessMgr.getProcessId();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + " cacheWriterParam is " + callback + ", region is " + aRegion.getFullPath());
                try {
                    aRegion.create(key, anObj, (Object)callback);
                    Log.getLogWriter().info("addEntry: done creating key " + key);
                }
                catch (EntryExistsException e) {
                    Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
                }
            } else {
                Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
                try {
                    aRegion.create(key, anObj);
                    Log.getLogWriter().info("addEntry: done creating key " + key);
                }
                catch (EntryExistsException e) {
                    Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
                }
            }
        } else {
            Object returnVal = null;
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("addEntry: calling put for key " + key + ", object " + TestHelper.toString(anObj) + " callback is " + callback + ", region is " + aRegion.getFullPath());
                returnVal = aRegion.put(key, anObj, (Object)callback);
                Log.getLogWriter().info("addEntry: done putting key " + key + ", returnVal is " + returnVal);
            } else {
                Log.getLogWriter().info("addEntry: calling put for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
                returnVal = aRegion.put(key, anObj);
                Log.getLogWriter().info("addEntry: done putting key " + key + ", returnVal is " + returnVal);
            }
        }
    }

    protected void putAll(Region aRegion) {
        Map mapToPut = this.getPutAllMap(aRegion);
        Log.getLogWriter().info("putAll: calling putAll with map of " + mapToPut.size() + " entries, region is " + aRegion.getFullPath());
        aRegion.putAll(mapToPut);
        Log.getLogWriter().info("putAll: done calling putAll with map of " + mapToPut.size() + " entries");
    }

    protected Map getPutAllMap(Region aRegion) {
        int numPutAllNewKeys = SnapshotPrms.getNumPutAllNewKeys();
        HashMap<Object, Object> mapToPut = new HashMap<Object, Object>();
        StringBuffer newKeys = new StringBuffer();
        for (int i = 1; i <= numPutAllNewKeys; ++i) {
            Object key = this.obtainNewKey();
            Object anObj = this.getValueForKey(key);
            mapToPut.put(key, anObj);
            newKeys.append(key + " ");
            if (i % 10 != 0) continue;
            newKeys.append("\n");
        }
        int numPutAllExistingKeys = TestConfig.tab().intAt(SnapshotPrms.numPutAllExistingKeys);
        List<String> existingKeysList = this.obtainExistingKeys(aRegion, numPutAllExistingKeys);
        StringBuffer existingKeys = new StringBuffer();
        int count = 0;
        for (String key : existingKeysList) {
            Object anObj = this.getUpdateObject(aRegion, key);
            mapToPut.put(key, anObj);
            existingKeys.append(key + " ");
            if (++count % 10 != 0) continue;
            existingKeys.append("\n");
        }
        Log.getLogWriter().info(aRegion.getFullPath() + " size is " + aRegion.size() + ", map to use as argument to putAll is " + mapToPut.getClass().getName() + " containing " + numPutAllNewKeys + " new keys and " + numPutAllExistingKeys + " existing keys (updates); total map size is " + mapToPut.size() + "\nnew keys are: " + newKeys + "\n" + "existing keys are: " + existingKeys);
        return mapToPut;
    }

    protected void invalidateEntry(Region aRegion, boolean isLocalInvalidate) {
        Object key = this.obtainExistingKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("invalidateEntry: No keys in region " + aRegion.getFullPath());
            return;
        }
        this.invalidateEntry(aRegion, key, isLocalInvalidate);
    }

    protected void invalidateEntry(Region aRegion, Object key, boolean isLocalInvalidate) {
        String callback = invalidateCallbackPrefix + ProcessMgr.getProcessId();
        if (isLocalInvalidate) {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("invalidateEntry: local invalidate for " + key + " callback is " + callback + ", region is " + aRegion.getFullPath());
                aRegion.localInvalidate(key, (Object)callback);
                Log.getLogWriter().info("invalidateEntry: done with local invalidate for " + key);
            } else {
                Log.getLogWriter().info("invalidateEntry: local invalidate for " + key + ", region is " + aRegion.getFullPath());
                aRegion.localInvalidate(key);
                Log.getLogWriter().info("invalidateEntry: done with local invalidate for " + key);
            }
        } else if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("invalidateEntry: invalidating key " + key + " callback is " + callback + ", region is " + aRegion.getFullPath());
            aRegion.invalidate(key, (Object)callback);
            Log.getLogWriter().info("invalidateEntry: done invalidating key " + key);
        } else {
            Log.getLogWriter().info("invalidateEntry: invalidating key " + key + ", aRegion is " + aRegion.getFullPath());
            aRegion.invalidate(key);
            Log.getLogWriter().info("invalidateEntry: done invalidating key " + key);
        }
    }

    protected void destroyEntry(Region aRegion, boolean isLocalDestroy) {
        Object key = this.obtainExistingKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("destroyEntry: No keys in region " + aRegion.getFullPath());
            return;
        }
        this.destroyEntry(aRegion, key, isLocalDestroy);
    }

    protected void destroyEntry(Region aRegion, Object key, boolean isLocalDestroy) {
        String callback = destroyCallbackPrefix + ProcessMgr.getProcessId();
        if (isLocalDestroy) {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("destroyEntry: local destroy for " + key + " callback is " + callback + ", region is " + aRegion.getFullPath());
                aRegion.localDestroy(key, (Object)callback);
                Log.getLogWriter().info("destroyEntry: done with local destroy for " + key);
            } else {
                Log.getLogWriter().info("destroyEntry: local destroy for " + key + ", region is " + aRegion.getFullPath());
                aRegion.localDestroy(key);
                Log.getLogWriter().info("destroyEntry: done with local destroy for " + key);
            }
        } else if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("destroyEntry: destroying key " + key + " callback is " + callback + ", region is " + aRegion.getFullPath());
            aRegion.destroy(key, (Object)callback);
            Log.getLogWriter().info("destroyEntry: done destroying key " + key);
        } else {
            Log.getLogWriter().info("destroyEntry: destroying key " + key + ", region is " + aRegion.getFullPath());
            aRegion.destroy(key);
            Log.getLogWriter().info("destroyEntry: done destroying key " + key);
        }
    }

    protected void updateEntry(Region aRegion) {
        Object key = this.obtainExistingKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("updateEntry: No keys in region " + aRegion.getFullPath());
            return;
        }
        this.updateEntry(aRegion, key);
    }

    protected void updateEntry(Region aRegion, Object key) {
        Object anObj = this.getUpdateObject(aRegion, (String)key);
        String callback = updateCallbackPrefix + ProcessMgr.getProcessId();
        Object returnVal = null;
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj) + ", callback is " + callback + ", region is " + aRegion.getFullPath());
            returnVal = aRegion.put(key, anObj, (Object)callback);
            Log.getLogWriter().info("Done with call to put (update), returnVal is " + returnVal);
        } else {
            Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
            returnVal = aRegion.put(key, anObj, (Object)false);
            Log.getLogWriter().info("Done with call to put (update), returnVal is " + returnVal);
        }
    }

    protected void getNewKey(Region aRegion) {
        Object key = this.obtainNewKey();
        this.getThisNewKey(aRegion, key);
    }

    protected void getThisNewKey(Region aRegion, Object key) {
        Object anObj;
        String callback = getCallbackPrefix + ProcessMgr.getProcessId();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("getNewKey: getting new key " + key + ", callback is " + callback + ", region is " + aRegion.getFullPath());
            anObj = aRegion.get(key, (Object)callback);
        } else {
            Log.getLogWriter().info("getNewKey: getting new key " + key + ", region is " + aRegion.getFullPath());
            anObj = aRegion.get(key);
        }
        Log.getLogWriter().info("getNewKey: done getting value for new key " + key + ": " + TestHelper.toString(anObj));
    }

    protected Object obtainExistingKey(Region aRegion) {
        if (aRegion.size() == 0) {
            return null;
        }
        Object[] keyArr = aRegion.keySet().toArray();
        int myTid = RemoteTestModule.getCurrentThread().getThreadId();
        int numThreads = TestHelper.getNumThreads();
        for (Object key : keyArr) {
            if (this.uniqueKeys) {
                long keyIndex = NameFactory.getCounterForName(key);
                if (keyIndex % (long)numThreads != (long)myTid) continue;
                return key;
            }
            return key;
        }
        return null;
    }

    protected List<String> obtainExistingKeys(Region aRegion, int numToObtain) {
        ArrayList<String> aList = new ArrayList<String>();
        if (aRegion.size() == 0) {
            return aList;
        }
        Object[] keyArr = aRegion.keySet().toArray();
        int myTid = RemoteTestModule.getCurrentThread().getThreadId();
        int numThreads = TestHelper.getNumThreads();
        for (Object key : keyArr) {
            if (this.uniqueKeys) {
                long keyIndex = NameFactory.getCounterForName(key);
                if (keyIndex % (long)numThreads != (long)myTid) continue;
                aList.add((String)key);
                if (aList.size() != numToObtain) continue;
                return aList;
            }
            aList.add((String)key);
            if (aList.size() != numToObtain) continue;
            return aList;
        }
        return aList;
    }

    protected static long logExecutionNumber() {
        long exeNum = SnapshotBB.getBB().getSharedCounters().incrementAndRead(SnapshotBB.executionNumber);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
        return exeNum;
    }

    protected static void checkForLastIteration() {
        int secondsToRun = SnapshotPrms.getSecondsToRun();
        long taskStartTime = 0L;
        String bbKey = "taskStartTime";
        Object anObj = SnapshotBB.getBB().getSharedMap().get("taskStartTime");
        if (anObj == null) {
            taskStartTime = System.currentTimeMillis();
            SnapshotBB.getBB().getSharedMap().put("taskStartTime", new Long(taskStartTime));
            Log.getLogWriter().info("Initialized taskStartTime to " + taskStartTime);
        } else {
            taskStartTime = (Long)anObj;
        }
        if (System.currentTimeMillis() - taskStartTime >= (long)(secondsToRun * 1000)) {
            Log.getLogWriter().info("This is the last iteration of this task");
            SnapshotBB.getBB().getSharedCounters().increment(SnapshotBB.timeToStop);
        } else {
            Log.getLogWriter().info("Running for " + secondsToRun + " seconds; time remaining is " + ((long)secondsToRun - (System.currentTimeMillis() - taskStartTime) / 1000L) + " seconds");
        }
    }

    protected Object obtainNewKey() {
        if (this.uniqueKeys) {
            int thisThreadID = RemoteTestModule.getCurrentThread().getThreadId();
            int anInt = (Integer)SnapshotBB.getBB().getSharedMap().get(uniqueKeyIndex + thisThreadID);
            SnapshotBB.getBB().getSharedMap().put(uniqueKeyIndex + thisThreadID, anInt += TestHelper.getNumThreads());
            NameBB.getBB().getSharedCounters().setIfLarger(NameBB.POSITIVE_NAME_COUNTER, anInt);
            return NameFactory.getObjectNameForCounter(anInt);
        }
        return NameFactory.getNextPositiveObjectName();
    }

    private Object getValueForKey(Object key) {
        String valueClassName = SnapshotPrms.getValueClassName();
        BaseValueHolder vh = null;
        if (valueClassName.equals(ValueHolder.class.getName())) {
            vh = new ValueHolder((String)key, this.randomValues);
        } else if (valueClassName.equals(VHDataSerializable.class.getName())) {
            vh = new VHDataSerializable((String)key, this.randomValues);
        } else if (valueClassName.equals(VHDataSerializableInstantiator.class.getName())) {
            vh = new VHDataSerializableInstantiator((String)key, this.randomValues);
        } else {
            if (valueClassName.equals("util.PdxVersionedValueHolder") || valueClassName.equals("util.VersionedValueHolder")) {
                vh = SnapshotTest.getVersionedValueHolder(valueClassName, (String)key, this.randomValues);
                return vh;
            }
            throw new TestException("Test does not support SnapshotPrms.valueClassName " + valueClassName);
        }
        if (this.useSnapshotFilter) {
            return vh;
        }
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Object anObj = vh.extraObject;
            if (anObj == null) {
                throw new TestException("Test config problem: ValueHolder does not have extraObj");
            }
            return anObj;
        }
        return vh;
    }

    protected Object getUpdateObject(Region r, String key) {
        Object anObj = r.get((Object)key);
        Object newObj = null;
        newObj = anObj == null || !(anObj instanceof BaseValueHolder) ? this.getValueForKey(key) : ((BaseValueHolder)anObj).getAlternateValueHolder(this.randomValues);
        if (newObj instanceof BaseValueHolder && TestConfig.tab().getRandGen().nextBoolean()) {
            return ((BaseValueHolder)newObj).extraObject;
        }
        return newObj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleRebalanceException(Exception e) {
        boolean undergoingShutDownAll = (Boolean)SnapshotBB.getBB().getSharedMap().get("shutDownAllKey");
        if (undergoingShutDownAll || this.cacheClosed) return;
        if (!(e instanceof PartitionOfflineException) && (!(e instanceof ServerOperationException) || !(e.getCause() instanceof PartitionOfflineException))) throw new TestException(TestHelper.getStackTrace(e));
        boolean expectOfflineException = false;
        Object bbValue = SnapshotBB.getBB().getSharedMap().get("expectOfflineException");
        if (bbValue instanceof Boolean) {
            expectOfflineException = (Boolean)bbValue;
        }
        if (!expectOfflineException) throw new TestException("Unexpected PartitionOfflineException " + e + " " + TestHelper.getStackTrace(e));
        Log.getLogWriter().info("handleRebalanceException got expected exception " + e + ", returning normally to allow a possible nice exit, continuing test");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleOperationExceptions(Region aRegion, Exception e) {
        boolean expectOfflineException = false;
        Object bbValue = SnapshotBB.getBB().getSharedMap().get("expectOfflineException");
        if (bbValue instanceof Boolean) {
            expectOfflineException = (Boolean)bbValue;
        }
        boolean persistentPartition = false;
        DataPolicy dataPolicy = aRegion.getAttributes().getDataPolicy();
        if (dataPolicy.withPartitioning() && dataPolicy.withPersistence()) {
            persistentPartition = true;
        }
        boolean undergoingShutDownAll = (Boolean)SnapshotBB.getBB().getSharedMap().get("shutDownAllKey");
        boolean thisVMReceivedNiceKill = StopStartVMs.niceKillInProgress();
        if (undergoingShutDownAll || thisVMReceivedNiceKill) {
            if (!(e instanceof CacheClosedException) && !(e instanceof DistributedSystemDisconnectedException) && !(e instanceof RegionDestroyedException)) throw new TestException(TestHelper.getStackTrace(e));
            Log.getLogWriter().info("Caught expected exception " + e + "; continuing test");
            return;
        } else if (e instanceof PartitionOfflineException || e instanceof ServerOperationException && e.getCause() instanceof PartitionOfflineException) {
            if (!this.isPRAccessor && !persistentPartition) {
                throw new TestException("PartitionOfflineException processed for region which was not a persistentPartition\n" + TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("handleOperationException got expected exception " + e + ", returning normally to allow a possible nice exit, continuing test");
            if (!expectOfflineException) {
                throw new TestException("Unexpected PartitionOfflineException " + e + " " + TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("handleOperationException got expected exception " + e + ", returning normally to allow a possible nice exit, continuing test");
            return;
        } else {
            if (!(e instanceof PartitionedRegionStorageException)) throw new TestException("Unexpected Exception " + e + " " + TestHelper.getStackTrace(e));
            if (!this.isPRAccessor) throw new TestException("Unexpected Exception " + e + " " + TestHelper.getStackTrace(e));
            Log.getLogWriter().info("handleOperationException got expected exception " + e + ", returning normally to allow a possible nice exit, continuing test");
        }
    }

    public static synchronized void CloseTask_closeCache() {
        CacheHelper.closeCache();
    }

    public static synchronized void HydraTask_removeDiskFiles() {
        File[] listing;
        int myVmID = RemoteTestModule.getMyVmid();
        String currDirName = System.getProperty("user.dir");
        File currDir = new File(currDirName);
        for (File aFile : listing = currDir.listFiles()) {
            File[] diskFiles;
            String fileName = aFile.getName();
            if (!fileName.startsWith("vm_" + myVmID + "_") || fileName.indexOf("disk_") < 0 || !aFile.isDirectory()) continue;
            for (File diskFile : diskFiles = aFile.listFiles()) {
                boolean result = diskFile.delete();
                if (!result) {
                    throw new TestException("Unable to delete file " + diskFile.getAbsolutePath());
                }
                Log.getLogWriter().info("Removed " + diskFile.getAbsolutePath());
            }
        }
    }

    public static void initPdxClassLoader() {
        PdxTest.initClassLoader();
    }

    public static BaseValueHolder getVersionedValueHolder(String valueClassName, String key, RandomValues randomValues) {
        return PdxTest.getVersionedValueHolder(valueClassName, key, randomValues);
    }

    public static boolean instanceOfPdxInstance(Object value) {
        return value instanceof PdxInstance;
    }

    public static BaseValueHolder toValueHolder(Object value) {
        return PdxTest.toValueHolder(value);
    }

    public static class ValueTypeSnapshotFilter
    implements SnapshotFilter {
        public boolean accept(Map.Entry entry) {
            boolean accepted = false;
            Object value = entry.getValue();
            if (value instanceof ValueHolder) {
                accepted = true;
            }
            return accepted;
        }
    }

    public static class ValueSnapshotFilter
    implements SnapshotFilter {
        public boolean accept(Map.Entry entry) {
            boolean accepted = true;
            Object value = entry.getValue();
            if (value instanceof String && ((String)value).startsWith("object to be filtered")) {
                accepted = false;
            }
            return accepted;
        }
    }

    public static class KeySnapshotFilter
    implements SnapshotFilter {
        public boolean accept(Map.Entry entry) {
            boolean accepted = false;
            String key = (String)entry.getKey();
            if (key.startsWith(NameFactory.OBJECT_NAME_PREFIX)) {
                accepted = true;
            }
            return accepted;
        }
    }
}

