/*
 * Decompiled with CFR 0.152.
 */
package splitBrain;

import hydra.ClientVmInfo;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedLock;
import java.util.List;
import java.util.Map;
import util.TestException;

public class ControllerBB
extends Blackboard {
    static String BB_NAME = "controllerBB_Blackboard";
    static String BB_TYPE = "RMI";
    public static ControllerBB bbInstance = null;
    public static int ExceptionCounter;
    public static int metCounter;
    public static final String ErrorKey = "Error";
    public static final String EnableSlowListenerKey = "EnableSlowListener_";
    public static final String EnableSickKey = "EnableSick_";
    public static final String EnableDeadKey = "EnableDead_";
    public static final String ReadyForInitKey = "ReadyForInit_";
    public static final String InitIsCompleteKey = "InitIsComplete_";
    public static final String MembershipFailureBegunKey = "MembershipFailureBegun_";
    public static final String MembershipFailureCompleteKey = "MembershipFailureComplete_";
    public static final String SevereAlertKey = "SevereAlertKey_";
    public static final String IsSickKey = "IsSick_";
    public static final String IsDeadKey = "IsDead_";
    public static final String NumForcedDiscEventsKey = "NumForcedDiscEvents_";
    public static final String VmRestarted = "VmRestarted_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ControllerBB getBB() {
        if (bbInstance != null) return bbInstance;
        Class<ControllerBB> clazz = ControllerBB.class;
        synchronized (ControllerBB.class) {
            if (bbInstance != null) return bbInstance;
            bbInstance = new ControllerBB(BB_NAME, BB_TYPE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return bbInstance;
        }
    }

    public ControllerBB() {
    }

    public ControllerBB(String name, String type) {
        super(name, type, ControllerBB.class);
    }

    public static boolean isAlertEnabled(int vmID) {
        if (ControllerBB.isSicknessEnabled(vmID) || ControllerBB.isSlowListenerEnabled(vmID)) {
            return !ControllerBB.isPlayDeadEnabled(vmID);
        }
        return false;
    }

    public static void enableSlowListener() {
        ControllerBB.enableSlowListener(RemoteTestModule.getMyVmid());
    }

    public static void enableSlowListener(int vmID) {
        Log.getLogWriter().info("ControllerBB: enabling slow listeners for vmID " + vmID);
        String key = EnableSlowListenerKey + vmID;
        ControllerBB.getBB().getSharedMap().put(key, "");
    }

    public static boolean isSlowListenerEnabled() {
        String key = EnableSlowListenerKey + RemoteTestModule.getMyVmid();
        return ControllerBB.getBB().getSharedMap().containsKey(key);
    }

    public static boolean isSlowListenerEnabled(int vmID) {
        String key = EnableSlowListenerKey + vmID;
        return ControllerBB.getBB().getSharedMap().containsKey(key);
    }

    public static void signalReadyForInit() {
        ControllerBB.signalReadyForInit(RemoteTestModule.getMyVmid());
    }

    public static void signalReadyForInit(int vmID) {
        Log.getLogWriter().info("ControllerBB: ready for init for vmID " + vmID);
        ControllerBB.getBB().getSharedMap().put(ReadyForInitKey + vmID, "");
    }

    public static boolean isReadyForInit() {
        return ControllerBB.isReadyForInit(RemoteTestModule.getMyVmid());
    }

    public static boolean isReadyForInit(int vmID) {
        String key = ReadyForInitKey + vmID;
        return ControllerBB.getBB().getSharedMap().containsKey(key);
    }

    public static void signalInitIsComplete() {
        ControllerBB.signalInitIsComplete(RemoteTestModule.getMyVmid());
    }

    public static void signalInitIsComplete(int vmID) {
        Log.getLogWriter().info("ControllerBB: signaling init is complete for vmID " + vmID);
        String key = InitIsCompleteKey + vmID;
        ControllerBB.getBB().getSharedMap().put(key, "");
    }

    public static void waitForInitialization() {
        ControllerBB.waitForInitialization(RemoteTestModule.getMyVmid());
    }

    public static void waitForInitialization(int vmID) {
        Log.getLogWriter().info("Waiting for initialize to complete for vmID " + vmID);
        String key = InitIsCompleteKey + vmID;
        while (true) {
            if (ControllerBB.getBB().getSharedMap().containsKey(key)) {
                Log.getLogWriter().info("Done waiting for initialize to complete for vmID " + vmID);
                return;
            }
            MasterController.sleepForMs(2000);
            ControllerBB.checkForError();
        }
    }

    public static void signalVmRestarted(int vmID) {
        Log.getLogWriter().info("ControllerBB: signaling init is complete for vmID " + vmID);
        String key = VmRestarted + vmID;
        ControllerBB.getBB().getSharedMap().put(key, "");
    }

    public static void waitForRestartedVm(int vmID) {
        Log.getLogWriter().info("Waiting for vmID " + vmID + " to restart");
        String key = InitIsCompleteKey + vmID;
        while (true) {
            if (ControllerBB.getBB().getSharedMap().containsKey(key)) {
                Log.getLogWriter().info("Done Waiting for vmID " + vmID + " to restart");
                return;
            }
            MasterController.sleepForMs(2000);
            ControllerBB.checkForError();
        }
    }

    public static void signalMembershipFailureBegun() {
        Log.getLogWriter().info("ControllerBB: signaling membership failure begun for vmID " + RemoteTestModule.getMyVmid());
        String key = MembershipFailureBegunKey + RemoteTestModule.getMyVmid();
        ControllerBB.getBB().getSharedMap().put(key, new Long(System.currentTimeMillis()));
    }

    public static void signalMembershipFailureComplete() {
        Log.getLogWriter().info("ControllerBB: signaling membership failure complete for vmID " + RemoteTestModule.getMyVmid());
        String key = MembershipFailureCompleteKey + RemoteTestModule.getMyVmid();
        ControllerBB.getBB().getSharedMap().put(key, new Long(System.currentTimeMillis()));
    }

    public static long getMembershipFailureStartTime() {
        String key = MembershipFailureBegunKey + RemoteTestModule.getMyVmid();
        return (Long)ControllerBB.getBB().getSharedMap().get(key);
    }

    public static long getMembershipFailureCompletionTime() {
        String key = MembershipFailureCompleteKey + RemoteTestModule.getMyVmid();
        return (Long)ControllerBB.getBB().getSharedMap().get(key);
    }

    public static boolean isMembershipFailureComplete() {
        String key = MembershipFailureCompleteKey + RemoteTestModule.getMyVmid();
        return ControllerBB.getBB().getSharedMap().containsKey(key);
    }

    public static void waitMembershipFailureComplete() {
        ControllerBB.waitMembershipFailureComplete(RemoteTestModule.getMyVmid());
    }

    public static void waitMembershipFailureComplete(int vmID) {
        Log.getLogWriter().info("Waiting for vmID " + vmID + " to complete membership failure");
        String key = MembershipFailureCompleteKey + vmID;
        while (true) {
            if (ControllerBB.getBB().getSharedMap().containsKey(key)) {
                Log.getLogWriter().info("Done waiting for vmID " + vmID + " to complete membership failure");
                return;
            }
            MasterController.sleepForMs(2000);
            ControllerBB.checkForError();
        }
    }

    public static void enableSickness() {
        ControllerBB.enableSickness(RemoteTestModule.getMyVmid());
    }

    public static void enableSickness(int vmID) {
        Log.getLogWriter().info("ControllerBB: enabling sickness for vmID " + vmID);
        String key = EnableSickKey + vmID;
        ControllerBB.getBB().getSharedMap().put(key, "");
    }

    public static boolean isSicknessEnabled() {
        String key = EnableSickKey + RemoteTestModule.getMyVmid();
        return ControllerBB.getBB().getSharedMap().containsKey(key);
    }

    public static boolean isSicknessEnabled(int vmID) {
        String key = EnableSickKey + vmID;
        return ControllerBB.getBB().getSharedMap().containsKey(key);
    }

    public static void signalIsSick() {
        ControllerBB.signalIsSick(RemoteTestModule.getMyVmid());
    }

    public static void signalIsSick(int vmID) {
        String key = IsSickKey + vmID;
        ControllerBB.getBB().getSharedMap().put(key, "");
    }

    public static void waitForIsSick() {
        ControllerBB.waitForIsSick(RemoteTestModule.getMyVmid());
    }

    public static void waitForIsSick(int vmID) {
        Log.getLogWriter().info("Waiting for vmID " + vmID + " to become sick");
        String key = IsSickKey + vmID;
        while (true) {
            if (ControllerBB.getBB().getSharedMap().containsKey(key)) {
                Log.getLogWriter().info("Done waiting for vmID " + vmID + " to become sick");
                return;
            }
            MasterController.sleepForMs(2000);
            ControllerBB.checkForError();
        }
    }

    public static void enablePlayDead() {
        ControllerBB.enablePlayDead(RemoteTestModule.getMyVmid());
    }

    public static void enablePlayDead(int vmID) {
        Log.getLogWriter().info("ControllerBB: enabling play dead for vmID " + vmID);
        String key = EnableDeadKey + vmID;
        ControllerBB.getBB().getSharedMap().put(key, "");
    }

    public static boolean isPlayDeadEnabled() {
        String key = EnableDeadKey + RemoteTestModule.getMyVmid();
        return ControllerBB.getBB().getSharedMap().containsKey(key);
    }

    public static boolean isPlayDeadEnabled(int vmID) {
        String key = EnableDeadKey + vmID;
        return ControllerBB.getBB().getSharedMap().containsKey(key);
    }

    public static void signalIsDead() {
        ControllerBB.signalIsDead(RemoteTestModule.getMyVmid());
    }

    public static void signalIsDead(int vmID) {
        String key = IsDeadKey + vmID;
        ControllerBB.getBB().getSharedMap().put(key, "");
    }

    public static void waitForIsDead() {
        ControllerBB.waitForIsDead(RemoteTestModule.getMyVmid());
    }

    public static void waitForIsDead(int vmID) {
        Log.getLogWriter().info("Waiting for vmID " + vmID + " to become dead");
        String key = IsDeadKey + vmID;
        while (true) {
            if (ControllerBB.getBB().getSharedMap().containsKey(key)) {
                Log.getLogWriter().info("Done waiting for vmID " + vmID + " to become dead");
                return;
            }
            MasterController.sleepForMs(2000);
            ControllerBB.checkForError();
        }
    }

    public static void signalSevereAlert() {
        ControllerBB.signalSevereAlert(RemoteTestModule.getMyVmid());
    }

    public static void signalSevereAlert(int vmID) {
        String key = SevereAlertKey + vmID;
        ControllerBB.getBB().getSharedMap().put(key, "");
    }

    public static boolean receivedSevereAlert() {
        return ControllerBB.receivedSevereAlert(RemoteTestModule.getMyVmid());
    }

    public static boolean receivedSevereAlert(int vmID) {
        String key = SevereAlertKey + vmID;
        return ControllerBB.getBB().getSharedMap().containsKey(key);
    }

    public static void waitForSevereAlert() {
        ControllerBB.waitForSevereAlert(RemoteTestModule.getMyVmid());
    }

    public static void waitForSevereAlert(int vmID) {
        Log.getLogWriter().info("Waiting for vmID " + vmID + " to recognize a severe alert");
        String key = SevereAlertKey + vmID;
        while (true) {
            if (ControllerBB.getBB().getSharedMap().containsKey(key)) {
                Log.getLogWriter().info("Done waiting for vmID " + vmID + " to recognize a severe alert");
                return;
            }
            MasterController.sleepForMs(2000);
            ControllerBB.checkForError();
        }
    }

    public static int getMapCounter(String keyBase) {
        String key = keyBase + RemoteTestModule.getMyVmid();
        Object value = ControllerBB.getBB().getSharedMap().get(key);
        if (value == null) {
            return 0;
        }
        int intVal = (Integer)value;
        return intVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incMapCounter(String keyBase) {
        String key = keyBase + RemoteTestModule.getMyVmid();
        Log.getLogWriter().info("Incrementing sharedMap counter " + key);
        SharedLock slock = ControllerBB.getBB().getSharedLock();
        slock.lock();
        try {
            int newValue = 0;
            Object value = ControllerBB.getBB().getSharedMap().get(key);
            newValue = value == null ? 1 : (Integer)value + 1;
            ControllerBB.getBB().getSharedMap().put(key, new Integer(newValue));
            Log.getLogWriter().info("Incremented sharedMap counter, count is now " + newValue);
        }
        finally {
            slock.unlock();
        }
    }

    public static void checkForError() {
        Object error = ControllerBB.getBB().getSharedMap().get(ErrorKey);
        if (error != null) {
            throw new TestException(error.toString());
        }
    }

    public static int getVmIdForPid(int pid) {
        int vmid = (Integer)ControllerBB.getBB().getSharedMap().get("" + pid);
        return vmid;
    }

    public static void reset(int vmID) {
        ControllerBB.getBB().getSharedMap().remove(ErrorKey + vmID);
        ControllerBB.getBB().getSharedMap().remove(EnableSlowListenerKey + vmID);
        ControllerBB.getBB().getSharedMap().remove(EnableSickKey + vmID);
        ControllerBB.getBB().getSharedMap().remove(EnableDeadKey + vmID);
        ControllerBB.getBB().getSharedMap().remove(ReadyForInitKey + vmID);
        ControllerBB.getBB().getSharedMap().remove(InitIsCompleteKey + vmID);
        ControllerBB.getBB().getSharedMap().remove(MembershipFailureBegunKey + vmID);
        ControllerBB.getBB().getSharedMap().remove(MembershipFailureCompleteKey + vmID);
        ControllerBB.getBB().getSharedMap().remove(SevereAlertKey + vmID);
        ControllerBB.getBB().getSharedMap().remove(IsSickKey + vmID);
        ControllerBB.getBB().getSharedMap().remove(IsDeadKey + vmID);
        ControllerBB.getBB().getSharedMap().remove(NumForcedDiscEventsKey + vmID);
        ControllerBB.getBB().getSharedMap().remove(VmRestarted + vmID);
        Log.getLogWriter().info("ControllerBB: reset vmID " + vmID);
    }

    public static void checkEventCounters(String baseKey, List vmList, int expectedCount) {
        Map aMap = ControllerBB.getBB().getSharedMap().getMap();
        for (String key : aMap.keySet()) {
            if (!key.startsWith(baseKey)) continue;
            int value = (Integer)aMap.get(key);
            boolean foundInVmIdList = false;
            for (int i = 0; i < vmList.size(); ++i) {
                int vmId = ((ClientVmInfo)vmList.get(i)).getVmid();
                if (!key.endsWith("_" + vmId)) continue;
                foundInVmIdList = true;
                if (value == expectedCount) continue;
                throw new TestException("Expected value for BB key " + key + " to be " + expectedCount + " but it is " + value);
            }
            if (foundInVmIdList || value == 0) continue;
            throw new TestException("Expected value for BB key " + key + " to be 0 but it is " + value);
        }
    }
}

