/*
 * Decompiled with CFR 0.152.
 */
package splitBrain;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.distributed.DistributedSystem;
import hydra.CacheHelper;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import java.util.Properties;
import splitBrain.ControllerBB;
import splitBrain.ForcedDiscUtil;
import splitBrain.SBUtil;
import util.AbstractListener;
import util.TestException;
import util.TestHelper;

public class ControllerListener
extends AbstractListener
implements CacheListener,
Declarable {
    public static boolean validateForcedDisconnects = true;

    public void afterDestroy(EntryEvent event) {
    }

    public void afterInvalidate(EntryEvent event) {
    }

    public void afterUpdate(EntryEvent event) {
    }

    public void afterRegionInvalidate(RegionEvent event) {
    }

    public void afterRegionClear(RegionEvent event) {
    }

    public void afterRegionCreate(RegionEvent event) {
    }

    public void afterRegionLive(RegionEvent event) {
    }

    public void init(Properties prop) {
    }

    public void close() {
    }

    public void afterCreate(EntryEvent event) {
        try {
            this.doAfterCreate(event);
        }
        catch (Exception e) {
            String errStr = "Error occurred in vm_" + RemoteTestModule.getMyVmid() + " " + TestHelper.getStackTrace(e);
            Log.getLogWriter().info(errStr);
            ControllerBB.getBB().getSharedMap().put("Error", errStr);
        }
    }

    protected void doAfterCreate(EntryEvent event) {
        final DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        final Cache theCache = CacheHelper.getCache();
        if (ControllerBB.isSlowListenerEnabled()) {
            this.logCall("afterCreate", (CacheEvent)event);
            if (ControllerBB.isPlayDeadEnabled()) {
                SBUtil.playDead();
                this.waitForFDThenInit(ds, theCache);
            } else {
                try {
                    ControllerBB.waitForSevereAlert();
                }
                catch (TestException e) {
                    Log.getLogWriter().info(e.getMessage());
                    ControllerBB.getBB().getSharedMap().put("Error", e.getMessage());
                }
            }
            Log.getLogWriter().info("Returning from doAfterCreate");
        } else if (ControllerBB.isSicknessEnabled()) {
            this.logCall("afterCreate", (CacheEvent)event);
            SBUtil.beSick();
            if (ControllerBB.isPlayDeadEnabled()) {
                SBUtil.playDead();
                String threadName = Thread.currentThread().getName();
                Thread monitorThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ControllerListener.this.waitForFDThenInit(ds, theCache);
                        Log.getLogWriter().info("Done in wait for forced disconnect thread");
                    }
                }, "waitForFDThenInitThread" + threadName);
                monitorThread.start();
            }
            Log.getLogWriter().info("Returning from doAfterCreate");
        }
    }

    public void afterRegionDestroy(RegionEvent event) {
        try {
            this.doAfterRegionDestroy(event);
        }
        catch (Exception e) {
            String errStr = "Error occurred in vm_" + RemoteTestModule.getMyVmid() + " " + TestHelper.getStackTrace(e);
            Log.getLogWriter().info(errStr);
            ControllerBB.getBB().getSharedMap().put("Error", errStr);
        }
    }

    protected void doAfterRegionDestroy(RegionEvent event) {
        String eventStr = this.logCall("afterRegionDestroy", (CacheEvent)event);
        Operation op = event.getOperation();
        if (op.equals(Operation.FORCED_DISCONNECT)) {
            Log.getLogWriter().info("Received an afterRegionDestroy event with Operation.FORCED_DISCONNECT");
            ControllerBB.incMapCounter("NumForcedDiscEvents_");
            if (validateForcedDisconnects && !ControllerBB.isPlayDeadEnabled()) {
                String errStr = "Got an unexpected forced disconnect event invoked in vmID " + RemoteTestModule.getMyVmid() + ": " + eventStr;
                Log.getLogWriter().info(errStr);
                ControllerBB.getBB().getSharedMap().put("Error", errStr);
            }
        }
    }

    public void initAfterDisconnect() {
    }

    public void afterDisconnect() {
    }

    protected void waitForFDThenInit(DistributedSystem ds, Cache theCache) {
        try {
            ForcedDiscUtil.waitForForcedDiscConditions(ds, theCache);
        }
        catch (TestException e) {
            Log.getLogWriter().info(e.getMessage());
            ControllerBB.getBB().getSharedMap().put("Error", e.getMessage());
        }
        this.afterDisconnect();
        Log.getLogWriter().info("ControllerListener: Waiting to be ready for initialization...");
        while (!ControllerBB.isReadyForInit()) {
            MasterController.sleepForMs(2000);
        }
        this.initAfterDisconnect();
        Log.getLogWriter().info("ControllerListener: Done with initialization");
        ControllerBB.signalInitIsComplete();
    }
}

